/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import sqlj.runtime.ResultSetIterator;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.RTResultSet;

public class ResultSetIterImpl
implements ResultSetIterator {
    int fetchSize;
    int maxRows;
    boolean nextCalled_ = false;
    protected RTResultSet resultSet;

    public ResultSetIterImpl(RTResultSet rTResultSet) {
        this.resultSet = rTResultSet;
    }

    public ResultSetIterImpl(RTResultSet rTResultSet, int n2, int n3) throws SQLException {
        this.resultSet = rTResultSet;
        this.fetchSize = n2;
        this.maxRows = n3;
        if (this.fetchSize != 0) {
            this.resultSet.getJDBCResultSet().setFetchSize(this.fetchSize);
        }
    }

    public ResultSetIterImpl(RTResultSet rTResultSet, int n2) throws SQLException {
        this(rTResultSet);
        try {
            ResultSetIterImpl.checkColumns(rTResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    public ResultSetIterImpl(RTResultSet rTResultSet, int n2, int n3, int n4) throws SQLException {
        this(rTResultSet, n2, n3);
        try {
            ResultSetIterImpl.checkColumns(rTResultSet, n4);
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    public static void checkColumns(RTResultSet rTResultSet, int n2) throws SQLException {
        int n3 = rTResultSet.getColumnCount();
        if (n3 != n2) {
            RuntimeRefErrors.raise_WRONG_NUM_COLS(n2, n3);
        }
    }

    protected int findColumn(String string) throws SQLException {
        try {
            return this.resultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        return this.resultSet.getJDBCResultSet();
    }

    public void close() throws SQLException {
        this.resultSet.close();
    }

    public boolean isClosed() throws SQLException {
        return this.resultSet.isClosed();
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public boolean endFetch() throws SQLException {
        return !this.resultSet.isValidRow() && this.nextCalled_;
    }

    public boolean next() throws SQLException {
        this.nextCalled_ = true;
        return this.resultSet.next();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            throw throwable;
        }
    }

    public void setFetchSize(int n2) throws SQLException {
        if (n2 < 0 || n2 > this.maxRows) {
            throw new SQLException(new IllegalArgumentException(n2 + "").getMessage());
        }
        this.fetchSize = n2;
        this.getResultSet().setFetchSize(n2);
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getRow() throws SQLException {
        return this.getResultSet().getRow();
    }

    public int getSensitivity() throws SQLException {
        int n2 = this.getResultSet().getType();
        if (n2 == 1005) {
            return 3;
        }
        if (n2 == 1004) {
            return 2;
        }
        return 1;
    }
}

