/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2BaseDataSource;
import com.ibm.db2.jcc.a.b;
import com.ibm.db2.jcc.a.g;
import com.ibm.db2.jcc.b.SQLException;
import com.ibm.db2.jcc.b.SQLWarning;
import com.ibm.db2.jcc.b.bo;
import com.ibm.db2.jcc.b.bz;
import com.ibm.db2.jcc.b.ck;
import com.ibm.db2.jcc.b.k;
import com.ibm.db2.jcc.t2.T2Configuration;
import com.ibm.db2.jcc.uw.UWConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class DB2Driver
implements Driver {
    private static final int DB2_PROTOCOL = 1;
    private static final int DB2_LEGACY_PROTOCOL = 2;
    private static final int CLOUDSCAPE_REMOTE_PROTOCOL = 3;
    private static SQLException exceptionsOnLoadDriver = null;
    public static final int jccTestBuild = 1;
    public static final int jccBetaBuild = 2;
    public static final int jccReleaseBuild = 3;

    public Connection connect(String string, Properties properties) throws java.sql.SQLException {
        int n2;
        String string2;
        StringTokenizer stringTokenizer;
        int n3;
        if (exceptionsOnLoadDriver != null) {
            throw exceptionsOnLoadDriver;
        }
        if (properties == null) {
            properties = new Properties();
        }
        if ((n3 = DB2Driver.tokenizeProtocol(string, stringTokenizer = new StringTokenizer(string, "/:=; \t\n\r\f", true))) == 0) {
            return null;
        }
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException(null, noSuchElementException, "Invalid database url syntax: " + string);
        }
        if (string2.equals("/")) {
            int n4;
            if (n3 == 2) {
                throw new SQLException(null, "Deprecated DB2 OS/390 protocol not supported by T4: " + string + "  Use protocol jdbc:db2:");
            }
            String string3 = DB2Driver.tokenizeServerName(stringTokenizer, string);
            int n5 = DB2Driver.tokenizeOptionalPortNumber(stringTokenizer, string);
            if (n5 == 0) {
                switch (n3) {
                    case 1: {
                        n5 = 446;
                        break;
                    }
                    case 3: {
                        n5 = 1527;
                        break;
                    }
                    default: {
                        n5 = 0;
                    }
                }
            }
            String string4 = DB2Driver.tokenizeDatabase(stringTokenizer, string);
            Properties properties2 = stringTokenizer.hasMoreTokens() ? DB2Driver.tokenizeURLProperties(stringTokenizer, string, properties) : properties;
            try {
                n4 = DB2BaseDataSource.getTraceLevel(properties2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException(null, numberFormatException, "trouble reading traceLevel connection property");
            }
            bo bo2 = DB2BaseDataSource.computeJccLogWriter(4, DriverManager.getLogWriter(), DB2BaseDataSource.getTraceFile(properties2), n4, "");
            b b2 = new b((g)bo2, (SQLWarning)null, DriverManager.getLoginTimeout(), string3, n5, string4, properties2);
            return b2;
        }
        String string5 = string2;
        if (T2Configuration.e != null) {
            throw T2Configuration.e;
        }
        try {
            n2 = DB2BaseDataSource.getTraceLevel(properties);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(null, numberFormatException, "trouble reading traceLevel connection property");
        }
        bo bo3 = DB2BaseDataSource.computeJccLogWriter(2, DriverManager.getLogWriter(), DB2BaseDataSource.getTraceFile(properties), n2, "");
        switch (T2Configuration.a) {
            case 1: {
                return null;
            }
            case 2: {
                return new UWConnection((g)bo3, null, DriverManager.getLoginTimeout(), string5, properties, this);
            }
        }
        throw new SQLException(bo3, "Unrecognized type 2 driver platform for IBM DB2 JDBC Universal Driver Architecture");
    }

    public boolean acceptsURL(String string) throws java.sql.SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/:=; \t\n\r\f", true);
        int n2 = DB2Driver.tokenizeProtocol(string, stringTokenizer);
        return n2 != 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws java.sql.SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[2];
        if (properties == null) {
            properties = new Properties();
        }
        driverPropertyInfoArray[0] = new DriverPropertyInfo("user", properties.getProperty("user"));
        driverPropertyInfoArray[1] = new DriverPropertyInfo("password", properties.getProperty("password"));
        driverPropertyInfoArray[0].description = bz.a("7");
        driverPropertyInfoArray[1].description = bz.a("8");
        driverPropertyInfoArray[0].required = true;
        driverPropertyInfoArray[1].required = false;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public int getJCCBuildNumber() {
        return 581;
    }

    public int getJCCBuildCertification() {
        return 3;
    }

    public String[] getJCCCompatibleJREVersions() {
        return k.o;
    }

    private static int tokenizeProtocol(String string, StringTokenizer stringTokenizer) throws SQLException {
        if (string == null) {
            return 0;
        }
        if (stringTokenizer == null) {
            return 0;
        }
        try {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("jdbc")) {
                return 0;
            }
            if (!stringTokenizer.nextToken().equals(":")) {
                return 0;
            }
            String string3 = stringTokenizer.nextToken();
            int n2 = 0;
            if (string3.equals("db2")) {
                n2 = 1;
            } else if (string3.equals("db2os390") || string3.equals("db2os390sqlj")) {
                n2 = 2;
            } else if (string3.equals("db2j")) {
                if (!stringTokenizer.nextToken().equals(":")) {
                    return 0;
                }
                if (!stringTokenizer.nextToken().equals("net")) {
                    return 0;
                }
                n2 = 3;
            } else {
                return 0;
            }
            if (!stringTokenizer.nextToken().equals(":")) {
                return 0;
            }
            return n2;
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    private static String tokenizeServerName(StringTokenizer stringTokenizer, String string) throws SQLException {
        try {
            if (!stringTokenizer.nextToken().equals("/")) {
                throw new SQLException(null, "Invalid database url syntax: " + string);
            }
            return stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException(null, noSuchElementException, "Invalid database url syntax: " + string);
        }
    }

    private static int tokenizeOptionalPortNumber(StringTokenizer stringTokenizer, String string) throws SQLException {
        try {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(":")) {
                String string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.nextToken().equals("/")) {
                    throw new SQLException(null, "Invalid database url syntax: " + string);
                }
                return Integer.parseInt(string3);
            }
            if (string2.equals("/")) {
                return 0;
            }
            throw new SQLException(null, "Invalid database url syntax: " + string);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException(null, noSuchElementException, "Invalid database url syntax: " + string);
        }
    }

    private static String tokenizeDatabase(StringTokenizer stringTokenizer, String string) throws SQLException {
        try {
            return stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException(null, noSuchElementException, "Invalid database url syntax: " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties tokenizeURLProperties(StringTokenizer stringTokenizer, String string, Properties properties) throws SQLException {
        Properties properties2 = (Properties)((Hashtable)properties).clone();
        try {
            if (!stringTokenizer.nextToken().equals(":")) {
                throw new SQLException(null, "Invalid database url syntax: " + string);
            }
            while (true) {
                if (!stringTokenizer.hasMoreTokens()) {
                    return properties2;
                }
                String string2 = stringTokenizer.nextToken("/:=; \t\n\r\f");
                if (!stringTokenizer.nextToken().equals("=")) {
                    throw new SQLException(null, "Invalid database url syntax: " + string);
                }
                String string3 = stringTokenizer.nextToken(";");
                if (!stringTokenizer.nextToken().equals(";")) {
                    throw new SQLException(null, "Invalid database url syntax: " + string + "A semicolon is needed after property value " + string3);
                }
                if (properties.getProperty(string2) != null) {
                    throw new SQLException(null, "java.util.Properties object passed to java.sql.Driver.connect() cannot be overriden by URL: " + string);
                }
                properties2.setProperty(string2, string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException(null, noSuchElementException, "Invalid database url syntax: " + string);
        }
    }

    static {
        if (k.G != null) {
            exceptionsOnLoadDriver = ck.a(k.G, exceptionsOnLoadDriver);
        }
        try {
            DriverManager.registerDriver(new DB2Driver());
        }
        catch (java.sql.SQLException sQLException) {
            exceptionsOnLoadDriver = ck.a(new SQLException(null, sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode()), exceptionsOnLoadDriver);
        }
    }
}

