/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2BaseDataSource;
import com.ibm.db2.jcc.DB2ConnectionPoolDataSource;
import com.ibm.db2.jcc.DB2ConnectionPoolManager;
import com.ibm.db2.jcc.a.b;
import com.ibm.db2.jcc.a.g;
import com.ibm.db2.jcc.b.SQLException;
import com.ibm.db2.jcc.b.SQLWarning;
import com.ibm.db2.jcc.b.bo;
import com.ibm.db2.jcc.b.ck;
import com.ibm.db2.jcc.t2.T2Configuration;
import com.ibm.db2.jcc.uw.UWConnection;
import java.io.Serializable;
import java.sql.Connection;
import javax.naming.Referenceable;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class DB2DataSource
extends DB2BaseDataSource
implements DataSource,
Serializable,
Referenceable {
    private static final long serialVersionUID = 6447560170638224643L;
    static final String className__ = "com.ibm.db2.jcc.DB2DataSource";
    private String password = null;
    public static final String propertyKey_password = "password";
    private transient DB2ConnectionPoolManager connectionPoolManager;
    private DB2ConnectionPoolDataSource connectionPoolDataSource = new DB2ConnectionPoolDataSource();
    private boolean isConnectionPoolDataSourceSet = false;

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    public void finalize() throws java.sql.SQLException {
        if (this.connectionPoolManager != null) {
            this.connectionPoolManager.clear();
        }
    }

    public Connection getConnection() throws java.sql.SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String string, String string2) throws java.sql.SQLException {
        PooledConnection pooledConnection;
        Object var3_3 = null;
        if (string != null) {
            this.user = string;
        }
        if (string2 != null) {
            this.password = string2;
        }
        this.initialize();
        if (this.connectionPoolDataSource == null) {
            return this.getSimpleConnection(this.user, this.password);
        }
        if (this.connectionPoolManager == null) {
            this.connectionPoolManager = new DB2ConnectionPoolManager();
        }
        if ((pooledConnection = this.connectionPoolManager.lookup(string, string2)) == null) {
            DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource = this.connectionPoolDataSource;
            synchronized (dB2ConnectionPoolDataSource) {
                pooledConnection = this.connectionPoolDataSource.getPooledConnection(string, string2);
            }
            pooledConnection.addConnectionEventListener(this.connectionPoolManager);
        }
        return pooledConnection.getConnection();
    }

    public Connection getSimpleConnection(String string, String string2) throws java.sql.SQLException {
        SQLWarning sQLWarning = null;
        bo bo2 = DB2BaseDataSource.computeJccLogWriter(this.driverType, this.logWriter, this.traceFile, this.traceLevel, "");
        switch (this.driverType) {
            case 4: {
                return new b((g)bo2, sQLWarning, string, string2, (DB2BaseDataSource)this);
            }
            case 2: {
                if (this.serverName != null) {
                    sQLWarning = ck.a(new SQLWarning(bo2, "The serverName data source property was ignored."), sQLWarning);
                }
                if (2 == T2Configuration.a) {
                    return new UWConnection((g)bo2, sQLWarning, string, string2, this, 0, false);
                }
                return null;
            }
        }
        throw new SQLException(bo2, "Driver type " + this.driverType + " not available for " + "IBM DB2 JDBC Universal Driver Architecture");
    }

    private void initialize() {
        if (!this.isConnectionPoolDataSourceSet && this.connectionPoolDataSource != null) {
            this.connectionPoolDataSource.setDatabaseName(this.getDatabaseName());
            this.connectionPoolDataSource.setServerName(this.getServerName());
            this.connectionPoolDataSource.setPortNumber(this.getPortNumber());
            this.connectionPoolDataSource.setDriverType(this.getDriverType());
            this.connectionPoolDataSource.setTraceFile(this.getTraceFile());
            this.isConnectionPoolDataSourceSet = true;
        }
    }
}

