/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.mip.FuzzyDateMachine;

import edu.berkeley.mip.FuzzyDateMachine.Yytoken;
import java.util.Hashtable;

public class Filter {
    public static final int DAY = 0;
    public static final int MONTH = 1;
    public static final int YEAR = 2;
    static final Hashtable monthsTable = new Hashtable();
    static final String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    static final String[] roman_months = new String[]{"i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix", "x", "xi", "xii"};

    static {
        int n = 0;
        while (n < months.length) {
            monthsTable.put(months[n], new Integer(n + 1));
            monthsTable.put(roman_months[n], new Integer(n + 1));
            ++n;
        }
    }

    private Filter() {
    }

    public static synchronized int calendarToJulian(int n, int n2, int n3) throws Exception {
        int n4;
        int n5;
        int n6 = 588829;
        if (n3 == 0) {
            throw new Exception("FuzzyDateMachine: no year zero.");
        }
        if (n2 == 2 && (n == 29 && Filter.dysize(n3) != 366 || n > 29)) {
            throw new Exception("FuzzyDateMachine: illegal leap day: year == " + n3 + " day == " + n + " day == " + n);
        }
        if ((n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) && n > 30 || n > 31 || n < 0) {
            throw new Exception("FuzzyDateMachine: illegal day for month : year == " + n3 + " day == " + n);
        }
        if (n2 > 12 || n2 < 1) {
            throw new Exception("FuzzyDateMachine: illegal month : year == " + n3 + " day == " + n);
        }
        if (n3 < 0) {
            ++n3;
        }
        if (n2 > 2) {
            n5 = n3;
            n4 = n2 + 1;
        } else {
            n5 = n3 - 1;
            n4 = n2 + 13;
        }
        int n7 = (int)(365.25 * (double)n5) + (int)(30.6001 * (double)n4) + n + 1720995;
        if (n + 31 * (n2 + 12 * n3) >= n6) {
            int n8 = (int)(0.01 * (double)n5);
            n7 = n7 + 2 - n8 + (int)(0.25 * (double)n8);
        }
        return n7;
    }

    public static synchronized int calendarToJulian(int[] nArray) throws Exception {
        return Filter.calendarToJulian(nArray[0], nArray[1], nArray[2]);
    }

    public static synchronized int[] calendarToJulianPair(int[][] nArray) throws Exception {
        int[] nArray2 = new int[]{Filter.calendarToJulian(nArray[0]), Filter.calendarToJulian(nArray[1])};
        if (nArray2[0] > nArray2[1]) {
            throw new Exception("Illegal range: start before end!");
        }
        return nArray2;
    }

    protected static int dysize(int n) {
        if (n % 4 == 0 && n % 100 != 0 || n % 400 == 0) {
            return 366;
        }
        return 365;
    }

    public static synchronized int[] julianToCalendar(int n) {
        int[] nArray = new int[3];
        int n2 = 2299161;
        int n3 = n;
        if (n >= n2) {
            int n4 = (int)(((double)(n - 1867216) - 0.25) / 36524.25);
            n3 = n + 1 + n4 - (int)(0.25 * (double)n4);
        }
        int n5 = n3 + 1524;
        int n6 = (int)(6680.0 + ((double)(n5 - 2439870) - 122.1) / 365.25);
        int n7 = 365 * n6 + (int)(0.25 * (double)n6);
        int n8 = (int)((double)(n5 - n7) / 30.6001);
        nArray[0] = n5 - n7 - (int)(30.6001 * (double)n8);
        nArray[1] = n8 - 1;
        if (nArray[1] > 12) {
            nArray[1] = nArray[1] - 12;
        }
        nArray[2] = n6 - 4715;
        if (nArray[1] > 2) {
            nArray[2] = nArray[2] - 1;
        }
        if (nArray[2] <= 0) {
            nArray[2] = nArray[2] - 1;
        }
        return nArray;
    }

    public static int julianToDayOfWeek(int n) {
        return (n + 1) % 7;
    }

    public static int lengthOfMonth(int n, int n2) {
        int n3 = 31;
        if (n == 2) {
            n3 = 28 + Filter.dysize(n2) % 365;
        } else if (n == 4 || n == 6 || n == 9 || n == 11) {
            n3 = 30;
        }
        return n3;
    }

    public static synchronized void mergeRange(Yytoken yytoken, Yytoken yytoken2) {
        yytoken.dayMonthYear[1][0] = yytoken2.dayMonthYear[1][0];
        yytoken.dayMonthYear[1][1] = yytoken2.dayMonthYear[1][1];
        yytoken.dayMonthYear[1][2] = yytoken2.dayMonthYear[1][2];
    }

    public static synchronized void mergeToRange(Yytoken yytoken, Yytoken yytoken2) {
        yytoken.dayMonthYear[1][0] = yytoken2.dayMonthYear[0][0];
        yytoken.dayMonthYear[1][1] = yytoken2.dayMonthYear[0][1];
        yytoken.dayMonthYear[1][2] = yytoken2.dayMonthYear[0][2];
    }

    public static int monthForString(String string) {
        int n = -1;
        Integer n2 = (Integer)monthsTable.get(string.toLowerCase().substring(0, Math.min(3, string.length())));
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public static synchronized void toCentury(Yytoken yytoken) {
        int n = (yytoken.yyValue - 1) * 100;
        yytoken.dayMonthYear[0][0] = 1;
        yytoken.dayMonthYear[0][1] = 1;
        yytoken.dayMonthYear[0][2] = n + 1;
        yytoken.dayMonthYear[1][0] = 31;
        yytoken.dayMonthYear[1][1] = 12;
        yytoken.dayMonthYear[1][2] = n + 100;
    }

    public static synchronized void toCenturyBCE(Yytoken yytoken) {
        int n = (yytoken.yyValue - 1) * -100;
        yytoken.dayMonthYear[1][0] = 31;
        yytoken.dayMonthYear[1][1] = 12;
        yytoken.dayMonthYear[1][2] = n - 1;
        yytoken.dayMonthYear[0][0] = 1;
        yytoken.dayMonthYear[0][1] = 1;
        yytoken.dayMonthYear[0][2] = n - 100;
    }

    public static synchronized void toDateBCE(Yytoken yytoken) {
        int[] nArray = yytoken.dayMonthYear[0];
        nArray[2] = nArray[2] * -1;
    }

    public static synchronized void toMillennium(Yytoken yytoken) {
        System.err.println("tomill: " + yytoken);
        int n = (yytoken.yyValue - 1) * 1000;
        yytoken.dayMonthYear[0][0] = 1;
        yytoken.dayMonthYear[0][1] = 1;
        yytoken.dayMonthYear[0][2] = n + 1;
        yytoken.dayMonthYear[1][0] = 31;
        yytoken.dayMonthYear[1][1] = 12;
        yytoken.dayMonthYear[1][2] = n + 1000;
        System.err.println("filtered: " + yytoken);
    }

    public static synchronized void toMillenniumBCE(Yytoken yytoken) {
        System.err.println("tomillBCE: " + yytoken);
        int n = (yytoken.yyValue - 1) * -1000;
        yytoken.dayMonthYear[1][0] = 31;
        yytoken.dayMonthYear[1][1] = 12;
        yytoken.dayMonthYear[1][2] = n - 1;
        yytoken.dayMonthYear[0][0] = 1;
        yytoken.dayMonthYear[0][1] = 1;
        yytoken.dayMonthYear[0][2] = n - 1000;
        System.err.println("filtered: " + yytoken);
    }

    public static synchronized void toPartOfYear(Yytoken yytoken, Yytoken yytoken2) {
        switch (yytoken.yySymbol) {
            case 15: {
                yytoken2.dayMonthYear[1][0] = 31;
                yytoken2.dayMonthYear[1][1] = 3;
                break;
            }
            case 16: {
                yytoken2.dayMonthYear[0][0] = 1;
                yytoken2.dayMonthYear[0][1] = 4;
                yytoken2.dayMonthYear[1][0] = 30;
                yytoken2.dayMonthYear[1][1] = 9;
                break;
            }
            case 17: {
                yytoken2.dayMonthYear[0][0] = 1;
                yytoken2.dayMonthYear[0][1] = 10;
                break;
            }
        }
    }

    public static synchronized void toSeason(Yytoken yytoken, Yytoken yytoken2) {
        switch (yytoken.yySymbol) {
            case 33: {
                yytoken2.dayMonthYear[0][0] = 1;
                yytoken2.dayMonthYear[0][1] = 12;
                int[] nArray = yytoken2.dayMonthYear[0];
                nArray[2] = nArray[2] - 1;
                yytoken2.dayMonthYear[1][0] = Filter.dysize(yytoken2.dayMonthYear[1][2]) == 365 ? 28 : 29;
                yytoken2.dayMonthYear[1][1] = 2;
                break;
            }
            case 31: {
                yytoken2.dayMonthYear[0][0] = 1;
                yytoken2.dayMonthYear[0][1] = 3;
                yytoken2.dayMonthYear[1][0] = 31;
                yytoken2.dayMonthYear[1][1] = 5;
                break;
            }
            case 32: {
                yytoken2.dayMonthYear[0][0] = 1;
                yytoken2.dayMonthYear[0][1] = 6;
                yytoken2.dayMonthYear[1][0] = 31;
                yytoken2.dayMonthYear[1][1] = 8;
                break;
            }
            case 34: {
                yytoken2.dayMonthYear[0][0] = 1;
                yytoken2.dayMonthYear[0][1] = 9;
                yytoken2.dayMonthYear[1][0] = 30;
                yytoken2.dayMonthYear[1][1] = 11;
                break;
            }
        }
    }

    public static synchronized void toYearBCE(Yytoken yytoken) {
        int[] nArray = yytoken.dayMonthYear[0];
        nArray[2] = nArray[2] * -1;
        int[] nArray2 = yytoken.dayMonthYear[1];
        nArray2[2] = nArray2[2] * -1;
    }
}

