/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.usergroup;

import com.luna.insight.server.InsightSmartServer;
import com.luna.insight.server.links.LinkCodeGenerator;
import com.luna.insight.server.links.LinkFileManager;
import com.luna.insight.server.usergroup.UserGroup;
import com.luna.insight.server.usergroup.UserGroupConnection;
import com.luna.insight.server.usergroup.UserGroupConnectionKey;
import com.luna.insight.server.usergroup.UserGroupReserveCounter;
import java.util.Enumeration;
import java.util.Vector;

public class UserGroupConnectionPool {
    protected int poolID;
    protected String poolName;
    protected int maxConnections;
    protected int lastConnectionLimit = 0;
    protected Vector sessions = new Vector();
    protected UserGroupReserveCounter COMMUNAL_COUNTER = new UserGroupReserveCounter();
    protected int totalReserveRequests = 0;
    protected Vector userGroups = new Vector();
    protected int timeoutMinutes;
    protected InsightSmartServer serverParent;

    public UserGroupConnectionPool(int n, String string, int n2, InsightSmartServer insightSmartServer) {
        this.poolID = n;
        this.poolName = string;
        this.maxConnections = n2;
        this.serverParent = insightSmartServer;
        this.lastConnectionLimit = n2;
    }

    public void setTimeoutMinutes(int n) {
        this.timeoutMinutes = n;
    }

    public int getTimeoutMinutes() {
        return this.timeoutMinutes;
    }

    public int getPoolID() {
        return this.poolID;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String string) {
        this.poolName = string;
    }

    public int getSessionCount() {
        return this.sessions.size();
    }

    public int getSessionLimit() {
        return this.maxConnections;
    }

    public void setSessionLimit(int n) {
        this.lastConnectionLimit = this.maxConnections;
        this.maxConnections = n;
    }

    public int getUserGroupCount() {
        return this.userGroups.size();
    }

    public void rollback() {
        this.maxConnections = this.lastConnectionLimit;
    }

    public boolean equals(Object object) {
        if (object instanceof UserGroupConnectionPool) {
            UserGroupConnectionPool userGroupConnectionPool = (UserGroupConnectionPool)object;
            return this.poolID == userGroupConnectionPool.getPoolID();
        }
        return super.equals(object);
    }

    public UserGroupConnectionKey getKey(String string, String string2, UserGroup userGroup) {
        return new UserGroupConnectionKey(string, string2, userGroup);
    }

    public int getRequestedReserveCount() {
        return this.getRequestedReserveCount(false);
    }

    public int getRequestedReserveCount(boolean bl) {
        if (bl) {
            this.totalReserveRequests = 0;
            for (int i = 0; i < this.userGroups.size(); ++i) {
                this.totalReserveRequests += ((UserGroup)this.userGroups.elementAt(i)).getConnectionReserve();
            }
        }
        return this.totalReserveRequests;
    }

    public void setUserGroups(Vector vector) {
        if (vector != null) {
            this.totalReserveRequests = 0;
            this.userGroups.removeAllElements();
            for (int i = 0; i < vector.size(); ++i) {
                UserGroup userGroup = (UserGroup)vector.elementAt(i);
                if (this.poolID != userGroup.getPoolID()) continue;
                userGroup.setConnectionPool(this);
                if (userGroup.reserveCounter == null) {
                    userGroup.reserveCounter = new UserGroupReserveCounter();
                }
                if (this.totalReserveRequests + userGroup.getConnectionReserve() > this.maxConnections) {
                    userGroup.setConnectionReserve(this.maxConnections - this.totalReserveRequests);
                }
                this.totalReserveRequests += userGroup.getConnectionReserve();
                this.userGroups.addElement(userGroup);
            }
        }
    }

    public void removeUserGroup(UserGroup userGroup) {
        if (userGroup != null && this.userGroups.contains(userGroup)) {
            for (int i = 0; i < this.sessions.size(); ++i) {
                UserGroupConnection userGroupConnection = (UserGroupConnection)this.sessions.elementAt(i);
                if (!userGroupConnection.getUserGroup().equals(userGroup)) continue;
                this.removeSession(userGroupConnection.getIPAddress(), userGroupConnection.getLocalIPAddress(), userGroup);
            }
            this.userGroups.removeElement(userGroup);
            userGroup.setPoolID(-1);
            userGroup.setConnectionPool(null);
            userGroup.reserveCounter = null;
        }
    }

    public int getFilledReserveCount(UserGroup userGroup) {
        if (userGroup != null && userGroup.getPoolID() == this.poolID && userGroup.reserveCounter != null) {
            return userGroup.reserveCounter.count;
        }
        return -1;
    }

    public boolean areReservedSessionsAvailable(UserGroup userGroup) {
        if (userGroup != null && userGroup.getPoolID() == this.poolID && userGroup.reserveCounter != null) {
            return userGroup.reserveCounter.count < userGroup.getConnectionReserve();
        }
        return false;
    }

    public boolean areCommunalSessionsAvailable() {
        return this.COMMUNAL_COUNTER.count < this.maxConnections - this.getRequestedReserveCount();
    }

    protected void adjustReserveCount(UserGroup userGroup, boolean bl, boolean bl2) {
        if (userGroup != null && userGroup.getPoolID() == this.poolID && userGroup.reserveCounter != null) {
            UserGroupReserveCounter userGroupReserveCounter = this.COMMUNAL_COUNTER;
            if (bl2) {
                userGroupReserveCounter = userGroup.reserveCounter;
            }
            if (bl) {
                userGroupReserveCounter.inc();
            } else {
                userGroupReserveCounter.dec();
            }
        }
    }

    public UserGroupConnection addNewSession(String string, String string2, UserGroup userGroup, boolean bl) {
        UserGroupConnectionKey userGroupConnectionKey = this.getKey(string, string2, userGroup);
        if (!this.sessions.contains(userGroupConnectionKey)) {
            this.adjustReserveCount(userGroup, true, bl);
            UserGroupConnection userGroupConnection = new UserGroupConnection(string, string2, userGroup, this.timeoutMinutes * 60, bl);
            this.sessions.addElement(userGroupConnection);
            return userGroupConnection;
        }
        return null;
    }

    public Vector getSessions() {
        return this.sessions;
    }

    public UserGroupConnection getSession(String string, String string2, UserGroup userGroup) {
        UserGroupConnectionKey userGroupConnectionKey = this.getKey(string, string2, userGroup);
        int n = this.sessions.indexOf(userGroupConnectionKey);
        if (n > -1) {
            return (UserGroupConnection)this.sessions.elementAt(n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSession(String string, String string2, UserGroup userGroup) {
        UserGroupConnectionKey userGroupConnectionKey = this.getKey(string, string2, userGroup);
        int n = this.sessions.indexOf(userGroupConnectionKey);
        if (n > -1) {
            UserGroupConnection userGroupConnection = (UserGroupConnection)this.sessions.elementAt(n);
            this.adjustReserveCount(userGroupConnection.getUserGroup(), false, userGroupConnection.isUsingReservedConnection());
            this.sessions.removeElementAt(n);
            LinkFileManager linkFileManager = this.serverParent.getLinkFileManager();
            synchronized (linkFileManager) {
                this.serverParent.unpublishLinksWithFragment(LinkCodeGenerator.getIPAddressHeader(userGroupConnection.getIPAddress(), userGroupConnection.getLocalIPAddress()));
            }
            return true;
        }
        return false;
    }

    public void renewSession(String string, String string2, UserGroup userGroup) {
        UserGroupConnectionKey userGroupConnectionKey = this.getKey(string, string2, userGroup);
        int n = this.sessions.indexOf(userGroupConnectionKey);
        if (n > -1) {
            UserGroupConnection userGroupConnection = (UserGroupConnection)this.sessions.elementAt(n);
            userGroupConnection.heardFrom();
        } else {
            this.addNewSession(string, string2, userGroup, false);
        }
    }

    public void checkForTimeouts() {
        Enumeration enumeration = this.sessions.elements();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            UserGroupConnection userGroupConnection = (UserGroupConnection)enumeration.nextElement();
            if (userGroupConnection.isTimedOut()) {
                this.serverParent.logAccess(null, null, userGroupConnection.getIPAddress(), userGroupConnection.getLocalIPAddress(), null, userGroupConnection.getGroupName(), null, null, null, null, this.poolName, this.getSessionCount() + "", "unknown", "timedout", null);
                this.removeSession(userGroupConnection.getIPAddress(), userGroupConnection.getLocalIPAddress(), userGroupConnection.getUserGroup());
                ++n2;
                continue;
            }
            ++n;
        }
    }
}

