/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.ucb;

import InsightMIP.JaguarInsight;
import InsightMIP.JtipInsight;
import InsightMIP.JtipLevelDescriptor;
import InsightMIP.JtipTile;
import InsightMIP.ThesaurusInsight;
import com.luna.insight.server.AudioFieldCriterion;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.ImageInGroup;
import com.luna.insight.server.InsightJtipImage;
import com.luna.insight.server.InsightJtipTile;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.ObjectDimension;
import com.luna.insight.server.QtvrFieldCriterion;
import com.luna.insight.server.StringCriterionValue;
import com.luna.insight.server.VideoFieldCriterion;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.InsightBackendConnector;
import com.luna.insight.server.links.LinkFieldCriterion;
import com.luna.insight.server.links.LinkFieldMapping;
import com.luna.insight.server.mpd.MpdFieldCriterion;
import com.luna.insight.server.mvi.MviFieldCriterion;
import com.luna.insight.server.presentation.ImageSeries;
import com.luna.insight.server.presentation.ImageSeriesSlide;
import com.luna.insight.server.ucb.FuzzyDateFieldCriterion;
import com.luna.insight.server.ucb.FuzzyDateJulianRange;
import com.luna.insight.server.ucb.UcbFuzzyDateMachine;
import com.luna.insight.server.ucb.UcbHierarchyNodeData;
import com.luna.insight.server.ucb.UcbResultSet;
import com.luna.insight.server.ucb.UcbTreeNodeFieldCriterion;
import edu.berkeley.mip.thesaurus.ThesaurusNodeData;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class UcbSupportConnector
extends InsightBackendConnector {
    public static final int DEBUG_LEVEL = 3;
    public String VERSION_ID = "1.82 (09August2001)";
    public String COMPONENT_CODE = "UCBConnector";
    protected Properties mipProps = null;
    protected Properties ucbTableNames = null;
    public String UCB_TABLE_DENORM = "luci_denorm";
    public String UCB_TABLE_ITEM_DERIV_IMG = "item_deriv_img";
    public String UCB_TABLE_DIT_LEVEL1 = "dit_level1";
    public String UCB_TABLE_SUBJECT_OBJECT = "luci_subject_object";

    public UcbSupportConnector(Hashtable hashtable, Properties properties, Properties properties2) {
        super(hashtable);
        ((InsightBackendConnector)this).VERSION_ID = this.VERSION_ID;
        ((InsightBackendConnector)this).COMPONENT_CODE = this.COMPONENT_CODE;
        this.mipProps = properties;
        this.ucbTableNames = properties2;
        this.setTableNames(this.ucbTableNames);
    }

    public String getVersionId() {
        return this.VERSION_ID;
    }

    public String getImplementationName() {
        return "UCB " + this.dbConnectorGenerator.getConnectorTypeString() + " Insight Backend";
    }

    protected void setTableNames(Properties properties) {
        if (properties != null) {
            this.UCB_TABLE_DENORM = properties.getProperty("DenormTable", this.UCB_TABLE_DENORM);
            this.UCB_TABLE_ITEM_DERIV_IMG = properties.getProperty("ItemDerivImgTable", this.UCB_TABLE_ITEM_DERIV_IMG);
            this.UCB_TABLE_DIT_LEVEL1 = properties.getProperty("DitLevel1Table", this.UCB_TABLE_DIT_LEVEL1);
            this.UCB_TABLE_SUBJECT_OBJECT = properties.getProperty("SubjectObjectTable", this.UCB_TABLE_SUBJECT_OBJECT);
        }
    }

    public boolean getFuzzyDateSupport() {
        return true;
    }

    public FieldCriterion[] getFuzzyDateConversion(FieldCriterion fieldCriterion, String string) {
        return this.getFuzzyDateConversion(fieldCriterion, string, false);
    }

    public FieldCriterion[] getFuzzyDateConversion(FieldCriterion fieldCriterion, String string, boolean bl) {
        FieldCriterion[] fieldCriterionArray = null;
        if (fieldCriterion != null && fieldCriterion.field != null && fieldCriterion.field.date) {
            this.debugOut("in getFuzzyDateConversion().");
            try {
                FuzzyDateJulianRange fuzzyDateJulianRange = UcbFuzzyDateMachine.getFuzzyDateJulianRange(string);
                if (fuzzyDateJulianRange != null) {
                    String string2;
                    String string3;
                    if (bl) {
                        string3 = "early_j";
                        string2 = "late_j";
                    } else {
                        string3 = fieldCriterion.field.fieldName + "_Start";
                        string2 = fieldCriterion.field.fieldName + "_End";
                    }
                    fieldCriterionArray = new FieldCriterion[2];
                    fieldCriterionArray[0] = new FieldCriterion(fieldCriterion.booleanOperator, 7, new StringCriterionValue("" + fuzzyDateJulianRange.getStartJulian()), 1);
                    fieldCriterionArray[0].field = new Field(-1, string3, 2);
                    fieldCriterionArray[1] = new FieldCriterion(1, 8, new StringCriterionValue("" + fuzzyDateJulianRange.getEndJulian()), 2);
                    fieldCriterionArray[1].field = new Field(-1, string2, 2);
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getFuzzyDateConversion(): " + exception);
            }
        }
        return fieldCriterionArray;
    }

    public boolean getLexiconTreeSupport() {
        if (this.mipProps != null) {
            try {
                String[] stringArray = ThesaurusInsight.getThesaurusList();
                ThesaurusNodeData thesaurusNodeData = new ThesaurusNodeData("test", 0, 0, 0, 0, 0, 0);
                return true;
            }
            catch (Error error) {
                this.debugOut("Lexicon trees not supported, err: " + error);
                return false;
            }
            catch (Exception exception) {
                this.debugOut("Lexicon trees not supported, exp: " + exception);
                return false;
            }
        }
        return false;
    }

    public String[] getThesaurusList() {
        return ThesaurusInsight.getThesaurusList();
    }

    public Vector getTopLevelNodes(String string) {
        ThesaurusInsight thesaurusInsight;
        Vector vector;
        Vector<UcbHierarchyNodeData> vector2 = new Vector<UcbHierarchyNodeData>();
        if (this.mipProps != null && (vector = (thesaurusInsight = new ThesaurusInsight(string, this.mipProps)).doTreePathSearch(null)) != null) {
            ThesaurusNodeData thesaurusNodeData = (ThesaurusNodeData)vector.firstElement();
            vector2.addElement(new UcbHierarchyNodeData(string, thesaurusNodeData.string(), thesaurusNodeData.getNodeId(), thesaurusNodeData.getParentNodeId(), thesaurusNodeData.getLeftVisit(), thesaurusNodeData.getRightVisit(), thesaurusNodeData.getDepth(), vector.size() - 1));
        }
        return vector2;
    }

    public Vector doTermSearch(String string, String string2) {
        ThesaurusInsight thesaurusInsight;
        Vector vector;
        Vector<UcbHierarchyNodeData> vector2 = new Vector<UcbHierarchyNodeData>();
        if (this.mipProps != null && (vector = (thesaurusInsight = new ThesaurusInsight(string, this.mipProps)).doTermSearch(string2)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ThesaurusNodeData thesaurusNodeData = (ThesaurusNodeData)vector.elementAt(i);
                vector2.addElement(new UcbHierarchyNodeData(string, thesaurusNodeData.string(), thesaurusNodeData.getNodeId(), thesaurusNodeData.getParentNodeId(), thesaurusNodeData.getLeftVisit(), thesaurusNodeData.getRightVisit(), thesaurusNodeData.getDepth(), thesaurusNodeData.getTotalChildCount()));
            }
        }
        return vector2;
    }

    public Vector doTreePathSearch(UcbHierarchyNodeData ucbHierarchyNodeData) {
        if (ucbHierarchyNodeData != null) {
            return this.doTreePathSearch(ucbHierarchyNodeData.getHierarchyName(), ucbHierarchyNodeData);
        }
        return null;
    }

    public Vector doTreePathSearch(String string, UcbHierarchyNodeData ucbHierarchyNodeData) {
        Vector<UcbHierarchyNodeData> vector = new Vector<UcbHierarchyNodeData>();
        if (this.mipProps != null) {
            Vector vector2;
            ThesaurusInsight thesaurusInsight = new ThesaurusInsight(string, this.mipProps);
            ThesaurusNodeData thesaurusNodeData = null;
            if (ucbHierarchyNodeData != null) {
                thesaurusNodeData = new ThesaurusNodeData(ucbHierarchyNodeData.getNodeName(), ucbHierarchyNodeData.getNodeID(), ucbHierarchyNodeData.getParentNodeID(), ucbHierarchyNodeData.getLeftVisit(), ucbHierarchyNodeData.getRightVisit(), ucbHierarchyNodeData.getDepth(), ucbHierarchyNodeData.getTotalChildCount());
            }
            if ((vector2 = thesaurusInsight.doTreePathSearch(thesaurusNodeData)) != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    ThesaurusNodeData thesaurusNodeData2 = (ThesaurusNodeData)vector2.elementAt(i);
                    vector.addElement(new UcbHierarchyNodeData(string, thesaurusNodeData2.string(), thesaurusNodeData2.getNodeId(), thesaurusNodeData2.getParentNodeId(), thesaurusNodeData2.getLeftVisit(), thesaurusNodeData2.getRightVisit(), thesaurusNodeData2.getDepth(), thesaurusNodeData2.getTotalChildCount()));
                }
            }
        }
        return vector;
    }

    public Vector doTreeChildSearch(UcbHierarchyNodeData ucbHierarchyNodeData) {
        if (ucbHierarchyNodeData != null && this.mipProps != null) {
            String string = ucbHierarchyNodeData.getHierarchyName();
            ThesaurusInsight thesaurusInsight = new ThesaurusInsight(string, this.mipProps);
            ThesaurusNodeData thesaurusNodeData = null;
            thesaurusNodeData = new ThesaurusNodeData(ucbHierarchyNodeData.getNodeName(), ucbHierarchyNodeData.getNodeID(), ucbHierarchyNodeData.getParentNodeID(), ucbHierarchyNodeData.getLeftVisit(), ucbHierarchyNodeData.getRightVisit(), ucbHierarchyNodeData.getDepth(), ucbHierarchyNodeData.getTotalChildCount());
            Vector vector = thesaurusInsight.doTreeChildSearch(thesaurusNodeData);
            Vector<UcbHierarchyNodeData> vector2 = new Vector<UcbHierarchyNodeData>();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    ThesaurusNodeData thesaurusNodeData2 = (ThesaurusNodeData)vector.elementAt(i);
                    vector2.addElement(new UcbHierarchyNodeData(string, thesaurusNodeData2.string(), thesaurusNodeData2.getNodeId(), thesaurusNodeData2.getParentNodeId(), thesaurusNodeData2.getLeftVisit(), thesaurusNodeData2.getRightVisit(), thesaurusNodeData2.getDepth(), thesaurusNodeData2.getTotalChildCount()));
                }
            }
            return vector2;
        }
        return null;
    }

    public Vector doAncillarySearch(UcbHierarchyNodeData ucbHierarchyNodeData, String string) {
        if (ucbHierarchyNodeData != null && this.mipProps != null) {
            String string2 = ucbHierarchyNodeData.getHierarchyName();
            ThesaurusInsight thesaurusInsight = new ThesaurusInsight(string2, this.mipProps);
            ThesaurusNodeData thesaurusNodeData = null;
            thesaurusNodeData = new ThesaurusNodeData(ucbHierarchyNodeData.getNodeName(), ucbHierarchyNodeData.getNodeID(), ucbHierarchyNodeData.getParentNodeID(), ucbHierarchyNodeData.getLeftVisit(), ucbHierarchyNodeData.getRightVisit(), ucbHierarchyNodeData.getDepth(), ucbHierarchyNodeData.getTotalChildCount());
            Vector vector = thesaurusInsight.doAncillarySearch(thesaurusNodeData, string);
            return vector;
        }
        return null;
    }

    public boolean getJTIPSupport() {
        if (this.mipProps != null) {
            DatabaseConnector databaseConnector;
            block8: {
                databaseConnector = this.getDatabaseConnector();
                try {
                    databaseConnector.setQuery("SELECT JtipSupport FROM UCBSupports;");
                    databaseConnector.runQuery();
                    if (databaseConnector.more()) {
                        if (databaseConnector.getIntegerFieldByName("JtipSupport") != 1) {
                            return false;
                        }
                        break block8;
                    }
                    return false;
                }
                catch (Exception exception) {
                    databaseConnector.close();
                    return false;
                }
            }
            databaseConnector.close();
            try {
                JtipInsight jtipInsight = new JtipInsight(this.mipProps);
            }
            catch (Error error) {
                this.debugOut("JTIPS not supported, err: " + error);
                return false;
            }
            catch (Exception exception) {
                this.debugOut("JTIPS not supported, exp: " + exception);
                return false;
            }
            return true;
        }
        return false;
    }

    public int getJtipLevelCount(String string) {
        if (string != null && this.mipProps != null) {
            try {
                JtipInsight jtipInsight = new JtipInsight(this.mipProps);
                return jtipInsight.getLevelCount(string);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getJtipLevelCount, e: " + exception);
            }
        }
        return 0;
    }

    public InsightJtipImage getJtipImage(long l, int n) {
        if (this.mipProps != null) {
            try {
                int n2 = n + 1;
                JtipInsight jtipInsight = new JtipInsight(this.mipProps);
                JtipLevelDescriptor jtipLevelDescriptor = jtipInsight.getLevelDescriptor(l + "", n2);
                if (jtipLevelDescriptor != null) {
                    return this.convertToInsightJtipImage(jtipLevelDescriptor);
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getJtipImage, e: " + exception);
            }
        }
        return null;
    }

    public Vector getJtipImages(long l) {
        if (l != 0L && this.mipProps != null) {
            try {
                JtipInsight jtipInsight = new JtipInsight(this.mipProps);
                int n = jtipInsight.getLevelCount("" + l);
                Vector<InsightJtipImage> vector = new Vector<InsightJtipImage>();
                for (int i = 1; i <= n; ++i) {
                    try {
                        JtipLevelDescriptor jtipLevelDescriptor = jtipInsight.getLevelDescriptor("" + l, i);
                        if (jtipLevelDescriptor == null) continue;
                        vector.addElement(this.convertToInsightJtipImage(jtipLevelDescriptor));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return vector;
            }
            catch (Exception exception) {
                this.debugOut("Exception in getJtipImage, e: " + exception);
            }
        }
        return null;
    }

    public Vector getJtipImageData(Vector vector) {
        Vector vector2 = new Vector();
        if (vector != null && this.mipProps != null) {
            try {
                Vector vector3 = this.convertToUcbTiles(vector);
                JtipInsight jtipInsight = new JtipInsight(this.mipProps);
                jtipInsight.fetchJpegData(vector3);
                vector2 = this.convertToInsightTiles(vector3);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getJtipImageData(), e: " + exception);
            }
        }
        return vector2;
    }

    public InsightJtipImage convertToInsightJtipImage(JtipLevelDescriptor jtipLevelDescriptor) {
        JtipTile[][] jtipTileArray;
        if (jtipLevelDescriptor != null && (jtipTileArray = jtipLevelDescriptor.tiles) != null) {
            Vector<JtipTile> vector = new Vector<JtipTile>();
            for (int i = 0; i < jtipTileArray.length; ++i) {
                for (int j = 0; j < jtipTileArray[i].length; ++j) {
                    vector.addElement(jtipTileArray[i][j]);
                }
            }
            Vector vector2 = this.convertToInsightTiles(vector);
            InsightJtipImage insightJtipImage = new InsightJtipImage(jtipLevelDescriptor.strImageID, jtipLevelDescriptor.nLevel, jtipLevelDescriptor.nRows, jtipLevelDescriptor.nColumns, jtipLevelDescriptor.rectSize, vector2);
            return insightJtipImage;
        }
        return null;
    }

    public Vector convertToInsightTiles(Vector vector) {
        if (vector != null) {
            Vector<InsightJtipTile> vector2 = new Vector<InsightJtipTile>();
            for (int i = 0; i < vector.size(); ++i) {
                JtipTile jtipTile = (JtipTile)vector.elementAt(i);
                vector2.addElement(new InsightJtipTile(jtipTile.strImageID, jtipTile.nLevel, jtipTile.nRow, jtipTile.nColumn, jtipTile.rectCoverage, jtipTile.jpegData));
            }
            return vector2;
        }
        return null;
    }

    public Vector convertToUcbTiles(Vector vector) {
        if (vector != null) {
            Vector<JtipTile> vector2 = new Vector<JtipTile>();
            for (int i = 0; i < vector.size(); ++i) {
                InsightJtipTile insightJtipTile = (InsightJtipTile)vector.elementAt(i);
                vector2.addElement(new JtipTile(insightJtipTile.getImageId(), insightJtipTile.getLevel(), insightJtipTile.getRow(), insightJtipTile.getCol(), insightJtipTile.getCoverage()));
            }
            return vector2;
        }
        return null;
    }

    public Vector getImageFiles(long l, int n, int n2) {
        return this.getJtipImages(l);
    }

    public ImageFile getImageFile(long l, int n, int n2, int n3) {
        return this.getJtipImage(l, n);
    }

    public ObjectDimension getObjectDimension(Integer n, long l) {
        this.debugOut("getObjectDimension(), image ID: " + l);
        ObjectDimension objectDimension = new ObjectDimension(l);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            String string = "SELECT * FROM IROBJECTDIMENSION WHERE UniqueCollectionID = " + n;
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                int n2;
                int n3 = databaseConnector.getIntegerFieldByName("WidthFieldID");
                int n4 = databaseConnector.getIntegerFieldByName("HeightFieldID");
                objectDimension.metric = n2 = databaseConnector.getIntegerFieldByName("Metric");
                databaseConnector.close();
                databaseConnector.setQuery("SELECT FieldId, FieldName FROM " + this.IG_TABLE_FIELDS + " WHERE (FieldId = " + n3 + " OR FieldId = " + n4 + ")");
                this.debugOut("Query: \n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    String string2 = null;
                    String string3 = null;
                    while (databaseConnector.more()) {
                        int n5 = databaseConnector.getIntegerFieldByName("FieldId");
                        if (n5 == n3) {
                            string2 = this.underscoreFieldName(databaseConnector.getFieldByName("FieldName"));
                        }
                        if (n5 == n4) {
                            string3 = this.underscoreFieldName(databaseConnector.getFieldByName("FieldName"));
                        }
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    if (string2 != null && string3 != null) {
                        string = "SELECT " + this.UCB_TABLE_DENORM + ".item_id, " + this.UCB_TABLE_DENORM + "." + string2 + ", " + this.UCB_TABLE_DENORM + "." + string3 + " FROM (" + this.IG_TABLE_OBJECT_IMAGE_MAP + " INNER JOIN " + this.UCB_TABLE_DENORM + " ON " + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ObjectID = " + this.UCB_TABLE_DENORM + ".item_id)" + " WHERE (" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID = " + l + ")";
                        databaseConnector.setQuery(string);
                        this.debugOut("Query: \n" + databaseConnector.getQuery());
                        databaseConnector.runQuery();
                        if (databaseConnector.more()) {
                            objectDimension.objectID = databaseConnector.getLongField("item_id");
                            objectDimension.convertDimension(databaseConnector.getFieldByName(string2), databaseConnector.getFieldByName(string3));
                        }
                        databaseConnector.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getObjectDimension: " + exception);
        }
        databaseConnector.close();
        return objectDimension;
    }

    public FieldValue[] getFullInformation(long l) {
        if (this.connectString != null) {
            this.debugOut("In getFullInformation(), objectID: " + l);
            String string = "SELECT " + this.IG_TABLE_FIELDS + ".FieldID, " + this.IG_TABLE_FIELDS + ".FieldName, " + this.IG_TABLE_FIELDS + ".TableName, " + this.IG_TABLE_FIELDS + ".DisplayOrder, " + this.IG_TABLE_FIELDS + ".FieldType" + " FROM " + this.IG_TABLE_FIELDS + " WHERE " + this.IG_TABLE_FIELDS + ".Displayed = 1 AND " + this.IG_TABLE_FIELDS + ".FieldType <> 0" + " ORDER BY " + this.IG_TABLE_FIELDS + ".DisplayOrder;";
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            while (databaseConnector.more()) {
                try {
                    vector.addElement(databaseConnector.getFieldByName("FieldName").replace(' ', '_'));
                    vector2.addElement(new Integer(databaseConnector.getIntegerField("FieldID")));
                }
                catch (Exception exception) {
                    this.debugOut("Exception in getFullInformation(): " + exception);
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            int n = vector.size();
            Object[] objectArray = new String[n];
            Object[] objectArray2 = new Integer[n];
            vector.copyInto(objectArray);
            vector2.copyInto(objectArray2);
            String string2 = "SELECT " + this.UCB_TABLE_DENORM + ".*";
            String string3 = " FROM (" + this.IG_TABLE_OBJECT_IMAGE_MAP + " INNER JOIN " + this.UCB_TABLE_DENORM + " ON " + this.UCB_TABLE_DENORM + ".item_id = " + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ObjectID)";
            String string4 = " WHERE (" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ObjectID = " + l + ");";
            String string5 = string2 + string3 + string4;
            this.debugOut("getFullInformation(), full info query is...\n" + string5);
            databaseConnector.setQuery(string5);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                this.debugOut("At least one element found.");
                int n2 = n * 2;
                Vector<FieldValue> vector3 = new Vector<FieldValue>(n2);
                for (int i = 0; i < n; ++i) {
                    try {
                        String string6 = databaseConnector.getFieldByName((String)objectArray[i]);
                        if (string6 == null) continue;
                        vector3.addElement(new FieldValue((Integer)objectArray2[i], ((String)objectArray[i]).replace('_', ' '), string6, false));
                        continue;
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception while attempting to gather data from field " + (String)objectArray[i]);
                        this.debugOut(exception.toString());
                    }
                }
                Object[] objectArray3 = new FieldValue[vector3.size()];
                vector3.copyInto(objectArray3);
                databaseConnector.close();
                return objectArray3;
            }
            this.debugOut("No matching elements.");
            databaseConnector.close();
            return new FieldValue[0];
        }
        this.debugOut("Database connect string not specified.");
        return new FieldValue[0];
    }

    public Vector doThumbnailQuery(int n, String[] stringArray, FieldCriterion[] fieldCriterionArray, String[] stringArray2, int n2, int n3) {
        Vector vector = new Vector();
        if (this.mipProps != null) {
            try {
                Object[] objectArray;
                int n4;
                Object object;
                String string;
                String string2 = " FROM " + this.IG_TABLE_GROUPS + ", " + this.IG_TABLE_GROUP_IMAGE_MAP + ", " + this.IG_TABLE_OBJECT_IMAGE_MAP + ", " + this.UCB_TABLE_DENORM + ", " + this.UCB_TABLE_ITEM_DERIV_IMG + ", " + this.UCB_TABLE_DIT_LEVEL1;
                String string3 = "";
                string3 = string3 + " WHERE ((" + this.IG_TABLE_GROUPS + ".GroupID = " + n + ")";
                string3 = string3 + " AND (" + this.IG_TABLE_GROUPS + ".GroupID = " + this.IG_TABLE_GROUP_IMAGE_MAP + ".GroupID)";
                string3 = string3 + " AND (" + this.IG_TABLE_GROUP_IMAGE_MAP + ".ImageID = " + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID)";
                string3 = string3 + " AND (" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ObjectID = " + this.UCB_TABLE_DENORM + ".item_id)";
                string3 = string3 + " AND (" + this.UCB_TABLE_DENORM + ".item_id = " + this.UCB_TABLE_ITEM_DERIV_IMG + ".item_id)";
                string3 = string3 + " AND (" + this.UCB_TABLE_ITEM_DERIV_IMG + ".image_id = " + this.UCB_TABLE_DIT_LEVEL1 + ".image_id)";
                if (fieldCriterionArray != null && fieldCriterionArray.length > 0) {
                    string = this.createCriteriaClause(fieldCriterionArray);
                    this.debugOut("Criteria string: " + string);
                    if (!string.equals("")) {
                        string3 = string3 + " AND (" + string + ")";
                    }
                }
                string3 = string3 + ")";
                string = "";
                String string4 = this.createOrderBy(this.underscoreFields(stringArray2));
                if (string4.length() > 0) {
                    string = " ORDER BY " + string4;
                }
                if (stringArray != null) {
                    object = new Vector();
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        if (stringArray[n4] == null || stringArray[n4].length() <= 0) continue;
                        ((Vector)object).addElement(stringArray[n4]);
                    }
                    objectArray = new String[((Vector)object).size()];
                    ((Vector)object).copyInto(objectArray);
                    objectArray = this.underscoreFields((String[])objectArray);
                } else {
                    objectArray = new String[]{};
                }
                object = "SELECT ";
                n4 = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null || ((String)objectArray[i]).length() <= 0) continue;
                    object = (String)object + this.convertFieldName((String)objectArray[i]) + ", ";
                    ++n4;
                }
                object = (String)object + this.UCB_TABLE_DENORM + ".item_id, " + this.UCB_TABLE_DIT_LEVEL1 + ".image_id, " + this.UCB_TABLE_DIT_LEVEL1 + ".tile_width, " + this.UCB_TABLE_DIT_LEVEL1 + ".tile_height";
                if (string4.length() > 0) {
                    object = (String)object + ", " + string4;
                }
                this.debugOut("Thumbnail query:\n '" + (String)object + string2 + string3 + string + "'");
                vector = this.processThumbnailResults(n4, (String)object, string2, string3, string, n2, n3);
            }
            catch (Exception exception) {
                this.debugOut("Exception in doThumbnailQuery(), e: " + exception);
                vector = new Vector(0);
            }
        }
        return vector;
    }

    public Vector doFreeTextThumbnailQuery(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, int n2, int n3) {
        Vector vector = new Vector();
        if (this.mipProps != null) {
            try {
                int n4;
                Object object;
                Object object2;
                String string = " FROM " + this.IG_TABLE_GROUPS + ", " + this.IG_TABLE_GROUP_IMAGE_MAP + ", " + this.IG_TABLE_OBJECT_IMAGE_MAP + ", " + this.UCB_TABLE_DENORM + ", " + this.UCB_TABLE_ITEM_DERIV_IMG + ", " + this.UCB_TABLE_DIT_LEVEL1;
                String string2 = "";
                string2 = string2 + " WHERE ((" + this.IG_TABLE_GROUPS + ".GroupID = " + n + ")";
                string2 = string2 + " AND (" + this.IG_TABLE_GROUPS + ".GroupID = " + this.IG_TABLE_GROUP_IMAGE_MAP + ".GroupID)";
                string2 = string2 + " AND (" + this.IG_TABLE_GROUP_IMAGE_MAP + ".ImageID = " + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID)";
                string2 = string2 + " AND (" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ObjectID = " + this.UCB_TABLE_DENORM + ".item_id)";
                string2 = string2 + " AND (" + this.UCB_TABLE_DENORM + ".item_id = " + this.UCB_TABLE_ITEM_DERIV_IMG + ".item_id)";
                string2 = string2 + " AND (" + this.UCB_TABLE_ITEM_DERIV_IMG + ".image_id = " + this.UCB_TABLE_DIT_LEVEL1 + ".image_id)";
                if (stringArray2 != null && stringArray2.length > 0) {
                    string2 = string2 + " AND (";
                    boolean bl = true;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        object2 = new StringTokenizer(stringArray2[i]);
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            if (!bl) {
                                string2 = string2 + " AND ";
                            }
                            string2 = string2 + "(" + this.UCB_TABLE_DENORM + ".item_id = ANY (SELECT " + this.UCB_TABLE_DENORM + ".item_id FROM (ReverseLookup INNER JOIN Keywords ON ReverseLookup.ValueID = Keywords.ValueID) INNER JOIN " + this.UCB_TABLE_DENORM + " ON ReverseLookup.ObjectID = " + this.UCB_TABLE_DENORM + ".item_id WHERE ";
                            string2 = string2 + "(Keywords.ValueText = '" + ((StringTokenizer)object2).nextToken() + "')))";
                            bl = false;
                        }
                    }
                    string2 = string2 + ")";
                }
                string2 = string2 + ")";
                String string3 = "";
                String string4 = this.createOrderBy(this.underscoreFields(stringArray3));
                if (string4.length() > 0) {
                    string3 = " ORDER BY " + string4;
                }
                if (stringArray != null) {
                    object = new Vector();
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        if (stringArray[n4] == null || stringArray[n4].length() <= 0) continue;
                        ((Vector)object).addElement(stringArray[n4]);
                    }
                    object2 = new String[((Vector)object).size()];
                    ((Vector)object).copyInto((Object[])object2);
                    object2 = this.underscoreFields((String[])object2);
                } else {
                    object2 = new String[]{};
                }
                object = "SELECT ";
                n4 = 0;
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    if (object2[i] == null || ((String)object2[i]).length() <= 0) continue;
                    object = (String)object + this.convertFieldName((String)object2[i]) + ", ";
                    ++n4;
                }
                object = (String)object + this.UCB_TABLE_DENORM + ".item_id, " + this.UCB_TABLE_DIT_LEVEL1 + ".image_id, " + this.UCB_TABLE_DIT_LEVEL1 + ".tile_width, " + this.UCB_TABLE_DIT_LEVEL1 + ".tile_height";
                if (string4.length() > 0) {
                    object = (String)object + ", " + string4;
                }
                this.debugOut("Free text thumbnail query:\n '" + (String)object + string + string2 + string3 + "'");
                vector = this.processThumbnailResults(n4, (String)object, string, string2, string3, n2, n3);
            }
            catch (Exception exception) {
                this.debugOut("Exception in doThumbnailQuery(), e: " + exception);
                vector = new Vector(0);
            }
        }
        return vector;
    }

    protected Vector processThumbnailResults(int n, String string, String string2, String string3, String string4, int n2, int n3) {
        Vector<InsightSmartClientResults> vector = new Vector<InsightSmartClientResults>();
        try {
            JaguarInsight jaguarInsight = new JaguarInsight(this.mipProps);
            Vector vector2 = jaguarInsight.doSimpleQuery(string, string2, string3, string4);
            UcbResultSet ucbResultSet = new UcbResultSet(vector2);
            this.totalRecords = ucbResultSet.getRecordCount();
            this.debugOut("Skipping " + n2 + " items.");
            ucbResultSet.advanceToRecord(n2);
            this.debugOut("Retrieving items.");
            int n4 = 0;
            for (int i = 0; i < n3 && ucbResultSet.more(); ++i) {
                this.debugOut("Retreiving item " + i);
                InsightSmartClientResults insightSmartClientResults = new InsightSmartClientResults();
                insightSmartClientResults.fieldData = new String[n];
                for (int j = 0; j < n; ++j) {
                    insightSmartClientResults.fieldData[j] = ucbResultSet.getColumnValueString(j);
                }
                insightSmartClientResults.objectID = ucbResultSet.getColumnValueLong(n);
                insightSmartClientResults.imageID = ucbResultSet.getColumnValueLong(n + 1);
                insightSmartClientResults.thumbDimension = new Dimension(ucbResultSet.getColumnValueInt(n + 2), ucbResultSet.getColumnValueInt(n + 3));
                insightSmartClientResults.mediaType = 1;
                insightSmartClientResults.thumbnailURL = "UCB THUMBNAIL";
                insightSmartClientResults.iscrLocale = this.collectionLocale;
                vector.addElement(insightSmartClientResults);
                ucbResultSet.next();
                ++n4;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in processThumbnailResults(): " + exception);
            vector = new Vector(0);
        }
        Collections.sort(vector);
        return vector;
    }

    public CriterionValue[] getUniqueList(String string, int n, int n2, String string2, int n3, Vector vector) {
        String string3 = string.replace(' ', '_');
        CriterionValue[] criterionValueArray = new CriterionValue[]{};
        this.debugOut("In getUniqueList() with fieldName = " + string);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            Object object;
            int n4;
            Object object2;
            String string4 = "SELECT DISTINCT " + this.UCB_TABLE_DENORM + "." + string3 + " FROM " + this.IG_TABLE_GROUPS + ", " + this.IG_TABLE_GROUP_IMAGE_MAP + ", " + this.IG_TABLE_OBJECT_IMAGE_MAP + ", " + this.UCB_TABLE_DENORM + ", " + this.UCB_TABLE_ITEM_DERIV_IMG + ", " + this.UCB_TABLE_DIT_LEVEL1 + " WHERE (((" + this.IG_TABLE_GROUP_IMAGE_MAP + ".GroupID)=" + n + ") AND (" + this.IG_TABLE_GROUPS + ".GroupID = " + this.IG_TABLE_GROUP_IMAGE_MAP + ".GroupID) AND (" + this.IG_TABLE_GROUP_IMAGE_MAP + ".ImageID = " + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID) AND (" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ObjectID = " + this.UCB_TABLE_DENORM + ".item_id) AND (" + this.UCB_TABLE_DENORM + ".item_id = " + this.UCB_TABLE_ITEM_DERIV_IMG + ".item_id) AND (" + this.UCB_TABLE_ITEM_DERIV_IMG + ".image_id = " + this.UCB_TABLE_DIT_LEVEL1 + ".image_id)";
            if (n2 != 0 && string2 != null) {
                object2 = this.UCB_TABLE_DENORM + "." + string3;
                if (this.useLowerCaseCommand) {
                    object2 = "LOWER(" + (String)object2 + ")";
                }
                n4 = 0;
                object = this.escapeSpecialCharacters(string2);
                if (this.useLowerCaseCommand) {
                    if (object == null) {
                        object = "LOWER('" + (String)object + "')";
                    } else if (this.useLowerCaseCommandOnSearchValue) {
                        n4 = 1;
                    } else {
                        object = ((String)object).toLowerCase();
                    }
                }
                string4 = string4 + " AND " + this.createEquivalenceRelationshipClause((String)object2, 1, n2, (String)object, n4 != 0);
            }
            string4 = string4 + ") ORDER BY " + this.UCB_TABLE_DENORM + "." + string3 + ";";
            this.debugOut("getUniqueList query is:\n" + string4);
            databaseConnector.setQuery(string4);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                object2 = new Vector();
                n4 = 0;
                while (databaseConnector.more()) {
                    object = new StringCriterionValue(databaseConnector.getFieldByName(string3));
                    if (object != null && !((CriterionValue)object).isEmpty()) {
                        ((Vector)object2).addElement(object);
                        ++n4;
                    }
                    databaseConnector.next();
                }
                this.debugOut(n4 + " elements found.");
                criterionValueArray = new CriterionValue[n4];
                for (int i = 0; i < n4; ++i) {
                    criterionValueArray[i] = (CriterionValue)((Vector)object2).elementAt(i);
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueList(): " + exception);
        }
        databaseConnector.close();
        if (n3 > -1) {
            if (criterionValueArray.length > n3) {
                return null;
            }
            return criterionValueArray;
        }
        return criterionValueArray;
    }

    public Vector getImagesInGroup(int n, int n2, int n3, CollectionKey collectionKey) {
        this.debugOut("In getImagesInGroup.");
        Vector<ImageInGroup> vector = new Vector<ImageInGroup>();
        if (this.mipProps != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                databaseConnector.setQuery("SELECT DISTINCT " + this.IG_TABLE_GROUP_IMAGE_MAP + ".*" + " FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + ", " + this.IG_TABLE_PROFILE + " WHERE (" + this.IG_TABLE_GROUP_IMAGE_MAP + ".GroupID = " + n + ") AND (" + this.IG_TABLE_PROFILE + ".ProfileID = " + n2 + ") AND (" + this.IG_TABLE_PROFILE + ".CollectionID = " + n3 + ")" + " ORDER BY " + this.IG_TABLE_GROUP_IMAGE_MAP + ".ImageID");
                this.debugOut("Query is:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    boolean bl;
                    long l = databaseConnector.getLongField("ObjectID");
                    long l2 = databaseConnector.getLongField("ImageID");
                    try {
                        bl = databaseConnector.getBooleanField("MpdSeries");
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    Vector vector2 = this.getJtipImages(l2);
                    vector.addElement(new ImageInGroup(l, l2, bl, collectionKey, vector2));
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getImagesInGroup(): " + exception);
            }
            databaseConnector.close();
        }
        return vector;
    }

    public ImageSeries getImageSeries(int n, int n2, int n3) {
        this.debugOut("In getImageSeries(" + n + ", " + n2 + ")");
        ImageSeries imageSeries = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT " + this.IG_TABLE_IMAGE_SERIES + ".*, " + this.IG_TABLE_GROUPS + ".Name" + " FROM " + this.IG_TABLE_GROUPS + " INNER JOIN " + this.IG_TABLE_IMAGE_SERIES + " ON " + this.IG_TABLE_GROUPS + ".GroupID = " + this.IG_TABLE_IMAGE_SERIES + ".GroupID" + " WHERE (ImageSeriesID = " + n + ");");
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                String string = databaseConnector.getFieldByName("SeriesName");
                imageSeries = new ImageSeries(string, n);
                Vector vector = imageSeries.getSlideVector();
                databaseConnector.close();
                databaseConnector.setQuery("SELECT " + this.IG_TABLE_IMAGE_SERIES_SLIDES + ".*, " + this.IG_TABLE_IMAGE_SERIES_SLIDES + ".DisplayOrder" + " FROM " + this.IG_TABLE_IMAGE_SERIES_SLIDES + " WHERE (" + this.IG_TABLE_IMAGE_SERIES_SLIDES + ".ImageSeriesID = " + n + ")" + " ORDER BY " + this.IG_TABLE_IMAGE_SERIES_SLIDES + ".DisplayOrder;");
                this.debugOut("Query is: " + databaseConnector.getQuery());
                databaseConnector.runQuery();
                int n4 = -1;
                while (databaseConnector.more()) {
                    int n5 = databaseConnector.getIntegerFieldByName("DisplayOrder");
                    if (n5 > n4) {
                        n4 = n5;
                        long l = databaseConnector.getLongField("ObjectID");
                        long l2 = databaseConnector.getLongField("ImageID");
                        int n6 = databaseConnector.getIntegerFieldByName("Resolution");
                        Rectangle rectangle = new Rectangle(databaseConnector.getIntegerFieldByName("XPosition"), databaseConnector.getIntegerFieldByName("YPosition"), databaseConnector.getIntegerFieldByName("Width"), databaseConnector.getIntegerFieldByName("Height"));
                        if (rectangle.width == -1 && rectangle.height == -1) {
                            rectangle = null;
                        }
                        Point point = new Point(databaseConnector.getIntegerFieldByName("ViewLeft"), databaseConnector.getIntegerFieldByName("ViewTop"));
                        if (point.x == -1 && point.y == -1) {
                            point = null;
                        }
                        Dimension dimension = new Dimension(databaseConnector.getIntegerFieldByName("TotalWidth"), databaseConnector.getIntegerFieldByName("TotalHeight"));
                        if (dimension.width == -1 && dimension.height == -1) {
                            dimension = null;
                        }
                        boolean bl = databaseConnector.getIntegerFieldByName("Enabled") == 1;
                        int n7 = databaseConnector.getIntegerFieldByName("LinkCount");
                        boolean bl2 = databaseConnector.getIntegerFieldByName("Maximized") == 1;
                        boolean bl3 = databaseConnector.getIntegerFieldByName("Minimized") == 1;
                        ImageSeriesSlide imageSeriesSlide = new ImageSeriesSlide(n, l, l2, new CollectionKeyWrapper("", "", null), n6, rectangle, point, dimension, bl, n7, null, bl2, bl3);
                        this.debugOut("Adding: " + imageSeriesSlide);
                        vector.addElement(imageSeriesSlide);
                    }
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageSeries: " + exception);
        }
        databaseConnector.close();
        return imageSeries;
    }

    protected void debugOut(String string) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, 3);
    }

    protected String[] underscoreFields(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace(' ', '_');
        }
        return stringArray;
    }

    protected String createCriteriaClause(FieldCriterion[] fieldCriterionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fieldCriterionArray != null) {
            for (int i = 0; i < fieldCriterionArray.length; ++i) {
                String string;
                Object object;
                FieldCriterion fieldCriterion = fieldCriterionArray[i];
                if (fieldCriterion != null && fieldCriterion instanceof UcbTreeNodeFieldCriterion) {
                    object = (UcbTreeNodeFieldCriterion)fieldCriterion;
                    if (i > 0) {
                        if (((UcbTreeNodeFieldCriterion)object).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(");
                    stringBuffer.append("EXISTS (SELECT * FROM " + this.UCB_TABLE_SUBJECT_OBJECT + " WHERE left_v BETWEEN " + ((UcbTreeNodeFieldCriterion)object).leftVisitation + " AND " + ((UcbTreeNodeFieldCriterion)object).rightVisitation + " AND luci_subject_object.item_id = " + this.UCB_TABLE_DENORM + ".item_id)");
                    stringBuffer.append(")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof MviFieldCriterion) {
                    object = (MviFieldCriterion)fieldCriterion;
                    if (i > 0) {
                        if (((MviFieldCriterion)object).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_GROUP_IMAGE_MAP + ".MviSeries = 1)");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof MpdFieldCriterion) {
                    object = (MpdFieldCriterion)fieldCriterion;
                    if (i > 0) {
                        if (((MpdFieldCriterion)object).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_GROUP_IMAGE_MAP + ".MpdSeries = 1)");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof AudioFieldCriterion) {
                    object = (AudioFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((AudioFieldCriterion)object).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_IMAGE_FILES + ".MediaType = " + 2 + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof VideoFieldCriterion) {
                    object = (VideoFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((VideoFieldCriterion)object).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_IMAGE_FILES + ".MediaType = " + 3 + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof QtvrFieldCriterion) {
                    object = (QtvrFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((QtvrFieldCriterion)object).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_IMAGE_FILES + ".MediaType = " + 4 + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof FuzzyDateFieldCriterion && fieldCriterion.fieldMapping != null) {
                    if (!this.supportsFuzzyDates) continue;
                    object = (FuzzyDateFieldCriterion)fieldCriterion;
                    String string2 = "(" + this.convertFieldName("early_j") + " >= " + ((FuzzyDateFieldCriterion)object).getStartJulian() + " AND " + this.convertFieldName("late_j") + " <= " + ((FuzzyDateFieldCriterion)object).getEndJulian() + ")";
                    if (string2.length() <= 0) continue;
                    if (stringBuffer.length() > 0) {
                        if (((FuzzyDateFieldCriterion)object).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + string2 + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof LinkFieldCriterion && (fieldCriterion.relationship != 0 || ((LinkFieldCriterion)fieldCriterion).getFuzzyDateJulianRange() != null) && fieldCriterion.fieldMapping != null && fieldCriterion.fieldMapping instanceof LinkFieldMapping) {
                    object = (LinkFieldCriterion)fieldCriterion;
                    String string3 = "";
                    if (((LinkFieldCriterion)object).getFuzzyDateJulianRange() != null) {
                        if (((LinkFieldCriterion)object).fieldMapping.isFuzzyDateSearchable()) {
                            string = this.underscoreFieldName(fieldCriterion.fieldMapping.fieldName);
                            string3 = "(" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID = ANY (" + "SELECT ImageID FROM " + "IRLINKREPOSITORY" + " WHERE " + this.createLinkCodeClause(((LinkFieldCriterion)object).getCollectionKey(), ((LinkFieldCriterion)object).getClientIP(), ((LinkFieldCriterion)object).getLocalClientIP(), ((LinkFieldCriterion)object).getUserGroupShells()) + " AND " + string + "_Start" + " >= " + ((LinkFieldCriterion)object).getFuzzyDateJulianRange().getStartJulian() + " AND " + string + "_End" + " <= " + ((LinkFieldCriterion)object).getFuzzyDateJulianRange().getEndJulian() + "))";
                        }
                    } else {
                        string = this.useLowerCaseCommand ? "(LOWER(" + this.underscoreFieldName(fieldCriterion.fieldMapping.fieldName) + "))" : "(" + this.underscoreFieldName(fieldCriterion.fieldMapping.fieldName) + ")";
                        boolean bl = false;
                        String string4 = this.escapeSpecialCharacters(fieldCriterion.equivalence.getSearchValue());
                        if (this.useLowerCaseCommand) {
                            if (string4 == null) {
                                string4 = "LOWER('" + string4 + "')";
                            } else if (this.useLowerCaseCommandOnSearchValue) {
                                bl = true;
                            } else {
                                string4 = string4.toLowerCase();
                            }
                        }
                        string3 = "(" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID = ANY (" + "SELECT ImageID FROM " + "IRLINKREPOSITORY" + " WHERE " + this.createLinkCodeClause(((LinkFieldCriterion)object).getCollectionKey(), ((LinkFieldCriterion)object).getClientIP(), ((LinkFieldCriterion)object).getLocalClientIP(), ((LinkFieldCriterion)object).getUserGroupShells()) + " AND " + this.createEquivalenceRelationshipClause(string, 1, fieldCriterion.relationship, string4, bl) + "))";
                    }
                    if (string3.length() <= 0) continue;
                    if (stringBuffer.length() > 0) {
                        if (((LinkFieldCriterion)object).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append(string3);
                    continue;
                }
                if (fieldCriterion == null || fieldCriterion.field == null || fieldCriterion.relationship == 0 || fieldCriterion.field.fieldType == 0) continue;
                if (i > 0) {
                    if (fieldCriterion.booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                if (fieldCriterion.paren == 1) {
                    stringBuffer.append("(");
                }
                stringBuffer.append("(");
                object = this.useLowerCaseCommand ? "LOWER(" + this.convertFieldName(fieldCriterion.field.fieldName) + ")" : this.convertFieldName(fieldCriterion.field.fieldName);
                boolean bl = false;
                string = this.escapeSpecialCharacters(fieldCriterion.equivalence.getSearchValue());
                if (this.useLowerCaseCommand) {
                    if (string == null) {
                        string = "LOWER('" + string + "')";
                    } else if (this.useLowerCaseCommandOnSearchValue) {
                        bl = true;
                    } else {
                        string = string.toLowerCase();
                    }
                }
                stringBuffer.append(this.createEquivalenceRelationshipClause((String)object, 1, fieldCriterion.relationship, string, bl));
                stringBuffer.append(")");
                if (fieldCriterion.paren != 2) continue;
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    protected String convertSortField(String string) {
        if (string.equalsIgnoreCase("ImageID")) {
            return this.UCB_TABLE_DIT_LEVEL1 + ".image_id";
        }
        return this.UCB_TABLE_DENORM + "." + string;
    }

    protected String convertFieldName(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.equalsIgnoreCase("ImageID")) {
            return this.UCB_TABLE_DIT_LEVEL1 + ".image_id";
        }
        return this.UCB_TABLE_DENORM + "." + this.underscoreFieldName(string);
    }

    protected String createOrderBy(String[] stringArray) {
        String string = "";
        int n = 0;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl;
                boolean bl2 = bl = stringArray[i] != null && !stringArray[i].equals("");
                if (!bl) continue;
                for (int j = 0; j < i; ++j) {
                    if (stringArray[j] == null || !stringArray[i].equals(stringArray[j])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + this.convertSortField(stringArray[i]);
                ++n;
            }
        }
        return string;
    }
}

