/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.ucb;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

class UcbResultSet {
    protected Vector jagResultsVector;
    protected int currentRecordIndex = 0;

    public UcbResultSet(Vector vector) {
        this.jagResultsVector = vector;
    }

    public boolean more() {
        return this.jagResultsVector != null && this.currentRecordIndex < this.jagResultsVector.size();
    }

    public void next() {
        ++this.currentRecordIndex;
    }

    public void first() {
        this.currentRecordIndex = 0;
    }

    public void last() {
        this.currentRecordIndex = this.jagResultsVector != null && this.jagResultsVector.size() > 0 ? this.jagResultsVector.size() - 1 : 0;
    }

    public void advanceToRecord(int n) {
        this.currentRecordIndex = n;
    }

    public int getRecordCount() {
        if (this.jagResultsVector != null) {
            return this.jagResultsVector.size();
        }
        return 0;
    }

    public Vector getCurrentRecord() {
        if (this.more()) {
            return (Vector)this.jagResultsVector.elementAt(this.currentRecordIndex);
        }
        return null;
    }

    public String getColumnValueString(int n) {
        Vector vector = this.getCurrentRecord();
        if (vector != null && n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof Long) {
                return "" + (Long)e;
            }
            if (e instanceof String) {
                return (String)e;
            }
            return "";
        }
        return "";
    }

    public int getColumnValueInt(int n) {
        String string = this.getColumnValueString(n);
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public long getColumnValueLong(int n) {
        String string = this.getColumnValueString(n);
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public int getInputStreamColumn() {
        Vector vector = this.getCurrentRecord();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.elementAt(i) instanceof InputStream)) continue;
                return i;
            }
        }
        return -1;
    }

    public byte[] fetchRasterData() {
        Vector vector;
        byte[] byArray = null;
        int n = this.getInputStreamColumn();
        if (n > 0 && (vector = this.getCurrentRecord()) != null && vector.elementAt(n - 1) instanceof Integer) {
            int n2 = (Integer)vector.elementAt(n - 1);
            InputStream inputStream = (InputStream)vector.elementAt(n);
            try {
                if (inputStream != null) {
                    byArray = new byte[n2];
                    if (this.waitForInput(inputStream, 1, 10000L) > 0) {
                        int n3;
                        for (int i = 0; i < n2; i += n3) {
                            int n4 = n2 - i;
                            n3 = inputStream.read(byArray, i, n4);
                        }
                    } else {
                        byArray = null;
                    }
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                byArray = null;
            }
        }
        return byArray;
    }

    protected int waitForInput(InputStream inputStream, int n, long l) {
        int n2;
        block5: {
            int n3 = 200;
            n2 = 0;
            try {
                if (inputStream == null) break block5;
                int n4 = 0;
                while (inputStream.available() < n) {
                    n4 += n3;
                    try {
                        Thread.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((long)n4 < l) continue;
                }
                n2 = inputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n2;
    }
}

