/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.theme;

import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.DefaultTheme;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.TrinityConnector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;

public class ThemeFileManager {
    public static final String COMPONENT_NAME = "ThemeFileManager";
    public static final String COMPONENT_CODE = "TFM";
    public static final String THEMEFILE_NAME = "collection";
    public static final String THEMEFILE_EXT = "thm";
    private static final Object THEME_FILE_LOCK = new Object();
    protected String themeFilePath = "";
    protected String themeFileURL = "";

    public static void debugOut(String string) {
        ThemeFileManager.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("TFM: " + string, n);
    }

    public static String getCollectionHeader(CollectionKey collectionKey) {
        return CoreUtilities.constructTripletText(collectionKey.getInstitutionID(), collectionKey.getCollectionID(), collectionKey.getVCID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getThemeFile(CollectionKey collectionKey, long l) throws FileNotFoundException {
        Object object = THEME_FILE_LOCK;
        synchronized (object) {
            byte[] byArray;
            block23: {
                ObjectInputStream objectInputStream;
                block22: {
                    byArray = null;
                    File file = this.themeExists(collectionKey);
                    if (file == null) return byArray;
                    objectInputStream = null;
                    objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    DefaultTheme defaultTheme = (DefaultTheme)objectInputStream.readObject();
                    objectInputStream.close();
                    if (defaultTheme.getCRCValue() == l) break block22;
                    File file2 = this.themeImageExists(collectionKey);
                    if (file2 != null) {
                        ImageIcon imageIcon = new ImageIcon(file2.getCanonicalPath());
                        imageIcon.getImage().flush();
                        imageIcon = new ImageIcon(file2.getCanonicalPath());
                        while (imageIcon.getImageLoadStatus() != 8 && imageIcon.getImageLoadStatus() != 4) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        long l2 = DefaultTheme.calculateThemeCRC(imageIcon);
                        if (l != l2) {
                            byArray = CoreUtilities.importFileBytes(file2);
                        }
                        if (defaultTheme.getCRCValue() != l2) {
                            defaultTheme.setCRCValue(l2);
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                            objectOutputStream.writeObject(defaultTheme);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                        }
                        break block22;
                    }
                    ThemeFileManager.debugOut("Unable to find background image for collection key " + collectionKey.toKeyString());
                }
                Object var15_15 = null;
                if (objectInputStream == null) return byArray;
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
                {
                    break block23;
                    catch (IOException iOException) {
                        ThemeFileManager.debugOut("Exception getting theme file:\n" + InsightUtilities.getStackTrace(iOException));
                        Object var15_16 = null;
                        if (objectInputStream == null) return byArray;
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException2) {}
                        break block23;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ThemeFileManager.debugOut("Exception getting theme file:\n" + InsightUtilities.getStackTrace(classNotFoundException));
                        Object var15_17 = null;
                        if (objectInputStream == null) return byArray;
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    if (objectInputStream == null) throw throwable;
                    try {
                        objectInputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean saveThemeFile(Integer n, TrinityConnector trinityConnector, CollectionKey collectionKey, DefaultTheme defaultTheme, byte[] byArray) {
        Object object = THEME_FILE_LOCK;
        synchronized (object) {
            boolean bl;
            block26: {
                IOException iOException2222;
                OutputStream outputStream;
                ObjectOutputStream objectOutputStream;
                block24: {
                    Object object2;
                    bl = false;
                    File file = new File(this.getDirectoryPath(collectionKey));
                    if (!file.exists()) {
                        file.mkdirs();
                        if (!file.exists()) {
                            ThemeFileManager.debugOut("Unable to create theme directory:  " + file);
                            return false;
                        }
                    }
                    objectOutputStream = null;
                    outputStream = null;
                    ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
                    ZipEntry zipEntry = null;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        int n2;
                        object2 = file + File.separator + zipEntry.getName();
                        outputStream = new FileOutputStream((String)object2);
                        byte[] byArray2 = new byte[1024];
                        while ((n2 = zipInputStream.read(byArray2)) > 0) {
                            outputStream.write(byArray2, 0, n2);
                        }
                        outputStream.close();
                    }
                    object2 = new File(this.getThemeFilePath(collectionKey));
                    objectOutputStream = new ObjectOutputStream(new FileOutputStream((File)object2));
                    objectOutputStream.writeObject(defaultTheme);
                    objectOutputStream.flush();
                    bl = trinityConnector.updateThemeInfo(n, collectionKey, this.getThemeURL(collectionKey), defaultTheme);
                    Object var17_17 = null;
                    if (objectOutputStream == null) break block24;
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException2222) {}
                }
                break block26;
                {
                    catch (Exception exception) {
                        IOException iOException32222;
                        ThemeFileManager.debugOut("Exception in saveThemeFile " + InsightUtilities.getStackTrace(exception));
                        Object var17_18 = null;
                        if (objectOutputStream != null) {
                            try {
                                objectOutputStream.close();
                            }
                            catch (IOException iOException32222) {
                                // empty catch block
                            }
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException32222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException42222;
                    Object var17_19 = null;
                    if (objectOutputStream != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTheme(CollectionKey collectionKey) {
        Object object = THEME_FILE_LOCK;
        synchronized (object) {
            ThemeFileManager.debugOut("in deleteTheme().");
            boolean bl = false;
            File file = this.themeExists(collectionKey);
            if (file != null) {
                bl = file.delete();
                if (bl) {
                    ThemeFileManager.debugOut(file.getPath() + " successfully deleted.");
                } else {
                    ThemeFileManager.debugOut(file.getPath() + " not deleted.");
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File themeExists(CollectionKey collectionKey) {
        Object object = THEME_FILE_LOCK;
        synchronized (object) {
            ThemeFileManager.debugOut("in themeExists().");
            String string = this.getThemeFilePath(collectionKey);
            ThemeFileManager.debugOut("Finding file at " + string);
            File file = new File(string);
            return file.exists() ? file : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File themeImageExists(CollectionKey collectionKey) {
        Object object = THEME_FILE_LOCK;
        synchronized (object) {
            ThemeFileManager.debugOut("in themeImageExists().");
            String string = this.getThemeImageFilePath(collectionKey);
            ThemeFileManager.debugOut("Finding file at " + string);
            File file = new File(string);
            return file.exists() ? file : null;
        }
    }

    public ThemeFileManager(String string, String string2) {
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            this.themeFilePath = string;
        }
        if (string2 != null) {
            if (!string2.equals("") && !string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            this.themeFileURL = string2;
        }
    }

    protected String getDirectoryPath(CollectionKey collectionKey) {
        return this.themeFilePath + ThemeFileManager.getCollectionHeader(collectionKey) + File.separator;
    }

    protected String getThemeFilePath(CollectionKey collectionKey) {
        return this.getDirectoryPath(collectionKey) + THEMEFILE_NAME + "." + THEMEFILE_EXT;
    }

    protected String getThemeURL(CollectionKey collectionKey) {
        return (this.themeFileURL + ThemeFileManager.getCollectionHeader(collectionKey)).replace(File.separatorChar, '/') + '/';
    }

    public String getBrowserBaseThemeURL() {
        return (this.themeFileURL + "PC-Default").replace(File.separatorChar, '/') + '/';
    }

    protected String getThemeImageFilePath(CollectionKey collectionKey) {
        return this.getDirectoryPath(collectionKey) + "insightbackground.jpg";
    }
}

