/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.security;

import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.security.Context;
import com.luna.insight.server.security.MediaSecurityConstants;
import com.oreilly.servlet.MultipartRequest;
import java.io.File;
import javax.servlet.http.HttpServletRequest;

public class MediaUploadHandler
implements MediaSecurityConstants {
    protected String fileRootDir = "";

    public static void debugOut(String string) {
        MediaUploadHandler.debugOut(string, null, 2);
    }

    public static void debugOut(String string, Context context) {
        MediaUploadHandler.debugOut(string, context, 2);
    }

    public static void debugOut(String string, Context context, int n) {
        if (context == null) {
            Debug.debugOut("MediaUploadHandler: " + string, n);
        } else {
            Debug.debugOut("MUplHndlr(" + context.getClientIP() + "): " + string, n);
        }
    }

    public void configure(EnhancedProperties enhancedProperties) {
        try {
            this.fileRootDir = enhancedProperties.getProperty("MediaFileRootDir", "");
            this.fileRootDir = File.separatorChar == '\\' ? this.fileRootDir.replace('/', File.separatorChar) : this.fileRootDir.replace('\\', File.separatorChar);
            MediaUploadHandler.debugOut("Upload media file root dir: " + this.fileRootDir);
        }
        catch (Exception exception) {
            MediaUploadHandler.debugOut("Exception in configure():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public boolean handleRequest(Context context) {
        MediaUploadHandler.debugOut("Received command: " + context.getCommand(), context);
        MediaUploadHandler.debugOut("URL request:\n" + context.getRequestSignature(), context);
        if (context.getCommand().equalsIgnoreCase("uploadmedia")) {
            return this.handleUpload(context);
        }
        return false;
    }

    protected boolean handleUpload(Context context) {
        HttpServletRequest httpServletRequest = context.getRequest();
        int n = httpServletRequest.getContentLength();
        MediaUploadHandler.debugOut("handleUpload(): contentLength = " + n);
        MultipartRequest multipartRequest = null;
        File file = null;
        String string = this.fileRootDir;
        try {
            File file2;
            File file3 = new File(string);
            if (!file3.exists()) {
                file3.mkdirs();
            }
            multipartRequest = new MultipartRequest(httpServletRequest, string, n + 1024);
            String string2 = multipartRequest.getParameter("clientlocalfpath");
            String string3 = multipartRequest.getParameter("clientlocaldir");
            String string4 = multipartRequest.getParameter("replace");
            file = multipartRequest.getFile("mediafile");
            MediaUploadHandler.debugOut("Param: clientlocalfpath = " + string2);
            MediaUploadHandler.debugOut("Param: clientlocaldir = " + string3);
            MediaUploadHandler.debugOut("Param: mediafile = " + file);
            MediaUploadHandler.debugOut("Param: replace = " + string4);
            boolean bl = string4 == null || string4.equals("") ? false : new Boolean(string4.trim());
            String string5 = "";
            if (string2 != null && string3 != null && string2.startsWith(string3)) {
                string5 = string2.substring(string3.length());
            }
            string5 = File.separatorChar == '\\' ? string5.replace('/', File.separatorChar) : string5.replace('\\', File.separatorChar);
            String string6 = InsightUtilities.concatFilepath(string, string5);
            MediaUploadHandler.debugOut("handleUpload(): finalFilePath = " + string6);
            File file4 = new File(string6);
            if (file4.exists() && file4.isFile() && bl) {
                MediaUploadHandler.debugOut("handleUpload(): deleting existing finalFile: " + file4);
                file4.delete();
            }
            if ((file2 = file4.getParentFile()) != null && !file2.exists()) {
                file2.mkdirs();
            }
            boolean bl2 = file.renameTo(file4);
            MediaUploadHandler.debugOut("handleUpload(): renameSucceeded = " + bl2);
        }
        catch (Exception exception) {
            MediaUploadHandler.debugOut("handleFileUpload(): exception:\n" + InsightUtilities.getStackTrace(exception));
        }
        return true;
    }
}

