/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.security;

import com.luna.insight.server.Debug;
import com.luna.insight.server.security.MediaSecurityConstants;

public class MediaTicket
implements MediaSecurityConstants {
    protected String ticket = "";
    protected long durationMs;
    protected int maxRes = 0;
    protected long timeStamp = System.currentTimeMillis();

    public static void debugOut(String string) {
        MediaTicket.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MediaTicket: " + string, n);
    }

    public MediaTicket(String string, int n, int n2) {
        this.ticket = string;
        this.durationMs = n * 60 * 1000;
        this.maxRes = n2;
    }

    public String getTicket() {
        return this.ticket;
    }

    public long getDuration() {
        return this.durationMs;
    }

    public int getMaxRes() {
        return this.maxRes;
    }

    public boolean isTicketValid() {
        return this.timeStamp + this.durationMs >= System.currentTimeMillis();
    }

    public String toString() {
        return "MTicket [ticket: " + this.getTicket() + ", duration: " + this.getDuration() + "ms, max res: " + this.getMaxRes() + "]";
    }
}

