/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.security;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.security.MediaSecurityConstants;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.List;

public class MediaSecurityUtilities
implements MediaSecurityConstants {
    protected static HashSet uploadedURLSet = new HashSet();

    public static void debugOut(String string) {
        MediaSecurityUtilities.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MediaSecurityUtilities: " + string, n);
    }

    public static void registerTicket(String string, String string2) throws Exception {
        String string3 = MediaSecurityUtilities.getRegisterTicketUrl(string, string2);
        MediaSecurityUtilities.debugOut("Register ticket url:\n" + string3);
        URL uRL = new URL(string3);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        MediaSecurityUtilities.debugOut("UrlConnection: " + uRLConnection.getClass().getName());
        int n = MediaSecurityUtilities.getStatusCode(uRLConnection);
        MediaSecurityUtilities.debugOut("Status code: " + n);
        if (n != 200) {
            throw new Exception("Failed to register ticket: " + string2 + ", status code: " + n);
        }
    }

    public static String getRegisterTicketUrl(String string, String string2) {
        if (InsightUtilities.isNonEmpty(string) && InsightUtilities.isNonEmpty(string2)) {
            StringBuffer stringBuffer = new StringBuffer(InsightUtilities.rightTrimSlashes(string) + "?" + "cmd" + "=" + "register");
            stringBuffer.append("&" + MediaSecurityUtilities.getTicketParameter(string2));
            return stringBuffer.toString();
        }
        return null;
    }

    public static String getRegisterTicketParams(String string, int n, int n2, String string2) {
        if (InsightUtilities.isNonEmpty(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(MediaSecurityUtilities.getTicketParameter(string));
            stringBuffer.append("&duration=" + n);
            stringBuffer.append("&maxres=" + n2);
            stringBuffer.append("&clientip=" + string2);
            return stringBuffer.toString();
        }
        return null;
    }

    public static URL appendTicketToUrl(URL uRL, String string) {
        URL uRL2 = uRL;
        try {
            if (uRL != null && InsightUtilities.isNonEmpty(string)) {
                String string2 = uRL.toString();
                string2 = MediaSecurityUtilities.appendUrlParam(string2, MediaSecurityUtilities.getTicketParameter(string));
                uRL2 = new URL(string2);
            }
        }
        catch (Exception exception) {
            MediaSecurityUtilities.debugOut("Exception in appendTicketToUrl():\n" + InsightUtilities.getStackTrace(exception));
        }
        return uRL2;
    }

    public static String getTicketParameter(String string) {
        try {
            if (InsightUtilities.isNonEmpty(string)) {
                return "ticket=" + URLEncoder.encode(string, "UTF-8");
            }
            return "";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String appendUrlParam(String string, String string2) {
        if (InsightUtilities.isNonEmpty(string) && InsightUtilities.isNonEmpty(string2)) {
            return string + '?' + string2;
        }
        return string;
    }

    public static int getStatusCode(URLConnection uRLConnection) {
        int n = -1;
        if (uRLConnection != null) {
            try {
                if (uRLConnection.getURL().getProtocol().equalsIgnoreCase("file")) {
                    return 200;
                }
                uRLConnection.getInputStream();
                n = MediaSecurityUtilities.getStatusCode(uRLConnection.getHeaderField(0));
            }
            catch (Exception exception) {
                MediaSecurityUtilities.debugOut("Exception in getStatusCode():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return n;
    }

    public static int getStatusCode(String string) {
        int n = -1;
        if (InsightUtilities.isNonEmpty(string)) {
            try {
                int n2 = string.indexOf(32);
                while (string.charAt(n2) == ' ') {
                    ++n2;
                }
                n = Integer.parseInt(string.substring(n2, n2 + 3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static void uploadMediaFiles(List list, String string, String string2) throws IOException {
        MediaSecurityUtilities.uploadMediaFiles(list, string, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void uploadMediaFiles(List list, String string, String string2, boolean bl) throws IOException {
        if (list == null) return;
        if (list.size() == 0) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            block18: {
                Exception exception2;
                Object var19_20;
                String string3 = (String)list.get(i);
                MediaSecurityUtilities.debugOut("Uploading media file: " + string3);
                boolean bl2 = bl;
                bl2 = !uploadedURLSet.add(string3) && bl;
                DataOutputStream dataOutputStream = null;
                try {
                    try {
                        URL uRL = new URL(string + "?" + "cmd" + "=" + "uploadmedia");
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setDoOutput(true);
                        uRLConnection.setDoInput(true);
                        uRLConnection.setUseCaches(false);
                        String string4 = "--7d021a37605f0";
                        uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string4);
                        MediaSecurityUtilities.debugOut("Before DataOutputStream");
                        dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("--" + string4 + "\r\n");
                        stringBuffer.append("Content-Disposition: form-data; name=\"clientlocalfpath\"\r\n");
                        stringBuffer.append("\r\n");
                        stringBuffer.append(string3 + "\r\n");
                        if (bl) {
                            stringBuffer.append("--" + string4 + "\r\n");
                            stringBuffer.append("Content-Disposition: form-data; name=\"replace\"\r\n");
                            stringBuffer.append("\r\n");
                            stringBuffer.append(bl + "\r\n");
                        }
                        stringBuffer.append("--" + string4 + "\r\n");
                        stringBuffer.append("Content-Disposition: form-data; name=\"clientlocaldir\"\r\n");
                        stringBuffer.append("\r\n");
                        stringBuffer.append(string2 + "\r\n");
                        stringBuffer.append("--" + string4 + "\r\n");
                        stringBuffer.append("Content-Disposition: form-data;name=\"mediafile\"; filename=\"" + string3 + "\"\r\n");
                        stringBuffer.append("Content-Type: application/x-zip-compressed\r\n");
                        stringBuffer.append("\r\n");
                        dataOutputStream.write(stringBuffer.toString().getBytes());
                        MediaSecurityUtilities.debugOut("Data Stream:\n" + stringBuffer.toString());
                        MediaSecurityUtilities.debugOut("Before file data send.");
                        FileInputStream fileInputStream = null;
                        try {
                            byte[] byArray;
                            int n;
                            fileInputStream = new FileInputStream(string3);
                            int n2 = 1024;
                            int n3 = fileInputStream.available();
                            MediaSecurityUtilities.debugOut("Size of file: " + n3);
                            while ((n3 = fileInputStream.available()) > 0 && (n = fileInputStream.read(byArray = n3 >= n2 ? new byte[n2] : new byte[n3])) != -1) {
                                dataOutputStream.write(byArray);
                            }
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            System.out.println("Caught exception while reading/writing media file: \n" + InsightUtilities.getStackTrace(iOException));
                            throw iOException;
                        }
                        finally {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("\r\n--" + string4 + "--\r\n");
                        dataOutputStream.write(stringBuffer.toString().getBytes());
                        dataOutputStream.flush();
                        dataOutputStream.close();
                        InputStream inputStream = uRLConnection.getInputStream();
                        inputStream.close();
                        MediaSecurityUtilities.debugOut("After http stream close. HttpMultiPartPost Done.");
                    }
                    catch (IOException iOException) {
                        MediaSecurityUtilities.debugOut("Caught exception while uploading media file: \n" + InsightUtilities.getStackTrace(iOException));
                        throw iOException;
                    }
                    var19_20 = null;
                    if (dataOutputStream == null) break block18;
                }
                catch (Throwable throwable) {
                    var19_20 = null;
                    if (dataOutputStream == null) throw throwable;
                    try {
                        dataOutputStream.flush();
                        dataOutputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception exception2) {}
                dataOutputStream.flush();
                dataOutputStream.close();
            }
            ++i;
        }
    }
}

