/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.security;

import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.security.CollectionMediaDeleteHandler;
import com.luna.insight.server.security.Context;
import com.luna.insight.server.security.MediaDeleteHandler;
import com.luna.insight.server.security.MediaSecurityConstants;
import com.luna.insight.server.security.MediaSecurityHandler;
import com.luna.insight.server.security.MediaUploadHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MediaSecurityServlet
extends HttpServlet
implements MediaSecurityConstants {
    public static final String BUILD_DATE = "14June2007";
    public static final String SERVLET_NAME = "MediaSecurityServlet";
    public static final String SERVLET_CONF_FILE = "MediaSecurityServlet.conf";
    protected MediaSecurityHandler mediaSecurityHandler;
    protected MediaUploadHandler mediaUploadHandler;
    protected MediaDeleteHandler mediaDeleteHandler;
    protected CollectionMediaDeleteHandler collectionMediaDeleteHandler;

    public static void debugOut(String string) {
        MediaSecurityServlet.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MediaSecurityServlet: " + string, n);
    }

    public static void newLine() {
        Debug.debugOut("", 2);
    }

    public void init() {
        this.displayBanner();
        this.configure();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handleRequest(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handleRequest(httpServletRequest, httpServletResponse);
    }

    protected void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MediaSecurityServlet.newLine();
            Context context = new Context(httpServletRequest, httpServletResponse, this.getServletContext());
            context.gatherCommand();
            boolean bl = this.mediaUploadHandler.handleRequest(context);
            if (!bl) {
                bl = this.mediaDeleteHandler.handleRequest(context);
            }
            if (!bl) {
                bl = this.collectionMediaDeleteHandler.handleRequest(context);
            }
            if (!bl) {
                this.mediaSecurityHandler.handleRequest(context);
            }
        }
        catch (Throwable throwable) {
            MediaSecurityServlet.debugOut("Throwable in handleRequest:\n" + InsightUtilities.getStackTrace(throwable));
        }
    }

    protected void displayBanner() {
        Debug.debugOutAlways("MediaSecurityServlet - Build of " + InsightVersion.releaseName());
        String string = System.getProperty("java.vm.name", "Unknown");
        String string2 = System.getProperty("java.vm.version", "?");
        String string3 = System.getProperty("os.name", "Unknown");
        String string4 = System.getProperty("os.version", "?");
        String string5 = System.getProperty("os.arch", "Unknown");
        Debug.debugOutAlways(string + " (v" + string2 + ")");
        Debug.debugOutAlways(string3 + " (v" + string4 + "; " + string5 + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void configure() {
        block12: {
            MediaSecurityServlet.debugOut("Configuring MediaSecurityServlet.");
            InputStream inputStream = null;
            inputStream = this.getConfigFile();
            if (inputStream == null) {
                MediaSecurityServlet.debugOut("Config file for MediaSecurityServlet is null!");
            }
            EnhancedProperties enhancedProperties = new EnhancedProperties();
            enhancedProperties.load(inputStream);
            inputStream.close();
            this.configureWithProps(enhancedProperties);
            MediaSecurityServlet.debugOut("Configuration complete.");
            Object var4_4 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block12;
            }
            catch (IOException iOException) {}
            break block12;
            {
                catch (Exception exception) {
                    MediaSecurityServlet.debugOut("Cannot read configuration file:\n" + InsightUtilities.getStackTrace(exception));
                    Object var4_5 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block12;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void configureWithProps(EnhancedProperties enhancedProperties) {
        Debug.setDebugLevel(enhancedProperties.getIntegerProperty("DebugLevel", 0));
        this.mediaSecurityHandler = new MediaSecurityHandler();
        this.mediaSecurityHandler.configure(enhancedProperties);
        this.mediaUploadHandler = new MediaUploadHandler();
        this.mediaUploadHandler.configure(enhancedProperties);
        this.mediaDeleteHandler = new MediaDeleteHandler();
        this.mediaDeleteHandler.configure(enhancedProperties);
        this.collectionMediaDeleteHandler = new CollectionMediaDeleteHandler();
        this.collectionMediaDeleteHandler.configure(enhancedProperties);
    }

    protected InputStream getConfigFile() {
        try {
            String string = this.getServletConfigParameter("ConfigurationFile");
            if (string == null) {
                string = SERVLET_CONF_FILE;
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            MediaSecurityServlet.debugOut("Configuration file: " + string);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = new FileInputStream(string);
            }
            return inputStream;
        }
        catch (Exception exception) {
            MediaSecurityServlet.debugOut("Exception occured while reading configuration file:\n" + InsightUtilities.getStackTrace(exception));
            return null;
        }
    }

    public String getServletConfigParameter(String string) {
        return this.getServletConfig().getInitParameter(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase("-version")) continue;
                Debug.debugOutAlways("MediaSecurityServlet - Build of " + InsightVersion.releaseName());
                return;
            }
        }
    }
}

