/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.security;

import com.luna.insight.core.jpeg2000.IJPEG2KDecodeParam;
import com.luna.insight.core.jpeg2000.IJPEG2KImageDecoder;
import com.luna.insight.core.jpeg2000.JPEG2KCodec;
import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.security.Context;
import com.luna.insight.server.security.MediaSecurityConstants;
import com.luna.insight.server.security.MediaSecurityUtilities;
import com.luna.insight.server.security.MediaTicket;
import com.luna.insight.server.usergroup.IPAddressCollection;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.servlet.ServletContext;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class MediaSecurityHandler
implements MediaSecurityConstants {
    protected static final int TICKET_LENGTH = 20;
    protected static final int BUFFER_SIZE = 32768;
    protected static Random random;
    private static boolean configuredJPEG2KCodec;
    protected String logDirectory = "";
    protected String accessLogFilename = "";
    protected boolean accessLogMode = false;
    protected boolean logThumbnails = false;
    protected SimpleDateFormat datetimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected boolean ticketlessMode = false;
    protected Map ticketCache = new Hashtable();
    protected String fileRootDir = "";
    protected String servletBaseUrl = "";
    protected int ticketDurationMin = 0;
    protected boolean allowLinking = false;
    protected String securityKey = "";
    protected int maxResolution = 0;
    protected List resolutionMarkersLC = new Vector();
    protected String sidUrlMarkerLC;
    protected IPAddressCollection adminIPs = null;
    protected String providerClassName = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    protected String algorithm = "PBEWithSHAAnd3-KeyTripleDES-CBC";
    protected String transformation = "PBEWithSHAAnd3-KeyTripleDES-CBC";
    protected String secretKeyStr = null;
    protected AlgorithmParameterSpec paramSpec;
    protected SecretKey secretKey;
    protected Cipher cipher;

    public static void debugOut(String string) {
        MediaSecurityHandler.debugOut(string, null, 2);
    }

    public static void debugOut(String string, Context context) {
        MediaSecurityHandler.debugOut(string, context, 2);
    }

    public static void debugOut(String string, Context context, int n) {
        if (context == null) {
            Debug.debugOut("MediaSecurityHandler: " + string, n);
        } else {
            Debug.debugOut("MSecHndlr(" + context.getClientIP() + "): " + string, n);
        }
    }

    public static String generateTicket() {
        return MediaSecurityHandler.generateTicket(20);
    }

    public static String generateTicket(int n) {
        random.setSeed(System.currentTimeMillis() + (long)(Math.random() * 150.0));
        StringBuffer stringBuffer = new StringBuffer("T");
        for (int i = 0; i < n; ++i) {
            int n2 = 65 + (int)(random.nextDouble() * 26.0);
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public static Map getAllRequestParameters(Context context) {
        return MediaSecurityHandler.getAllRequestParameters(context.getRequest().getQueryString());
    }

    public static Map getAllRequestParameters(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string2 = URLDecoder.decode(string, "UTF-8");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "?&");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                int n = string3.indexOf(61);
                if (n > 0) {
                    if (n == string3.length() - 1) {
                        hashMap.put(string3.substring(0, n), null);
                        continue;
                    }
                    hashMap.put(string3.substring(0, n), string3.substring(n + 1));
                    continue;
                }
                if (n != -1) continue;
                hashMap.put(string3, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    public static List parseResolutionMarkers(String string) {
        Vector<String> vector = new Vector<String>(0);
        if (InsightUtilities.isNonEmpty(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f", false);
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public void configure(EnhancedProperties enhancedProperties) {
        try {
            this.logDirectory = enhancedProperties.getProperty("LogDirectory", this.logDirectory);
            if (!this.logDirectory.equals("") && !this.logDirectory.endsWith(File.separator)) {
                this.logDirectory = this.logDirectory + File.separator;
            }
            this.accessLogFilename = enhancedProperties.getProperty("AccessLogFilename", this.accessLogFilename);
            this.accessLogMode = enhancedProperties.getBooleanProperty("AccessLogMode", this.accessLogMode);
            this.logThumbnails = enhancedProperties.getBooleanProperty("LogThumbnails", this.logThumbnails);
            this.allowLinking = enhancedProperties.getBooleanProperty("AllowLinking", this.allowLinking);
            MediaSecurityHandler.debugOut("Log directory: " + this.logDirectory);
            MediaSecurityHandler.debugOut("Log filename: " + this.accessLogFilename);
            MediaSecurityHandler.debugOut("Log mode: " + this.accessLogMode);
            MediaSecurityHandler.debugOut("allowLinking: " + this.allowLinking);
            this.servletBaseUrl = enhancedProperties.getProperty("MediaSecurityServletUrl", "");
            MediaSecurityHandler.debugOut("Media servlet base URL: " + this.servletBaseUrl);
            this.securityKey = enhancedProperties.getProperty("MediaSecurityKey", "");
            MediaSecurityHandler.debugOut("Media security key = " + this.securityKey);
            this.ticketlessMode = enhancedProperties.getBooleanProperty("MediaSecurityTicketless", this.ticketlessMode);
            if (!this.ticketlessMode) {
                this.ticketDurationMin = enhancedProperties.getIntegerProperty("MediaTicketDuration", -1);
                MediaSecurityHandler.debugOut("Ticket duration (min): " + this.ticketDurationMin);
            }
            this.fileRootDir = enhancedProperties.getProperty("MediaFileRootDir", "");
            this.fileRootDir = File.separatorChar == '\\' ? this.fileRootDir.replace('/', File.separatorChar) : this.fileRootDir.replace('\\', File.separatorChar);
            MediaSecurityHandler.debugOut("Media file root dir: " + this.fileRootDir);
            this.maxResolution = enhancedProperties.getIntegerProperty("MaxResolution", -1);
            MediaSecurityHandler.debugOut("Max resolution: " + this.maxResolution);
            this.resolutionMarkersLC.clear();
            for (int i = 0; i <= this.maxResolution; ++i) {
                List list = MediaSecurityHandler.parseResolutionMarkers(URLDecoder.decode(enhancedProperties.getProperty("ResolutionMarker" + i, ""), "UTF-8").toLowerCase());
                MediaSecurityHandler.debugOut("Resolution marker " + i + ": " + list);
                this.resolutionMarkersLC.add(list);
            }
            this.sidUrlMarkerLC = URLDecoder.decode(enhancedProperties.getProperty("SidUrlMarker", ""), "UTF-8").toLowerCase();
            MediaSecurityHandler.debugOut("Sid url marker: " + this.sidUrlMarkerLC);
            String string = enhancedProperties.getProperty("MediaSecurityAdminIPs", "");
            MediaSecurityHandler.debugOut("Media security admin IPs: " + string);
            this.adminIPs = new IPAddressCollection(string);
            if (!this.ticketlessMode) {
                this.secretKeyStr = enhancedProperties.getProperty("MediaSecuritySecretKey", "default");
                MediaSecurityHandler.debugOut("Media security secret key: " + this.secretKeyStr);
                this.providerClassName = enhancedProperties.getProperty("MediaSecurityJCEProvider", this.providerClassName);
                MediaSecurityHandler.debugOut("JCE provider class name: " + this.providerClassName);
                this.algorithm = enhancedProperties.getProperty("MediaSecurityAlgorithm", this.algorithm);
                MediaSecurityHandler.debugOut("Media security algorithm: " + this.algorithm);
                this.transformation = enhancedProperties.getProperty("MediaSecurityTransformation", this.algorithm);
                MediaSecurityHandler.debugOut("Media security transformation: " + this.transformation);
                this.initKey(this.secretKeyStr);
            }
        }
        catch (Exception exception) {
            MediaSecurityHandler.debugOut("Exception in configure():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public boolean handleRequest(Context context) {
        MediaSecurityHandler.debugOut("Received command: " + context.getCommand(), context);
        MediaSecurityHandler.debugOut("URL request:\n" + context.getRequestSignature(), context);
        if (context.getCommand().equalsIgnoreCase("register")) {
            this.registerTicket(context);
        } else if (context.getCommand().equalsIgnoreCase("validate")) {
            this.validateTicket(context);
        } else {
            MediaSecurityHandler.debugOut("Handling media request.", context);
            this.fetchMedia(context);
        }
        return true;
    }

    protected int getMediaResolution(String string) {
        if (InsightUtilities.isNonEmpty(string)) {
            String string2 = URLDecoder.decode(string).toLowerCase();
            String string3 = string2.replace(File.separatorChar, '/');
            for (int i = 0; i < this.resolutionMarkersLC.size(); ++i) {
                List list = (List)this.resolutionMarkersLC.get(i);
                MediaSecurityHandler.debugOut("Res marker[" + i + "]: " + list);
                for (int j = 0; j < list.size(); ++j) {
                    String string4 = (String)list.get(j);
                    if (!InsightUtilities.isNonEmpty(string4) || string2.indexOf(string4) <= -1 && string3.indexOf(string4) <= -1) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    protected String getMediaFile(Context context, String string) throws Exception {
        String string2;
        String string3;
        int n;
        if (context != null && InsightUtilities.isNonEmpty(string) && (n = InsightUtilities.indexOf(string3 = string, string2 = "mediafile=", true)) > -1) {
            String string4 = string3.substring(n + string2.length());
            if (this.isSidFile(string4)) {
                if (!string4.toLowerCase().startsWith("http://")) {
                    string4 = "http://" + string4;
                }
            } else {
                int n2;
                int n3 = string4.indexOf(63);
                if (n3 > -1) {
                    string4 = string4.substring(0, n3);
                }
                if ((n2 = string4.indexOf(38)) > -1) {
                    string4 = string4.substring(0, n2);
                }
                string4 = File.separatorChar == '\\' ? string4.replace('/', File.separatorChar) : string4.replace('\\', File.separatorChar);
                string4 = InsightUtilities.concatFilepath(this.fileRootDir, string4);
                string4 = new File(string4).getCanonicalPath();
                MediaSecurityHandler.debugOut("fileRootDir: " + this.fileRootDir + " OS Name: " + System.getProperty("os.name") + " allowLinking: " + this.allowLinking);
                if (!(string4.startsWith(this.fileRootDir) || !System.getProperty("os.name").startsWith("Windows") && this.allowLinking)) {
                    MediaSecurityHandler.debugOut("Media file name compromised:\n" + string4, context);
                    throw new Exception("Requested media file name has been compromised.");
                }
            }
            return string4;
        }
        return null;
    }

    public String getServletBaseUrl() {
        return this.servletBaseUrl;
    }

    public boolean isTicketlessMode() {
        return this.ticketlessMode;
    }

    public int getTicketDuration() {
        return this.ticketDurationMin;
    }

    public String getSecurityKey() {
        return this.securityKey;
    }

    protected void validateTicket(Context context) {
        try {
            MediaSecurityHandler.debugOut("Validating ticket.");
            String string = context.getRequestValue("ticket", "");
            MediaSecurityHandler.debugOut("Received ticket: " + string, context);
            if (InsightUtilities.isEmpty(string)) {
                throw new Exception("Ticket is empty.");
            }
            MediaTicket mediaTicket = (MediaTicket)this.ticketCache.get(string);
            if (mediaTicket != null) {
                if (mediaTicket.isTicketValid()) {
                    MediaSecurityHandler.debugOut("Validated ticket.");
                    context.getResponse().sendError(200, "Ticket valid.");
                    return;
                }
                MediaSecurityHandler.debugOut("Ticket expired.");
            } else {
                MediaSecurityHandler.debugOut("Ticket not registered.");
            }
            context.getResponse().sendError(403, "Ticket invalid.");
        }
        catch (Exception exception) {
            MediaSecurityHandler.debugOut("Exception validating ticket: " + exception, context);
            try {
                context.getResponse().sendError(403, exception.getMessage());
            }
            catch (Exception exception2) {
                MediaSecurityHandler.debugOut("Exception sending status code:\n" + InsightUtilities.getStackTrace(exception2), context);
            }
        }
    }

    protected void registerTicket(Context context) {
        try {
            String string = context.getClientIP();
            MediaSecurityHandler.debugOut("Verifying client IP: " + string, context);
            if (!this.adminIPs.isIPAddressInRange(string)) {
                throw new Exception("Client IP: " + string + " not validated.");
            }
            String string2 = context.getRequestValue("ticket", "");
            MediaSecurityHandler.debugOut("Received encrypted ticket: " + string2, context);
            if (InsightUtilities.isEmpty(string2)) {
                throw new Exception("Ticket is empty.");
            }
            String string3 = this.decrypt(string2);
            MediaSecurityHandler.debugOut("Ticket decrypted to: " + string3, context);
            Map map = MediaSecurityHandler.getAllRequestParameters(string3);
            String string4 = (String)map.get("ticket");
            if (InsightUtilities.isEmpty(string4)) {
                throw new Exception("Ticket invalid.");
            }
            int n = -1;
            try {
                n = Integer.parseInt((String)map.get("duration"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            MediaSecurityHandler.debugOut("Received ticket duration: " + n, context);
            if (n < 0) {
                throw new Exception("Ticket duration invalid.");
            }
            int n2 = -1;
            try {
                n2 = Integer.parseInt((String)map.get("maxres"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            MediaSecurityHandler.debugOut("Received max resolution: " + n2, context);
            if (n2 < 0) {
                throw new Exception("Max authorized resolution invalid.");
            }
            this.addTicket(new MediaTicket(string4, n, n2));
            context.getResponse().sendError(200, "Ticket registered.");
        }
        catch (Exception exception) {
            MediaSecurityHandler.debugOut("Exception registering ticket: " + exception, context);
            try {
                context.getResponse().sendError(403, exception.getMessage());
            }
            catch (Exception exception2) {
                MediaSecurityHandler.debugOut("Exception sending status code:\n" + InsightUtilities.getStackTrace(exception2), context);
            }
        }
    }

    protected void fetchMedia(Context context) {
        Map map = null;
        String string = null;
        try {
            String string2 = context.getRequestSignature();
            map = MediaSecurityHandler.getAllRequestParameters(context);
            MediaTicket mediaTicket = null;
            if (!this.ticketlessMode) {
                String string3 = (String)map.get("ticket");
                if (InsightUtilities.isEmpty(string3)) {
                    throw new Exception("Ticket not specified: " + string2);
                }
                MediaSecurityHandler.debugOut("Ticket: " + string3, context);
                mediaTicket = this.getTicket(string3);
                if (mediaTicket == null) {
                    throw new Exception("Ticket not found.");
                }
                if (!mediaTicket.isTicketValid()) {
                    throw new Exception("Ticket has expired.");
                }
            }
            string = this.getMediaFile(context, string2);
            MediaSecurityHandler.debugOut("Media file:\n" + string, context);
            int n = this.getMediaResolution(string);
            if (n < 0 && this.isJp2File(string)) {
                n = this.getMediaResolution(string2);
            }
            MediaSecurityHandler.debugOut("Resolution: " + n, context);
            if (!this.ticketlessMode) {
                if (n < 0) {
                    if ((this.isSidFile(string) || this.isJp2File(string)) && this.maxResolution >= 5) {
                        n = 5;
                        MediaSecurityHandler.debugOut("Assume Resolution: " + n, context);
                    } else {
                        throw new Exception("Resolution size could not be determined for: " + string2);
                    }
                }
                if (n > mediaTicket.getMaxRes()) {
                    throw new Exception("Requested resolution size (" + n + ") exceeds authorized size (" + mediaTicket.getMaxRes() + ").");
                }
                if (InsightUtilities.isEmpty(string)) {
                    throw new Exception("Media file could not be determined:\n" + string2);
                }
            }
            boolean bl = false;
            bl = this.isSidFile(string) ? this.proxySidRequest(context, string) : (this.isJp2File(string) ? this.sendJp2File(context, string) : this.sendMediaFile(context, string));
            if (!bl) {
                MediaSecurityHandler.debugOut("Media file could not be transmitted:\n" + string, context);
                context.getResponse().setContentType("text/html;charset=UTF-8");
                context.getResponse().sendError(404, "Requested media not found.");
                this.logAccess(n, map, context, 404);
            } else {
                this.logAccess(n, map, context, 200);
            }
        }
        catch (Exception exception) {
            MediaSecurityHandler.debugOut("Exception fetching media: " + exception, context);
            MediaSecurityHandler.debugOut(InsightUtilities.getStackTrace(exception), context);
            try {
                context.getResponse().sendError(403, exception.getMessage());
            }
            catch (Exception exception2) {
                MediaSecurityHandler.debugOut("Exception sending status code:\n" + InsightUtilities.getStackTrace(exception2), context);
            }
            this.logAccess(1, map, context, 403);
        }
    }

    protected void logAccess(int n, Map map, Context context, int n2) {
        block8: {
            Object object;
            if (!this.accessLogMode || !this.logThumbnails && n == 0) {
                return;
            }
            String string = InsightUtilities.appendDateToFilename(this.logDirectory + this.accessLogFilename, ".txt");
            MediaSecurityHandler.debugOut("Writing to log file " + string);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            Object object2 = map.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (((String)object).equals("mediafile") || ((String)object).equals("ticket")) continue;
                if (bl) {
                    stringBuffer.append('&');
                }
                bl = true;
                stringBuffer.append((String)object).append('=');
                stringBuffer.append((String)map.get(object));
            }
            if (stringBuffer.length() == 0) {
                stringBuffer = new StringBuffer("-");
            }
            object2 = this.datetimeFormatter.format(new Date());
            object = null;
            try {
                String string2 = (String)object2 + " " + context.getClientIP() + " " + "-" + " " + InetAddress.getLocalHost().getHostAddress() + " " + context.getRequest().getServerPort() + " " + context.getRequest().getMethod() + " " + map.get("mediafile") + " " + stringBuffer + " " + n2 + " " + context.getHeader("User-Agent") + "\n";
                object = new FileWriter(string, true);
                ((Writer)object).write(string2);
                ((OutputStreamWriter)object).flush();
                ((OutputStreamWriter)object).close();
            }
            catch (Exception exception) {
                MediaSecurityHandler.debugOut("Exception writing access log record: " + InsightUtilities.getStackTrace(exception));
                if (object == null) break block8;
                try {
                    ((OutputStreamWriter)object).close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean isJp2File(String string) {
        if (InsightUtilities.isNonEmpty(string)) {
            return string.toLowerCase().endsWith(".jp2") || string.toLowerCase().endsWith(".jpx");
        }
        return false;
    }

    protected boolean isSidFile(String string) {
        if (InsightUtilities.isNonEmpty(string) && InsightUtilities.isNonEmpty(this.sidUrlMarkerLC)) {
            return string.toLowerCase().indexOf(this.sidUrlMarkerLC) > -1;
        }
        return false;
    }

    protected boolean proxySidRequest(Context context, String string) {
        if (context != null && InsightUtilities.isNonEmpty(string)) {
            try {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                int n = MediaSecurityUtilities.getStatusCode(uRLConnection);
                MediaSecurityHandler.debugOut("Status code: " + n, context);
                context.setStatusCode(n);
                String string2 = uRLConnection.getContentType();
                MediaSecurityHandler.debugOut("Content type: " + string2, context);
                if (string2 != null) {
                    context.setContentType(string2);
                }
                return this.sendMediaBytes(context, uRLConnection.getInputStream(), "SID image");
            }
            catch (Exception exception) {
                MediaSecurityHandler.debugOut("Exception contacting SID server:\n" + InsightUtilities.getStackTrace(exception), context);
            }
        }
        return false;
    }

    protected boolean sendJp2File(Context context, String string) throws Exception {
        if (context != null && InsightUtilities.isNonEmpty(string)) {
            String string2;
            ServletContext servletContext;
            if (!configuredJPEG2KCodec) {
                JPEG2KCodec.configure();
                configuredJPEG2KCodec = true;
            }
            if ((servletContext = context.getServletContext()) != null && (string2 = servletContext.getMimeType(string)) != null) {
                context.setContentType(string2);
            }
            try {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 100;
                int n5 = 100;
                Map map = MediaSecurityHandler.getAllRequestParameters(context);
                try {
                    n = Integer.parseInt((String)map.get("level"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n2 = Integer.parseInt((String)map.get("x"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n3 = Integer.parseInt((String)map.get("y"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n4 = Integer.parseInt((String)map.get("width"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n5 = Integer.parseInt((String)map.get("height"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string3 = "{" + n3 + "," + n2 + "},{" + n5 + "," + n4 + "}";
                IJPEG2KDecodeParam iJPEG2KDecodeParam = JPEG2KCodec.getDefaultJPEG2KDecodeParam();
                iJPEG2KDecodeParam.setLevelReductionFactor(n);
                iJPEG2KDecodeParam.setRegion(string3);
                IJPEG2KImageDecoder iJPEG2KImageDecoder = JPEG2KCodec.createJPEG2KDecoder(string, iJPEG2KDecodeParam);
                MediaSecurityHandler.debugOut("Debug - JP2 source: " + string + " levelReductionFactor=" + n + " extractionRegion=" + string3);
                BufferedImage bufferedImage = iJPEG2KImageDecoder.decodeAsBufferedImage();
                if (bufferedImage != null) {
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    BufferedOutputStream bufferedOutputStream = null;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                    int n6 = 15;
                    if (n6 < 0) {
                        n6 = 0;
                    } else if (n6 > 100) {
                        n6 = 100;
                    }
                    float f = 1.0f - (float)n6 / 100.0f;
                    JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
                    JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                    jPEGEncodeParam.setQuality(f, true);
                    jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
                    bufferedImage.flush();
                    bufferedImage = null;
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    long l = byArray.length;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    byArray = null;
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                    MediaSecurityHandler.debugOut("Set content length: " + l, context);
                    context.setContentLength((int)l);
                    MediaSecurityHandler.debugOut("Creating input stream: " + string, context);
                    MediaSecurityHandler.debugOut("Input stream created.", context);
                    return this.sendMediaBytes(context, byteArrayInputStream, string);
                }
            }
            catch (Exception exception) {
                MediaSecurityHandler.debugOut("Exception handling JP2 extraction: " + exception, context);
            }
            catch (Error error) {
                MediaSecurityHandler.debugOut("Error in sendJp2File():\n" + InsightUtilities.getStackTrace(error));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendMediaFile(Context context, String string) throws Exception {
        if (context != null && InsightUtilities.isNonEmpty(string)) {
            Object object;
            ServletContext servletContext = context.getServletContext();
            if (servletContext != null && (object = servletContext.getMimeType(string)) != null) {
                context.setContentType((String)object);
            }
            object = null;
            try {
                File file = new File(string);
                MediaSecurityHandler.debugOut("Creating input stream: " + string, context);
                object = new FileInputStream(file);
                MediaSecurityHandler.debugOut("Input stream created.", context);
                long l = file.length();
                MediaSecurityHandler.debugOut("Set content length: " + l, context);
                context.setContentLength((int)l);
                boolean bl = this.sendMediaBytes(context, (InputStream)object, string);
                return bl;
            }
            catch (FileNotFoundException fileNotFoundException) {
                MediaSecurityHandler.debugOut("Exception creating FileInputStream: " + fileNotFoundException, context);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        return false;
    }

    protected boolean sendMediaBytes(Context context, InputStream inputStream, String string) {
        if (inputStream != null && context != null) {
            if (!context.isContentTypeSet()) {
                context.setContentType("application/octet-stream;name=\"" + string + "\"");
            }
            try {
                OutputStream outputStream = context.getOutputStream();
                int n = InsightUtilities.copyStreamBytes(inputStream, outputStream, true);
                MediaSecurityHandler.debugOut("Set content length: " + n, context);
                context.setContentLength(n);
                MediaSecurityHandler.debugOut("Set status code: 200", context);
                context.setStatusCode(200);
                outputStream.flush();
                inputStream.close();
                return true;
            }
            catch (IOException iOException) {
                MediaSecurityHandler.debugOut("IOException while sending file: " + iOException, context);
            }
        }
        return false;
    }

    protected void addTicket(MediaTicket mediaTicket) {
        if (mediaTicket != null) {
            this.ticketCache.put(mediaTicket.getTicket(), mediaTicket);
            MediaSecurityHandler.debugOut("Added ticket: " + mediaTicket);
            if (this.ticketCache.size() > 200) {
                this.removeExpiredTickets();
            }
        }
    }

    protected MediaTicket getTicket(String string) {
        return (MediaTicket)this.ticketCache.get(string);
    }

    protected void removeExpiredTickets() {
        Iterator iterator = this.ticketCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (((MediaTicket)entry.getValue()).isTicketValid()) continue;
            MediaSecurityHandler.debugOut("Removing expired ticket: " + entry.getKey());
            iterator.remove();
        }
    }

    protected void initKey(String string) {
        try {
            Provider provider = (Provider)Class.forName(this.providerClassName).newInstance();
            Security.addProvider(provider);
            Provider[] providerArray = Security.getProviders();
            for (int i = 0; i < providerArray.length; ++i) {
                MediaSecurityHandler.debugOut("Provider[" + i + "]: " + providerArray[i].getName());
            }
            byte[] byArray = new byte[]{-57, 127, 33, -116, 126, -56, 37, -103};
            int n = 11;
            this.paramSpec = new PBEParameterSpec(byArray, n);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.algorithm, provider.getName());
            this.secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            this.cipher = Cipher.getInstance(this.transformation, provider.getName());
            MediaSecurityHandler.debugOut(">>> Cryptography TEST <<<");
            String string2 = "encryptiontest";
            MediaSecurityHandler.debugOut("Encrypt: " + string2);
            String string3 = this.encrypt(string2);
            MediaSecurityHandler.debugOut("Cipher text: " + string3);
            String string4 = this.decrypt(string3);
            MediaSecurityHandler.debugOut("Decrypts to: " + string4);
            if (string2.equals(string4)) {
                MediaSecurityHandler.debugOut("SUCCESS: Original text matches decrypted text.");
            } else {
                MediaSecurityHandler.debugOut("Cryptography ERROR: Original text does NOT match decrypted text.");
            }
            MediaSecurityHandler.debugOut(">>> End TEST <<<");
        }
        catch (Exception exception) {
            MediaSecurityHandler.debugOut("Exception in initKey():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            MediaSecurityHandler.debugOut("Error in initKey():\n" + InsightUtilities.getStackTrace(error));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encrypt(String string) {
        try {
            Cipher cipher = this.cipher;
            synchronized (cipher) {
                this.cipher.init(1, (Key)this.secretKey, this.paramSpec);
                return URLEncoder.encode(new BASE64Encoder().encode(this.cipher.doFinal(string.getBytes())), "UTF-8");
            }
        }
        catch (Exception exception) {
            MediaSecurityHandler.debugOut("Exception in encrypt():\n" + InsightUtilities.getStackTrace(exception));
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String decrypt(String string) {
        try {
            Cipher cipher = this.cipher;
            synchronized (cipher) {
                this.cipher.init(2, (Key)this.secretKey, this.paramSpec);
                return new String(this.cipher.doFinal(new BASE64Decoder().decodeBuffer(URLDecoder.decode(string, "UTF-8"))));
            }
        }
        catch (Exception exception) {
            MediaSecurityHandler.debugOut("Exception in decrypt():\n" + InsightUtilities.getStackTrace(exception));
            return "";
        }
    }

    static {
        configuredJPEG2KCodec = false;
        random = new Random();
    }
}

