/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.security;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.security.MediaSecurityConstants;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class Context
implements MediaSecurityConstants {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected ServletContext servletContext;
    protected String requestContentType;
    protected boolean isContentTypeSet = false;
    protected boolean newSession = false;
    protected long processingStart = System.currentTimeMillis();
    protected String command;
    protected HttpServletRequestWrapper requestWrapper;

    public static void debugOut(String string) {
        Context.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("Context: " + string, n);
    }

    public Context(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.servletContext = servletContext;
        this.command = null;
        this.requestWrapper = new HttpServletRequestWrapper(httpServletRequest);
        this.requestWrapper.setAttribute("Context", (Object)this);
    }

    public String toString() {
        return "Context [" + this.getClientIP() + "]";
    }

    public long getStartTime() {
        return this.processingStart;
    }

    public long getDuration() {
        return System.currentTimeMillis() - this.processingStart;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String gatherCommand() {
        this.command = this.getRequestValue("cmd", "getmedia");
        return this.command;
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.requestWrapper.getRequest();
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void print(String string) {
        try {
            this.response.getWriter().println(string);
        }
        catch (Exception exception) {
            Context.debugOut("IOException on print():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void printException(Throwable throwable) {
        try {
            throwable.printStackTrace(this.response.getWriter());
        }
        catch (Exception exception) {
            Context.debugOut("Exception while attempting to print exception to Context:\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void flush() {
        try {
            this.response.getWriter().flush();
        }
        catch (Exception exception) {
            Context.debugOut("Exception flush():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public String getHeader(String string) {
        return this.requestWrapper.getHeader(string);
    }

    public String getReferer() {
        return this.getHeader("Referer");
    }

    public String[] getRequestValues(String string) {
        try {
            return this.requestWrapper.getParameterValues(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Context.debugOut("Exception in getRequestValues(" + string + "):\n" + InsightUtilities.getStackTrace(illegalArgumentException));
            return null;
        }
    }

    public String[] getRequestValues(String string, int n) {
        String[] stringArray = this.getRequestValues(string);
        if (stringArray == null) {
            stringArray = new String[n];
        }
        return stringArray;
    }

    public int[] getIntRequestValues(String string) {
        String[] stringArray = this.getRequestValues(string);
        if (stringArray != null) {
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    nArray[i] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    nArray[i] = 0;
                }
            }
            return nArray;
        }
        return null;
    }

    public int[] getIntRequestValues(String string, int n) {
        int[] nArray = this.getIntRequestValues(string);
        if (nArray == null) {
            nArray = new int[n];
        }
        return nArray;
    }

    public String getRequestValue(String string, String string2) {
        try {
            String string3 = this.getRequestValue(string);
            if (string3 != null) {
                return string3;
            }
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Context.debugOut("Exception in getRequestValue(" + string + ", " + string2 + "):\n" + InsightUtilities.getStackTrace(illegalArgumentException));
            return string2;
        }
    }

    public String getParameter(String string, String string2) {
        return this.getRequestValue(string, string2);
    }

    public String getRequestValue(String string) {
        try {
            return this.requestWrapper.getParameter(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Context.debugOut("Exception in getRequestValue(" + string + "):\n" + InsightUtilities.getStackTrace(illegalArgumentException));
            return null;
        }
    }

    public String getParameter(String string) {
        return this.getRequestValue(string);
    }

    public int getIntRequestValue(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(this.requestWrapper.getParameter(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public int getIntRequestValue(String string, int n, int n2, int n3) {
        int n4 = n;
        try {
            n4 = Integer.parseInt(this.requestWrapper.getParameter(string));
            if (n4 < n2) {
                n4 = n2;
            }
            if (n4 > n3) {
                n4 = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n4;
    }

    public int getIntRequestValue(String string) {
        return this.getIntRequestValue(string, 0);
    }

    public String getRequestSignature() {
        String string = this.request.getQueryString();
        if (string != null && string.length() > 0) {
            return this.request.getRequestURL().append("?" + string).toString();
        }
        return this.request.getRequestURL().toString();
    }

    public String getClientIP() {
        return this.requestWrapper.getRemoteAddr();
    }

    public String getRequestMethod() {
        return this.requestWrapper.getMethod();
    }

    public void sendHTTPRedirect(String string) throws IOException {
        this.response.sendRedirect(string);
    }

    public boolean sendHTTPRedirectCaught(String string) {
        try {
            this.sendHTTPRedirect(string);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setResponseHeader(String string, String string2) {
        this.response.setHeader(string, string2);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public boolean isContentTypeSet() {
        return this.isContentTypeSet;
    }

    public void setContentType(String string) {
        this.response.setContentType(string);
        this.isContentTypeSet = true;
    }

    public void setContentLength(int n) {
        this.response.setContentLength(n);
    }

    public void setStatusCode(int n) {
        this.response.setStatus(n);
    }

    public void setExpiration(int n) {
        this.response.setDateHeader("Expires", System.currentTimeMillis() + (long)n * 1000L);
    }

    public String encodeURL(String string) {
        return this.response.encodeURL(string);
    }

    public String makeLink(String string) {
        return "<a href=\"" + this.encodeURL(string) + "\">";
    }

    public String makeLink(String string, String string2) {
        return "<a href=\"" + this.encodeURL(string) + "\" target=\"" + string2 + "\">";
    }
}

