/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.security;

import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.security.Context;
import com.luna.insight.server.security.MediaSecurityConstants;
import java.io.File;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class CollectionMediaDeleteHandler
implements MediaSecurityConstants {
    public static String[] SIZE_NAMES = new String[]{"JP2K", "Size0", "Size1", "Size2", "Size3", "Size4", "AUDIO", "VIDEO", "MISC", "SOURCE"};
    protected String fileRootDir = "";
    protected String securityKey = "";
    protected boolean enableMediaDelete = false;

    public static void debugOut(String string) {
        CollectionMediaDeleteHandler.debugOut(string, null, 2);
    }

    public static void debugOut(String string, Context context) {
        CollectionMediaDeleteHandler.debugOut(string, context, 2);
    }

    public static void debugOut(String string, Context context, int n) {
        if (context == null) {
            Debug.debugOut("CollectionMediaDeleteHandler: " + string, n);
        } else {
            Debug.debugOut("CMDelHndlr(" + context.getClientIP() + "): " + string, n);
        }
    }

    public CollectionMediaDeleteHandler() {
        CollectionMediaDeleteHandler.debugOut("CollectionMediaDeleteHandler created");
    }

    public void configure(EnhancedProperties enhancedProperties) {
        try {
            this.fileRootDir = enhancedProperties.getProperty("MediaFileRootDir", "");
            this.fileRootDir = File.separatorChar == '\\' ? this.fileRootDir.replace('/', File.separatorChar) : this.fileRootDir.replace('\\', File.separatorChar);
            CollectionMediaDeleteHandler.debugOut("Media file root dir: " + this.fileRootDir);
            this.securityKey = enhancedProperties.getProperty("MediaSecurityKey", "");
            CollectionMediaDeleteHandler.debugOut("MediaDelete security key = " + this.securityKey);
            this.enableMediaDelete = enhancedProperties.getProperty("MediaDeleteEnabled", "").equalsIgnoreCase("1");
            CollectionMediaDeleteHandler.debugOut("MediaDelete mode: " + this.enableMediaDelete);
        }
        catch (Exception exception) {
            CollectionMediaDeleteHandler.debugOut("Exception in configure():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public boolean handleRequest(Context context) {
        CollectionMediaDeleteHandler.debugOut("Received command: " + context.getCommand(), context);
        CollectionMediaDeleteHandler.debugOut("URL request:\n" + context.getRequestSignature(), context);
        if (context.getCommand().equalsIgnoreCase("deletecollectionmedia")) {
            return this.handleDelete(context);
        }
        return false;
    }

    protected boolean handleDelete(Context context) {
        CollectionMediaDeleteHandler.debugOut("in handleDelete()...");
        if (!this.enableMediaDelete) {
            return false;
        }
        HttpServletRequest httpServletRequest = context.getRequest();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string = null;
        String string2 = null;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.startsWith("forcollection")) {
                string2 = httpServletRequest.getParameter(string);
            }
            if (!string.startsWith("mediasecuritykey")) continue;
            if (!httpServletRequest.getParameter(string).equalsIgnoreCase(URLEncoder.encode(this.securityKey))) {
                CollectionMediaDeleteHandler.debugOut("handleDelete(): MediaSecurityKey do not match");
                return false;
            }
            bl = true;
        }
        if (string2 != null && bl) {
            int n = 0;
            for (int i = 0; i < SIZE_NAMES.length; ++i) {
                String string3 = InsightUtilities.concatFilepath(this.fileRootDir, SIZE_NAMES[i]);
                string3 = InsightUtilities.concatFilepath(string3, string2);
                try {
                    File file = new File(string3);
                    boolean bl2 = false;
                    if (file.exists() && file.isDirectory() && file.canWrite() && (bl2 = this.deleteDirectory(file))) {
                        ++n;
                    }
                    CollectionMediaDeleteHandler.debugOut("handleDelete(): deleted directory: " + string3 + " deleted: " + bl2);
                    continue;
                }
                catch (Exception exception) {
                    CollectionMediaDeleteHandler.debugOut("handleUpload(): Exception while deleting file:\n" + InsightUtilities.getStackTrace(exception));
                }
            }
            return n > 0;
        }
        return false;
    }

    public boolean deleteDirectory(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = this.deleteDirectory(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }
}

