/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.presentation;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageInGroup;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ImageSeriesSlide
implements Serializable,
CollectionKey {
    static final long serialVersionUID = 9159649331185981335L;
    protected int imageSeriesID = 0;
    protected int resolution = 0;
    protected Rectangle windowRectangle = null;
    protected Dimension totalSize = null;
    protected Point viewportPosition = null;
    protected boolean enabled = true;
    protected int linkCount = 0;
    protected transient ImageInGroup imageDetails = null;
    protected boolean imageMaximized = false;
    protected boolean imageMinimized = false;
    protected long imageIDV3 = 0L;
    protected long objectIDLong = 0L;
    protected String institutionIDV3;
    protected String collectionIDV3;
    protected String vcID;
    private int objectIDV3 = 0;
    private int imageID = 0;
    private int collectionID = 0;

    public ImageSeriesSlide(int n, long l, long l2, CollectionKey collectionKey, int n2, Rectangle rectangle, Point point, Dimension dimension, boolean bl, int n3) {
        this(n, l, l2, collectionKey, n2, rectangle, point, dimension, bl, n3, null, false, false);
    }

    public ImageSeriesSlide(int n, long l, long l2, CollectionKey collectionKey, int n2, Rectangle rectangle, Point point, Dimension dimension, boolean bl, int n3, ImageInGroup imageInGroup, boolean bl2) {
        this(n, l, l2, collectionKey, n2, rectangle, point, dimension, bl, n3, imageInGroup, bl2, false);
    }

    public ImageSeriesSlide(ImageSeriesSlide imageSeriesSlide) {
        this(imageSeriesSlide.getImageSeriesID(), imageSeriesSlide.getObjectID(), imageSeriesSlide.getImageID(), imageSeriesSlide, imageSeriesSlide.getResolution(), imageSeriesSlide.getWindowRectangle() != null ? new Rectangle(imageSeriesSlide.getWindowRectangle()) : null, imageSeriesSlide.getViewportPosition() != null ? new Point(imageSeriesSlide.getViewportPosition()) : null, imageSeriesSlide.getTotalSize() != null ? new Dimension(imageSeriesSlide.getTotalSize()) : null, imageSeriesSlide.isEnabled(), imageSeriesSlide.getLinkCount(), imageSeriesSlide.getImageDetails(), imageSeriesSlide.isMaximized(), imageSeriesSlide.isMinimized());
    }

    public ImageSeriesSlide(int n, long l, long l2, CollectionKey collectionKey, int n2, Rectangle rectangle, Point point, Dimension dimension, boolean bl, int n3, ImageInGroup imageInGroup, boolean bl2, boolean bl3) {
        this.imageSeriesID = n;
        this.objectIDLong = l;
        this.imageIDV3 = l2;
        this.institutionIDV3 = collectionKey.getInstitutionID();
        this.collectionIDV3 = collectionKey.getCollectionID();
        this.vcID = collectionKey.getVCID();
        this.resolution = n2;
        this.windowRectangle = rectangle;
        this.viewportPosition = point;
        this.totalSize = dimension;
        this.enabled = bl;
        this.linkCount = n3;
        this.imageDetails = imageInGroup;
        this.imageMaximized = bl2;
        this.imageMinimized = bl3;
    }

    public int getImageSeriesID() {
        return this.imageSeriesID;
    }

    public long getObjectID() {
        return this.objectIDLong;
    }

    public long getImageID() {
        return this.imageIDV3;
    }

    public ImageInGroup getImageDetails() {
        return this.imageDetails;
    }

    public void setImageSeriesID(int n) {
        this.imageSeriesID = n;
    }

    public void setObjectID(long l) {
        this.objectIDLong = l;
    }

    public void setImageID(long l) {
        this.imageIDV3 = l;
    }

    public void setInstitutionID(String string) {
        this.institutionIDV3 = string;
    }

    public void setCollectionID(String string) {
        this.collectionIDV3 = string;
    }

    public void setVCID(String string) {
        this.vcID = string;
    }

    public void setImageDetails(ImageInGroup imageInGroup) {
        this.imageDetails = imageInGroup;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Dimension getTotalSize() {
        return this.totalSize;
    }

    public Rectangle getWindowRectangle() {
        return this.windowRectangle;
    }

    public Point getViewportPosition() {
        return this.viewportPosition;
    }

    public int getLinkCount() {
        return this.linkCount;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMaximized() {
        return this.imageMaximized;
    }

    public boolean isMinimized() {
        return this.imageMinimized;
    }

    public boolean isLinked() {
        return this.linkCount > 0;
    }

    public boolean setResolution(int n) {
        boolean bl = n != this.resolution;
        this.resolution = n;
        return bl;
    }

    public boolean setTotalSize(Dimension dimension) {
        boolean bl = this.totalSize == null && dimension != null || this.totalSize != null && !this.totalSize.equals(dimension);
        this.totalSize = dimension;
        return bl;
    }

    public boolean setWindowRectangle(Rectangle rectangle) {
        boolean bl = this.windowRectangle == null && rectangle != null || this.windowRectangle != null && !this.windowRectangle.equals(rectangle);
        this.windowRectangle = rectangle;
        return bl;
    }

    public boolean setViewportPosition(Point point) {
        boolean bl = this.viewportPosition == null && point != null || this.viewportPosition != null && !this.viewportPosition.equals(point);
        this.viewportPosition = point;
        return bl;
    }

    public boolean setLinkCount(int n) {
        if (n >= 0) {
            boolean bl = n != this.linkCount;
            this.linkCount = n;
            return bl;
        }
        return false;
    }

    public boolean incLinkCount() {
        ++this.linkCount;
        return true;
    }

    public boolean decLinkCount() {
        if (this.linkCount > 0) {
            --this.linkCount;
            return true;
        }
        return false;
    }

    public boolean setEnabled(boolean bl) {
        boolean bl2 = bl != this.enabled;
        this.enabled = bl;
        return bl2;
    }

    public boolean setMaximized(boolean bl) {
        boolean bl2 = bl != this.imageMaximized;
        this.imageMaximized = bl;
        return bl2;
    }

    public boolean setMinimized(boolean bl) {
        boolean bl2 = bl != this.imageMinimized;
        this.imageMinimized = bl;
        return bl2;
    }

    public String toString() {
        String string = "disabled";
        if (this.enabled) {
            string = "enabled";
        }
        String string2 = "not linked";
        if (this.isLinked()) {
            string2 = "link count = " + this.linkCount;
        }
        String string3 = "not maximized";
        if (this.imageMaximized) {
            string3 = "maximized";
        }
        String string4 = "not minimized";
        if (this.imageMinimized) {
            string4 = "minimized";
        }
        return "ISS [hashCode = " + this.hashCode() + "; id=" + this.getImageID() + "; inst=" + this.getInstitutionID() + "; clcn=" + this.getCollectionID() + "; res=" + this.getResolution() + "; " + string2 + "; " + string + "; " + string3 + "; " + string4 + "]";
    }

    public String getInstitutionID() {
        return this.institutionIDV3;
    }

    public String getCollectionID() {
        return this.collectionIDV3;
    }

    public String getVCID() {
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.objectIDLong == 0L) {
            this.objectIDLong = this.objectIDV3;
        }
        if (this.imageIDV3 == 0L) {
            try {
                this.imageIDV3 = this.imageID;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.collectionIDV3 == null) {
            try {
                this.collectionIDV3 = Integer.toString(this.collectionID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.imageID = 0;
        this.collectionID = 0;
    }

    public static void debugOut(String string) {
        ImageSeriesSlide.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ImageSeriesSlide: " + string, n);
    }
}

