/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.personalcollections;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.TrinityCollectionInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PersonalCollection
implements CollectionKey,
Serializable {
    static final long serialVersionUID = 6500533925888240942L;
    public static final int USER_GROUP_PRIVS = 0;
    public static final int NON_USER_GROUP_PRIVS = 1;
    public static final int PRIV_READ = 1;
    public static final int PRIV_WRITE = 3;
    public static final int PRIV_DELETE = 5;
    private static int TEMP_COLLECTION_ID = -1;
    protected TrinityCollectionInfo tci;
    protected List thumbnails = new Vector(0);
    protected Map mediaFilesMap = new HashMap();
    protected long nextTempObjectID = -1L;
    protected long nextTempMediaID = -1L;
    protected transient Map transientStore = null;

    public static void debugOut(String string) {
        PersonalCollection.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("PersonalCollection: " + string, n);
    }

    public static boolean isTempCollectionID(String string) {
        try {
            return PersonalCollection.isTempCollectionID(Integer.parseInt(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isTempCollectionID(int n) {
        return n <= 0;
    }

    public static synchronized String getNextTempCollectionID() {
        return TEMP_COLLECTION_ID-- + "";
    }

    public static boolean isTempID(long l) {
        return l <= 0L;
    }

    public static boolean hasPermissionSetting(int n, int n2) {
        return (n & n2) == n2;
    }

    public static int getPermissionSettings(Map map) {
        int n = 0;
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                n |= ((Integer)entry.getKey()).intValue();
            }
        }
        return n;
    }

    public PersonalCollection(TrinityCollectionInfo trinityCollectionInfo) {
        this.tci = trinityCollectionInfo;
    }

    public boolean hasPermission(int n, int n2) {
        if (n == 0) {
            return PersonalCollection.hasPermissionSetting(this.tci.getPcUsrGrpMemberPrivs(), n2);
        }
        if (n == 1) {
            return PersonalCollection.hasPermissionSetting(this.tci.getPcNonUsrGrpMemberPrivs(), n2);
        }
        return false;
    }

    public void setPermissions(int n, Map map) {
        if (map != null) {
            int n2 = PersonalCollection.getPermissionSettings(map);
            if (n == 0) {
                this.tci.setPcUsrGrpMemberPrivs(n2);
            } else if (n == 1) {
                this.tci.setPcNonUsrGrpMemberPrivs(n2);
            }
        }
    }

    public String getStandardName() {
        return null;
    }

    public TrinityCollectionInfo getTci() {
        return this.tci;
    }

    public String getCollectionName() {
        return this.tci.getCollectionName();
    }

    public List getThumbnails() {
        return this.thumbnails;
    }

    public InsightSmartClientResults getThumbnail(long l) {
        for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
            InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.thumbnails.get(i);
            if (insightSmartClientResults.objectID != l) continue;
            return insightSmartClientResults;
        }
        return null;
    }

    public List getMediaFiles(long l) {
        Vector vector = (Vector)this.mediaFilesMap.get(new Long(l));
        if (vector == null) {
            vector = new Vector(0);
        }
        return vector;
    }

    public boolean getUploadMediaToServer() {
        return true;
    }

    public void setTci(TrinityCollectionInfo trinityCollectionInfo) {
        this.tci = trinityCollectionInfo;
    }

    public void setStandardName(String string) {
    }

    public void setCollectionName(String string) {
        this.tci.setCollectionName(string);
    }

    public void setCollectionID(String string) {
        this.tci.setCollectionID(string);
        this.tci.setVCID(string);
    }

    public void setUploadMediaToServer(boolean bl) {
    }

    public InsightSmartClientResults addThumbnail(InsightSmartClientResults insightSmartClientResults) {
        if (insightSmartClientResults != null) {
            insightSmartClientResults.setCollectionKey(this);
            this.thumbnails.add(insightSmartClientResults);
        }
        return insightSmartClientResults;
    }

    public boolean deleteThumbnail(long l) {
        try {
            InsightSmartClientResults insightSmartClientResults = this.getThumbnail(l);
            this.thumbnails.remove(insightSmartClientResults);
            return true;
        }
        catch (Exception exception) {
            PersonalCollection.debugOut("Exception in deleteThumbnail() " + InsightUtilities.getStackTrace(exception));
            return false;
        }
    }

    public void addMediaFiles(List list) {
        if (list != null && list.size() > 0) {
            this.addMediaFiles(((ImageFile)list.get((int)0)).imageID, list);
        }
    }

    public void addMediaFiles(long l, List list) {
        if (list != null) {
            this.mediaFilesMap.put(new Long(l), list);
        }
    }

    public void removeMediaFiles(long l) {
        this.mediaFilesMap.remove(new Long(l));
    }

    public synchronized long getNextTempObjectID() {
        return this.nextTempObjectID--;
    }

    public synchronized long getNextTempMediaID() {
        return this.nextTempMediaID--;
    }

    public void changeMediaID(long l, long l2) {
        List list = this.getMediaFiles(l);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ((ImageFile)list.get((int)i)).imageID = l2;
        }
        for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
            InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.thumbnails.get(i);
            if (insightSmartClientResults.imageID != l) continue;
            insightSmartClientResults.imageID = l2;
        }
        this.removeMediaFiles(l);
        this.addMediaFiles(l2, list);
    }

    public void changeObjectID(long l, long l2) {
        InsightSmartClientResults insightSmartClientResults = this.getThumbnail(l);
        if (insightSmartClientResults != null) {
            insightSmartClientResults.objectID = l2;
        }
    }

    public boolean updateMediaLocations(String string, String string2) {
        boolean bl = true;
        try {
            Collection collection = this.mediaFilesMap.values();
            Object[] objectArray = collection.toArray();
            for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                List list = (List)objectArray[i];
                for (int j = 0; list != null && j < list.size(); ++j) {
                    ImageFile imageFile = (ImageFile)list.get(j);
                    if (!imageFile.URL.startsWith(string)) continue;
                    imageFile.URL = InsightUtilities.concatFilepath(string2, imageFile.URL.substring(string.length()));
                }
            }
            for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.thumbnails.get(i);
                if (!insightSmartClientResults.thumbnailURL.startsWith(string)) continue;
                insightSmartClientResults.thumbnailURL = InsightUtilities.concatFilepath(string2, insightSmartClientResults.thumbnailURL.substring(string.length()));
            }
        }
        catch (Exception exception) {
            PersonalCollection.debugOut("Exception in updateMediaLocations(): \n" + InsightUtilities.getStackTrace(exception));
            bl = false;
        }
        return bl;
    }

    public void moveToTransient() {
        if (this.transientStore == null) {
            this.transientStore = new HashMap();
        }
        this.transientStore.clear();
        this.transientStore.put("thumbnails", this.thumbnails);
        this.transientStore.put("mediaFilesMap", this.mediaFilesMap);
        this.thumbnails = null;
        this.mediaFilesMap = null;
    }

    public void restoreFromTransient() {
        if (this.transientStore != null) {
            this.thumbnails = (List)this.transientStore.get("thumbnails");
            this.mediaFilesMap = (Map)this.transientStore.get("mediaFilesMap");
        }
    }

    public String getInstitutionID() {
        return this.tci.getInstitutionID();
    }

    public String getCollectionID() {
        return this.tci.getCollectionID();
    }

    public String getVCID() {
        return this.tci.getVCID();
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }
}

