/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mpd;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.mpd.MultipageDocumentLevel;
import com.luna.insight.server.mpd.MultipageDocumentSeries;
import java.io.Serializable;

public class MultipageDocumentPathEntry
implements Serializable,
Cloneable,
Comparable {
    static final long serialVersionUID = 5358501761737723105L;
    protected MultipageDocumentLevel level = null;
    protected int levelNumber = 0;
    protected int nodeValue = 0;
    protected String nodeName = "";
    protected transient String valueToCompare = null;

    public static void debugOut(String string) {
        MultipageDocumentPathEntry.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MPDPathEntry: " + string, n);
    }

    public MultipageDocumentPathEntry(int n, int n2) {
        this.levelNumber = n;
        this.nodeValue = n2;
    }

    public void findLevelAndNodeName(MultipageDocumentSeries multipageDocumentSeries) {
        if (multipageDocumentSeries != null) {
            this.level = multipageDocumentSeries.getLevel(this.getLevelNumber());
            if (this.level != null) {
                this.setNodeName(this.level.getNodeName(this.getNodeValue()));
            }
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MultipageDocumentPathEntry) {
            return this.compareTo((MultipageDocumentPathEntry)object) == 0;
        }
        return super.equals(object);
    }

    public int compareTo(Object object) {
        if (object instanceof MultipageDocumentPathEntry) {
            MultipageDocumentPathEntry multipageDocumentPathEntry = (MultipageDocumentPathEntry)object;
            if (this.getLevelNumber() == multipageDocumentPathEntry.getLevelNumber()) {
                return this.getNodeValue() - multipageDocumentPathEntry.getNodeValue();
            }
            return this.getLevelNumber() - multipageDocumentPathEntry.getLevelNumber();
        }
        return InsightUtilities.compareStrings(this.toString(), object.toString());
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public int getNodeValue() {
        return this.nodeValue;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getLevelName() {
        if (this.level == null) {
            return "";
        }
        return this.level.getLevelName();
    }
}

