/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mpd;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.mpd.MultipageDocumentPage;
import com.luna.insight.server.mpd.MultipageDocumentPathEntry;
import com.luna.insight.server.mpd.MultipageDocumentSeries;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class MultipageDocumentNode
implements Serializable,
Cloneable,
Comparable {
    static final long serialVersionUID = 5677468389416966401L;
    protected MultipageDocumentSeries series = null;
    protected int nodePosition = 0;
    protected MultipageDocumentNode parentNode = null;
    protected Vector childNodes = null;
    protected Vector siblingNodes = null;
    protected Vector path = new Vector();

    public static void debugOut(String string) {
        MultipageDocumentNode.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MPDNode: " + string, n);
    }

    public static int comparePaths(Vector vector, Vector vector2) {
        int n = 0;
        if (vector != null && vector2 != null) {
            MultipageDocumentPathEntry multipageDocumentPathEntry;
            MultipageDocumentPathEntry multipageDocumentPathEntry2;
            int n2 = Math.min(vector.size(), vector2.size());
            for (int i = 0; i < n2 && (multipageDocumentPathEntry2 = (MultipageDocumentPathEntry)vector.elementAt(i)).equals(multipageDocumentPathEntry = (MultipageDocumentPathEntry)vector2.elementAt(i)); ++i) {
                ++n;
            }
        }
        return n;
    }

    public static Vector getMissingAncestors(Vector vector, Vector vector2, MultipageDocumentSeries multipageDocumentSeries) {
        Vector<MultipageDocumentNode> vector3 = new Vector<MultipageDocumentNode>();
        if (vector != null && vector2 != null && vector.size() != vector2.size()) {
            Vector vector4;
            Vector vector5;
            if (vector.size() < vector2.size()) {
                vector5 = vector;
                vector4 = vector2;
            } else {
                vector5 = vector2;
                vector4 = vector;
            }
            Vector vector6 = vector5;
            MultipageDocumentPathEntry multipageDocumentPathEntry = null;
            MultipageDocumentNode multipageDocumentNode = null;
            for (int i = vector5.size(); i < vector4.size() - 1; ++i) {
                multipageDocumentPathEntry = (MultipageDocumentPathEntry)vector4.elementAt(i);
                vector6 = (Vector)vector6.clone();
                vector6.addElement(multipageDocumentPathEntry);
                MultipageDocumentNode multipageDocumentNode2 = new MultipageDocumentNode(multipageDocumentSeries);
                multipageDocumentNode2.setPath(vector6);
                if (multipageDocumentNode != null) {
                    multipageDocumentNode.registerChildNode(multipageDocumentNode2);
                }
                multipageDocumentNode = multipageDocumentNode2;
                vector3.addElement(multipageDocumentNode2);
            }
        }
        return vector3;
    }

    public MultipageDocumentNode(MultipageDocumentSeries multipageDocumentSeries) {
        this.series = multipageDocumentSeries;
    }

    public Object clone() {
        MultipageDocumentNode multipageDocumentNode = (MultipageDocumentNode)InsightUtilities.deepCopy(this);
        return multipageDocumentNode;
    }

    public void setNodePosition(int n) {
        this.nodePosition = n;
    }

    public void setParentNode(MultipageDocumentNode multipageDocumentNode) {
        this.parentNode = multipageDocumentNode;
    }

    public int getNodePosition() {
        return this.nodePosition;
    }

    public MultipageDocumentNode getParentNode() {
        return this.parentNode;
    }

    public Vector getChildNodes() {
        return this.childNodes;
    }

    public boolean isRoot() {
        return this.getParentNode() == null;
    }

    public Vector getSiblingNodes() {
        if (this.siblingNodes == null) {
            if (this.getParentNode() != null && this.getParentNode().getChildNodes() != null) {
                this.siblingNodes = new Vector(this.getParentNode().getChildNodes().size());
                MultipageDocumentNode multipageDocumentNode = null;
                for (int i = 0; i < this.getParentNode().getChildNodes().size(); ++i) {
                    multipageDocumentNode = (MultipageDocumentNode)this.getParentNode().getChildNodes().elementAt(i);
                    if (multipageDocumentNode == this) continue;
                    this.siblingNodes.addElement(multipageDocumentNode);
                }
            } else {
                this.siblingNodes = new Vector(0);
            }
        }
        return this.siblingNodes;
    }

    public int getLevelNumber() {
        MultipageDocumentPathEntry multipageDocumentPathEntry = this.getLastPathEntry();
        if (multipageDocumentPathEntry == null) {
            return 0;
        }
        return multipageDocumentPathEntry.getLevelNumber();
    }

    public String getLevelName() {
        MultipageDocumentPathEntry multipageDocumentPathEntry = this.getLastPathEntry();
        if (multipageDocumentPathEntry == null) {
            return "";
        }
        return multipageDocumentPathEntry.getLevelName();
    }

    public int getNodeValue() {
        MultipageDocumentPathEntry multipageDocumentPathEntry = this.getLastPathEntry();
        if (multipageDocumentPathEntry == null) {
            return 0;
        }
        return multipageDocumentPathEntry.getNodeValue();
    }

    public String getNodeName() {
        MultipageDocumentPathEntry multipageDocumentPathEntry = this.getLastPathEntry();
        if (multipageDocumentPathEntry == null) {
            return "";
        }
        return multipageDocumentPathEntry.getNodeName();
    }

    public String getNodeFullName() {
        String string = this.getNodeName();
        if (string != null && string.length() > 0) {
            return this.getLevelName() + " - " + string;
        }
        return this.getLevelName() + " - " + this.getNodeValue();
    }

    public String toString() {
        return this.getNodeFullName();
    }

    public void setFirstPathEntry(int n, int n2) {
        this.setFirstPathEntry(this.series.getPathEntry(n, n2));
    }

    public void setFirstPathEntry(MultipageDocumentPathEntry multipageDocumentPathEntry) {
        this.path.insertElementAt(multipageDocumentPathEntry, 0);
    }

    public void addToPath(int n, int n2) {
        this.path.addElement(this.series.getPathEntry(n, n2));
    }

    public int getPathLength() {
        return this.path.size();
    }

    public void setPath(Vector vector) {
        if (vector != null) {
            this.path = vector;
        }
    }

    public Vector getPath() {
        return this.path;
    }

    public Enumeration getPathEnum() {
        return this.path.elements();
    }

    public void trimPath() {
        Collections.sort(this.path);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n < this.path.size()) {
            if (bl) {
                this.path.removeElementAt(n);
                continue;
            }
            MultipageDocumentPathEntry multipageDocumentPathEntry = (MultipageDocumentPathEntry)this.path.elementAt(n);
            if (n == 0) {
                n2 = multipageDocumentPathEntry.getLevelNumber();
            }
            if (multipageDocumentPathEntry.getLevelNumber() != n2) {
                bl = true;
                continue;
            }
            ++n2;
            ++n;
        }
    }

    public void findParentNode() {
        if (this.getPathLength() > 1) {
            Vector vector;
            MultipageDocumentNode multipageDocumentNode = null;
            Vector vector2 = this.series.getNodes();
            for (int i = 0; i < vector2.size(); ++i) {
                int n;
                MultipageDocumentNode multipageDocumentNode2 = (MultipageDocumentNode)vector2.elementAt(i);
                if (multipageDocumentNode2 == this || multipageDocumentNode2.getPathLength() >= this.getPathLength() || (n = MultipageDocumentNode.comparePaths(multipageDocumentNode2.getPath(), this.getPath())) != multipageDocumentNode2.getPathLength()) continue;
                if (multipageDocumentNode == null || multipageDocumentNode.getPathLength() < multipageDocumentNode2.getPathLength()) {
                    multipageDocumentNode = multipageDocumentNode2;
                }
                if (multipageDocumentNode.getPathLength() == this.getPathLength() - 1) break;
            }
            if ((multipageDocumentNode == null || multipageDocumentNode.getPathLength() < this.getPathLength() - 1) && (vector = MultipageDocumentNode.getMissingAncestors(multipageDocumentNode == null ? new Vector(0) : multipageDocumentNode.getPath(), this.getPath(), this.series)) != null && vector.size() > 0) {
                if (multipageDocumentNode != null) {
                    multipageDocumentNode.registerChildNode((MultipageDocumentNode)vector.firstElement());
                }
                multipageDocumentNode = (MultipageDocumentNode)vector.lastElement();
                for (int i = 0; i < vector.size(); ++i) {
                    MultipageDocumentNode multipageDocumentNode3 = (MultipageDocumentNode)vector.elementAt(i);
                    this.series.addNode(multipageDocumentNode3);
                }
            }
            if (multipageDocumentNode == null) {
                MultipageDocumentNode.debugOut("A parent could not be found for node Level-" + this.getLevelNumber() + "-NodeValue-" + this.getNodeValue());
            } else {
                multipageDocumentNode.registerChildNode(this);
            }
        }
    }

    public void registerChildNode(MultipageDocumentNode multipageDocumentNode) {
        if (multipageDocumentNode != null) {
            multipageDocumentNode.setParentNode(this);
            if (this.childNodes == null) {
                this.childNodes = new Vector();
            }
            if (!this.childNodes.contains(multipageDocumentNode)) {
                this.childNodes.addElement(multipageDocumentNode);
            }
        }
    }

    public MultipageDocumentNode getFirstGenerationAncestor() {
        MultipageDocumentNode multipageDocumentNode = this;
        for (MultipageDocumentNode multipageDocumentNode2 = this.getParentNode(); multipageDocumentNode2 != null && !multipageDocumentNode2.isRoot(); multipageDocumentNode2 = multipageDocumentNode2.getParentNode()) {
            multipageDocumentNode = multipageDocumentNode2;
        }
        return multipageDocumentNode;
    }

    public MultipageDocumentPage getNearestPage() {
        if (this instanceof MultipageDocumentPage) {
            return (MultipageDocumentPage)this;
        }
        MultipageDocumentPage multipageDocumentPage = null;
        for (int i = 0; this.getChildNodes() != null && i < this.getChildNodes().size() && (multipageDocumentPage = ((MultipageDocumentNode)this.getChildNodes().elementAt(i)).getNearestPage()) == null; ++i) {
        }
        return multipageDocumentPage;
    }

    public void reorder(Vector vector) {
        vector.addElement(this);
        for (int i = 0; this.childNodes != null && i < this.childNodes.size(); ++i) {
            MultipageDocumentNode multipageDocumentNode = (MultipageDocumentNode)this.childNodes.elementAt(i);
            multipageDocumentNode.reorder(vector);
        }
    }

    public void display(StringBuffer stringBuffer, int n) {
        int n2;
        String string = "\n";
        for (n2 = 0; n2 < n; ++n2) {
            string = string + "\t";
        }
        stringBuffer.append(string + this.toString());
        for (n2 = 0; this.childNodes != null && n2 < this.childNodes.size(); ++n2) {
            MultipageDocumentNode multipageDocumentNode = (MultipageDocumentNode)this.childNodes.elementAt(n2);
            multipageDocumentNode.display(stringBuffer, n + 1);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof MultipageDocumentNode) {
            MultipageDocumentNode multipageDocumentNode = (MultipageDocumentNode)object;
            int n = MultipageDocumentNode.comparePaths(this.getPath(), multipageDocumentNode.getPath());
            if (n == this.getPathLength()) {
                if (this.getPathLength() == multipageDocumentNode.getPathLength()) {
                    return 0;
                }
                return -1;
            }
            if (n == multipageDocumentNode.getPathLength()) {
                return 1;
            }
            if (n < this.getPathLength() && n < multipageDocumentNode.getPathLength()) {
                return ((MultipageDocumentPathEntry)this.getPath().elementAt(n)).compareTo((MultipageDocumentPathEntry)multipageDocumentNode.getPath().elementAt(n));
            }
            MultipageDocumentNode.debugOut("Wrongly returning 0 from compareTo(), matchingSteps: " + n + ", getPathLength(): " + this.getPathLength() + ", node.getPathLength(): " + multipageDocumentNode.getPathLength());
            return 0;
        }
        return InsightUtilities.compareStrings(this.toString(), object.toString());
    }

    protected MultipageDocumentPathEntry getLastPathEntry() {
        if (this.path != null && this.path.size() > 0) {
            return (MultipageDocumentPathEntry)this.path.lastElement();
        }
        return null;
    }
}

