/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.links;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.io.InsightPkgRemoverOutputStream;
import com.luna.insight.server.io.InsightPkgSetterInputStream;
import com.luna.insight.server.links.LinkData;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class LinkFileManager
implements FilenameFilter {
    public static final String COMPONENT_NAME = "LinkFileManager";
    public static final String COMPONENT_CODE = "LFM";
    public static final String DEFAULT_LINK_FILE_PATH = "Link-Image-Files";
    public static final String LINK_FILE_EXT = "link";
    public static final String INSTITUTION_PREFIX = "InstID-";
    public static final String COLLECTION_PREFIX = "CollID-";
    public static final String VC_PREFIX = "VCID-";
    public static final String IMAGE_PREFIX = "Image-";
    public static final String REGION_PREFIX = "Region-";
    protected String linkFilePath = "Link-Image-Files";

    public static void debugOut(String string) {
        LinkFileManager.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LFM: " + string, n);
    }

    public static String getCollectionHeader(CollectionKey collectionKey) {
        return collectionKey.getInstitutionID() + "-" + collectionKey.getCollectionID() + "-" + collectionKey.getVCID();
    }

    public static String getUserGroupHeader(String string, String string2) {
        return string + "-" + string2;
    }

    public static String getImageHeader(long l) {
        return IMAGE_PREFIX + l;
    }

    public static String getRegionHeader(Rectangle rectangle) {
        return REGION_PREFIX + rectangle.x + "-" + rectangle.y + "-" + rectangle.width + "-" + rectangle.height;
    }

    public LinkFileManager(String string) {
        if (string != null) {
            this.linkFilePath = string;
        }
    }

    public Vector getLinks(CollectionKey collectionKey) {
        return this.getLinks(collectionKey, null, null);
    }

    public Vector getLinks(CollectionKey collectionKey, String string, String string2) {
        LinkFileManager.debugOut("in getLinks().");
        Vector vector = new Vector();
        String string3 = this.getDirectoryPath(collectionKey, string, string2);
        LinkFileManager.debugOut("Retrieving available links from root directory " + string3);
        File file = new File(string3);
        String[] stringArray = file.list();
        String string4 = null;
        File file2 = null;
        Vector vector2 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            string4 = stringArray[i];
            LinkFileManager.debugOut("Checking filename: " + string4);
            if (!string4.startsWith(IMAGE_PREFIX)) continue;
            file2 = new File(string3 + string4);
            LinkFileManager.debugOut("Investigating " + file2.getPath());
            if (!file2.isDirectory()) continue;
            LinkFileManager.debugOut(file2.getPath() + " indicates an eligible directory.");
            vector2 = this.getLinks(collectionKey, string, string2, string4);
            for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                vector.addElement(vector2.elementAt(j));
            }
        }
        return vector;
    }

    public Vector getLinks(CollectionKey collectionKey, long l) {
        return this.getLinks(collectionKey, null, null, l);
    }

    public Vector getLinks(CollectionKey collectionKey, String string, String string2, long l) {
        return this.getLinks(collectionKey, string, string2, LinkFileManager.getImageHeader(l));
    }

    public Vector getLinks(CollectionKey collectionKey, String string, String string2, String string3) {
        LinkFileManager.debugOut("in getLinks().");
        Vector<LinkData> vector = new Vector<LinkData>();
        String string4 = this.getDirectoryPath(collectionKey, string, string2, string3);
        LinkFileManager.debugOut("Retrieving available links for " + string4);
        File file = new File(string4);
        String[] stringArray = file.list(this);
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            LinkData linkData;
            String string5 = stringArray[i];
            if (!string5.endsWith(".link") || (linkData = this.getLink(string4 + string5)) == null) continue;
            linkData.setGroupName(string);
            linkData.setGroupCodeKey(string2);
            vector.addElement(linkData);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public LinkData getLink(String string) {
        LinkData linkData;
        block12: {
            linkData = null;
            LinkFileManager.debugOut("Finding file at " + string);
            File file = new File(string);
            if (file.exists()) {
                FileInputStream fileInputStream = null;
                fileInputStream = new FileInputStream(file);
                InsightPkgSetterInputStream insightPkgSetterInputStream = new InsightPkgSetterInputStream(fileInputStream);
                linkData = (LinkData)insightPkgSetterInputStream.readObject();
                insightPkgSetterInputStream.close();
                fileInputStream.close();
                Object var7_7 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    break block12;
                }
                catch (IOException iOException) {}
                break block12;
                {
                    catch (Exception exception) {
                        LinkFileManager.debugOut("Exception in getLink(): " + exception);
                        Object var7_8 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            break block12;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return linkData;
    }

    public boolean saveLink(LinkData linkData) {
        return this.saveLink(linkData, null, null);
    }

    public boolean saveLink(LinkData linkData, String string, String string2) {
        return this.saveLink(linkData, string, string2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveLink(LinkData linkData, String string, String string2, boolean bl) {
        LinkFileManager.debugOut("in saveLink().");
        File file = null;
        try {
            Object object;
            Object object2;
            String string3 = this.getFilePath(linkData, string, string2, linkData.getImageID(), linkData.getRegion());
            file = new File(string3);
            if (file.exists()) {
                if (!bl) return false;
                file.delete();
            } else {
                object2 = this.getDirectoryPath((CollectionKey)linkData, string, string2, linkData.getImageID());
                object = new File((String)object2);
                ((File)object).mkdirs();
            }
            object2 = new FileOutputStream(file);
            object = InsightPkgRemoverOutputStream.getInstance((OutputStream)object2);
            ((ObjectOutputStream)object).writeObject(linkData);
            ((ObjectOutputStream)object).close();
            ((FileOutputStream)object2).close();
            return file.exists();
        }
        catch (Exception exception) {
            LinkFileManager.debugOut("Exception in saveLink(): " + exception);
            return false;
        }
    }

    public boolean deleteLink(CollectionKey collectionKey, long l, Rectangle rectangle) {
        return this.deleteLink(collectionKey, null, null, l, rectangle);
    }

    public boolean deleteLink(CollectionKey collectionKey, String string, String string2, long l, Rectangle rectangle) {
        return this.deleteLink(collectionKey, string, string2, l, rectangle, true);
    }

    public boolean deleteLink(CollectionKey collectionKey, String string, String string2, long l, Rectangle rectangle, boolean bl) {
        LinkFileManager.debugOut("in deleteLink().");
        String string3 = this.getFilePath(collectionKey, string, string2, l, rectangle);
        LinkFileManager.debugOut("Finding file at " + string3);
        File file = new File(string3);
        if (file.exists() && !bl) {
            return false;
        }
        boolean bl2 = file.delete();
        if (bl2) {
            LinkFileManager.debugOut(string3 + " successfully deleted.");
        } else {
            LinkFileManager.debugOut(string3 + " not deleted.");
        }
        return bl2;
    }

    public boolean clearLinks() {
        return InsightUtilities.cleanDirectory(this.linkFilePath, false, true, true);
    }

    public boolean accept(File file, String string) {
        return string != null && string.endsWith(".link");
    }

    protected String getDirectoryPath(CollectionKey collectionKey, String string, String string2, long l) {
        return this.getDirectoryPath(collectionKey, string, string2, LinkFileManager.getImageHeader(l));
    }

    protected String getDirectoryPath(CollectionKey collectionKey, String string, String string2) {
        return this.getDirectoryPath(collectionKey, string, string2, null);
    }

    protected String getDirectoryPath(CollectionKey collectionKey, String string, String string2, String string3) {
        if (string != null && string2 != null) {
            return this.linkFilePath + File.separator + LinkFileManager.getCollectionHeader(collectionKey) + File.separator + LinkFileManager.getUserGroupHeader(string, string2) + File.separator + (string3 == null ? "" : string3 + File.separator);
        }
        return this.linkFilePath + File.separator + LinkFileManager.getCollectionHeader(collectionKey) + File.separator + (string3 == null ? "" : string3 + File.separator);
    }

    protected String getFilePath(CollectionKey collectionKey, String string, String string2, long l, Rectangle rectangle) {
        return this.getDirectoryPath(collectionKey, string, string2, l) + LinkFileManager.getImageHeader(l) + "-" + LinkFileManager.getRegionHeader(rectangle) + "." + LINK_FILE_EXT;
    }
}

