/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.links;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.links.LinkData;
import com.luna.insight.server.links.LinkFileManager;
import com.luna.insight.server.usergroup.UserGroupShell;
import java.util.Vector;

public class LinkCodeGenerator {
    public static final String SEPARATOR = "-";
    public static final String IP_PREFIX = "IP-";
    public static final String GROUP_PREFIX = "Group-";
    public static final String COLLECTION_PREFIX = "Coll-";

    public static Vector getLinkCodes(CollectionKey collectionKey, String string, String string2, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(LinkCodeGenerator.getLocalLinkCode(collectionKey, string, string2));
        String string3 = new String();
        String string4 = new String();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            string3 = ((UserGroupShell)vector.elementAt(i)).getName();
            string4 = ((UserGroupShell)vector.elementAt(i)).getCodeKey();
            vector2.addElement(LinkCodeGenerator.getGroupLinkCode(collectionKey, string3, string4));
        }
        vector2.addElement(LinkCodeGenerator.getCollectionLinkCode(collectionKey));
        return vector2;
    }

    public static String getLinkCode(LinkData linkData) {
        String string = "";
        if (linkData != null) {
            if (linkData.getSaveLocation() == 0) {
                string = LinkCodeGenerator.getCollectionLinkCode(linkData);
            } else if (linkData.getSaveLocation() == 1) {
                string = LinkCodeGenerator.getGroupLinkCode(linkData, linkData.getGroupName(), linkData.getGroupCodeKey());
            } else if (linkData.getSaveLocation() == 2) {
                // empty if block
            }
        }
        return string;
    }

    public static String getLocalLinkCode(CollectionKey collectionKey, String string, String string2) {
        return LinkCodeGenerator.getLinkCode(collectionKey, string, string2, null, null);
    }

    public static String getGroupLinkCode(CollectionKey collectionKey, String string, String string2) {
        return LinkCodeGenerator.getLinkCode(collectionKey, null, null, string, string2);
    }

    public static String getCollectionLinkCode(CollectionKey collectionKey) {
        return LinkCodeGenerator.getLinkCode(collectionKey, null, null, null, null);
    }

    private static String getLinkCode(CollectionKey collectionKey, String string, String string2, String string3, String string4) {
        String string5 = "";
        if (string != null && string2 != null && collectionKey != null) {
            string5 = LinkCodeGenerator.getIPAddressHeader(string, string2) + SEPARATOR + COLLECTION_PREFIX + LinkFileManager.getCollectionHeader(collectionKey);
        } else if (string3 != null && string4 != null && collectionKey != null) {
            string5 = GROUP_PREFIX + string3 + SEPARATOR + string4 + SEPARATOR + COLLECTION_PREFIX + LinkFileManager.getCollectionHeader(collectionKey);
        } else if (collectionKey != null) {
            string5 = COLLECTION_PREFIX + LinkFileManager.getCollectionHeader(collectionKey);
        }
        return string5;
    }

    public static String getIPAddressHeader(String string, String string2) {
        return IP_PREFIX + string + SEPARATOR + string2;
    }
}

