/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.io;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.io.InsightPkgStreamConstants;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ClassDescriptionFilter
implements ObjectStreamConstants,
InsightPkgStreamConstants {
    protected static final long WAIT_LIMIT = 10000L;
    protected static final Map SERIAL_VERSION_IDS = new Hashtable();
    protected static final List PACKAGE_NAMES = new Vector();
    protected static final Map VALID_CLASS_NAMES = new Hashtable();
    protected DataOutputStream output;
    protected boolean removePackages;

    public static void debugOut(String string) {
        ClassDescriptionFilter.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ClassDescFltr: " + string, n);
    }

    public static String removePackage(String string) {
        if (string != null) {
            String string2 = string;
            int n = -1;
            int n2 = -1;
            n = string.indexOf("com.luna.insight.server");
            if (n > -1) {
                n2 = string.lastIndexOf(46);
            } else {
                n = string.indexOf(InsightPkgStreamConstants.INSIGHT_PKG_SLASH_PREFIX);
                if (n > -1) {
                    n2 = string.lastIndexOf(47);
                }
            }
            if (n > -1 && n2 > -1) {
                string = string.substring(0, n) + string.substring(n2 + 1);
            }
        }
        return string;
    }

    public static String getValidClassName(String object) {
        Object object2 = object;
        if (object != null && object.length() > 0 && object.indexOf(46) == -1 && object.indexOf(47) == -1) {
            object2 = (String)VALID_CLASS_NAMES.get(object);
            if (object2 == null) {
                Object object3;
                Object object4 = object;
                boolean bl = false;
                if (object4.startsWith("[L")) {
                    bl = true;
                    if ((object4 = object4.substring(2)).endsWith(";")) {
                        object4 = object4.substring(0, object4.length() - 1);
                    }
                    object4 = object4.intern();
                }
                if (ClassDescriptionFilter.isClassNameValid((String)object4)) {
                    object2 = object4;
                }
                if (object2 == null) {
                    for (int i = 0; PACKAGE_NAMES != null && i < PACKAGE_NAMES.size(); ++i) {
                        object3 = ((String)PACKAGE_NAMES.get(i) + '.' + (String)object4).intern();
                        if (!ClassDescriptionFilter.isClassNameValid((String)object3)) continue;
                        object2 = object3;
                        break;
                    }
                }
                if (object2 == null) {
                    object3 = Package.getPackages();
                    for (int i = 0; object3 != null && i < ((Package[])object3).length; ++i) {
                        String string;
                        if (!object3[i].getName().startsWith("com.luna.insight.server") || !ClassDescriptionFilter.isClassNameValid(string = (object3[i].getName() + '.' + (String)object4).intern())) continue;
                        object2 = string;
                        break;
                    }
                }
                if (object2 != null) {
                    if (bl) {
                        object2 = ("[L" + (String)object2 + ";").intern();
                    }
                    VALID_CLASS_NAMES.put(object, object2);
                }
            }
            if (object2 == null) {
                object2 = object;
            }
            ClassDescriptionFilter.debugOut("Class: " + (String)object + " -> " + (String)object2);
        }
        return object2;
    }

    public static boolean isClassNameValid(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long getSerialVersionUID(String string, long l) {
        try {
            Class<?> clazz = Class.forName(string);
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
            if (objectStreamClass != null) {
                return objectStreamClass.getSerialVersionUID();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public ClassDescriptionFilter(OutputStream outputStream, boolean bl) {
        this.output = new DataOutputStream(outputStream);
        this.removePackages = bl;
    }

    public void filterClassDescriptor(InputStream inputStream) throws IOException {
        String string = this.readUTF(inputStream);
        long l = this.readLong(inputStream);
        byte by = this.readByte(inputStream);
        Long l2 = (Long)SERIAL_VERSION_IDS.get(string);
        if (l2 != null) {
            l = l2;
        }
        if (this.removePackages) {
            string = ClassDescriptionFilter.removePackage(string);
        }
        this.output.writeUTF(string);
        this.output.writeLong(l);
        this.output.writeByte(by);
        int n = this.readShort(inputStream);
        this.output.writeShort(n);
        for (int i = 0; i < n; ++i) {
            Object object;
            char c = (char)this.readByte(inputStream);
            String string2 = this.readUTF(inputStream);
            Object object2 = object = c == 'L' || c == '[' ? this.readTypeString(inputStream) : new String(new char[]{c});
            if (object instanceof String && this.removePackages) {
                object = ClassDescriptionFilter.removePackage((String)object);
            }
            this.output.writeByte(c);
            this.output.writeUTF(string2);
            if (c != 'L' && c != '[') continue;
            this.writeTypeString(object);
        }
    }

    protected byte readByte(InputStream inputStream) throws IOException {
        return InsightUtilities.readByte(inputStream, 10000L);
    }

    protected short readShort(InputStream inputStream) throws IOException {
        return InsightUtilities.readShort(inputStream, 10000L);
    }

    protected int readInt(InputStream inputStream) throws IOException {
        return InsightUtilities.readInt(inputStream, 10000L);
    }

    protected long readLong(InputStream inputStream) throws IOException {
        return InsightUtilities.readLong(inputStream, 10000L);
    }

    protected String readUTF(InputStream inputStream) throws IOException {
        return InsightUtilities.readUTF(inputStream, 10000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object readTypeString(InputStream inputStream) throws IOException {
        byte by = this.readByte(inputStream);
        switch (by) {
            case 112: {
                return null;
            }
            case 113: {
                return new Integer(this.readInt(inputStream));
            }
            case 116: {
                return this.readUTF(inputStream);
            }
            case 124: {
                throw new StreamCorruptedException("Cannot read type strings of type TC_LONGSTRING.");
            }
        }
        throw new StreamCorruptedException();
    }

    protected void writeTypeString(Object object) throws IOException {
        if (object == null) {
            this.output.writeByte(112);
        } else if (object instanceof Integer) {
            this.output.writeByte(113);
            this.output.writeInt((Integer)object);
        } else if (object instanceof String) {
            this.output.writeByte(116);
            this.output.writeUTF((String)object);
        }
    }

    static {
        SERIAL_VERSION_IDS.put("[Lcom.luna.insight.server.DynamicDistributionBucketInfo;", new Long(-1913199459398557139L));
        SERIAL_VERSION_IDS.put("[Lcom.luna.insight.server.FieldMapping;", new Long(-587630664984706674L));
        PACKAGE_NAMES.add("com.luna.insight.server");
        PACKAGE_NAMES.add("com.luna.insight.server.backend");
        PACKAGE_NAMES.add("com.luna.insight.core.util");
        PACKAGE_NAMES.add("com.luna.insight.server.hierarchy");
        PACKAGE_NAMES.add("com.luna.insight.server.indexer");
        PACKAGE_NAMES.add("com.luna.insight.server.inscribe");
        PACKAGE_NAMES.add("com.luna.insight.server.io");
        PACKAGE_NAMES.add("com.luna.insight.server.links");
        PACKAGE_NAMES.add("com.luna.insight.server.mpd");
        PACKAGE_NAMES.add("com.luna.insight.server.mvi");
        PACKAGE_NAMES.add("com.luna.insight.server.personalcollections");
        PACKAGE_NAMES.add("com.luna.insight.server.presentation");
        PACKAGE_NAMES.add("com.luna.insight.server.security");
        PACKAGE_NAMES.add("com.luna.insight.server.ucb");
        PACKAGE_NAMES.add("com.luna.insight.server.usergroup");
    }
}

