/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.core.util.MutableBoolean;
import com.luna.insight.server.Debug;
import com.luna.insight.server.inscribe.MedePublisher;
import com.luna.insight.server.inscribe.MedeTermProcessorDetails;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class MedeTermProcessor
extends Thread {
    public static final int TERM_INDEX_OFF = 0;
    public static final int TERM_INDEX_IMMEDIATE = 1;
    public static final int TERM_INDEX_BACKGROUND = 2;
    private static List termIndexingQueue = Collections.synchronizedList(new LinkedList());
    private static MutableBoolean isTermProcessingLock = new MutableBoolean(false);

    public static void debugOut(String string) {
        MedeTermProcessor.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MedeTermProcessor: " + string, n);
    }

    public static void prepareAndProcessTermIndexing(MedeTermProcessorDetails medeTermProcessorDetails) {
        MedePublisher medePublisher = medeTermProcessorDetails.medepublisher;
        if (medePublisher.termIndexingMode != 0) {
            if (medePublisher.termIndexingMode == 1) {
                medePublisher.processTermIndexing(medeTermProcessorDetails);
            } else {
                MedeTermProcessor.prepareAndProcessTermIndexingInBackground(medeTermProcessorDetails);
            }
        }
    }

    public static void prepareAndProcessTermIndexingInBackground(MedeTermProcessorDetails medeTermProcessorDetails) {
        MedePublisher medePublisher = medeTermProcessorDetails.medepublisher;
        termIndexingQueue.add(medeTermProcessorDetails);
        if (!medePublisher.isTermProcessingScheduled()) {
            MedeTermProcessor.startTermProcessing();
        }
    }

    public static void startTermProcessing() {
        if (termIndexingQueue.size() == 0) {
            MedeTermProcessor.debugOut("There are no term indexing requests");
            return;
        }
        new MedeTermProcessor().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getTermProcessingLock() {
        boolean bl = false;
        MutableBoolean mutableBoolean = isTermProcessingLock;
        synchronized (mutableBoolean) {
            if (!isTermProcessingLock.getValue()) {
                isTermProcessingLock.setValue(true);
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseTermProcessingLock() {
        MutableBoolean mutableBoolean = isTermProcessingLock;
        synchronized (mutableBoolean) {
            if (isTermProcessingLock.getValue()) {
                isTermProcessingLock.setValue(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (true) {
                if (MedeTermProcessor.getTermProcessingLock()) {
                    int n = termIndexingQueue.size();
                    for (int i = 0; i < n; ++i) {
                        MedeTermProcessor.debugOut("Processing term indexing request " + (i + 1) + " of " + n);
                        MedeTermProcessorDetails medeTermProcessorDetails = (MedeTermProcessorDetails)termIndexingQueue.remove(0);
                        medeTermProcessorDetails.medepublisher.processTermIndexing(medeTermProcessorDetails);
                    }
                    MedeTermProcessor.releaseTermProcessingLock();
                    break;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            MedeTermProcessor.releaseTermProcessingLock();
        }
    }
}

