/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.server.CollectionConnection;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.InsightRequest;
import com.luna.insight.server.InsightServicerCommands;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.ResultsControllerInterface;
import com.luna.insight.server.ResultsProgressListener;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.UniqueListResultCollector;
import com.luna.insight.server.collectionmanagement.CollectionBuildingObject;
import com.luna.insight.server.collectionmanagement.CollectionBuildingTemplate;
import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.EntityChangeList;
import com.luna.insight.server.inscribe.EntityEquivalenceQuery;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityKeyWrapper;
import com.luna.insight.server.inscribe.EntityLock;
import com.luna.insight.server.inscribe.EntitySearchQuery;
import com.luna.insight.server.inscribe.EntitySearchResult;
import com.luna.insight.server.inscribe.EntitySearchResultCollector;
import com.luna.insight.server.inscribe.EntitySearchResultGetter;
import com.luna.insight.server.inscribe.EntityType;
import com.luna.insight.server.inscribe.EntityTypeKey;
import com.luna.insight.server.inscribe.EntityUniqueListGetter;
import com.luna.insight.server.inscribe.EquivalenceClass;
import com.luna.insight.server.inscribe.MedePrivileges;
import com.luna.insight.server.inscribe.MediaSearchQuery;
import com.luna.insight.server.inscribe.MediaSearchResult;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MedeSmartClient
extends InsightSmartClient
implements InsightServicerCommands {
    public static void debugOut(String string) {
        MedeSmartClient.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MedeSmartClient: " + string, n);
    }

    public MedeSmartClient(List list) {
        super(list);
    }

    public MedeSmartClient(List list, CollectionKey collectionKey) {
        super(list, collectionKey);
    }

    public MedeSmartClient(String string, int n) {
        super(string, n);
    }

    public MedeSmartClient(TrinityCollectionInfo trinityCollectionInfo) {
        super(trinityCollectionInfo);
    }

    public Vector getFieldList() {
        MedeSmartClient.debugOut("in getFieldList().");
        Vector vector = new Vector(0);
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(94, collectionConnection.tci, this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    vector = (Vector)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getFieldList():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return vector;
    }

    public boolean isMedeEnabled() {
        MedeSmartClient.debugOut("in isMedeEnabled().");
        boolean bl = false;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(93, collectionConnection.tci, this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    bl = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in isMedeEnabled():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl;
    }

    public void getCommitApprovalLevels(MedePrivileges medePrivileges) {
        MedeSmartClient.debugOut("Retrieving commit approval levels.");
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(177, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("MEDE_PRIVS", medePrivileges);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    MedePrivileges medePrivileges2 = (MedePrivileges)collectionConnection.ois.readObject();
                    medePrivileges.setInvertedCommitLevel(medePrivileges2.getInvertedCommitLevel());
                    medePrivileges.setSourceCommitLevel(medePrivileges2.getSourceCommitLevel());
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getCommitApprovalLevels():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
    }

    public MedePrivileges getMedePrivileges(InsightUser insightUser) {
        MedeSmartClient.debugOut("Retrieving MEDE privileges.");
        MedePrivileges medePrivileges = null;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(95, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addObjectParam("USER", insightUser);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    int n = collectionConnection.ois.readInt();
                    int n2 = collectionConnection.ois.readInt();
                    int n3 = collectionConnection.ois.readInt();
                    insightUser.setUserID(n2);
                    collectionConnection.tci.setUserID(n2);
                    Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                    hashtable.put("approval-level", new Integer(n));
                    hashtable.put("mede-user-ID", new Integer(n2));
                    hashtable.put("permissions", new Integer(n3));
                    medePrivileges = new MedePrivileges(hashtable);
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getMedePrivileges():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return medePrivileges;
    }

    public List getEntityTypes() {
        MedeSmartClient.debugOut("in getEntityTypes().");
        List list = new Vector(0);
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(96, collectionConnection.tci, this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    list = (List)collectionConnection.ois.readObject();
                }
                for (int i = 0; list != null && i < list.size(); ++i) {
                    ((EntityType)list.get(i)).setCollectionKey(collectionConnection.tci);
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntityTypes():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list;
    }

    public List getEntityTypeRelationships() {
        MedeSmartClient.debugOut("in getEntityTypeRelationships().");
        List list = new Vector(0);
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(148, collectionConnection.tci, this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                list = this.waitForInput(collectionConnection) > 0 ? (List)collectionConnection.ois.readObject() : null;
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntityTypeRelationships():\n" + InsightUtilities.getStackTrace(exception), 2);
            list = null;
        }
        return list;
    }

    public List getEntities(List list) {
        MedeSmartClient.debugOut("in getEntities().");
        List list2 = new Vector(0);
        try {
            if (list != null && list.size() > 0 && this.collectionConnections != null && this.collectionConnections.size() > 0) {
                Vector<EntityKeyWrapper> vector = new Vector<EntityKeyWrapper>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    EntityKey entityKey = (EntityKey)list.get(i);
                    vector.add(new EntityKeyWrapper(entityKey.getEntityTypeID(), entityKey.getEntityID()));
                }
                CollectionConnection collectionConnection = this.getCollectionConnection((EntityKey)list.get(0));
                InsightRequest insightRequest = InsightRequest.newRequest(97, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("ENTITIES", vector);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    list2 = (List)collectionConnection.ois.readObject();
                }
                for (int i = 0; list2 != null && i < list2.size(); ++i) {
                    ((Entity)list2.get(i)).setCollectionKey(collectionConnection.tci);
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntities():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list2;
    }

    public Entity getEntity(EntityKey entityKey) {
        MedeSmartClient.debugOut("in getEntity().");
        Entity entity = null;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entityKey);
                InsightRequest insightRequest = InsightRequest.newRequest(98, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", entityKey.getEntityTypeID());
                insightRequest.addLongParam("ENTITY_ID", entityKey.getEntityID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    entity = (Entity)collectionConnection.ois.readObject();
                }
                if (entity != null) {
                    entity.setCollectionKey(collectionConnection.tci);
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntity():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return entity;
    }

    public Entity getEntityByFieldValue(EntityTypeKey entityTypeKey, int n, String string) {
        MedeSmartClient.debugOut("in getEntityByFieldValue().");
        Entity entity = null;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entityTypeKey);
                InsightRequest insightRequest = InsightRequest.newRequest(99, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", entityTypeKey.getEntityTypeID());
                insightRequest.addIntegerParam("FIELD_ID", n);
                insightRequest.addStringParam("VALUE", string);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    collectionConnection.totalRecords = collectionConnection.ois.readInt();
                    entity = (Entity)collectionConnection.ois.readObject();
                }
                if (entity != null) {
                    entity.setCollectionKey(collectionConnection.tci);
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntityByFieldValue():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return entity;
    }

    public List getEntitiesByFieldValue(EntityTypeKey entityTypeKey, int n, String string, int n2, int n3) {
        MedeSmartClient.debugOut("in getEntitiesByFieldValue().");
        List list = null;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entityTypeKey);
                InsightRequest insightRequest = InsightRequest.newRequest(131, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", entityTypeKey.getEntityTypeID());
                insightRequest.addIntegerParam("FIELD_ID", n);
                insightRequest.addStringParam("VALUE", string);
                insightRequest.addIntegerParam("START", n2);
                insightRequest.addIntegerParam("LENGTH", n3);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    collectionConnection.totalRecords = collectionConnection.ois.readInt();
                    list = (List)collectionConnection.ois.readObject();
                }
                for (int i = 0; list != null && i < list.size(); ++i) {
                    ((Entity)list.get(i)).setCollectionKey(collectionConnection.tci);
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntitiesByFieldValue():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list;
    }

    public EntityLock getEntityLock(EntityKey entityKey) {
        MedeSmartClient.debugOut("in getEntityLock().");
        EntityLock entityLock = null;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entityKey);
                InsightRequest insightRequest = InsightRequest.newRequest(105, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", entityKey.getEntityTypeID());
                insightRequest.addLongParam("ENTITY_ID", entityKey.getEntityID());
                insightRequest.addIntegerParam("USER_ID", collectionConnection.tci.getUserID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    entityLock = (EntityLock)collectionConnection.ois.readObject();
                }
                if (entityLock != null) {
                    entityLock.setCollectionKey(collectionConnection.tci);
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntityLock():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return entityLock;
    }

    public boolean unlockEntity(EntityKey entityKey) {
        MedeSmartClient.debugOut("in unlockEntity().");
        boolean bl = false;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entityKey);
                InsightRequest insightRequest = InsightRequest.newRequest(106, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", entityKey.getEntityTypeID());
                insightRequest.addLongParam("ENTITY_ID", entityKey.getEntityID());
                insightRequest.addIntegerParam("USER_ID", collectionConnection.tci.getUserID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    bl = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in unlockEntity():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl;
    }

    public boolean saveEntity(EntityChangeList entityChangeList) {
        MedeSmartClient.debugOut("in saveEntity().");
        boolean bl = false;
        try {
            if (entityChangeList != null && this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entityChangeList);
                List list = entityChangeList.getEntities();
                entityChangeList.setEntities(null);
                entityChangeList.setUserID(collectionConnection.tci.getUserID());
                InsightRequest insightRequest = InsightRequest.newRequest(101, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("ENTITY_CHANGE_LIST", entityChangeList);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                entityChangeList.setEntities(list);
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    bl = collectionConnection.ois.readBoolean();
                    Map map = (Map)collectionConnection.ois.readObject();
                    if (map != null && map.size() > 0) {
                        MedeSmartClient.debugOut("Received " + map.size() + " entityID changes.");
                        entityChangeList.setEntityIDChanges(map);
                    } else {
                        MedeSmartClient.debugOut("No entityID changes.");
                    }
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in saveEntity():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl;
    }

    public boolean saveEntityChanges(List list, boolean bl, CollectionKey collectionKey) {
        MedeSmartClient.debugOut("in saveEntityChanges().");
        boolean bl2 = false;
        try {
            if (list != null && list.size() > 0 && this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
                InsightRequest insightRequest = InsightRequest.newRequest(113, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("ENTITY_CHANGE_LIST", list);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addIntegerParam("USER_ID", collectionConnection.tci.getUserID());
                insightRequest.addBooleanParam("ENTITY_LOCK_FLAG", bl);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    bl2 = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in saveEntityChanges():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl2;
    }

    public boolean deleteEntity(EntityKey entityKey, boolean bl) {
        MedeSmartClient.debugOut("in deleteEntity().");
        boolean bl2 = false;
        try {
            if (entityKey != null && this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entityKey);
                InsightRequest insightRequest = InsightRequest.newRequest(102, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", entityKey.getEntityTypeID());
                insightRequest.addLongParam("ENTITY_ID", entityKey.getEntityID());
                insightRequest.addIntegerParam("USER_ID", collectionConnection.tci.getUserID());
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addBooleanParam("DELETE_FLAG", bl);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    bl2 = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in deleteEntity():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean deleteCollectionMedia(TrinityCollectionInfo trinityCollectionInfo) {
        String string = this.getMediaSecurityServletBaseUrl(trinityCollectionInfo);
        StringBuffer stringBuffer = new StringBuffer("cmd=deletecollectionmedia");
        stringBuffer.append("&forcollection=" + URLEncoder.encode(trinityCollectionInfo.getTriplet()));
        String string2 = this.getMediaSecurityKey(trinityCollectionInfo);
        stringBuffer.append("&mediasecuritykey=" + URLEncoder.encode(string2));
        DataOutputStream dataOutputStream = null;
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        MedeSmartClient.debugOut("Before DataOutputStream");
        dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
        dataOutputStream.write(stringBuffer.toString().getBytes());
        dataOutputStream.flush();
        dataOutputStream.close();
        InputStream inputStream = httpURLConnection.getInputStream();
        inputStream.close();
        MedeSmartClient.debugOut("After https stream close");
        MedeSmartClient.debugOut("Http Post Done.");
        boolean bl = true;
        Object var11_11 = null;
        if (dataOutputStream == null) return bl;
        try {
            dataOutputStream.flush();
            dataOutputStream.close();
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
        catch (Exception exception) {
            try {
                MedeSmartClient.debugOut("Exception in deleteCollectionMediaFiles(): \n" + InsightUtilities.getStackTrace(exception));
                Object var11_12 = null;
                if (dataOutputStream == null) return false;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (dataOutputStream == null) throw throwable;
                try {
                    dataOutputStream.flush();
                    dataOutputStream.close();
                    throw throwable;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                dataOutputStream.flush();
                dataOutputStream.close();
                return false;
            }
            catch (Exception exception3) {}
            return false;
        }
    }

    public List importEntities(Collection collection) {
        return this.importEntities(collection, false);
    }

    public List importEntities(Collection collection, boolean bl) {
        MedeSmartClient.debugOut("in importEntities().");
        List list = null;
        try {
            if (collection != null && collection.size() > 0 && this.collectionConnections != null && this.collectionConnections.size() > 0) {
                Entity entity = (Entity)collection.iterator().next();
                CollectionConnection collectionConnection = this.getCollectionConnection(entity);
                InsightRequest insightRequest = InsightRequest.newRequest(111, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("USER_ID", collectionConnection.tci.getUserID());
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addObjectParam("ENTITIES", collection);
                insightRequest.addBooleanParam("PUBLISH_IMMEDIATELY", bl);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    list = (List)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in importEntities():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list;
    }

    public List getEntityChangeUsers(int n, List list, int n2, boolean bl) {
        MedeSmartClient.debugOut("in getEntityChangeUsers().");
        List list2 = new Vector(0);
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(107, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addIntegerParam("CHANGE_STATUS", n);
                insightRequest.addObjectParam("CHANGE_CATEGORIES", list);
                insightRequest.addIntegerParam("EDITOR_ID", bl ? collectionConnection.tci.getUserID() : -1);
                insightRequest.addIntegerParam("APPROVAL_LEVEL_MODE", n2);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    list2 = (List)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntityChangeUsers():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list2;
    }

    public List getEntityChangeLists(EntityTypeKey entityTypeKey, int n, int n2, List list, int n3, boolean bl) {
        MedeSmartClient.debugOut("in getEntityChangeLists().");
        List list2 = new Vector(0);
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entityTypeKey);
                InsightRequest insightRequest = InsightRequest.newRequest(108, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", entityTypeKey.getEntityTypeID());
                insightRequest.addIntegerParam("USER_ID", n);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addIntegerParam("CHANGE_STATUS", n2);
                insightRequest.addObjectParam("CHANGE_CATEGORIES", list);
                insightRequest.addIntegerParam("EDITOR_ID", bl ? collectionConnection.tci.getUserID() : -1);
                insightRequest.addIntegerParam("APPROVAL_LEVEL_MODE", n3);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(5, 10, 18), 7)) {
                    if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                        list2 = (List)collectionConnection.ois.readObject();
                    }
                } else if (this.waitForInput(collectionConnection) > 0) {
                    list2 = (List)collectionConnection.ois.readObject();
                }
                for (int i = 0; list2 != null && i < list2.size(); ++i) {
                    ((EntityChangeList)list2.get(i)).setCollectionKey(collectionConnection.tci);
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntityChangeLists():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list2;
    }

    public boolean approveEntityChanges(boolean bl, CollectionKey collectionKey, int n, List list, List list2) {
        MedeSmartClient.debugOut("in approveEntityChanges().");
        boolean bl2 = false;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = collectionKey == null ? (CollectionConnection)this.collectionConnections.get(0) : this.getCollectionConnection(collectionKey);
                int n2 = -1;
                long l = -1L;
                if (collectionKey instanceof EntityKey) {
                    n2 = ((EntityKey)collectionKey).getEntityTypeID();
                    l = ((EntityKey)collectionKey).getEntityID();
                } else if (collectionKey instanceof EntityTypeKey) {
                    n2 = ((EntityTypeKey)collectionKey).getEntityTypeID();
                }
                InsightRequest insightRequest = InsightRequest.newRequest(109, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addBooleanParam("APPROVE_FLAG", bl);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", n2);
                insightRequest.addLongParam("ENTITY_ID", l);
                insightRequest.addIntegerParam("USER_ID", n);
                insightRequest.addObjectParam("CHANGE_CATEGORIES", list);
                insightRequest.addObjectParam("CHANGE_IDS", list2);
                insightRequest.addIntegerParam("EDITOR_ID", collectionConnection.tci.getUserID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    bl2 = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in approveEntityChanges():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl2;
    }

    public List getExtraApprovalItems(CollectionKey collectionKey, long l, List list) {
        MedeSmartClient.debugOut("in getExtraApprovalItems().");
        List list2 = new ArrayList();
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection;
                CollectionConnection collectionConnection2 = collectionConnection = collectionKey == null ? (CollectionConnection)this.collectionConnections.get(0) : this.getCollectionConnection(collectionKey);
                if (collectionConnection != null && InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(5, 10, 15), 7)) {
                    InsightRequest insightRequest = InsightRequest.newRequest(181, collectionConnection.tci, this.getLocalAddress());
                    insightRequest.addLongParam("ENTITY_ID", l);
                    insightRequest.addObjectParam("CHANGE_CATEGORIES", list);
                    collectionConnection.oos.writeObject(insightRequest);
                    collectionConnection.oos.flush();
                    if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                        MedeSmartClient.debugOut("Receiving data.", 3);
                        list2 = (List)collectionConnection.ois.readObject();
                    }
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in approveEntityChanges():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list2;
    }

    public boolean cancelEntityChanges(CollectionKey collectionKey, List list) {
        MedeSmartClient.debugOut("in cancelEntityChanges().");
        boolean bl = false;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = collectionKey == null ? (CollectionConnection)this.collectionConnections.get(0) : this.getCollectionConnection(collectionKey);
                int n = -1;
                long l = -1L;
                if (collectionKey instanceof EntityKey) {
                    n = ((EntityKey)collectionKey).getEntityTypeID();
                    l = ((EntityKey)collectionKey).getEntityID();
                } else if (collectionKey instanceof EntityTypeKey) {
                    n = ((EntityTypeKey)collectionKey).getEntityTypeID();
                }
                InsightRequest insightRequest = InsightRequest.newRequest(127, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", n);
                insightRequest.addLongParam("ENTITY_ID", l);
                insightRequest.addObjectParam("CHANGE_IDS", list);
                insightRequest.addIntegerParam("EDITOR_ID", collectionConnection.tci.getUserID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    bl = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in cancelEntityChanges():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl;
    }

    public boolean removeRejectedEntityChanges(CollectionKey collectionKey, int n, List list) {
        return this.removeRejectedEntityChanges(collectionKey, n, list, null);
    }

    public boolean removeRejectedEntityChanges(CollectionKey collectionKey, List list) {
        return this.removeRejectedEntityChanges(collectionKey, 0, null, list);
    }

    public boolean removeRejectedEntityChanges(CollectionKey collectionKey, int n, List list, List list2) {
        MedeSmartClient.debugOut("in removeRejectedEntityChanges().");
        boolean bl = false;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = collectionKey == null ? (CollectionConnection)this.collectionConnections.get(0) : this.getCollectionConnection(collectionKey);
                int n2 = -1;
                long l = -1L;
                if (collectionKey instanceof EntityKey) {
                    n2 = ((EntityKey)collectionKey).getEntityTypeID();
                    l = ((EntityKey)collectionKey).getEntityID();
                } else if (collectionKey instanceof EntityTypeKey) {
                    n2 = ((EntityTypeKey)collectionKey).getEntityTypeID();
                }
                InsightRequest insightRequest = InsightRequest.newRequest(128, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", n2);
                insightRequest.addLongParam("ENTITY_ID", l);
                insightRequest.addIntegerParam("USER_ID", n);
                insightRequest.addObjectParam("CHANGE_CATEGORIES", list);
                insightRequest.addObjectParam("CHANGE_IDS", list2);
                insightRequest.addIntegerParam("EDITOR_ID", collectionConnection.tci.getUserID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    bl = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in removeRejectedEntityChanges():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl;
    }

    public CriterionValue[] getEntityUniqueList(int n, Field field, int n2, ResultsControllerInterface resultsControllerInterface, ResultsProgressListener resultsProgressListener) {
        return this.getEntityUniqueList(n, field, 0, null, n2, resultsControllerInterface, resultsProgressListener);
    }

    public CriterionValue[] getEntityUniqueList(int n, Field field, String string, int n2, ResultsControllerInterface resultsControllerInterface, ResultsProgressListener resultsProgressListener) {
        return this.getEntityUniqueList(n, field, 3, string, n2, resultsControllerInterface, resultsProgressListener);
    }

    public CriterionValue[] getEntityUniqueList(int n, Field field, int n2, String string, int n3, ResultsControllerInterface resultsControllerInterface, ResultsProgressListener resultsProgressListener) {
        MedeSmartClient.debugOut("in getUniqueList().");
        UniqueListResultCollector uniqueListResultCollector = new UniqueListResultCollector(n2, string, n3, field.fieldType);
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                EntityUniqueListGetter entityUniqueListGetter = new EntityUniqueListGetter(n, field, n2, string, n3, uniqueListResultCollector, resultsProgressListener, collectionConnection, this);
                entityUniqueListGetter.start();
            }
            while (!uniqueListResultCollector.doneCollecting() && this.continueThumbRetrieval) {
                Thread.sleep(200L);
            }
            if (resultsControllerInterface != null) {
                resultsControllerInterface.allResultsGathered();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getUniqueList():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return uniqueListResultCollector.getResults();
    }

    public EntitySearchResult[] getEntitySearchResults(EntitySearchQuery entitySearchQuery, int n, int n2, boolean bl, boolean bl2, ResultsControllerInterface resultsControllerInterface, ResultsProgressListener resultsProgressListener) {
        MedeSmartClient.debugOut("in getEntitySearchResults().");
        EntitySearchResultCollector entitySearchResultCollector = new EntitySearchResultCollector();
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                EntitySearchResultGetter entitySearchResultGetter = new EntitySearchResultGetter(entitySearchQuery, n, n2, bl, bl2, entitySearchResultCollector, resultsProgressListener, collectionConnection, this);
                entitySearchResultGetter.start();
            }
            while (!entitySearchResultCollector.doneCollecting() && this.continueUniqueListRetrieval) {
                Thread.sleep(200L);
            }
            if (resultsControllerInterface != null) {
                resultsControllerInterface.allResultsGathered();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntitySearchResults():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return entitySearchResultCollector.getResults();
    }

    public Vector getAllEntityKeys(EntitySearchQuery entitySearchQuery, boolean bl) {
        Vector<EntityKeyWrapper> vector = new Vector<EntityKeyWrapper>();
        MedeSmartClient.debugOut("================smart client in getAllEntityKeys().");
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(124, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("ENTITY_SEARCH_QUERY", entitySearchQuery);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addBooleanParam("ENTITY_IDS_ONLY_FLAG", bl);
                insightRequest.addStringParam("SESSION_GROUP_NAME", collectionConnection.tci.sessionResults.sessionGroupName);
                insightRequest.addStringParam("SESSION_GROUP_CODE_KEY", collectionConnection.tci.sessionResults.sessionCodeKey);
                insightRequest.addStringParam("CLIENT_LOCAL_IP", this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                MedeSmartClient.debugOut("Waiting for data.");
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    MedeSmartClient.debugOut("Receiving data.", 3);
                    int n = collectionConnection.ois.readInt();
                    MedeSmartClient.debugOut("received " + n + " total records from server");
                    EntityKeyWrapper entityKeyWrapper = null;
                    for (int i = 0; i < n; ++i) {
                        entityKeyWrapper = (EntityKeyWrapper)collectionConnection.ois.readObject();
                        entityKeyWrapper.setCollectionKey(collectionConnection.tci);
                        vector.add(entityKeyWrapper);
                    }
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getAllEntityKeys():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return vector;
    }

    public EquivalenceClass doEntityMerge(EntityEquivalenceQuery entityEquivalenceQuery, int n, Collection collection, Collection collection2) {
        EquivalenceClass equivalenceClass = null;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(176, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("ENTITY_EQUIVALENCE_QUERY", entityEquivalenceQuery);
                insightRequest.addIntegerParam("START", n);
                insightRequest.addObjectParam("ENTITY_CHANGE_LIST", collection);
                insightRequest.addObjectParam("MERGE_CHILD_ENTITIES", collection2);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addIntegerParam("USER_ID", collectionConnection.tci.getUserID());
                insightRequest.addStringParam("SESSION_GROUP_NAME", collectionConnection.tci.sessionResults.sessionGroupName);
                insightRequest.addStringParam("SESSION_GROUP_CODE_KEY", collectionConnection.tci.sessionResults.sessionCodeKey);
                insightRequest.addStringParam("CLIENT_LOCAL_IP", this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                MedeSmartClient.debugOut("Waiting for data.");
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    MedeSmartClient.debugOut("Receiving data.", 3);
                    equivalenceClass = (EquivalenceClass)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in doEntityMerge():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return equivalenceClass;
    }

    public List getEquivalenceSearchResults(int n, int n2, EntityEquivalenceQuery entityEquivalenceQuery) {
        List list = null;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(175, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("ENTITY_EQUIVALENCE_QUERY", entityEquivalenceQuery);
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addStringParam("SESSION_GROUP_NAME", collectionConnection.tci.sessionResults.sessionGroupName);
                insightRequest.addStringParam("SESSION_GROUP_CODE_KEY", collectionConnection.tci.sessionResults.sessionCodeKey);
                insightRequest.addStringParam("CLIENT_LOCAL_IP", this.getLocalAddress());
                insightRequest.addIntegerParam("START", n);
                insightRequest.addIntegerParam("LENGTH", n2);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                MedeSmartClient.debugOut("Waiting for data.");
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    MedeSmartClient.debugOut("Receiving data.", 3);
                    entityEquivalenceQuery.setResultCount(collectionConnection.ois.readInt());
                    entityEquivalenceQuery.setResultOffset(n);
                    list = (List)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEquivalenceSearchResults():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list;
    }

    public EntitySearchResult getEntitySearchResult(EntityKey entityKey, EntitySearchQuery entitySearchQuery) {
        EntitySearchResult entitySearchResult = null;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                if (!(entityKey instanceof EntityKeyWrapper)) {
                    entityKey = new EntityKeyWrapper(entityKey.getEntityTypeID(), entityKey.getEntityID(), entityKey);
                }
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(125, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("ENTITY_KEY", entityKey);
                insightRequest.addObjectParam("ENTITY_SEARCH_QUERY", entitySearchQuery);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addStringParam("SESSION_GROUP_NAME", collectionConnection.tci.sessionResults.sessionGroupName);
                insightRequest.addStringParam("SESSION_GROUP_CODE_KEY", collectionConnection.tci.sessionResults.sessionCodeKey);
                insightRequest.addStringParam("CLIENT_LOCAL_IP", this.getLocalAddress());
                insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                MedeSmartClient.debugOut("Waiting for data.");
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    MedeSmartClient.debugOut("Receiving data.", 3);
                    entitySearchResult = (EntitySearchResult)collectionConnection.ois.readObject();
                    if (entitySearchResult != null) {
                        entitySearchResult.setCollectionKey(collectionConnection.tci);
                    }
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntitySearchResult():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return entitySearchResult;
    }

    public MediaSearchResult[] getMediaSearchResults(MediaSearchQuery mediaSearchQuery, int n, int n2, EntitySearchQuery entitySearchQuery, ResultsControllerInterface resultsControllerInterface, ResultsProgressListener resultsProgressListener) {
        MediaSearchResult[] mediaSearchResultArray;
        block14: {
            MedeSmartClient.debugOut("in getMediaSearchResults().");
            mediaSearchResultArray = new MediaSearchResult[]{};
            try {
                if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                    CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                    if (resultsProgressListener != null) {
                        resultsProgressListener.serverContacted(true);
                    }
                    if (!this.continueThumbRetrieval()) {
                        if (resultsProgressListener != null) {
                            resultsProgressListener.resultLoadFailed();
                        }
                        return new MediaSearchResult[0];
                    }
                    InsightRequest insightRequest = InsightRequest.newRequest(110, collectionConnection.tci, this.getLocalAddress());
                    insightRequest.addObjectParam("MEDIA_SEARCH_QUERY", mediaSearchQuery);
                    insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                    insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                    insightRequest.addIntegerParam("START", n);
                    insightRequest.addIntegerParam("LENGTH", n2);
                    insightRequest.addObjectParam("ENTITY_SEARCH_QUERY", entitySearchQuery);
                    insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                    collectionConnection.oos.writeObject(insightRequest);
                    collectionConnection.oos.flush();
                    MedeSmartClient.debugOut("Waiting for data.");
                    if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                        MedeSmartClient.debugOut("Receiving data.", 3);
                        collectionConnection.totalRecords = collectionConnection.ois.readInt();
                        int n3 = collectionConnection.ois.readInt();
                        if (resultsProgressListener != null) {
                            resultsProgressListener.setResultCounts(collectionConnection.totalRecords, n3);
                        }
                        mediaSearchResultArray = new MediaSearchResult[n3];
                        MediaSearchResult mediaSearchResult = null;
                        for (int i = 0; i < n3; ++i) {
                            if (!this.continueThumbRetrieval()) {
                                if (resultsProgressListener != null) {
                                    resultsProgressListener.resultLoadFailed();
                                }
                                return new MediaSearchResult[0];
                            }
                            if (resultsProgressListener != null) {
                                resultsProgressListener.setResultProgress(i);
                            }
                            mediaSearchResult = (MediaSearchResult)collectionConnection.ois.readObject();
                            mediaSearchResult.setCollectionKey(collectionConnection.tci);
                            mediaSearchResultArray[i] = mediaSearchResult;
                        }
                    }
                }
                if (resultsControllerInterface != null) {
                    resultsControllerInterface.allResultsGathered();
                }
            }
            catch (Exception exception) {
                MedeSmartClient.debugOut("Exception in getMediaSearchResults():\n" + InsightUtilities.getStackTrace(exception), 2);
                if (resultsProgressListener == null) break block14;
                resultsProgressListener.serverContacted(false);
                resultsProgressListener.resultLoadFailed();
            }
        }
        if (resultsProgressListener != null) {
            resultsProgressListener.resultLoadComplete();
        }
        return mediaSearchResultArray;
    }

    public boolean isValueInValueList(EntityTypeKey entityTypeKey, int n, String string) {
        MedeSmartClient.debugOut("in isValueInValueList().");
        boolean bl = false;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entityTypeKey);
                InsightRequest insightRequest = InsightRequest.newRequest(112, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", entityTypeKey.getEntityTypeID());
                insightRequest.addIntegerParam("FIELD_ID", n);
                insightRequest.addStringParam("VALUE", string);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    bl = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in isValueInValueList():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl;
    }

    public List getEntityTypeFields(int n) {
        MedeSmartClient.debugOut("in getEntityTypeFields().");
        List list = new Vector();
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.firstElement();
                InsightRequest insightRequest = InsightRequest.newRequest(114, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", n);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    list = (List)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getEntityTypeFields():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list;
    }

    public List getKeysOfDuplicateEntities(Entity entity) {
        MedeSmartClient.debugOut("in getKeysOfDuplicateEntities().");
        List list = new Vector(0);
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entity);
                InsightRequest insightRequest = InsightRequest.newRequest(129, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("ENTITY", entity);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    list = (List)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getKeysOfDuplicateEntities():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return list;
    }

    public int getReferencedEntityCount(Entity entity) {
        MedeSmartClient.debugOut("in getReferencedEntityCount().");
        int n = 0;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getCollectionConnection(entity);
                InsightRequest insightRequest = InsightRequest.newRequest(130, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", entity.getEntityTypeID());
                insightRequest.addLongParam("ENTITY_ID", entity.getEntityID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    n = collectionConnection.ois.readInt();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getReferencedEntityCount():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return n;
    }

    public boolean saveImportedMediaFiles(TrinityCollectionInfo trinityCollectionInfo, List list, long l, int n) {
        MedeSmartClient.debugOut("in saveImportedMediaFiles()");
        long l2 = -1L;
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(trinityCollectionInfo);
            InsightRequest insightRequest = InsightRequest.newRequest(150, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("MEDIA_FILE_LIST", list);
            insightRequest.addStringParam("VCID", trinityCollectionInfo.getVCID());
            insightRequest.addStringParam("INITIAL_GROUP_OPEN", trinityCollectionInfo.getInitialGroupOpen());
            insightRequest.addIntegerParam("LPS_ID", n);
            insightRequest.addLongParam("MEDIA_ID", l);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            MedeSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
                l2 = collectionConnection.ois.readLong();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in saveImportedMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public int getLpsID(TrinityCollectionInfo trinityCollectionInfo, String string, boolean bl) {
        MedeSmartClient.debugOut("in getLpsID()");
        int n = -1;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(trinityCollectionInfo);
            InsightRequest insightRequest = InsightRequest.newRequest(151, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("LPS_PATH", string);
            insightRequest.addObjectParam("COLLECTION_INFO", trinityCollectionInfo);
            insightRequest.addBooleanParam("ADD_IF_NEEDED_FLAG", bl);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            MedeSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                n = collectionConnection.ois.readInt();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in saveImportedMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
        return n;
    }

    public List getSpsRecords(TrinityCollectionInfo trinityCollectionInfo) {
        MedeSmartClient.debugOut("in getSpsRecords()");
        List list = new Vector();
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(trinityCollectionInfo);
            InsightRequest insightRequest = InsightRequest.newRequest(152, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            MedeSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                list = (List)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getSpsRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public int addNewSpsRecords(TrinityCollectionInfo trinityCollectionInfo, List list) {
        MedeSmartClient.debugOut("in addNewSpsRecords()");
        int n = -1;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(trinityCollectionInfo);
            InsightRequest insightRequest = InsightRequest.newRequest(153, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("SPS_RECORDS", list);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            MedeSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                n = collectionConnection.ois.readInt();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in addNewSpsRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        return n;
    }

    public boolean isCatalogTemplateNameUnique(String string) {
        MedeSmartClient.debugOut("in isCatalogTemplateNameUnique");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(158, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("CATALOG_TEMPLATE_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in isCatalogTemplateNameUnique:\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public Set getCatalogTemplates() {
        MedeSmartClient.debugOut("in getCatalogTemplates()");
        Set set = null;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(157, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                set = (Set)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getCatalogTemplates:\n" + InsightUtilities.getStackTrace(exception));
        }
        return set;
    }

    public Set getStandardNames() {
        MedeSmartClient.debugOut("in getCatalogTemplates()");
        Set set = null;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(178, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                set = (Set)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getCatalogTemplates:\n" + InsightUtilities.getStackTrace(exception));
        }
        return set;
    }

    public List getDependentCollections(BaseTemplate baseTemplate) {
        MedeSmartClient.debugOut("in getDependentCollections()");
        List list = new Vector();
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(183, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("CATALOG_TEMPLATE_ID", baseTemplate.getTemplateID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                list = (List)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getDependentCollections:\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public boolean deleteCatalogTemplate(BaseTemplate baseTemplate) {
        MedeSmartClient.debugOut("in deleteCatalogTemplate().");
        boolean bl = false;
        try {
            if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
                CollectionConnection collectionConnection = this.getFirstCollectionConnection();
                InsightRequest insightRequest = InsightRequest.newRequest(184, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("CATALOG_TEMPLATE", baseTemplate);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    MedeSmartClient.debugOut("Receiving data.");
                    bl = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in deleteCatalogTemplate():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl;
    }

    public BaseTemplate saveCatalogTemplate(BaseTemplate baseTemplate) {
        MedeSmartClient.debugOut("in saveCatalogTemplate");
        BaseTemplate baseTemplate2 = null;
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(156, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("CATALOG_TEMPLATE", baseTemplate);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            MedeSmartClient.debugOut("Waiting for data.");
            if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
                baseTemplate2 = (BaseTemplate)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in saveCatalogTemplate:\n" + InsightUtilities.getStackTrace(exception));
        }
        if (bl) {
            return baseTemplate2;
        }
        return null;
    }

    public BaseTemplate updateCatalogTemplate(BaseTemplate baseTemplate, BaseTemplate baseTemplate2) {
        MedeSmartClient.debugOut("in updateCatalogTemplate");
        BaseTemplate baseTemplate3 = null;
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(185, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("CATALOG_TEMPLATE", baseTemplate);
            insightRequest.addObjectParam("CATALOG_TEMPLATE_ORIG", baseTemplate2);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            MedeSmartClient.debugOut("Waiting for data.");
            if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
                baseTemplate3 = (BaseTemplate)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in updateCatalogTemplate:\n" + InsightUtilities.getStackTrace(exception));
        }
        if (bl) {
            return baseTemplate3;
        }
        return null;
    }

    public CollectionBuildingTemplate getCollectionBuildingTemplate() {
        CollectionBuildingTemplate collectionBuildingTemplate = null;
        try {
            MedeSmartClient.debugOut("in getCollectionBuildingTemplate().");
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(154, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            MedeSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                collectionBuildingTemplate = (CollectionBuildingTemplate)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in getCollectionBuildingTemplate():\n" + InsightUtilities.getStackTrace(exception));
        }
        return collectionBuildingTemplate;
    }

    public boolean createVirtualCollection(CollectionBuildingObject collectionBuildingObject, String string, String string2) {
        boolean bl = false;
        try {
            MedeSmartClient.debugOut("in createVirtualCollection().");
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionBuildingObject);
            InsightRequest insightRequest = InsightRequest.newRequest(182, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("PERSONAL_COLLECTION", collectionBuildingObject);
            insightRequest.addStringParam("COLLECTION_NAME", string);
            insightRequest.addStringParam("VCID", string2);
            collectionBuildingObject.moveToTransient();
            collectionConnection.oos.writeObject(insightRequest);
            collectionBuildingObject.restoreFromTransient();
            if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in createVirtualCollection():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean saveCollectionBuildingObject(CollectionBuildingObject collectionBuildingObject) {
        boolean bl = false;
        try {
            MedeSmartClient.debugOut("in saveCollectionBuildingObject().");
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionBuildingObject);
            InsightRequest insightRequest = InsightRequest.newRequest(137, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("PERSONAL_COLLECTION", collectionBuildingObject);
            collectionBuildingObject.moveToTransient();
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            collectionBuildingObject.restoreFromTransient();
            MedeSmartClient.debugOut("Waiting for data.");
            if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                MedeSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
                String string = (String)collectionConnection.ois.readObject();
                collectionBuildingObject.setCollectionID(Integer.parseInt(string));
                Integer n = (Integer)collectionConnection.ois.readObject();
                collectionBuildingObject.setUniqueCollectionID(n);
                if (!collectionBuildingObject.isPersonalCollection()) {
                    collectionBuildingObject.setCollectionUserGroupName((String)collectionConnection.ois.readObject());
                    collectionBuildingObject.setCollectionUserGroupCodeKey((String)collectionConnection.ois.readObject());
                    if (collectionBuildingObject.getCollectionType().equals(CollectionBuildingObject.VIRTUAL_TYPE)) {
                        collectionBuildingObject.setVCID((String)collectionConnection.ois.readObject());
                    }
                }
            }
        }
        catch (Exception exception) {
            MedeSmartClient.debugOut("Exception in savePersonalCollection():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public Long getEntityCount(TrinityCollectionInfo trinityCollectionInfo, int n) {
        Long l = null;
        CollectionConnection collectionConnection = this.getCollectionConnection(trinityCollectionInfo);
        if (collectionConnection != null) {
            try {
                InsightRequest insightRequest = InsightRequest.newRequest(186, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", n);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                MedeSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(1, collectionConnection) > 0) {
                    MedeSmartClient.debugOut("Receiving data.");
                    l = new Long(collectionConnection.ois.readLong());
                }
            }
            catch (Exception exception) {
                MedeSmartClient.debugOut("Exception in getEntityCount():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return l == null || l.equals(new Long(-1L)) ? null : l;
    }
}

