/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.EntityField;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityType;
import com.luna.insight.server.inscribe.EquivalenceClass;
import com.luna.insight.server.inscribe.EquivalenceCriterion;
import com.luna.insight.server.inscribe.EquivalenceEntityKeyWrapper;
import com.luna.insight.server.inscribe.FieldEquivalenceCriterion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class EquivalenceRule
implements Serializable,
Comparator {
    static final long serialVersionUID = 792217139672321399L;
    public static final int SORT_UNSORTED = 0;
    public static final int SORT_PARENT_ENTITIES_DESC = 1;
    protected List criteria = new ArrayList();
    protected int sortType;
    protected EntityType entityType;
    protected int countThreshold;
    private long idCounter = 0L;

    public EquivalenceRule(EntityType entityType, int n, int n2) {
        this.entityType = entityType;
        this.countThreshold = n;
        this.sortType = n2;
    }

    public EquivalenceRule(EntityType entityType) {
        this(entityType, 2, 1);
    }

    public int compare(Object object, Object object2) {
        if (this.sortType == 1) {
            int n;
            int n2 = ((Entity)object).getParentEntityCount();
            if (n2 == (n = ((Entity)object2).getParentEntityCount())) {
                return 0;
            }
            return n2 < n ? -1 : 1;
        }
        return 0;
    }

    public int getSortType() {
        return this.sortType;
    }

    public void setSortType(int n) {
        this.sortType = n;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public int getCountThreshold() {
        return this.countThreshold;
    }

    public List getCriteria() {
        return Collections.unmodifiableList(this.criteria);
    }

    public void addCriterion(EquivalenceCriterion equivalenceCriterion) throws IllegalArgumentException {
        if (equivalenceCriterion.getEntityType() == null || equivalenceCriterion.getEntityType().getTypeID() != this.entityType.getTypeID()) {
            throw new IllegalArgumentException("Missing or mismatched EntityType in argument.");
        }
        this.criteria.add(equivalenceCriterion);
    }

    public boolean areEntitiesEquivalent(EntityKey entityKey, EntityKey entityKey2) {
        if (entityKey.getEntityTypeID() != entityKey2.getEntityTypeID()) {
            return false;
        }
        if (entityKey instanceof Entity) {
            Iterator iterator = this.criteria.iterator();
            while (iterator.hasNext()) {
                if (((EquivalenceCriterion)iterator.next()).areEntitiesEquivalent((Entity)entityKey, (Entity)entityKey2)) continue;
                return false;
            }
        }
        return true;
    }

    protected synchronized long getNextID() {
        return ++this.idCounter;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this.criteria.size() == ((EquivalenceRule)object).criteria.size()) {
            for (int i = 0; bl && i < this.criteria.size(); ++i) {
                if (this.criteria.get(i).equals(((EquivalenceRule)object).criteria.get(i))) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public int sortClasses(EquivalenceClass equivalenceClass, EquivalenceClass equivalenceClass2) {
        int n = 0;
        Iterator iterator = this.criteria.iterator();
        while (iterator.hasNext()) {
            String string;
            EquivalenceCriterion equivalenceCriterion = (EquivalenceCriterion)iterator.next();
            if (!(equivalenceCriterion instanceof FieldEquivalenceCriterion)) continue;
            EntityField entityField = ((FieldEquivalenceCriterion)equivalenceCriterion).getCriterionField();
            String string2 = equivalenceClass.hasAllEntities() ? ((Entity)equivalenceClass.getElements().get(0)).getFieldValue(entityField.getFieldID()).getValue() : equivalenceClass.getWrapperElements().values().toArray(new EquivalenceEntityKeyWrapper[0])[0].getValue();
            n = string2.compareTo(string = equivalenceClass2.hasAllEntities() ? ((Entity)equivalenceClass2.getElements().get(0)).getFieldValue(entityField.getFieldID()).getValue() : equivalenceClass2.getWrapperElements().values().toArray(new EquivalenceEntityKeyWrapper[0])[0].getValue());
            if (0 == n) continue;
            break;
        }
        return n;
    }
}

