/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.catalog.iface.IEntityType;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.indexer.TrinityTable;
import com.luna.insight.server.inscribe.EntityField;
import com.luna.insight.server.inscribe.EntityTypeKey;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class EntityType
implements Serializable,
EntityTypeKey {
    static final long serialVersionUID = -463591820411264537L;
    protected int entityTypeID;
    protected String institutionID = "";
    protected String collectionID = "";
    protected String vcID = "";
    protected String name;
    protected String displayName;
    protected int displayOrder = -1;
    protected String entityIDColumnName;
    protected int entityTableID;
    protected transient TrinityTable entityTable;
    private List relEntityTypes = new Vector(1);
    private List entityFields = new Vector(1);
    protected int restrictionLevel = -1;
    protected boolean isVocabulary = false;
    protected boolean isDependent = false;
    protected boolean isDupeCheckEnabled = false;
    protected boolean isRefCheckEnabled = false;
    protected boolean primaryType = false;

    public static void debugOut(String string) {
        EntityType.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("EntityType: " + string, n);
    }

    public static EntityType convertCatalogTemplateEntityType(CollectionKey collectionKey, IEntityType iEntityType) {
        EntityType entityType = new EntityType(iEntityType.getID(), iEntityType.getName(), iEntityType.getDisplayName(), iEntityType.getDisplayOrder(), iEntityType.getTableID(), iEntityType.getEntityIDColumnName(), iEntityType.getRestrictionLevel(), iEntityType.isVocabulary(), iEntityType.isDependent(), iEntityType.isDupeCheckEnabled(), iEntityType.isRefCheckEnabled());
        entityType.setCollectionKey(collectionKey);
        entityType.setPrimaryType(iEntityType.isPrimaryType());
        Iterator iterator = iEntityType.getRelatedEntityTypes().iterator();
        while (iterator.hasNext()) {
            entityType.addRelatedEntityType(EntityType.convertCatalogTemplateEntityType(collectionKey, (IEntityType)iterator.next()));
        }
        iterator = iEntityType.getEntityFields().iterator();
        while (iterator.hasNext()) {
            entityType.addEntityField(EntityField.convertCatalogTemplateEntityField(entityType, (IEntityField)iterator.next()));
        }
        return entityType;
    }

    public static String displayEntityType(EntityType entityType) {
        StringBuffer stringBuffer = new StringBuffer();
        EntityType.displayEntityType(entityType, stringBuffer, 0);
        return stringBuffer.toString();
    }

    public static void displayEntityType(EntityType entityType, StringBuffer stringBuffer, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        stringBuffer.append("\n" + string + entityType.toString());
        string = string + "\t";
        List list = entityType.getEntityFields();
        for (int i = 0; list != null && i < list.size(); ++i) {
            EntityField entityField = (EntityField)list.get(i);
            stringBuffer.append("\n" + string + entityField.getFieldID() + "-" + entityField.getField().fieldDisplayName);
        }
        List list2 = entityType.getRelatedEntityTypes();
        for (int i = 0; list2 != null && i < list2.size(); ++i) {
            EntityType entityType2 = (EntityType)list2.get(i);
            EntityType.displayEntityType(entityType2, stringBuffer, n + 1);
        }
    }

    public EntityType(int n, String string, String string2, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(n, string, string2, n2, -1, "", n3, bl, bl2, bl3, bl4);
    }

    public EntityType(int n, String string, String string2, int n2, int n3, String string3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.entityTypeID = n;
        this.name = string;
        this.displayName = string2;
        this.displayOrder = n2;
        this.entityTableID = n3;
        this.entityIDColumnName = string3;
        this.restrictionLevel = n4;
        this.isVocabulary = bl;
        this.isDependent = bl2;
        this.isDupeCheckEnabled = bl3;
        this.isRefCheckEnabled = bl4;
    }

    public void setTable(TrinityTable trinityTable) {
        this.entityTable = trinityTable;
    }

    public void setPrimaryType(boolean bl) {
        this.primaryType = bl;
    }

    public EntityType addRelatedEntityType(EntityType entityType) {
        if (entityType != null && !this.relEntityTypes.contains(entityType)) {
            this.relEntityTypes.add(entityType);
        }
        return entityType;
    }

    public EntityField addEntityField(EntityField entityField) {
        if (entityField != null && !this.entityFields.contains(entityField)) {
            this.entityFields.add(entityField);
        }
        return entityField;
    }

    public int getTypeID() {
        return this.entityTypeID;
    }

    public int getRestrictionLevel() {
        return this.restrictionLevel;
    }

    public boolean isVocabulary() {
        return this.isVocabulary;
    }

    public boolean isDependent() {
        return this.isDependent;
    }

    public boolean isDupeCheckEnabled() {
        return this.isDupeCheckEnabled;
    }

    public boolean isRefCheckEnabled() {
        return this.isRefCheckEnabled;
    }

    public int getTableID() {
        return this.entityTableID;
    }

    public boolean isPrimaryType() {
        return this.primaryType;
    }

    public TrinityTable getTable() {
        return this.entityTable;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public String getEntityIDColumnName() {
        return this.entityIDColumnName;
    }

    public List getRelatedEntityTypes() {
        return this.relEntityTypes;
    }

    public List getRelatedEntityTypesCopy() {
        if (this.relEntityTypes != null) {
            return new Vector(this.relEntityTypes);
        }
        return null;
    }

    public List getEntityFields() {
        return this.entityFields;
    }

    public List getEntityFieldsCopy() {
        if (this.entityFields != null) {
            return new Vector(this.entityFields);
        }
        return null;
    }

    public EntityField getEntityField(int n) {
        for (int i = 0; this.entityFields != null && i < this.entityFields.size(); ++i) {
            EntityField entityField = (EntityField)this.entityFields.get(i);
            if (entityField == null || entityField.getFieldID() != n) continue;
            return entityField;
        }
        return null;
    }

    public EntityField getEntityField(String string) {
        for (int i = 0; string != null && this.entityFields != null && i < this.entityFields.size(); ++i) {
            EntityField entityField = (EntityField)this.entityFields.get(i);
            if (entityField == null || entityField.getField() == null || entityField.getField().fieldName == null || !entityField.getField().fieldName.equalsIgnoreCase(string)) continue;
            return entityField;
        }
        return null;
    }

    public Field getField(String string) {
        EntityField entityField = this.getEntityField(string);
        if (entityField != null) {
            return entityField.getField();
        }
        return null;
    }

    public List getEntityFieldsDeep() {
        Vector vector = new Vector();
        this.getEntityFieldsDeep(vector);
        return vector;
    }

    public void getEntityFieldsDeep(List list) {
        if (list != null && this.entityFields != null) {
            list.addAll(this.entityFields);
        }
        for (int i = 0; this.relEntityTypes != null && i < this.relEntityTypes.size(); ++i) {
            ((EntityType)this.relEntityTypes.get(i)).getEntityFieldsDeep(list);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof EntityType) {
            EntityType entityType = (EntityType)object;
            return this.getTypeID() == entityType.getTypeID();
        }
        return this == object;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int getEntityTypeID() {
        return this.entityTypeID;
    }

    public String getEntityTypeKeyString() {
        return this.toKeyString() + "-[ETID:" + this.getEntityTypeID() + "]";
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public void setCollectionKey(CollectionKey collectionKey) {
        if (collectionKey != null) {
            this.institutionID = collectionKey.getInstitutionID();
            this.collectionID = collectionKey.getCollectionID();
            this.vcID = collectionKey.getVCID();
        }
    }
}

