/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityKeyComparer;
import com.luna.insight.server.inscribe.EntityKeyWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class EntitySearchResult
implements Serializable,
Comparable,
EntityKey {
    static final long serialVersionUID = 8787466317232903755L;
    protected int entityTypeID;
    protected long entityID;
    protected String institutionID = "";
    protected String collectionID = "";
    protected String vcID = "";
    protected String[] captionData = null;
    protected transient String[] sortData = null;
    protected String sortStr = null;
    protected List mediaFiles = new Vector(0);

    public static void debugOut(String string) {
        EntitySearchResult.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("EntitySearchResult: " + string, n);
    }

    public EntitySearchResult(int n, long l) {
        this.entityTypeID = n;
        this.entityID = l;
    }

    public ImageFile addThumbnailFile(ImageFile imageFile) {
        if (imageFile != null && !this.mediaFiles.contains(imageFile)) {
            this.mediaFiles.add(imageFile);
        }
        return imageFile;
    }

    public void setCaptionData(String[] stringArray) {
        this.captionData = stringArray;
        if (this.captionData == null) {
            this.captionData = new String[0];
        }
        for (int i = 0; i < this.captionData.length; ++i) {
            if (this.captionData[i] != null) continue;
            this.captionData[i] = "";
        }
    }

    public String setCaption(String string, int n) {
        if (string != null && this.captionData != null && n >= 0 && n < this.captionData.length) {
            this.captionData[n] = string;
        }
        return string;
    }

    public void setSortData(String[] stringArray) {
        this.sortData = stringArray;
        if (this.sortData == null) {
            this.sortData = new String[0];
        }
        for (int i = 0; i < this.sortData.length; ++i) {
            if (this.sortData[i] != null) continue;
            this.sortData[i] = "";
        }
    }

    public String setSort(String string, int n) {
        if (string != null && this.sortData != null && n >= 0 && n < this.sortData.length) {
            this.sortData[n] = string;
        }
        return string;
    }

    public String[] getCaptionData() {
        return this.captionData;
    }

    public String[] getSortData() {
        return this.sortData;
    }

    public String getSortString() {
        if (this.sortStr == null || this.sortStr.length() == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; this.sortData != null && i < this.sortData.length; ++i) {
                stringBuffer.append(TrinityConnector.convertSortValue(this.sortData[i]));
            }
            this.sortStr = stringBuffer.toString();
        }
        return this.sortStr;
    }

    public List getThumbnailFiles() {
        return this.getMediaFiles();
    }

    public List getMediaFiles() {
        return this.mediaFiles;
    }

    public boolean equals(Object object) {
        if (object instanceof EntityKey) {
            return EntityKeyComparer.keysAgree(this, (EntityKey)object);
        }
        return super.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ETID: " + this.getEntityTypeID() + ", EID: " + this.getEntityID() + "]");
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        return this.getSortString().compareToIgnoreCase(((EntitySearchResult)object).getSortString());
    }

    public int getEntityTypeID() {
        return this.entityTypeID;
    }

    public long getEntityID() {
        return this.entityID;
    }

    public String getEntityKeyString() {
        return EntityKeyWrapper.getEntityKeyString(this);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public void setCollectionKey(CollectionKey collectionKey) {
        if (collectionKey != null) {
            this.institutionID = collectionKey.getInstitutionID();
            this.collectionID = collectionKey.getCollectionID();
            this.vcID = collectionKey.getVCID();
        }
    }
}

