/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityKeyComparer;
import java.io.Serializable;

public class EntityKeyWrapper
implements EntityKey,
Serializable {
    static final long serialVersionUID = -728998360319806715L;
    protected int entityTypeID;
    protected long entityID;
    protected String institutionID = "";
    protected String collectionID = "";
    protected String vcID = "";
    protected boolean ignoreCollectionKey = false;

    public static String getEntityKeyString(EntityKey entityKey) {
        if (entityKey == null) {
            return "[null]";
        }
        return "[EID:" + entityKey.getEntityID() + ", ETID:" + entityKey.getEntityTypeID() + "]-" + entityKey.toKeyString();
    }

    public EntityKeyWrapper(int n, long l) {
        this(n, l, null);
    }

    public EntityKeyWrapper(int n, long l, CollectionKey collectionKey) {
        this.entityTypeID = n;
        this.entityID = l;
        if (collectionKey != null) {
            this.institutionID = collectionKey.getInstitutionID();
            this.collectionID = collectionKey.getCollectionID();
            this.vcID = collectionKey.getVCID();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof EntityKey) {
            return EntityKeyComparer.keysAgree(this, (EntityKey)object, this.ignoreCollectionKey);
        }
        return super.equals(object);
    }

    public int getEntityTypeID() {
        return this.entityTypeID;
    }

    public long getEntityID() {
        return this.entityID;
    }

    public String getEntityKeyString() {
        return EntityKeyWrapper.getEntityKeyString(this);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public void setCollectionKey(CollectionKey collectionKey) {
        this.institutionID = collectionKey.getInstitutionID();
        this.collectionID = collectionKey.getCollectionID();
        this.vcID = collectionKey.getVCID();
    }

    public void setIgnoreCollectionKey(boolean bl) {
        this.ignoreCollectionKey = bl;
    }
}

