/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.util.IntegerRange;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.indexer.TrinityIndexerField;
import com.luna.insight.server.indexer.TrinityJoin;
import com.luna.insight.server.indexer.TrinityTable;
import com.luna.insight.server.inscribe.EntityType;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EntityField
implements Serializable {
    static final long serialVersionUID = 1505028925343967699L;
    protected int entityTypeID;
    protected EntityType entityType;
    protected int fieldID;
    protected Field field;
    protected transient TrinityIndexerField trinityField;
    protected int joinID;
    protected transient TrinityJoin join;
    protected int fieldTableID;
    protected transient TrinityTable fieldTable;
    protected transient String fieldValueColumnName;
    protected transient String prefValueColumnName;
    protected transient String srcHierarchyIDColumnName;
    protected transient String srcHierarchyNodeIDColumnName;
    protected boolean isReadOnly = false;
    protected int restrictionLevel = -1;
    protected boolean isRequired = false;
    protected IntegerRange intRange = null;
    protected boolean valueListAllowed = false;
    protected int minApprovalToAddValue = 0;
    protected boolean repeatedValuesAllowed = false;
    protected boolean alwaysValidateNewValue = false;
    protected boolean displayInRelatedEntities = false;
    protected int maxValueLength = -1;
    public String groupingFieldName = null;
    public TrinityTable groupingTable = null;

    public static void debugOut(String string) {
        EntityField.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("EntityField: " + string, n);
    }

    public static EntityField convertCatalogTemplateEntityField(EntityType entityType, IEntityField iEntityField) {
        EntityField entityField = new EntityField(iEntityField.getParentEntityType().getID(), iEntityField.getID());
        entityField.setEntityType(entityType);
        entityField.setField(new Field(iEntityField.getID(), iEntityField.getName(), iEntityField.getFieldType()));
        entityField.getField().setFieldID(iEntityField.getID());
        return entityField;
    }

    public static void sortEntityFields(List list) {
        if (InsightUtilities.isNonEmpty(list)) {
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    EntityField entityField = (EntityField)object;
                    EntityField entityField2 = (EntityField)object2;
                    if (entityField.getDisplayOrder() == entityField2.getDisplayOrder()) {
                        return InsightUtilities.compareStrings(entityField.getDisplayName(), entityField2.getDisplayName());
                    }
                    return entityField.getDisplayOrder() - entityField2.getDisplayOrder();
                }
            };
            Collections.sort(list, comparator);
        }
    }

    public EntityField(int n, int n2) {
        this(n, n2, -1, -1, "", "", "", "");
    }

    public EntityField(int n, int n2, int n3, int n4, String string, String string2, String string3, String string4) {
        this.entityTypeID = n;
        this.fieldID = n2;
        this.joinID = n3;
        this.fieldTableID = n4;
        this.fieldValueColumnName = string;
        this.prefValueColumnName = string2;
        this.srcHierarchyIDColumnName = string3;
        this.srcHierarchyNodeIDColumnName = string4;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setTrinityField(TrinityIndexerField trinityIndexerField) {
        this.trinityField = trinityIndexerField;
    }

    public void setJoin(TrinityJoin trinityJoin) {
        this.join = trinityJoin;
    }

    public void setFieldTable(TrinityTable trinityTable) {
        this.fieldTable = trinityTable;
    }

    public void setRestrictionLevel(int n) {
        this.restrictionLevel = n;
    }

    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public void setRequired(boolean bl) {
        this.isRequired = bl;
    }

    public void setIntegerRange(IntegerRange integerRange) {
        this.intRange = integerRange;
    }

    public void setValueListAllowed(boolean bl) {
        this.valueListAllowed = bl;
    }

    public void setMinApprovalToAddValue(int n) {
        this.minApprovalToAddValue = n;
    }

    public void setRepeatedValuesAllowed(boolean bl) {
        this.repeatedValuesAllowed = bl;
    }

    public void setDisplayInRelatedEntities(boolean bl) {
        this.displayInRelatedEntities = bl;
    }

    public void setAlwaysValidateNewValue(boolean bl) {
        this.alwaysValidateNewValue = bl;
    }

    public void setMaxValueLength(int n) {
        this.maxValueLength = n;
    }

    public int getEntityTypeID() {
        return this.entityTypeID;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public int getFieldID() {
        return this.fieldID;
    }

    public Field getField() {
        return this.field;
    }

    public TrinityIndexerField getTrinityField() {
        return this.trinityField;
    }

    public int getJoinID() {
        return this.joinID;
    }

    public TrinityJoin getJoin() {
        return this.join;
    }

    public int getFieldTableID() {
        return this.fieldTableID;
    }

    public TrinityTable getFieldTable() {
        return this.fieldTable;
    }

    public String getFieldValueColumnName() {
        return this.fieldValueColumnName;
    }

    public String getPrefValueColumnName() {
        return this.prefValueColumnName;
    }

    public String getSrcHierarchyIDColumnName() {
        return this.srcHierarchyIDColumnName;
    }

    public String getSrcHierarchyNodeIDColumnName() {
        return this.srcHierarchyNodeIDColumnName;
    }

    public int getRestrictionLevel() {
        return this.restrictionLevel;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public IntegerRange getIntegerRange() {
        return this.intRange;
    }

    public boolean isValueListAllowed() {
        return this.valueListAllowed;
    }

    public int getMinApprovalToAddValue() {
        return this.minApprovalToAddValue;
    }

    public boolean areRepeatedValuesAllowed() {
        return this.repeatedValuesAllowed;
    }

    public boolean isAlwaysValidateNewValue() {
        return this.alwaysValidateNewValue;
    }

    public boolean isDisplayInRelatedEntities() {
        return this.displayInRelatedEntities;
    }

    public int getMaxValueLength() {
        return this.maxValueLength;
    }

    public String getGroupingFieldName() {
        return this.groupingFieldName;
    }

    public TrinityTable getGroupingTable() {
        return this.groupingTable;
    }

    public void setGroupingFieldName(String string) {
        this.groupingFieldName = string;
    }

    public void setGroupingTable(TrinityTable trinityTable) {
        this.groupingTable = trinityTable;
    }

    public int getDisplayOrder() {
        if (this.getField() != null) {
            return this.getField().getFieldDisplayOrder();
        }
        return 0;
    }

    public String getDisplayName() {
        if (this.getField() != null && this.getField().fieldDisplayName != null) {
            return this.getField().fieldDisplayName;
        }
        return "";
    }

    public boolean isIntegerInRange(int n) {
        if (this.intRange == null) {
            return true;
        }
        return this.intRange.isWithinRange(n);
    }

    public boolean isLongInRange(long l) {
        if (this.intRange == null) {
            return true;
        }
        return this.intRange.isWithinRange((int)l);
    }

    public boolean equals(Object object) {
        if (object instanceof EntityField) {
            EntityField entityField = (EntityField)object;
            return this.getEntityTypeID() == entityField.getEntityTypeID() && this.getFieldID() == entityField.getFieldID();
        }
        return false;
    }

    public String toString() {
        return this.getField().toString();
    }
}

