/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.inscribe.EquivalenceClass;
import com.luna.insight.server.inscribe.EquivalenceRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EntityEquivalenceQuery
implements Serializable {
    static final long serialVersionUID = -4176058787064555380L;
    public static final int PAGING_SORT_BY_CLASS_SIZE = 0;
    public static final int PAGING_SORT_BY_CLASS_SIZE_DESC = 1;
    public static final int PAGING_SORT_BY_RULE = 2;
    protected int pagingSortType = 2;
    protected EquivalenceRule rule;
    protected List results;
    protected int resultCount;
    protected int resultOffset;
    private boolean needResultSort = false;

    public EntityEquivalenceQuery(EquivalenceRule equivalenceRule) {
        this.rule = equivalenceRule;
    }

    public int getPagingSortType() {
        return this.pagingSortType;
    }

    public EquivalenceRule getRule() {
        return this.rule;
    }

    public List getResults() {
        this.sortResults(this.pagingSortType);
        return this.results;
    }

    public EquivalenceClass getResult(int n) {
        return this.getResult(n, this.pagingSortType);
    }

    public EquivalenceClass getResult(int n, int n2) {
        if (this.results == null || n >= this.results.size()) {
            return null;
        }
        this.sortResults(n2);
        return (EquivalenceClass)this.results.get(n);
    }

    public List getResults(int n, int n2) {
        return this.getResults(n, n2, this.pagingSortType);
    }

    public List getResults(int n, int n2, int n3) {
        if (this.results == null || n >= this.results.size()) {
            return null;
        }
        if (n2 <= 0) {
            n2 = this.results.size();
        }
        this.sortResults(n3);
        ArrayList arrayList = new ArrayList();
        int n4 = Math.min(this.results.size(), n + n2);
        for (int i = n; i < n4; ++i) {
            arrayList.add(this.results.get(i));
        }
        return arrayList;
    }

    public void setResults(List list) {
        this.results = list;
        this.needResultSort = true;
    }

    protected void sortResults(int n) {
        if (this.needResultSort || this.pagingSortType != n) {
            if (this.results != null) {
                if (n == 0) {
                    Collections.sort(this.results, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return new Integer(((EquivalenceClass)object).getSize()).compareTo(new Integer(((EquivalenceClass)object2).getSize()));
                        }
                    });
                    this.pagingSortType = n;
                } else if (n == 1) {
                    Collections.sort(this.results, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return -new Integer(((EquivalenceClass)object).getSize()).compareTo(new Integer(((EquivalenceClass)object2).getSize()));
                        }
                    });
                    this.pagingSortType = n;
                } else if (n == 2) {
                    Collections.sort(this.results, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return EntityEquivalenceQuery.this.rule.sortClasses((EquivalenceClass)object, (EquivalenceClass)object2);
                        }
                    });
                }
            }
            this.needResultSort = false;
        }
    }

    public boolean equals(Object object) {
        return this.rule.equals(((EntityEquivalenceQuery)object).getRule());
    }

    public int getResultCount() {
        return this.resultCount;
    }

    protected void setResultCount(int n) {
        this.resultCount = n;
    }

    public int getResultOffset() {
        return this.resultOffset;
    }

    protected void setResultOffset(int n) {
        this.resultOffset = n;
    }
}

