/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.indexer;

import com.luna.insight.server.hierarchy.ThesaurusRelationType;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TrinityHierarchyNode
implements Serializable,
Comparable {
    static final long serialVersionUID = -8441838162826807378L;
    public int termID = -1;
    public String term;
    public int fieldID = -1;
    public int hierarchyID = -1;
    public int hierarchyIndex = -1;
    public int parentIndex = -1;
    public int start = -1;
    public int end = -1;
    public List objectIDs = new Vector(1);
    public TrinityHierarchyNode parent = null;
    public List children = new Vector(1);
    public Map relationships = new Hashtable();

    public void addChild(TrinityHierarchyNode trinityHierarchyNode) {
        if (trinityHierarchyNode != null && !this.children.contains(trinityHierarchyNode)) {
            this.children.add(trinityHierarchyNode);
        }
    }

    public void addRelation(TrinityHierarchyNode trinityHierarchyNode, ThesaurusRelationType thesaurusRelationType) {
        List list;
        if (trinityHierarchyNode != null && thesaurusRelationType != null && (list = this.getRelatives(thesaurusRelationType, true)) != null && !list.contains(trinityHierarchyNode)) {
            list.add(trinityHierarchyNode);
        }
    }

    public void setHierarchyID(int n) {
        this.hierarchyID = n;
    }

    public void setTermID(int n) {
        this.termID = n;
    }

    public void setTerm(String string) {
        this.term = string;
    }

    public void setParent(TrinityHierarchyNode trinityHierarchyNode) {
        this.parent = trinityHierarchyNode;
    }

    public int getHierarchyID() {
        return this.hierarchyID;
    }

    public int getTermID() {
        return this.termID;
    }

    public String getTerm() {
        return this.term;
    }

    public TrinityHierarchyNode getParent() {
        return this.parent;
    }

    public Iterator getRelationTypes() {
        return this.relationships.keySet().iterator();
    }

    public List getRelatives(ThesaurusRelationType thesaurusRelationType) {
        return this.getRelatives(thesaurusRelationType, false);
    }

    public List getRelatives(ThesaurusRelationType thesaurusRelationType, boolean bl) {
        if (thesaurusRelationType != null) {
            Vector vector = (Vector)this.relationships.get(thesaurusRelationType);
            if (vector == null) {
                vector = new Vector(1);
                this.relationships.put(thesaurusRelationType, vector);
            }
            return vector;
        }
        return null;
    }

    public int setHierarchyNodesIndices(int n, int n2) {
        if (this.hierarchyIndex < 0) {
            this.hierarchyIndex = n + 1;
            this.parentIndex = n2;
            this.start = this.hierarchyIndex;
            this.end = this.hierarchyIndex;
            for (int i = 0; this.children != null && i < this.children.size(); ++i) {
                TrinityHierarchyNode trinityHierarchyNode = (TrinityHierarchyNode)this.children.get(i);
                this.end = trinityHierarchyNode.setHierarchyNodesIndices(this.end, this.hierarchyIndex);
            }
        }
        return this.end;
    }

    public int compareTo(Object object) {
        TrinityHierarchyNode trinityHierarchyNode = (TrinityHierarchyNode)object;
        if (!(this.term != null && this.term.length() != 0 || trinityHierarchyNode.term != null && trinityHierarchyNode.term.length() != 0)) {
            return 0;
        }
        if (this.term == null || this.term.length() == 0) {
            return -1;
        }
        if (trinityHierarchyNode.term == null || trinityHierarchyNode.term.length() == 0) {
            return 1;
        }
        return this.term.trim().compareToIgnoreCase(trinityHierarchyNode.term.trim());
    }
}

