/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.collectionmanagement;

import com.luna.insight.core.catalog.iface.BaseEntityField;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.ITemplate;
import com.luna.insight.server.collectionmanagement.MappingStandard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionBuildingTemplate
implements Serializable {
    static final long serialVersionUID = 1334183120133464377L;
    private Set standardNames;
    private Set catalogTemplates;
    private List mappingStandardsList;
    private Map mappingStandardsLookup;
    private Set mappingStandards;

    public CollectionBuildingTemplate(Set hashSet, List arrayList) {
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.catalogTemplates = hashSet;
        this.mappingStandardsList = Collections.unmodifiableList(arrayList);
        HashSet<MappingStandard> hashSet2 = new HashSet<MappingStandard>();
        this.mappingStandardsLookup = new HashMap();
        Iterator iterator = this.mappingStandardsList.iterator();
        while (iterator.hasNext()) {
            MappingStandard mappingStandard = (MappingStandard)iterator.next();
            this.mappingStandardsLookup.put(mappingStandard.getStandardName(), mappingStandard);
            if (mappingStandard.getStandardType() != 3) continue;
            hashSet2.add(mappingStandard);
        }
        this.mappingStandards = Collections.unmodifiableSet(hashSet2);
        this.standardNames = new HashSet();
    }

    public void addCollectionTemplate(BaseTemplate baseTemplate) {
        this.catalogTemplates.add(baseTemplate);
    }

    public void removeCollectionTemplate(BaseTemplate baseTemplate) {
        Iterator iterator = this.catalogTemplates.iterator();
        while (iterator.hasNext()) {
            BaseTemplate baseTemplate2 = (BaseTemplate)iterator.next();
            if (baseTemplate2.getTemplateID() != baseTemplate.getTemplateID()) continue;
            this.catalogTemplates.remove(baseTemplate2);
            return;
        }
    }

    public List getCatalogTemplateNames(boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.catalogTemplates.iterator();
        while (iterator.hasNext()) {
            ITemplate iTemplate = (ITemplate)iterator.next();
            if (bl && !iTemplate.isPublished() || bl2 && !iTemplate.isPersonalCollectionTemplate()) continue;
            arrayList.add(iTemplate.getTemplateName());
        }
        Collections.sort(arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    public BaseTemplate getCatalogTemplate(String string, boolean bl, boolean bl2) {
        Iterator iterator = this.catalogTemplates.iterator();
        while (iterator.hasNext()) {
            BaseTemplate baseTemplate = (BaseTemplate)iterator.next();
            if (!baseTemplate.getTemplateName().equals(string) || bl && !baseTemplate.isPublished() || bl2 && !baseTemplate.isPersonalCollectionTemplate()) continue;
            return baseTemplate;
        }
        return null;
    }

    public BaseTemplate getCatalogTemplate(int n) {
        Iterator iterator = this.catalogTemplates.iterator();
        while (iterator.hasNext()) {
            BaseTemplate baseTemplate = (BaseTemplate)iterator.next();
            if (baseTemplate.getTemplateID() != n) continue;
            return baseTemplate;
        }
        return null;
    }

    public boolean containsCatalogTemplate(String string) {
        return this.getCatalogTemplate(string, false, false) != null;
    }

    public List getThumbnailOptionFieldNames(String string) {
        return this.getThumbnailOptionFieldNames(this.getCatalogTemplate(string, false, false));
    }

    public List getThumbnailOptionFieldNames(BaseTemplate baseTemplate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (baseTemplate != null) {
            Iterator iterator = baseTemplate.getThumbnailOptionEntityFields().iterator();
            while (iterator.hasNext()) {
                arrayList.add(((BaseEntityField)iterator.next()).getDisplayName());
            }
            Collections.sort(arrayList);
            return arrayList;
        }
        return null;
    }

    public List getSortOptionFieldNames(String string) {
        return this.getSortOptionFieldNames(this.getCatalogTemplate(string, false, false));
    }

    public List getSortOptionFieldNames(BaseTemplate baseTemplate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (baseTemplate != null) {
            Iterator iterator = baseTemplate.getSortOptionEntityFields().iterator();
            while (iterator.hasNext()) {
                arrayList.add(((BaseEntityField)iterator.next()).getDisplayName());
            }
            Collections.sort(arrayList);
            return arrayList;
        }
        return null;
    }

    public List getMappingStandardsList() {
        return this.mappingStandardsList;
    }

    public MappingStandard getMappingStandard(String string) {
        return this.mappingStandardsLookup == null ? null : (MappingStandard)this.mappingStandardsLookup.get(string);
    }

    public List getMappingStandards(List list) {
        ArrayList<MappingStandard> arrayList = new ArrayList<MappingStandard>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = ((MappingStandard)iterator.next()).getStandardName();
                MappingStandard mappingStandard = (MappingStandard)this.mappingStandardsLookup.get(string);
                if (mappingStandard == null) continue;
                arrayList.add(mappingStandard);
            }
        }
        return arrayList;
    }

    public Set getStandardNames() {
        return this.standardNames;
    }

    public void setStandardNames(Set set) {
        this.standardNames = set;
    }

    public void removeStandardFromSet(String string) {
        this.standardNames.remove(string);
    }
}

