/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.collectionmanagement;

import com.luna.insight.core.catalog.iface.BaseEntityField;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.IFieldProfile;
import com.luna.insight.core.insightwizard.InsightWizardException;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.collectionmanagement.CollectionBuildingIOException;
import com.luna.insight.server.collectionmanagement.CollectionBuildingObjectWriter;
import com.luna.insight.server.inscribe.EntityType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CollectionBuildingObject
implements Serializable,
CollectionKey,
CollectionBuildingObjectWriter {
    static final long serialVersionUID = 2144858639492655192L;
    public static final Integer NULL_TYPE = new Integer(0);
    public static final Integer MASTER_TYPE = new Integer(1);
    public static final Integer VIRTUAL_TYPE = new Integer(2);
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String DEFAULT_LANGUAGE_CODE = "en";
    public static final String DEFAULT_COUNTRY_CODE = "US";
    public static final int PC_PRIV_READ = 1;
    public static final int PC_PRIV_WRITE = 2;
    public static final int PC_PRIV_DELETE = 4;
    public static final int PC_PRIV_EDIT = 3;
    private TrinityCollectionInfo tci = null;
    private TrinityCollectionInfo collectionParent = null;
    private boolean modified = false;
    private boolean collectionNameModified = false;
    private boolean fieldStandardModified = false;
    private boolean themeModified = false;
    private boolean collectionDescriptionModified = false;
    private boolean copyrightModified = false;
    private boolean collectionURLModified = false;
    private boolean pcUserGroupEditableModified = false;
    private boolean pcNonUserGroupEditableModified = false;
    private boolean mappingStandardsModified = false;
    private String fieldStandardTemplateName = null;
    private String fieldStandardTemplateDescription = null;
    protected BaseTemplate collectionTemplate = null;
    private List fieldStandardTemplateFieldList = new ArrayList();
    private List thumbnailFields = new ArrayList();
    private List sortFields = new ArrayList();
    private String originalCollectionName = null;
    private EntityType pcEntityType = null;
    private String shortDescription = null;
    private String collectionURL = null;
    private boolean personalCollection = false;
    private String collectionUserGroupName = null;
    private String collectionUserGroupCodeKey = null;
    private String selectedTheme = null;
    private Integer collectionType = MASTER_TYPE;
    private List mappingStandards = null;

    public CollectionBuildingObject() {
    }

    public CollectionBuildingObject(TrinityCollectionInfo trinityCollectionInfo, String string) {
        this.tci = trinityCollectionInfo;
        Integer n = this.collectionType = trinityCollectionInfo.getVCID().equals("NA") ? MASTER_TYPE : VIRTUAL_TYPE;
        if (this.collectionType.equals(VIRTUAL_TYPE)) {
            this.setCollectionParent(trinityCollectionInfo.getParentTci());
        }
        this.fieldStandardTemplateName = string;
        if (trinityCollectionInfo.dataFieldMappings == null) {
            for (int i = 0; i < 4; ++i) {
                this.thumbnailFields.add(null);
                this.sortFields.add(null);
            }
        } else {
            FieldMapping fieldMapping;
            Iterator iterator = trinityCollectionInfo.dataFieldMappings.iterator();
            while (iterator.hasNext()) {
                fieldMapping = (FieldMapping)iterator.next();
                if (fieldMapping.fieldID == -1) {
                    this.thumbnailFields.add(null);
                    continue;
                }
                this.thumbnailFields.add(fieldMapping.fieldDisplayName);
            }
            iterator = trinityCollectionInfo.sortFieldMappings.iterator();
            while (iterator.hasNext()) {
                fieldMapping = (FieldMapping)iterator.next();
                if (fieldMapping.fieldID == -1) {
                    this.sortFields.add(null);
                    continue;
                }
                this.sortFields.add(fieldMapping.fieldDisplayName);
            }
        }
    }

    public void writeCollectionBuildingObject(Object[] objectArray) throws CollectionBuildingIOException {
    }

    public boolean isTemporary() {
        return this.tci.getUniqueCollectionID() == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isCollectionNameModified() {
        return this.collectionNameModified;
    }

    public boolean isThemeModified() {
        return this.themeModified;
    }

    public boolean isCopyrightModified() {
        return this.copyrightModified;
    }

    public boolean isCollectionURLModified() {
        return this.collectionURLModified;
    }

    public boolean isFieldStandardModified() {
        return this.fieldStandardModified;
    }

    public boolean isCollectionDescriptionModified() {
        return this.collectionDescriptionModified;
    }

    public boolean isPCUserGroupEditableModified() {
        return this.pcUserGroupEditableModified;
    }

    public boolean isPCNonUserGroupEditableModified() {
        return this.pcNonUserGroupEditableModified;
    }

    public void setPublished() {
        this.modified = false;
        this.collectionNameModified = false;
        this.fieldStandardModified = false;
        this.themeModified = false;
        this.collectionDescriptionModified = false;
        this.collectionURLModified = false;
        this.copyrightModified = false;
        this.pcUserGroupEditableModified = false;
        this.pcNonUserGroupEditableModified = false;
        this.mappingStandardsModified = false;
    }

    public TrinityCollectionInfo getTCI() {
        return this.tci;
    }

    public void setTCI(TrinityCollectionInfo trinityCollectionInfo) {
        this.tci = trinityCollectionInfo;
    }

    public Integer getUniqueCollectionID() {
        return this.tci.getUniqueCollectionID();
    }

    public void setUniqueCollectionID(Integer n) {
        this.tci.setUniqueCollectionID(n);
    }

    public String getCollectionName() {
        String string = this.tci.getCollectionName();
        return string == null ? "" : string;
    }

    public boolean setCollectionName(String string) {
        if (string != null && !string.equals(this.tci.getCollectionName())) {
            if (!this.collectionNameModified) {
                this.collectionNameModified = true;
                this.originalCollectionName = this.tci.getCollectionName();
                this.fieldStandardModified = true;
            }
            this.tci.setCollectionName(string);
            this.modified = true;
            return true;
        }
        return false;
    }

    public String getInstitutionID() {
        return this.tci.getInstitutionID();
    }

    public boolean setInstitutionID(String string) {
        if (string != null && !string.equals(this.tci.getInstitutionID())) {
            this.tci.setInstitutionID(string);
            this.modified = true;
            return true;
        }
        return false;
    }

    public String getCollectionID() {
        String string = this.tci.getCollectionID();
        return string == null ? "" : string;
    }

    public boolean setCollectionID(int n) {
        String string;
        if (n > 0 && !(string = new Integer(n).toString()).equals(this.tci.getCollectionID())) {
            this.tci.setCollectionID(new Integer(n).toString());
            this.modified = true;
            return true;
        }
        return false;
    }

    public String getVCID() {
        return this.tci.getVCID();
    }

    public boolean setVCID(String string) {
        if (string != null && !string.equals(this.tci.getVCID())) {
            this.tci.setVCID(string);
            this.modified = true;
            return true;
        }
        return false;
    }

    public String getFieldStandardTemplateName() {
        return this.fieldStandardTemplateName == null ? "" : this.fieldStandardTemplateName;
    }

    public boolean setFieldStandardTemplateName(String string) {
        if (string != null && !string.equals(this.fieldStandardTemplateName)) {
            this.fieldStandardTemplateName = string;
            this.modified = true;
            this.fieldStandardModified = true;
            return true;
        }
        return false;
    }

    public String getFieldStandardTemplateDescription() {
        return this.fieldStandardTemplateDescription == null ? "" : this.fieldStandardTemplateDescription;
    }

    public void setFieldStandardTemplateDescription(String string) {
        this.modified = true;
        this.fieldStandardTemplateDescription = string;
    }

    public List getFieldStandardTemplateFieldList() {
        return this.fieldStandardTemplateFieldList;
    }

    public void setFieldStandardTemplateFieldList(List list) {
        this.fieldStandardTemplateFieldList = list;
    }

    public List getThumbnailFields() {
        return this.thumbnailFields;
    }

    public boolean setThumbnailFields(List list) {
        if (list == null || list.size() != 4) {
            return false;
        }
        if (this.fieldsModified(this.thumbnailFields, list)) {
            this.thumbnailFields = list;
            this.modified = true;
            this.fieldStandardModified = true;
            return true;
        }
        return false;
    }

    public List getSortFields() {
        return this.sortFields;
    }

    public boolean setSortFields(List list) {
        if (list == null || list.size() != 4) {
            return false;
        }
        if (this.fieldsModified(this.sortFields, list)) {
            this.sortFields = list;
            this.modified = true;
            this.fieldStandardModified = true;
            return true;
        }
        return false;
    }

    public BaseTemplate getCollectionTemplate() {
        return this.collectionTemplate;
    }

    public void setCollectionTemplate(BaseTemplate baseTemplate) {
        this.collectionTemplate = baseTemplate;
    }

    public String getDescription() {
        return this.shortDescription != null ? this.shortDescription : this.tci.getShortDescription();
    }

    public boolean setDescription(String string) {
        if (string != null && !string.equals(this.getDescription())) {
            this.shortDescription = string;
            this.tci.setShortDescription(string);
            this.modified = true;
            this.collectionDescriptionModified = true;
            return true;
        }
        return false;
    }

    public EntityType getEntityType() {
        return this.pcEntityType;
    }

    public void setEntityType(EntityType entityType) {
        this.pcEntityType = entityType;
    }

    public String toKeyString() {
        return this.tci.toKeyString();
    }

    public void moveToTransient() {
    }

    public void restoreFromTransient() {
    }

    private boolean fieldsModified(List list, List list2) {
        if (list.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            Object e2 = list2.get(i);
            if (e == null) {
                if (e2 == null) continue;
                return true;
            }
            if (e2 == null) {
                return true;
            }
            if (e.equals(e2)) continue;
            return true;
        }
        return false;
    }

    public String getCollectionCopyright() {
        return this.getTCI().getCopyrightStatement();
    }

    public boolean setCollectionCopyright(String string) {
        if (string != null && !string.equals(this.getTCI().getCopyrightStatement())) {
            this.getTCI().setCopyrightStatement(string);
            this.copyrightModified = true;
            this.modified = true;
            return true;
        }
        return false;
    }

    public String getCollectionURL() {
        return this.collectionURL != null ? this.collectionURL : this.tci.getLongDescriptionURL();
    }

    public boolean setCollectionURL(String string) {
        if (string != null && !string.equals(this.collectionURL)) {
            this.collectionURL = string;
            this.collectionURLModified = true;
            this.modified = true;
            return true;
        }
        return false;
    }

    public boolean getPCUserGroupEditable() {
        int n = this.getTCI().getPcUsrGrpMemberPrivs();
        return (n & 3) == 3;
    }

    public boolean setPCUserGroupEditable(boolean bl) {
        int n = this.getTCI().getPcUsrGrpMemberPrivs();
        if (bl != ((n & 3) == 3)) {
            this.getTCI().setPcUsrGrpMemberPrivs(bl ? n | 3 : 1);
            this.pcUserGroupEditableModified = true;
            this.modified = true;
        }
        return bl;
    }

    public boolean setUserGroupReadable(boolean bl) {
        int n = this.getTCI().getPcUsrGrpMemberPrivs();
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        this.getTCI().setPcUsrGrpMemberPrivs(n);
        this.modified = true;
        this.pcUserGroupEditableModified = true;
        return bl;
    }

    public boolean getUserGroupReadable() {
        int n = this.getTCI().getPcUsrGrpMemberPrivs();
        return (n & 1) == 1;
    }

    public boolean setUserGroupWritable(boolean bl) {
        int n = this.getTCI().getPcUsrGrpMemberPrivs();
        n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
        this.getTCI().setPcUsrGrpMemberPrivs(n);
        this.pcUserGroupEditableModified = true;
        this.modified = true;
        return bl;
    }

    public boolean getUserGroupWritable() {
        int n = this.getTCI().getPcUsrGrpMemberPrivs();
        return (n & 2) == 2;
    }

    public boolean setPCPublicReadable(boolean bl) {
        int n = this.getTCI().getPcNonUsrGrpMemberPrivs();
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        this.getTCI().setPcNonUsrGrpMemberPrivs(n);
        this.modified = true;
        this.pcNonUserGroupEditableModified = true;
        return bl;
    }

    public boolean getPCPublicReadable() {
        int n = this.getTCI().getPcNonUsrGrpMemberPrivs();
        return (n & 1) == 1;
    }

    public boolean setPCPublicWritable(boolean bl) {
        int n = this.getTCI().getPcNonUsrGrpMemberPrivs();
        n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
        this.getTCI().setPcNonUsrGrpMemberPrivs(n);
        this.pcNonUserGroupEditableModified = true;
        this.modified = true;
        return bl;
    }

    public boolean getPCPublicWritable() {
        int n = this.getTCI().getPcNonUsrGrpMemberPrivs();
        return (n & 2) == 2;
    }

    public Integer getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Integer n) {
        this.collectionType = n;
    }

    public String getCollectionTheme() {
        return this.selectedTheme;
    }

    public void setCollectionTheme(String string) {
        this.modified = true;
        this.themeModified = true;
        this.selectedTheme = string;
    }

    public boolean isPersonalCollection() {
        return this.personalCollection;
    }

    public void setPersonalCollection(boolean bl) {
        this.personalCollection = bl;
    }

    public String getCollectionUserGroupCodeKey() {
        return this.collectionUserGroupCodeKey;
    }

    public void setCollectionUserGroupCodeKey(String string) {
        this.collectionUserGroupCodeKey = string;
    }

    public String getCollectionUserGroupName() {
        return this.collectionUserGroupName;
    }

    public void setCollectionUserGroupName(String string) {
        this.collectionUserGroupName = string;
    }

    public void setTemplate(BaseTemplate baseTemplate, String string) throws InsightWizardException {
        this.setCollectionTemplate(baseTemplate);
        this.setFieldStandardTemplateName(baseTemplate == null ? "" : baseTemplate.getTemplateName());
        this.setFieldStandardTemplateDescription(baseTemplate == null ? "" : baseTemplate.getVersionInfo());
        this.setFieldStandardTemplateFieldList(null);
        this.getFieldList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (baseTemplate != null) {
            for (int i = 0; i < 4; ++i) {
                BaseEntityField baseEntityField;
                List<BaseEntityField> list = Arrays.asList(baseTemplate.getThumbnailFields());
                List<BaseEntityField> list2 = Arrays.asList(baseTemplate.getSortFields());
                if (i < list.size()) {
                    baseEntityField = list.get(i);
                    arrayList.add(baseEntityField != null ? baseEntityField.getDisplayName() : null);
                } else {
                    arrayList.add(null);
                }
                if (i < list2.size()) {
                    baseEntityField = list2.get(i);
                    arrayList2.add(baseEntityField != null ? baseEntityField.getDisplayName() : null);
                    continue;
                }
                arrayList2.add(null);
            }
        }
        this.setThumbnailFields(arrayList);
        this.setSortFields(arrayList2);
    }

    public List getFieldList() {
        if (this.getFieldStandardTemplateFieldList() == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.getCollectionTemplate() != null) {
                try {
                    try {
                        List list = this.getCollectionTemplate().getLinkedFieldList();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
                            IFieldProfile iFieldProfile = baseEntityField.getFieldProfile();
                            StringBuffer stringBuffer = new StringBuffer(baseEntityField.getDisplayName()).append(' ');
                            if (iFieldProfile == null) {
                                stringBuffer.append("(Custom)");
                            } else {
                                stringBuffer.append("(" + iFieldProfile.getProfileName() + ")");
                            }
                            arrayList.add(stringBuffer.toString());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        throw new InsightWizardException(classCastException);
                    }
                }
                catch (InsightWizardException insightWizardException) {
                    CoreUtilities.logException(insightWizardException);
                }
            }
            this.setFieldStandardTemplateFieldList(arrayList);
        }
        return this.getFieldStandardTemplateFieldList();
    }

    public String[] getFieldNames() {
        String[] stringArray = EMPTY_STRING_ARRAY;
        if (this.getCollectionTemplate() != null) {
            try {
                try {
                    ArrayList arrayList = new ArrayList(this.getCollectionTemplate().getLinkedFields());
                    stringArray = new String[arrayList.size()];
                    int n = 0;
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
                        stringArray[n] = baseEntityField.getDisplayName();
                        ++n;
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new InsightWizardException(classCastException);
                }
            }
            catch (InsightWizardException insightWizardException) {
                CoreUtilities.logException(insightWizardException);
            }
        }
        return stringArray;
    }

    public BaseEntityField[] getSearchableFields() {
        BaseEntityField[] baseEntityFieldArray = new BaseEntityField[]{};
        if (this.getCollectionTemplate() != null) {
            try {
                try {
                    ArrayList<BaseEntityField> arrayList = new ArrayList<BaseEntityField>();
                    ArrayList arrayList2 = new ArrayList(this.getCollectionTemplate().getLinkedFields());
                    int n = 0;
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
                        if (baseEntityField.isDataFieldSearchable()) {
                            arrayList.add(baseEntityField);
                        }
                        ++n;
                    }
                    Collections.sort(arrayList, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return ((BaseEntityField)object).getDisplayName().compareTo(((BaseEntityField)object2).getDisplayName());
                        }
                    });
                    baseEntityFieldArray = arrayList.toArray(baseEntityFieldArray);
                }
                catch (ClassCastException classCastException) {
                    throw new InsightWizardException(classCastException);
                }
            }
            catch (InsightWizardException insightWizardException) {
                CoreUtilities.logException(insightWizardException);
            }
        }
        return baseEntityFieldArray;
    }

    public BaseEntityField[] getFields() {
        BaseEntityField[] baseEntityFieldArray = new BaseEntityField[]{};
        if (this.getCollectionTemplate() != null) {
            try {
                try {
                    ArrayList<BaseEntityField> arrayList = new ArrayList<BaseEntityField>();
                    ArrayList arrayList2 = new ArrayList(this.getCollectionTemplate().getLinkedFields());
                    int n = 0;
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
                        arrayList.add(baseEntityField);
                        ++n;
                    }
                    Collections.sort(arrayList, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return ((BaseEntityField)object).getDisplayName().compareTo(((BaseEntityField)object2).getDisplayName());
                        }
                    });
                    baseEntityFieldArray = arrayList.toArray(baseEntityFieldArray);
                }
                catch (ClassCastException classCastException) {
                    throw new InsightWizardException(classCastException);
                }
            }
            catch (InsightWizardException insightWizardException) {
                CoreUtilities.logException(insightWizardException);
            }
        }
        return baseEntityFieldArray;
    }

    public List getMappingStandards() {
        return this.mappingStandards;
    }

    public void setMappingStandards(List list) {
        if (list == null) {
            this.mappingStandardsModified |= this.mappingStandards != null;
        } else if (!((Object)list).equals(this.mappingStandards)) {
            this.mappingStandardsModified = true;
        }
        this.modified |= this.mappingStandardsModified;
        this.mappingStandards = list;
    }

    public boolean isMappingStandardsModified() {
        return this.mappingStandardsModified;
    }

    public TrinityCollectionInfo getCollectionParent() {
        return this.collectionParent;
    }

    public void setCollectionParent(TrinityCollectionInfo trinityCollectionInfo) {
        this.collectionParent = trinityCollectionInfo;
    }
}

