/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ObjectDimension;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.JdbcConnectionManager;
import com.luna.insight.server.backend.JdbcConnectionProfile;
import com.luna.insight.server.backend.JdbcConnectorConstants;
import com.luna.insight.server.backend.JdbcConnectorError;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class JdbcConnector
implements DatabaseConnector,
JdbcConnectorConstants {
    public static final String COMPONENT_CODE = "jdbc";
    public static boolean DEBUG_ALSO_CONSOLE = true;
    public static final long EXCESSIVE_FILE_SIZE = 2000000L;
    public static final String DEFAULT_DEBUG_FILE = "c:\\temp\\JdbcConnector-debug.txt";
    public static final String NULL_VALUE_REPLACE = "[none]";
    protected static final String DEFAULT_DRIVER_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";
    protected static final String DEFAULT_JDBC_PREFIX = "jdbc:odbc:";
    protected static final SimpleDateFormat DEBUG_DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
    protected static int debugLevel = 3;
    protected static Vector loadedDrivers = new Vector();
    protected static String defJdbcURLPrefix = "jdbc:odbc:";
    protected static Object lockObject = new Object();
    protected static boolean initialized = false;
    protected static long queryNumber = 0L;
    protected static String debugFilename = "c:\\temp\\JdbcConnector-debug.txt";
    protected static Hashtable dbConnections = new Hashtable();
    private String username = null;
    private String password = null;
    protected int updateRowCount = -1;
    protected String jdbcURLPrefix = defJdbcURLPrefix;
    protected JdbcDriver driverInUse = null;
    protected Statement statement = null;
    protected ResultSet resultSet = null;
    protected boolean nextThrewException = true;
    protected boolean readOnly = true;
    protected boolean forwardOnly = false;
    protected String query = null;
    protected String connectString = null;
    protected long jdbcConnectionValidatePeriod = 0L;
    protected int rowCount = -1;
    protected int rowNumber = 0;
    protected boolean forceNewConnection = false;
    protected JdbcConnectionProfile forcedConnectionProfile = null;
    protected Connection forcedConnection = null;
    protected boolean logBatchCommands = false;

    public JdbcConnector(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        this(string, string2, 0L, string3, bl, bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcConnector(String string, String string2, long l, String string3, boolean bl, boolean bl2, boolean bl3) {
        JdbcConnector.debugFile("Constructor starting.");
        JdbcConnector.debugFile("Database connect string: " + string2);
        JdbcConnector.debugFile("JDBC prefix: " + string);
        JdbcConnector.debugFile("Query: " + string3);
        this.setReadOnly(bl);
        this.setForwardOnly(bl2);
        this.setJdbcURLPrefix(string);
        this.connectString = string2;
        this.jdbcConnectionValidatePeriod = l;
        this.query = this.stripSemiColon(string3);
        this.logBatchCommands = bl3;
        if (!initialized) {
            Object object = lockObject;
            synchronized (object) {
                JdbcConnector.loadDriver(DEFAULT_DRIVER_NAME, DEFAULT_JDBC_PREFIX, false, false);
            }
        }
        JdbcConnector.debugFile("Constructor finished.");
    }

    public JdbcConnector(String string, String string2, String string3, boolean bl, boolean bl2) {
        this(string, string2, string3, bl, bl2, false);
    }

    public JdbcConnector(String string, String string2, String string3) {
        this(string, string2, string3, true, false);
    }

    public JdbcConnector(String string, String string2, boolean bl, boolean bl2) {
        this(defJdbcURLPrefix, string, string2, bl, bl2);
    }

    public JdbcConnector(String string, String string2) {
        this(defJdbcURLPrefix, string, string2, true, false);
    }

    public JdbcConnector(String string) {
        this(defJdbcURLPrefix, string, "", true, false);
    }

    public void finalize() {
        this.close();
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String stripSemiColon(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).endsWith(";")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void setQuery(String string) {
        this.close(false);
        this.query = this.stripSemiColon(string);
        JdbcConnector.debugFile("setQuery: " + this.query);
        this.nextThrewException = true;
        if (!this.driverInUse.supportsGetRow) {
            this.rowNumber = 0;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setForceNewConnection(boolean bl) {
        this.forceNewConnection = bl;
    }

    public boolean getForceNewConnection() {
        return this.forceNewConnection;
    }

    public void setForwardOnly(boolean bl) {
        this.forwardOnly = bl;
    }

    public boolean getForwardOnly() {
        return this.forwardOnly;
    }

    public void first() {
        if (this.forwardOnly) {
            JdbcConnector.debugFile("call to first on a forward-only query.");
            return;
        }
        try {
            boolean bl = this.nextThrewException = !this.resultSet.first();
            if (!this.driverInUse.supportsGetRow) {
                this.rowNumber = 1;
            }
        }
        catch (Exception exception) {
            JdbcConnector.debugFile("Exception on first():\n" + InsightUtilities.getStackTrace(exception), 2);
            this.nextThrewException = true;
        }
    }

    public void next() {
        try {
            boolean bl = this.nextThrewException = !this.resultSet.next();
            if (!this.driverInUse.supportsGetRow) {
                ++this.rowNumber;
            }
        }
        catch (Exception exception) {
            JdbcConnector.debugFile("Exception on next():\n" + InsightUtilities.getStackTrace(exception), 2);
            this.nextThrewException = true;
        }
    }

    public boolean more() {
        return !this.nextThrewException;
    }

    public void moveAbsolute(int n) {
        if (this.forwardOnly) {
            JdbcConnector.debugFile("call to moveAbsolute on a forward-only query.");
            return;
        }
        try {
            if (this.driverInUse.supportsAbsolute) {
                this.resultSet.absolute(n + 1);
                if (!this.driverInUse.supportsGetRow) {
                    this.rowNumber = n + 1;
                }
            } else {
                this.first();
                while (this.getRowNumber() < n + 1 && this.more()) {
                    this.next();
                }
            }
        }
        catch (Exception exception) {
            JdbcConnector.debugFile("Exception while moving to absolute position " + n + ": " + exception, 2);
        }
    }

    public int getRowNumber() {
        try {
            if (this.driverInUse.supportsGetRow) {
                return this.resultSet.getRow();
            }
            return this.rowNumber;
        }
        catch (Exception exception) {
            JdbcConnector.debugFile("Exception while getting row number: " + exception, 2);
            return 0;
        }
    }

    public String[] getColumnTypeNames() {
        try {
            ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n];
            for (int i = 1; i < n + 1; ++i) {
                stringArray[i - 1] = resultSetMetaData.getColumnTypeName(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            JdbcConnector.debugFile("Exception while gathering column type names: " + exception, 2);
            return new String[0];
        }
    }

    public int[] getColumnSizes() {
        try {
            ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int[] nArray = new int[n];
            for (int i = 1; i < n + 1; ++i) {
                nArray[i - 1] = resultSetMetaData.getColumnDisplaySize(i);
            }
            return nArray;
        }
        catch (Exception exception) {
            JdbcConnector.debugFile("Exception while gathering column sizes: " + exception, 2);
            return new int[0];
        }
    }

    public String[] getFieldNames() {
        try {
            ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n];
            for (int i = 1; i < n + 1; ++i) {
                stringArray[i - 1] = resultSetMetaData.getColumnName(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            JdbcConnector.debugFile("Exception while gathering field names: " + exception, 2);
            return new String[0];
        }
    }

    public int[] getFieldTypes() {
        try {
            ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int[] nArray = new int[n];
            for (int i = 1; i < n + 1; ++i) {
                nArray[i - 1] = resultSetMetaData.getColumnType(i);
            }
            return nArray;
        }
        catch (Exception exception) {
            JdbcConnector.debugFile("Exception while gathering field names: " + exception, 2);
            return new int[0];
        }
    }

    public String getStringField(String string) throws Exception {
        return this.getFieldByName(string);
    }

    public String getFieldByName(String string) throws Exception {
        return this.resultSet.getString(string);
    }

    public String getField(String string) throws Exception {
        String string2 = this.getFieldByName(string);
        if (string2 != null) {
            return string2;
        }
        return NULL_VALUE_REPLACE;
    }

    public int getIntegerFieldByName(String string) throws Exception {
        return this.getIntegerField(string);
    }

    public int getIntegerField(String string) throws Exception {
        return this.getIntegerField(string, 0);
    }

    public int getIntegerField(String string, int n) throws Exception {
        String string2 = null;
        try {
            string2 = this.resultSet.getString(string);
            return (int)ObjectDimension.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (string2 != null && !string2.equals("")) {
                JdbcConnector.debugFile("Exception getting integer value for " + string + ": " + numberFormatException);
            }
            return n;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public Date getDateFieldByName(String string) throws Exception {
        return this.getDateField(string);
    }

    public Date getDateField(String string) throws Exception {
        return this.getDateField(string, null);
    }

    public Date getDateField(String string, Date date) throws Exception {
        return this.resultSet.getDate(string);
    }

    public boolean getBooleanField(String string) throws Exception {
        return this.getBooleanField(string, false);
    }

    public boolean getBooleanField(String string, boolean bl) throws Exception {
        return this.getByteField(string, bl ? (byte)1 : 0) == 1;
    }

    public float getFloatField(String string) throws Exception {
        return this.getFloatField(string, 0.0f);
    }

    public float getFloatField(String string, float f) throws Exception {
        float f2 = f;
        try {
            f2 = ObjectDimension.parseFloat(this.getField(string));
        }
        catch (NumberFormatException numberFormatException) {
            f2 = f;
        }
        return f2;
    }

    public double getDoubleField(String string) throws Exception {
        return this.getDoubleField(string, 0.0);
    }

    public double getDoubleField(String string, double d) throws Exception {
        double d2 = d;
        try {
            d2 = ObjectDimension.parseDouble(this.getField(string));
        }
        catch (NumberFormatException numberFormatException) {
            d2 = d;
        }
        return d2;
    }

    public byte getByteField(String string) throws Exception {
        return this.getByteField(string, (byte)0);
    }

    public byte getByteField(String string, byte by) throws Exception {
        byte by2 = by;
        try {
            by2 = Byte.parseByte(this.getField(string));
        }
        catch (NumberFormatException numberFormatException) {
            by2 = by;
        }
        return by2;
    }

    public short getShortField(String string) throws Exception {
        return this.getShortField(string, (short)0);
    }

    public short getShortField(String string, short s) throws Exception {
        short s2 = s;
        try {
            s2 = Short.parseShort(this.getField(string));
        }
        catch (NumberFormatException numberFormatException) {
            s2 = s;
        }
        return s2;
    }

    public long getLongField(String string) throws Exception {
        return this.getLongField(string, 0L);
    }

    public long getLongField(String string, long l) throws Exception {
        long l2 = l;
        try {
            l2 = Long.parseLong(this.getField(string));
        }
        catch (NumberFormatException numberFormatException) {
            l2 = l;
        }
        return l2;
    }

    public int getRowCount() {
        if (this.resultSet != null) {
            if (this.rowCount > -1) {
                return this.rowCount;
            }
            this.rowCount = 0;
            this.first();
            while (this.more()) {
                ++this.rowCount;
                this.next();
            }
            this.first();
            return this.rowCount;
        }
        return 0;
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean bl) {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (Exception exception) {
                JdbcConnector.debugFile("Exception while closing result set: " + exception, 2);
            }
            this.resultSet = null;
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (Exception exception) {
                JdbcConnector.debugFile("Exception while closing statement: " + exception, 2);
            }
            this.statement = null;
        }
        if (bl && this.forcedConnection != null) {
            try {
                this.forcedConnection.close();
            }
            catch (Exception exception) {
                JdbcConnector.debugFile("Exception while closing forced connection: " + exception, 2);
            }
            this.forcedConnection = null;
            this.forcedConnectionProfile = null;
        }
    }

    public int runUpdateQuery() {
        return this.runUpdateQuery(false);
    }

    public int runUpdateQuerySafe() {
        return this.runUpdateQuery(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runUpdateQuery(boolean bl) {
        this.close(false);
        ++queryNumber;
        this.rowCount = -1;
        JdbcConnectionProfile jdbcConnectionProfile = this.getDbConnection(this.connectString, this.username, this.password);
        if (jdbcConnectionProfile != null) {
            jdbcConnectionProfile.incrementLoad();
            JdbcConnector.debugFile("Creating the statement.");
            if (bl) {
                try {
                    this.generateStatement(jdbcConnectionProfile, true);
                    JdbcConnector.debugFile("Statement created.");
                }
                catch (SQLException sQLException) {
                    JdbcConnector.debugFile("SQL Exception while creating statement: " + sQLException, 2);
                    jdbcConnectionProfile.close();
                    throw new JdbcConnectorError("Creation of statement failed.", sQLException);
                }
                try {
                    this.updateRowCount = this.doUpdateSafe(this.statement);
                }
                catch (SQLException sQLException) {
                    JdbcConnector.debugFile("SQL Exception while running query: " + sQLException, 2);
                    throw new JdbcConnectorError("runUpdateQuery failed.", sQLException);
                }
                finally {
                    jdbcConnectionProfile.decrementLoad();
                }
            }
            try {
                this.generateStatement(jdbcConnectionProfile, true);
                JdbcConnector.debugFile("Statement created.");
            }
            catch (SQLException sQLException) {
                JdbcConnector.debugFile("SQL Exception while creating statement: " + sQLException, 2);
                jdbcConnectionProfile.close();
                return -1;
            }
            try {
                this.updateRowCount = this.doUpdateSafe(this.statement);
            }
            catch (SQLException sQLException) {
                JdbcConnector.debugFile("SQL Exception while running query: " + sQLException, 2);
                int n = -1;
                return n;
            }
            finally {
                jdbcConnectionProfile.decrementLoad();
            }
        }
        JdbcConnector.debugFile("No valid connection available, aborting query.", 3);
        JdbcConnector.debugFile("Returning from runUpdateQuery.");
        return this.updateRowCount;
    }

    protected int doUpdate(Statement statement) {
        try {
            statement.execute(this.query);
            return statement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            JdbcConnector.debugFile("SQLException in doUpdate: " + sQLException);
            return -1;
        }
    }

    protected int doUpdateSafe(Statement statement) throws SQLException {
        try {
            statement.execute(this.query);
            return statement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            JdbcConnector.debugFile("SQLException in doUpdateSafe: " + sQLException);
            throw sQLException;
        }
    }

    public void runQuerySafe() {
        this.runQuery(true);
    }

    public void runQuery() {
        this.runQuery(false);
    }

    public void runQuery(boolean bl) {
        block13: {
            this.close(false);
            ++queryNumber;
            this.rowCount = -1;
            JdbcConnectionProfile jdbcConnectionProfile = this.getDbConnection(this.connectString, this.username, this.password);
            if (jdbcConnectionProfile != null) {
                jdbcConnectionProfile.incrementLoad();
                if (bl) {
                    try {
                        this.generateStatement(jdbcConnectionProfile, false);
                    }
                    catch (SQLException sQLException) {
                        JdbcConnector.debugFile("SQL Exception while creating statement: " + sQLException, 3);
                        jdbcConnectionProfile.close();
                        throw new JdbcConnectorError("Creation of statement failed.", sQLException);
                    }
                    try {
                        this.generateResults(this.statement);
                    }
                    catch (SQLException sQLException) {
                        jdbcConnectionProfile.decrementLoad();
                        JdbcConnector.debugFile("SQL Exception while running query: " + sQLException, 3);
                        throw new JdbcConnectorError("runQuery failed.", sQLException);
                    }
                }
                boolean bl2 = false;
                try {
                    this.generateStatement(jdbcConnectionProfile, false);
                }
                catch (SQLException sQLException) {
                    jdbcConnectionProfile.close();
                    JdbcConnector.debugFile("SQL Exception while creating statement: " + sQLException, 3);
                    bl2 = true;
                }
                if (!bl2) {
                    try {
                        this.generateResults(this.statement);
                    }
                    catch (SQLException sQLException) {
                        jdbcConnectionProfile.decrementLoad();
                        if (sQLException.toString().indexOf("onnection reset by peer") >= 0) {
                            jdbcConnectionProfile.close();
                            JdbcConnector.debugFile("SQL Exception while running query: " + sQLException, 3);
                            break block13;
                        }
                        JdbcConnector.debugFile("SQL Exception while running query: " + sQLException, 2);
                    }
                }
            } else {
                JdbcConnector.debugFile("No valid connection available, aborting query.", 3);
            }
        }
        JdbcConnector.debugFile("Returning from runQuery.");
    }

    public int[] executeBatch(Collection collection, boolean bl) {
        int[] nArray = null;
        if (this.driverInUse.jdbc1) {
            JdbcConnector.debugFile("executeBatch cannot run with a JDBC 1.x driver.");
            return nArray;
        }
        if (collection == null || collection.isEmpty()) {
            JdbcConnector.debugFile("executeBatch: No batch commands defined.");
        } else {
            this.close(false);
            ++queryNumber;
            JdbcConnectionProfile jdbcConnectionProfile = this.getDbConnection(this.connectString, this.username, this.password);
            if (jdbcConnectionProfile != null) {
                jdbcConnectionProfile.incrementLoad();
                if (bl) {
                    try {
                        this.generateStatement(jdbcConnectionProfile, false);
                    }
                    catch (SQLException sQLException) {
                        JdbcConnector.debugFile("SQL Exception while creating statement: " + sQLException, 3);
                        jdbcConnectionProfile.close();
                        throw new JdbcConnectorError("Creation of statement failed.", sQLException);
                    }
                    try {
                        if (this.logBatchCommands) {
                            JdbcConnector.debugFile("SQL batch commands: ");
                        }
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            if (this.logBatchCommands) {
                                JdbcConnector.debugFile(" " + string);
                            }
                            this.statement.addBatch(string);
                        }
                        nArray = this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    catch (SQLException sQLException) {
                        jdbcConnectionProfile.decrementLoad();
                        JdbcConnector.debugFile("SQL Exception while running query: " + sQLException, 3);
                        throw new JdbcConnectorError("executeBatch failed.", sQLException);
                    }
                }
                boolean bl2 = false;
                try {
                    this.generateStatement(jdbcConnectionProfile, false);
                }
                catch (SQLException sQLException) {
                    jdbcConnectionProfile.close();
                    JdbcConnector.debugFile("SQL Exception while creating statement: " + sQLException, 3);
                    bl2 = true;
                }
                if (!bl2) {
                    try {
                        if (this.logBatchCommands) {
                            JdbcConnector.debugFile("SQL batch commands: ");
                        }
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            if (this.logBatchCommands) {
                                JdbcConnector.debugFile(" " + string);
                            }
                            this.statement.addBatch(string);
                        }
                        nArray = this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    catch (SQLException sQLException) {
                        jdbcConnectionProfile.decrementLoad();
                        if (sQLException.toString().indexOf("onnection reset by peer") >= 0) {
                            jdbcConnectionProfile.close();
                            JdbcConnector.debugFile("SQL Exception while running query: " + sQLException, 3);
                        }
                        JdbcConnector.debugFile("SQL Exception while running query: " + sQLException, 2);
                    }
                }
            }
        }
        return nArray;
    }

    public int[] executeBatch(Collection collection) {
        return this.executeBatch(collection, false);
    }

    public void setJdbcURLPrefix(String string) {
        this.jdbcURLPrefix = string;
        this.driverInUse = null;
        for (int i = 0; i < loadedDrivers.size(); ++i) {
            JdbcDriver jdbcDriver = (JdbcDriver)loadedDrivers.elementAt(i);
            String string2 = jdbcDriver.urlPrefix;
            if (!string2.equals(this.jdbcURLPrefix)) continue;
            this.driverInUse = jdbcDriver;
            break;
        }
        if (this.driverInUse == null) {
            JdbcConnector.debugFile("No suitable driver found for prefix: " + this.jdbcURLPrefix + "!");
        }
    }

    public String getJdbcURLPrefix() {
        return this.jdbcURLPrefix;
    }

    protected void generateStatement(JdbcConnectionProfile jdbcConnectionProfile, boolean bl) throws SQLException {
        block16: {
            try {
                JdbcConnector.debugFile("Creating the statement.");
                if (this.driverInUse.jdbc1 || bl) {
                    if (this.driverInUse.jdbc1) {
                        JdbcConnector.debugFile("Driver in use: JDBC 1.x");
                    } else {
                        JdbcConnector.debugFile("Driver in use: > JDBC 1.x");
                    }
                    try {
                        this.statement = jdbcConnectionProfile.connection.createStatement();
                        long l = System.currentTimeMillis();
                        long l2 = l - jdbcConnectionProfile.getTimestamp();
                        jdbcConnectionProfile.setTimestamp(l);
                        if (this.jdbcConnectionValidatePeriod > 0L && l2 > this.jdbcConnectionValidatePeriod) {
                            JdbcConnector.debugFile("Connection validation period expired.  Executing query SELECT 1.", 3);
                            ResultSet resultSet = this.statement.executeQuery("SELECT 1");
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        JdbcConnector.debugFile("Exception in creating statement " + InsightUtilities.getStackTrace(exception), 3);
                        JdbcConnector.debugFile("Retrying statement creation.", 3);
                        jdbcConnectionProfile.close();
                        jdbcConnectionProfile = this.getDbConnection(this.connectString, this.username, this.password);
                        jdbcConnectionProfile.getConnection();
                        this.statement = jdbcConnectionProfile.connection.createStatement();
                    }
                    JdbcConnector.debugFile("Statement created.");
                    break block16;
                }
                JdbcConnector.debugFile("Driver in use: > JDBC 1.x");
                int n = 1004;
                int n2 = 1007;
                if (this.forwardOnly) {
                    n = 1003;
                }
                if (!this.readOnly) {
                    n2 = 1008;
                }
                JdbcConnector.debugFile("Getting the statement.");
                JdbcConnector.debugFile("   (dbConnectionToUse != null) ? " + (jdbcConnectionProfile != null));
                if (jdbcConnectionProfile != null) {
                    JdbcConnector.debugFile("   (dbConnectionToUse.connection != null) ?  " + (jdbcConnectionProfile.connection != null));
                }
                JdbcConnector.debugFile("   resultSetType = " + n + ", resultSetConcurrency = " + n2);
                try {
                    this.statement = jdbcConnectionProfile.connection.createStatement(n, n2);
                    long l = System.currentTimeMillis();
                    long l3 = l - jdbcConnectionProfile.getTimestamp();
                    jdbcConnectionProfile.setTimestamp(l);
                    if (this.jdbcConnectionValidatePeriod > 0L && l3 > this.jdbcConnectionValidatePeriod) {
                        JdbcConnector.debugFile("Connection validation period expired.  Executing query SELECT 1.", 3);
                        ResultSet resultSet = this.statement.executeQuery("SELECT 1");
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    JdbcConnector.debugFile("Exception in creating statement " + InsightUtilities.getStackTrace(exception), 3);
                    JdbcConnector.debugFile("Retrying statement creation.", 3);
                    jdbcConnectionProfile.close();
                    jdbcConnectionProfile = this.getDbConnection(this.connectString, this.username, this.password);
                    jdbcConnectionProfile.getConnection();
                    this.statement = jdbcConnectionProfile.connection.createStatement(n, n2);
                }
                if (this.statement != null) {
                    JdbcConnector.debugFile("Statement result set type is TYPE_FORWARD_ONLY ? " + (this.statement.getResultSetType() == 1003));
                }
                JdbcConnector.debugFile("Statement created.");
            }
            catch (SQLException sQLException) {
                JdbcConnector.debugFile("SQLException in generateStatement: " + sQLException, 3);
                JdbcConnector.debugFile("SQLState: " + sQLException.getSQLState(), 3);
                JdbcConnector.debugFile("SQLException stack trace:\n  " + InsightUtilities.getStackTrace(sQLException), 3);
                if (!bl) {
                    this.nextThrewException = true;
                    this.resultSet = null;
                }
                throw sQLException;
            }
        }
    }

    protected void generateResults(Statement statement) throws SQLException {
        try {
            this.resultSet = statement.executeQuery(this.query);
            JdbcConnector.debugFile("Results generated.");
            this.next();
        }
        catch (SQLException sQLException) {
            JdbcConnector.debugFile("SQLException in generateResults:\n" + InsightUtilities.getStackTrace(sQLException), 3);
            JdbcConnector.debugFile("SQLState: " + sQLException.getSQLState(), 3);
            this.nextThrewException = true;
            this.resultSet = null;
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcConnectionProfile getDbConnection(String string, String string2, String string3) {
        JdbcConnectionProfile jdbcConnectionProfile = null;
        if (this.forceNewConnection) {
            if (this.forcedConnectionProfile == null) {
                jdbcConnectionProfile = new JdbcConnectionProfile();
                jdbcConnectionProfile.establishDbConnection(this.jdbcURLPrefix, string, string2, string3);
                if (jdbcConnectionProfile.connection == null) {
                    jdbcConnectionProfile = null;
                } else {
                    this.forcedConnectionProfile = jdbcConnectionProfile;
                    this.forcedConnection = jdbcConnectionProfile.connection;
                }
            } else {
                jdbcConnectionProfile = this.forcedConnectionProfile;
            }
        } else {
            String string4 = string2 + "/" + string3 + "/" + string;
            JdbcConnectionManager jdbcConnectionManager = (JdbcConnectionManager)dbConnections.get(string4);
            Object object = lockObject;
            synchronized (object) {
                if (jdbcConnectionManager == null) {
                    jdbcConnectionManager = new JdbcConnectionManager();
                    dbConnections.put(string4, jdbcConnectionManager);
                }
                JdbcConnector.debugFile("manager.size(): " + jdbcConnectionManager.size());
                JdbcConnector.debugFile("driverInUse.pooling: " + this.driverInUse.pooling);
                if (jdbcConnectionManager.size() < this.driverInUse.pooling) {
                    JdbcConnectionProfile jdbcConnectionProfile2 = new JdbcConnectionProfile();
                    jdbcConnectionProfile2.establishDbConnection(this.jdbcURLPrefix, string, string2, string3);
                    if (jdbcConnectionProfile2.getConnection() != null) {
                        jdbcConnectionProfile = jdbcConnectionProfile2;
                        jdbcConnectionManager.add(jdbcConnectionProfile2);
                    }
                } else {
                    jdbcConnectionProfile = jdbcConnectionManager.getLowestLoad();
                    if (jdbcConnectionProfile != null && jdbcConnectionProfile.isClosed()) {
                        jdbcConnectionProfile.establishDbConnection(this.jdbcURLPrefix, string, string2, string3);
                        if (jdbcConnectionProfile.getConnection() == null) {
                            jdbcConnectionProfile = null;
                        }
                    }
                }
            }
        }
        return jdbcConnectionProfile;
    }

    protected Connection establishDbConnection(String string, String string2, String string3) {
        try {
            String string4 = this.jdbcURLPrefix + string;
            JdbcConnector.debugFile("establishDbConnection(" + string4 + ", " + string2 + ", " + string3 + ")");
            return DriverManager.getConnection(string4, string2, string3);
        }
        catch (SQLException sQLException) {
            JdbcConnector.debugFile("SQL Exception while connecting: " + sQLException, 3);
            return null;
        }
    }

    public static void loadDriver(String string, String string2, boolean bl, boolean bl2, boolean bl3, int n) {
        JdbcDriver jdbcDriver;
        for (int i = 0; i < loadedDrivers.size(); ++i) {
            jdbcDriver = (JdbcDriver)loadedDrivers.elementAt(i);
            if (!jdbcDriver.className.equals(string)) continue;
            return;
        }
        JdbcConnector.debugFile("Loading JDBC driver: " + string);
        JdbcConnector.debugFile("JDBC driver [urlPrefix: " + string2 + ", pooling: " + n + ", jdbc1: " + bl3 + "]");
        try {
            Class.forName(string);
            jdbcDriver = new JdbcDriver(string, string2, bl, bl2, bl3, n);
            loadedDrivers.addElement(jdbcDriver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JdbcConnector.debugFile("ClassNotFound: " + classNotFoundException, 3);
        }
        initialized = true;
    }

    public static void loadDriver(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        JdbcConnector.loadDriver(string, string2, bl, bl2, bl3, 1);
    }

    public static void loadDriver(String string, String string2, boolean bl, boolean bl2) {
        JdbcConnector.loadDriver(string, string2, bl, bl2, false, 1);
    }

    public static long getQueryNumber() {
        return queryNumber;
    }

    public SQLWarning getWarnings() {
        if (this.statement != null) {
            try {
                return this.statement.getWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    public SQLWarning getConnectionWarnings() {
        if (this.statement != null) {
            try {
                return this.statement.getConnection().getWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setDebugLevel(int n) {
        if (debugLevel >= 1 && debugLevel <= 3) {
            debugLevel = n;
        }
    }

    public static void setDebugFilename(String string) {
        debugFilename = string;
    }

    public static void setDefaultJdbcURLPrefix(String string) {
        defJdbcURLPrefix = string;
    }

    public static String getDefaultJdbcURLPrefix() {
        return defJdbcURLPrefix;
    }

    public static void debugFile(String string) {
        JdbcConnector.debugFile(string, 1);
    }

    public static void debugFile(String string, int n) {
        if (debugLevel <= n && debugFilename != null) {
            try {
                Object object;
                if (queryNumber % 500L == 0L && ((File)(object = new File(debugFilename))).exists() && ((File)object).length() > 2000000L) {
                    ((File)object).delete();
                }
                object = "H";
                if (n == 2) {
                    object = "M";
                } else if (n == 1) {
                    object = "L";
                }
                java.util.Date date = new java.util.Date();
                String string2 = "JC " + DEBUG_DATE_FORMAT.format(date) + " " + COMPONENT_CODE + ": [" + (String)object + "] " + string;
                FileWriter fileWriter = new FileWriter(debugFilename, true);
                fileWriter.write(string2 + "\r\n");
                fileWriter.flush();
                fileWriter.close();
                if (DEBUG_ALSO_CONSOLE) {
                    System.out.println(string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class JdbcDriver {
        public String className;
        public String urlPrefix;
        public boolean supportsAbsolute;
        public boolean supportsGetRow;
        public boolean jdbc1;
        public int pooling;

        public JdbcDriver(String string, String string2, boolean bl, boolean bl2, boolean bl3, int n) {
            this.className = string;
            this.urlPrefix = string2;
            this.supportsAbsolute = bl;
            this.supportsGetRow = bl2;
            this.jdbc1 = bl3;
            this.pooling = n;
        }
    }
}

