/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.backend.JdbcConnectionManager;
import com.luna.insight.server.backend.JdbcConnector;
import com.luna.insight.server.backend.JdbcConnectorConstants;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class JdbcConnectionProfile
implements JdbcConnectorConstants {
    protected Object lockObject = new Object();
    public int load = 0;
    public long timestamp = 0L;
    private String connectString;
    private String jdbcURLPrefix;
    private String username;
    private String password;
    protected JdbcConnectionManager manager;
    public Connection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void establishDbConnection(String string, String string2, String string3, String string4) {
        this.close();
        Object object = this.lockObject;
        synchronized (object) {
            if (this.connection == null) {
                this.jdbcURLPrefix = string;
                this.username = string3;
                this.password = string4;
                this.connectString = string2;
                String string5 = string + string2;
                try {
                    JdbcConnectionProfile.debugFile("establishDbConnection(" + string5 + ", " + string3 + ", " + string4 + ")");
                    this.connection = DriverManager.getConnection(string5, string3, string4);
                    this.connection.setAutoCommit(true);
                    this.setTimestamp(System.currentTimeMillis());
                }
                catch (SQLException sQLException) {
                    JdbcConnectionProfile.debugFile("SQL Exception while connecting: " + sQLException, 3);
                    this.connection = null;
                }
                this.load = 0;
            }
        }
    }

    public Connection getConnection() {
        if (this.connection == null) {
            if (this.connectString != null && this.jdbcURLPrefix != null) {
                this.establishDbConnection(this.jdbcURLPrefix, this.connectString, this.username, this.password);
            } else {
                JdbcConnectionProfile.debugFile("Cannot establish db connection: " + this.jdbcURLPrefix + " / " + this.connectString, 3);
            }
        }
        return this.connection;
    }

    public void setManager(JdbcConnectionManager jdbcConnectionManager) {
        this.manager = jdbcConnectionManager;
    }

    public boolean isClosed() {
        try {
            if (this.connection != null) {
                return this.connection.isClosed();
            }
        }
        catch (SQLException sQLException) {
            JdbcConnectionProfile.debugFile("SQLException while determining connection's closed status: " + sQLException);
        }
        return true;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                JdbcConnectionProfile.debugFile("SQLException while closing connection: " + sQLException);
            }
            this.connection = null;
        }
        this.load = 0;
    }

    public int incrementLoad() {
        return ++this.load;
    }

    public int decrementLoad() {
        --this.load;
        if (this.load < 0) {
            this.load = 0;
        }
        return this.load;
    }

    public int getLoad() {
        return this.load;
    }

    public static void debugFile(String string) {
        JdbcConnector.debugFile(string, 1);
    }

    public static void debugFile(String string, int n) {
        JdbcConnector.debugFile(string, n);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }
}

