/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.JdbcConnector;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;

public class DatabaseConnectorGenerator
implements Serializable {
    static final long serialVersionUID = -9112974888918618057L;
    public static final String COMPONENT_CODE = "DBC";
    public static final String DEFAULT_CONNECTOR_TYPE = "RDO";
    public static final String DEFAULT_PROPS_FILENAME = "InsightBackend.dat";
    protected static final int RDO_CONNECTOR = 0;
    protected static final int JDBC_CONNECTOR = 1;
    protected static final int ADO_CONNECTOR = 2;
    public static final String[] CONNECTOR_NAMES = new String[]{"RDO", "JDBC", "ADO"};
    protected static DatabaseConnectorGenerator DEFAULT_GENERATOR = null;
    private String username = null;
    private String password = null;
    public String DEBUG_FILENAME = "DatabaseConnector.txt";
    public boolean DEBUG_MODE = true;
    protected int currentlySelectedConnector = 1;
    protected String defaultUsername = null;
    protected String defaultPassword = null;
    protected String defaultJdbcDriver = null;
    protected String defaultJdbcUrlPrefix = null;
    protected int defaultJdbcConnectionPool = 10;
    protected long defaultJdbcConnectionValidatePeriod = 0L;
    protected boolean logBatchCommands = false;

    public static DatabaseConnectorGenerator getDefaultGenerator() {
        return DatabaseConnectorGenerator.getDefaultGenerator(false);
    }

    public static DatabaseConnectorGenerator getDefaultGenerator(boolean bl) {
        if (DEFAULT_GENERATOR == null) {
            DEFAULT_GENERATOR = new DatabaseConnectorGenerator();
            DEFAULT_GENERATOR.configure(DEFAULT_PROPS_FILENAME, bl);
        }
        return DEFAULT_GENERATOR;
    }

    public static DatabaseConnectorGenerator getCustomGenerator(Properties properties) {
        DatabaseConnectorGenerator databaseConnectorGenerator = (DatabaseConnectorGenerator)InsightUtilities.deepCopy(DatabaseConnectorGenerator.getDefaultGenerator(true));
        databaseConnectorGenerator.configure(properties);
        return databaseConnectorGenerator;
    }

    public void configure(String string) {
        this.configure(string, false);
    }

    public void configure(String string, boolean bl) {
        this.configure(this.loadProperties(string, bl));
    }

    public void configure(Properties properties) {
        if (properties != null) {
            String string;
            String string2;
            String string3 = properties.getProperty("DatabaseConnector");
            if (string3 != null) {
                this.setConnectorType(string3);
            }
            this.DEBUG_FILENAME = properties.getProperty("DatabaseDebugFilename", this.DEBUG_FILENAME);
            if (properties.getProperty("DatabaseDebugMode") != null) {
                boolean bl = this.DEBUG_MODE = properties.getProperty("DatabaseDebugMode", "1").equals("1");
            }
            if (this.currentlySelectedConnector == 1) {
                string2 = properties.getProperty("JDBCDriverName");
                if (string2 != null) {
                    this.defaultJdbcDriver = string2;
                }
                if ((string = properties.getProperty("JDBCUrlPrefix")) != null) {
                    this.defaultJdbcUrlPrefix = string;
                }
                try {
                    this.defaultJdbcConnectionPool = Integer.parseInt(properties.getProperty("JDBCConnectionPool", this.defaultJdbcConnectionPool + ""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.defaultJdbcConnectionPool < 1) {
                    this.defaultJdbcConnectionPool = 1;
                }
                try {
                    this.defaultJdbcConnectionValidatePeriod = 1000 * Integer.parseInt(properties.getProperty("JDBCConnectionValidatePeriod", this.defaultJdbcConnectionValidatePeriod + ""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string2 = properties.getProperty("DefaultUsername")) != null) {
                this.defaultUsername = string2;
            }
            if ((string = properties.getProperty("DefaultPassword")) != null) {
                this.defaultPassword = string;
            }
            try {
                this.logBatchCommands = Integer.parseInt(properties.getProperty("LogBatchCommands")) == 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getConnectionPoolSize() {
        return this.defaultJdbcConnectionPool;
    }

    public String getConnectorTypeString() {
        return CONNECTOR_NAMES[this.currentlySelectedConnector];
    }

    public int getConnectorType() {
        return this.currentlySelectedConnector;
    }

    public DatabaseConnector getConnector(String string) {
        return this.getConnector(string, true);
    }

    public DatabaseConnector getConnector(String string, boolean bl) {
        return this.getConnector(string, null, this.username, this.password, bl);
    }

    public DatabaseConnector getConnector(String string, String string2, String string3, String string4) {
        return this.getConnector(string, string2, string3, string4, true);
    }

    public DatabaseConnector getConnector(String string, String string2, String string3, String string4, boolean bl) {
        this.debugFile("DBC: fetching connector for query: " + string2);
        this.username = string3;
        this.password = string4;
        DatabaseConnector databaseConnector = null;
        switch (this.currentlySelectedConnector) {
            case 1: {
                JdbcConnector.DEBUG_ALSO_CONSOLE = false;
                if (this.DEBUG_MODE) {
                    JdbcConnector.setDebugFilename(this.DEBUG_FILENAME);
                    JdbcConnector.setDebugLevel(1);
                } else {
                    JdbcConnector.setDebugFilename(null);
                }
                JdbcConnector.loadDriver(this.defaultJdbcDriver, this.defaultJdbcUrlPrefix, false, false, this.defaultJdbcDriver != null && this.defaultJdbcDriver.indexOf("JdbcOdbcDriver") > -1, this.defaultJdbcConnectionPool);
                databaseConnector = new JdbcConnector(this.defaultJdbcUrlPrefix, string, this.defaultJdbcConnectionValidatePeriod, string2, true, bl, this.logBatchCommands);
            }
        }
        if (databaseConnector != null) {
            if (string3 != null) {
                databaseConnector.setUsername(string3);
            } else if (this.defaultUsername != null) {
                databaseConnector.setUsername(this.defaultUsername);
            }
            if (string4 != null) {
                databaseConnector.setPassword(string4);
            } else if (this.defaultPassword != null) {
                databaseConnector.setPassword(this.defaultPassword);
            }
        }
        return databaseConnector;
    }

    public int setConnectorType(String string) {
        this.debugFile("DBC: Setting connector type to " + string);
        for (int i = 0; i < CONNECTOR_NAMES.length; ++i) {
            this.debugFile("DBC: Matching with " + CONNECTOR_NAMES[i]);
            if (!CONNECTOR_NAMES[i].equalsIgnoreCase(string)) continue;
            this.debugFile("DBC: Matched " + CONNECTOR_NAMES[i]);
            this.currentlySelectedConnector = i;
            return i;
        }
        this.debugFile("DBC: type not found!");
        return -1;
    }

    public void setDefaultJdbcDriverName(String string) {
        this.defaultJdbcDriver = string;
    }

    public void setDefaultJdbcUrlPrefix(String string) {
        this.defaultJdbcUrlPrefix = string;
    }

    public void setDefaultJdbcConnectionPool(int n) {
        this.defaultJdbcConnectionPool = n;
    }

    protected Properties loadProperties(String string) {
        return this.loadProperties(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Properties loadProperties(String string, boolean bl) {
        Properties properties;
        block13: {
            System.out.println("DBC: in loadProperties().");
            String string2 = string;
            properties = new Properties();
            System.out.println("DBC: Created Properties object.");
            FileInputStream fileInputStream = null;
            if (!bl) {
                this.debugFile("DBC: Configuration file is " + string2 + ".");
                System.out.println("DBC: Configuration file is " + string2 + ".");
            }
            fileInputStream = new FileInputStream(string2);
            properties.load(fileInputStream);
            fileInputStream.close();
            Object var8_6 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block13;
            }
            catch (IOException iOException) {}
            break block13;
            {
                catch (IOException iOException) {
                    if (!bl) {
                        this.debugFile("DBC: Cannot read configuration file. exc: " + iOException);
                        System.out.println("DBC: Cannot read configuration file. exc: " + iOException);
                    }
                    Object var8_7 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block13;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }

    public void debugFile(String string) {
        if (this.DEBUG_FILENAME != null && this.DEBUG_MODE) {
            try {
                FileWriter fileWriter = new FileWriter(this.DEBUG_FILENAME, true);
                fileWriter.write(new Date() + ": " + string + "\r\n");
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long getDefaultJdbcConnectionValidatePeriod() {
        return this.defaultJdbcConnectionValidatePeriod;
    }

    public void setDefaultJdbcConnectionValidatePeriod(long l) {
        this.defaultJdbcConnectionValidatePeriod = l;
    }
}

