/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.GroupInformation;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.MediaField;
import com.luna.insight.server.MediaMetaData;
import com.luna.insight.server.ThumbnailQuery;
import com.luna.insight.server.ThumbnailQueryLogger;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.InsightBackendConnector;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.security.MediaSecurityHandler;
import com.luna.insight.server.security.MediaSecurityUtilities;
import com.luna.insight.server.usergroup.UserGroup;
import com.luna.insight.server.usergroup.UserGroupKey;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class BrowserInsightTrinityProxy {
    protected static String DEBUG_FILENAME = "Browser-Insight-Proxy.txt";
    protected static boolean DEBUG_MODE = true;
    protected static String HOST_IP = "UNKNOWN";
    public static String QUERY_LOG_DIRECTORY = "\\";
    public static String QUERY_LOG_FILENAME = "Browser-Insight-Query-Log.txt";
    public static boolean QUERY_LOG_MODE = true;
    private static HashMap logFileNames = new HashMap();
    public static final String VERSION_ID = "1.07 (23October2001)";
    public static final String COMPONENT_CODE = "BrowserInsightTrinityProxy";
    public static final int DEFAULT_QUERY_MODE = 0;
    public static final int MAX_COLLECTION_COUNT = 100;
    private static Vector[] allCollectionResults = new Vector[100];
    private static int[] allCollectionTotalRecords = new int[100];
    private static int[] allCollectionImageCount = new int[100];
    private static int[] allCollectionGroupID = new int[100];
    private static Object[] allCollectionFields = new Object[100];
    private static Object[] allCollectionSortFields = new Object[100];
    private static long[] allCollectionMaxEntityChangeID = new long[100];
    protected float DB_VERSION = 2.0f;
    protected String connectString = "ConnectStringNotSet";
    protected boolean msAccessMode = false;
    protected String charWildcard = "_";
    protected String stringWildcard = "%";
    protected String leftEscapeDelim = "[";
    protected String rightEscapeDelim = "]";
    protected Locale locale = InsightBackendConnector.DEFAULT_LOCALE;
    protected int queryMode = 0;
    protected String globalEscapeDelimiter = null;
    protected String unicodeFieldPrefix = null;
    protected boolean useLowerCaseCommand = false;
    protected boolean useLowerCaseCommandOnSearchValue = false;
    protected boolean useValueFromSubQuery = false;
    protected boolean useDistinctKeyword = true;
    protected boolean useSqlCountForThreshold = true;
    protected boolean useDistinctInCount = true;
    protected boolean useUniqueListCache = true;
    protected boolean caseInsensitiveComparison = true;
    protected boolean supportsFuzzyDates = false;
    protected TrinityConnector theBackendConnector = null;
    protected Hashtable backendParameters = null;
    protected DatabaseConnectorGenerator databaseConnectorGenerator = null;
    protected String databaseDebugFile = "DatabaseConnector.txt";
    protected boolean databaseDebugMode = false;
    protected String[] sortFieldNames = new String[0];
    protected int thumbnailSize = 0;
    protected Vector results = new Vector(0);
    protected int resultsIndex = 0;
    protected int resultsTotalRecords = 0;
    protected String mediaInfoTableName = "IRMEDIAINFO";
    protected int resultsStart = 0;
    protected int resultsOffset = 0;
    protected int resultsPageLength = 0;
    protected static int RESULTS_CACHE_TOTAL_PAGES = 7;
    protected static int RESULTS_CACHE_PREV_PAGES = 2;
    protected int imageCountOfGroup = 0;
    protected int imageCountGroupID = 0;
    protected boolean imageCountCached = false;
    protected boolean MEDIA_SECURITY_ENABLED = false;
    protected MediaSecurityHandler mediaSecurityHandler = null;

    public void setMediaSecurityEnabled(boolean bl) {
        this.MEDIA_SECURITY_ENABLED = bl;
    }

    public boolean isMediaSecurityEnabled() {
        return this.MEDIA_SECURITY_ENABLED;
    }

    public void setMediaSecurityHandler(MediaSecurityHandler mediaSecurityHandler) {
        this.mediaSecurityHandler = mediaSecurityHandler;
    }

    public void getConfigurationInfo(TrinityCollectionInfo trinityCollectionInfo) {
        if (this.theBackendConnector == null) {
            BrowserInsightTrinityProxy.debugFile("The backend connector is null.  Not getting configuration info.");
        } else {
            this.theBackendConnector.getConfigurationInfo(trinityCollectionInfo);
        }
    }

    public void getPrivs(TrinityCollectionInfo trinityCollectionInfo) {
        if (this.theBackendConnector == null) {
            BrowserInsightTrinityProxy.debugFile("The backend connector is null.  Keeping default priveleges.");
        } else {
            int n = trinityCollectionInfo.getProfileID();
            int n2 = trinityCollectionInfo.getUserCollection();
            int[] nArray = this.theBackendConnector.getPrivs(n, n2);
            BrowserInsightTrinityProxy.debugFile("Getting privs for (profileID, userCollection) = (" + n + ", " + n2);
            if (nArray != null && nArray.length >= 4) {
                trinityCollectionInfo.exportMaxResolution = nArray[0];
                trinityCollectionInfo.printResolution = nArray[1];
                trinityCollectionInfo.objectEditorPriv = nArray[2] == 1;
                boolean bl = trinityCollectionInfo.vocabEditorPriv = nArray[3] == 1;
            }
            if (nArray != null && nArray.length >= 8) {
                trinityCollectionInfo.maxViewableSize = nArray[4];
                trinityCollectionInfo.htmlExportPriv = nArray[5] == 1;
                trinityCollectionInfo.saveDBGroupsPriv = nArray[6] == 1;
                boolean bl = trinityCollectionInfo.deleteDBGroupsPriv = nArray[7] == 1;
            }
            if (nArray != null && nArray.length >= 9) {
                boolean bl = trinityCollectionInfo.mviPriv = nArray[8] == 1;
            }
            if (nArray != null && nArray.length >= 10) {
                boolean bl = trinityCollectionInfo.linkPriv = nArray[9] == 1;
            }
            if (nArray != null && nArray.length >= 11) {
                boolean bl = trinityCollectionInfo.editMpdPriv = nArray[10] == 1;
            }
            if (nArray != null && nArray.length >= 12) {
                trinityCollectionInfo.editPersonalCollections = nArray[11] == 1;
            }
            trinityCollectionInfo.presentationExportMaxResolution = nArray != null && nArray.length >= 13 ? nArray[12] : trinityCollectionInfo.getDefaultPresentationExportMaxResolution();
        }
    }

    public void setDatabaseDebugging(String string, boolean bl) {
        this.databaseDebugFile = string;
        this.databaseDebugMode = bl;
    }

    public void setProxyDebugging(String string, boolean bl) {
        DEBUG_FILENAME = string;
        DEBUG_MODE = bl;
    }

    public void setProxySearchPaging(int n, int n2) {
        if (n <= 0) {
            n = 1;
            n2 = 0;
        } else if (n2 >= n) {
            n2 = n - 1;
        }
        RESULTS_CACHE_TOTAL_PAGES = n;
        RESULTS_CACHE_PREV_PAGES = n2;
    }

    public void setSearchQueryLogging(String string, String string2, boolean bl, String string3) {
        QUERY_LOG_DIRECTORY = string;
        QUERY_LOG_FILENAME = string2;
        QUERY_LOG_MODE = bl;
        HOST_IP = string3;
    }

    public void setConnectString(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string2, String string3, String string4, String string5, int n, long l, String string6, String string7, String string8, String string9, int n2) {
        BrowserInsightTrinityProxy.debugFile("in setConnectString().");
        if (string != null) {
            this.connectString = string;
            this.useLowerCaseCommand = bl;
            this.useLowerCaseCommandOnSearchValue = bl2;
            this.useDistinctKeyword = bl3;
            this.useUniqueListCache = bl4;
            this.caseInsensitiveComparison = bl5;
            this.useValueFromSubQuery = bl6;
            this.leftEscapeDelim = string6;
            this.rightEscapeDelim = string7;
            this.globalEscapeDelimiter = string8;
            this.unicodeFieldPrefix = string9;
            this.queryMode = n2;
            BrowserInsightTrinityProxy.debugFile("useLowerCaseCommand is: " + bl);
            BrowserInsightTrinityProxy.debugFile("useLowerCaseCommandOnSearchValue is: " + bl2);
            BrowserInsightTrinityProxy.debugFile("useDistinctKeyword is: " + bl3);
            BrowserInsightTrinityProxy.debugFile("useUniqueListCache is: " + bl4);
            BrowserInsightTrinityProxy.debugFile("caseInsensitiveComparison is: " + bl5);
            BrowserInsightTrinityProxy.debugFile("useValueFromSubQuery is: " + bl6);
            BrowserInsightTrinityProxy.debugFile("Connect string set: '" + string + "'.");
            BrowserInsightTrinityProxy.debugFile("leftEscapeDelim set: '" + this.leftEscapeDelim + "'.");
            BrowserInsightTrinityProxy.debugFile("rightEscapeDelim set: '" + this.rightEscapeDelim + "'.");
            BrowserInsightTrinityProxy.debugFile("globalEscapeDelimiter set: '" + this.globalEscapeDelimiter + "'.");
            BrowserInsightTrinityProxy.debugFile("unicodeFieldPrefix set: '" + this.unicodeFieldPrefix + "'.");
            BrowserInsightTrinityProxy.debugFile("queryMode set: '" + this.queryMode + "'.");
            if (this.databaseConnectorGenerator == null) {
                this.databaseConnectorGenerator = new DatabaseConnectorGenerator();
                this.databaseConnectorGenerator.DEBUG_FILENAME = this.databaseDebugFile;
                this.databaseConnectorGenerator.DEBUG_MODE = this.databaseDebugMode;
            }
            this.databaseConnectorGenerator.setDefaultJdbcDriverName(string4);
            this.databaseConnectorGenerator.setDefaultJdbcUrlPrefix(string5);
            if (n > 1) {
                this.databaseConnectorGenerator.setDefaultJdbcConnectionPool(n);
            }
            this.databaseConnectorGenerator.getConnector(string, null, string2, string3);
            if (l > 0L) {
                this.databaseConnectorGenerator.setDefaultJdbcConnectionValidatePeriod(l);
            }
            this.msAccessMode = this.isMSAccessMode(string);
            if (this.msAccessMode) {
                BrowserInsightTrinityProxy.debugFile("Operating in MS Access mode.");
            }
            BrowserInsightTrinityProxy.debugFile("Constructing preliminary image group.");
            InsightBackendConnector insightBackendConnector = new InsightBackendConnector(this.getBackendParameters());
            BrowserInsightTrinityProxy.debugFile("Querying database for version number.");
            this.DB_VERSION = insightBackendConnector.getDatabaseVersion();
            BrowserInsightTrinityProxy.debugFile("DB version: " + this.DB_VERSION);
            BrowserInsightTrinityProxy.debugFile("Constructing final image group.");
            this.theBackendConnector = this.getBackendConnector(true);
            BrowserInsightTrinityProxy.debugFile("Final image group received, theBackendConnector: " + this.theBackendConnector);
        } else {
            BrowserInsightTrinityProxy.debugFile("setConnectString() received null.");
        }
    }

    public void finalize() {
        if (this.theBackendConnector != null) {
            this.theBackendConnector.finalize();
        }
    }

    public GroupInformation openGroup(Integer n, Vector vector, String string) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.openGroup(n, vector, string);
        }
        BrowserInsightTrinityProxy.debugFile("The backend connector is not defined.");
        return null;
    }

    public void openCollectionConfiguration(String string, String string2, String string3) {
        if (this.theBackendConnector != null) {
            this.theBackendConnector.openCollectionConfiguration(string, string2, string3);
        }
    }

    public String getCollectionConfigurationValue(String string) {
        String string2 = null;
        if (this.theBackendConnector != null) {
            string2 = this.theBackendConnector.getCollectionConfigurationValue(string);
        }
        BrowserInsightTrinityProxy.debugFile("CollectionConfigurationValue is: " + string2);
        return string2;
    }

    public void closeCollectionConfiguration() {
        if (this.theBackendConnector != null) {
            this.theBackendConnector.closeCollectionConfiguration();
        }
    }

    public String[] getCollectionList() {
        if (this.theBackendConnector != null) {
            List list = this.theBackendConnector.getCollectionList();
            String[] stringArray = new String[]{};
            if (InsightUtilities.isNonEmpty(list)) {
                stringArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    stringArray[i] = ((GroupInformation)list.get(i)).getGroupName();
                }
            }
            return stringArray;
        }
        BrowserInsightTrinityProxy.debugFile("getCollectionList(): The InsightBackendConnector is not defined.");
        return new String[0];
    }

    public String[] getGroupList(Integer n, String string) {
        if (this.theBackendConnector != null) {
            List list = this.theBackendConnector.getGroupList(n, string);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String string2 = ((GroupInformation)list.get(i)).getGroupName();
                if (string2 == null) continue;
                arrayList.add(string2);
            }
            return arrayList.toArray(new String[0]);
        }
        BrowserInsightTrinityProxy.debugFile("getGroupList(): The InsightBackendConnector is not defined.");
        return new String[0];
    }

    public List getTrinityList() {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getTrinityList();
        }
        BrowserInsightTrinityProxy.debugFile("getTrinityList(): The InsightBackendConnector is not defined.");
        return new Vector();
    }

    public List getUserGroupList() {
        if (this.theBackendConnector != null) {
            Vector vector = this.theBackendConnector.getUserGroupList();
            return vector;
        }
        BrowserInsightTrinityProxy.debugFile("getUserGroupList():  The InsightBackendConnector is not defined.");
        return new ArrayList();
    }

    public UserGroup isBrowserIPAddressInRange(UserGroupKey userGroupKey, String string) {
        UserGroup userGroup = null;
        List list = this.getUserGroupList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            UserGroup userGroup2 = (UserGroup)iterator.next();
            if (!userGroup2.equals(userGroupKey) || !userGroup2.isBrowserIPAddressInRange(string)) continue;
            userGroup = userGroup2;
            break;
        }
        return userGroup;
    }

    public int newGroup(Integer n, String string) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.newGroup(n, string);
        }
        BrowserInsightTrinityProxy.debugFile("newGroup(): The InsightBackendConnector is not defined.");
        return -3;
    }

    public int openGroup(Integer n, String string, String string2) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.openGroup(n, string, string2);
        }
        BrowserInsightTrinityProxy.debugFile("openGroup(): The InsightBackendConnector is not defined.");
        return -3;
    }

    public int saveAs(Integer n, String string, String string2) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.saveAs(n, string, string2, null);
        }
        BrowserInsightTrinityProxy.debugFile("saveAs(): The InsightBackendConnector is not defined.");
        return -3;
    }

    public int closeGroup() {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.closeGroup();
        }
        BrowserInsightTrinityProxy.debugFile("closeGroup(): The InsightBackendConnector is not defined.");
        return -3;
    }

    public boolean isOpen() {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.isOpen();
        }
        BrowserInsightTrinityProxy.debugFile("isOpen(): The InsightBackendConnector is not defined.");
        return false;
    }

    public int getType(int n) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getType(n);
        }
        BrowserInsightTrinityProxy.debugFile("getType(): The InsightBackendConnector is not defined.");
        return -3;
    }

    public int getGroupID() {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getGroupID();
        }
        BrowserInsightTrinityProxy.debugFile("getGroupID(): The InsightBackendConnector is not defined.");
        return 0;
    }

    public int getGroupID(Integer n, String string, String string2) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getGroupID(n, string, string2);
        }
        BrowserInsightTrinityProxy.debugFile("getGroupID(" + string + "): The InsightBackendConnector is not defined.");
        return -3;
    }

    public boolean addImage(int n, String string) {
        if (this.theBackendConnector != null) {
            try {
                return this.theBackendConnector.addImage(n, Long.parseLong(string));
            }
            catch (Exception exception) {
                BrowserInsightTrinityProxy.debugFile("Exception in addImage():\n" + InsightUtilities.getStackTrace(exception));
                return false;
            }
        }
        BrowserInsightTrinityProxy.debugFile("addImage(): The InsightBackendConnector is not defined.");
        return false;
    }

    public int removeImage(int n, String string) {
        if (this.theBackendConnector != null) {
            try {
                return this.theBackendConnector.removeImage(n, Long.parseLong(string));
            }
            catch (Exception exception) {
                BrowserInsightTrinityProxy.debugFile("Exception in removeImage():\n" + InsightUtilities.getStackTrace(exception));
                return -3;
            }
        }
        BrowserInsightTrinityProxy.debugFile("removeImage(): The InsightBackendConnector is not defined.");
        return -3;
    }

    public int getImageCountOfGroup(int n) {
        if (this.imageCountCached && this.imageCountGroupID == n) {
            return this.imageCountOfGroup;
        }
        if (this.theBackendConnector != null) {
            this.imageCountOfGroup = this.theBackendConnector.getImageCountOfGroup(n);
            this.imageCountGroupID = n;
            this.imageCountCached = true;
            return this.imageCountOfGroup;
        }
        BrowserInsightTrinityProxy.debugFile("getImageCountOfGroup(): The InsightBackendConnector is not defined.");
        return 0;
    }

    public long getMaxEntityChangeID() {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getMaxEntityChangeID();
        }
        BrowserInsightTrinityProxy.debugFile("getMaxEntityChangeID(): The InsightBackendConnector is not defined.");
        return 0L;
    }

    public Vector getImagesInGroup(GroupInformation groupInformation) {
        BrowserInsightTrinityProxy.debugFile("Getting images in group " + groupInformation.getGroupID() + ".");
        if (this.theBackendConnector == null) {
            BrowserInsightTrinityProxy.debugFile("No backend connector.");
            return null;
        }
        return this.theBackendConnector.getImagesInGroup(groupInformation.getGroupID(), groupInformation.getTci().getProfileID(), groupInformation.getTci().getUserCollection(), groupInformation.getTci());
    }

    public FieldCriterion[] getSearchCriteriaAsArray(String string, String string2, String string3) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getSearchCriteriaAsArray(string, string2, string3);
        }
        BrowserInsightTrinityProxy.debugFile("getSearchCriteriaAsArray(): The InsightBackendConnector is not defined.");
        return new FieldCriterion[0];
    }

    public void setSortFields(String[] stringArray) {
        this.sortFieldNames = stringArray;
    }

    private synchronized Vector getAllCollectionThumbnailResults(int n, int n2, String[] stringArray, String[] stringArray2, Object[] objectArray, int n3, int n4, int n5, int n6, String string, TrinityCollectionInfo trinityCollectionInfo) {
        int n7;
        int n8;
        String[] stringArray3;
        if (n < 1 || n > 100) {
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        if (stringArray2 == null) {
            return null;
        }
        boolean bl = false;
        if (allCollectionTotalRecords[n - 1] <= 0) {
            bl = true;
        }
        if (allCollectionGroupID[n - 1] != n2) {
            bl = true;
        }
        if (!bl) {
            stringArray3 = (String[])allCollectionFields[n - 1];
            if (stringArray3 == null) {
                bl = true;
            } else if (stringArray3.length != stringArray.length) {
                bl = true;
            } else {
                for (n8 = 0; n8 < stringArray.length; ++n8) {
                    if (stringArray3[n8].equals(stringArray[n8])) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (!bl) {
            stringArray3 = (String[])allCollectionSortFields[n - 1];
            if (stringArray3 == null) {
                bl = true;
            } else if (stringArray3.length != stringArray2.length) {
                bl = true;
            } else {
                for (n8 = 0; n8 < stringArray2.length; ++n8) {
                    if (stringArray3[n8].equals(stringArray2[n8])) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (!bl && allCollectionImageCount[n - 1] != (n7 = this.getImageCountOfGroup(n2))) {
            bl = true;
        }
        if (!bl) {
            long l = this.getMaxEntityChangeID();
            if (allCollectionMaxEntityChangeID[n - 1] != l) {
                BrowserInsightTrinityProxy.allCollectionMaxEntityChangeID[n - 1] = l;
                bl = true;
            }
        } else {
            BrowserInsightTrinityProxy.allCollectionMaxEntityChangeID[n - 1] = this.getMaxEntityChangeID();
        }
        if (bl) {
            TrinityConnector.clearuniqueListCache();
            int n9 = this.beginThumbnailQuery(n2, stringArray, objectArray, n3, n4, n5, n6, string, trinityCollectionInfo);
            if (n9 != -1) {
                return null;
            }
            BrowserInsightTrinityProxy.allCollectionTotalRecords[n - 1] = 0;
            BrowserInsightTrinityProxy.allCollectionResults[n - 1] = this.results;
            BrowserInsightTrinityProxy.allCollectionGroupID[n - 1] = n2;
            BrowserInsightTrinityProxy.allCollectionFields[n - 1] = stringArray;
            BrowserInsightTrinityProxy.allCollectionSortFields[n - 1] = stringArray2;
            BrowserInsightTrinityProxy.allCollectionImageCount[n - 1] = this.getImageCountOfGroup(n2);
            BrowserInsightTrinityProxy.allCollectionTotalRecords[n - 1] = this.resultsTotalRecords;
        }
        return allCollectionResults[n - 1];
    }

    private synchronized void checkAllCollectionMaxEntityChangeID(int n) {
        if (n < 1 || n > 100) {
            TrinityConnector.clearuniqueListCache();
        } else {
            long l = this.getMaxEntityChangeID();
            if (allCollectionMaxEntityChangeID[n - 1] != l) {
                BrowserInsightTrinityProxy.allCollectionMaxEntityChangeID[n - 1] = l;
                BrowserInsightTrinityProxy.allCollectionTotalRecords[n - 1] = 0;
                TrinityConnector.clearuniqueListCache();
            }
        }
    }

    private synchronized int getAllCollectionTotalRecords(int n) {
        if (n < 1 || n > 100) {
            return 0;
        }
        return allCollectionTotalRecords[n - 1];
    }

    public int beginBrowserThumbnailQuery(boolean bl, int n, boolean bl2, boolean bl3, int n2, String[] stringArray, Object[] objectArray, int n3, int n4, int n5, int n6, String string, TrinityCollectionInfo trinityCollectionInfo) {
        int n7 = -1;
        if (bl2 && n6 == this.resultsPageLength && this.resultsTotalRecords > 0) {
            if (this.resultsStart <= n5 && n5 <= this.resultsStart + this.resultsPageLength * (RESULTS_CACHE_TOTAL_PAGES - 1)) {
                this.resultsOffset = n5 - this.resultsStart;
                this.resultsPageLength = n6;
                this.resultsIndex = this.resultsOffset;
                return n7;
            }
            this.resultsStart = n5 - RESULTS_CACHE_PREV_PAGES * n6;
            if (this.resultsStart < 0) {
                this.resultsStart = 0;
            }
            while (this.resultsStart + n6 * (RESULTS_CACHE_TOTAL_PAGES - 1) > this.resultsTotalRecords) {
                this.resultsStart -= n6;
            }
            if (this.resultsStart < 0) {
                this.resultsStart = 0;
            }
        } else {
            this.resultsStart = n5;
            if (bl && !bl2 && n5 == 0 && !bl3 && RESULTS_CACHE_TOTAL_PAGES > 1) {
                this.imageCountCached = false;
                this.results = this.getAllCollectionThumbnailResults(n, n2, stringArray, this.sortFieldNames, objectArray, n3, n4, this.resultsStart, n6 * RESULTS_CACHE_TOTAL_PAGES, string, trinityCollectionInfo);
                this.resultsTotalRecords = this.getAllCollectionTotalRecords(n);
                if (this.resultsTotalRecords > 0) {
                    ThumbnailQuery thumbnailQuery = new ThumbnailQuery(new CollectionKeyWrapper(trinityCollectionInfo.getInstitutionID(), trinityCollectionInfo.getCollectionID(), trinityCollectionInfo.getVCID()), "", n2, null, null, objectArray, false, this.thumbnailSize, n3, n4, trinityCollectionInfo.isPersonalCollection());
                    thumbnailQuery.resultCount = this.resultsTotalRecords;
                    this.logSearchQuery(thumbnailQuery, string, trinityCollectionInfo);
                    this.resultsOffset = n5 - this.resultsStart;
                    this.resultsPageLength = n6;
                    this.resultsIndex = this.resultsOffset;
                    return n7;
                }
            }
        }
        n7 = bl3 ? this.beginFreeTextThumbnailQuery(n2, stringArray, (String[])objectArray, n3, n4, this.resultsStart, n6 * RESULTS_CACHE_TOTAL_PAGES, string, trinityCollectionInfo) : this.beginThumbnailQuery(n2, stringArray, objectArray, n3, n4, this.resultsStart, n6 * RESULTS_CACHE_TOTAL_PAGES, string, trinityCollectionInfo);
        this.resultsOffset = n5 - this.resultsStart;
        this.resultsPageLength = n6;
        this.resultsIndex = this.resultsOffset;
        return n7;
    }

    public int beginThumbnailQuery(int n, String[] stringArray, int n2, int n3, String string, TrinityCollectionInfo trinityCollectionInfo) {
        return this.beginThumbnailQuery(n, stringArray, new Object[0], n2, n3, false, 0, 0, string, trinityCollectionInfo);
    }

    public int beginThumbnailQuery(int n, String[] stringArray, Object[] objectArray, int n2, int n3, String string, TrinityCollectionInfo trinityCollectionInfo) {
        return this.beginThumbnailQuery(n, stringArray, objectArray, n2, n3, false, 0, 0, string, trinityCollectionInfo);
    }

    public int beginThumbnailQuery(int n, String[] stringArray, int n2, int n3, int n4, int n5, String string, TrinityCollectionInfo trinityCollectionInfo) {
        return this.beginThumbnailQuery(n, stringArray, new Object[0], n2, n3, true, n4, n5, string, trinityCollectionInfo);
    }

    public int beginThumbnailQuery(int n, String[] stringArray, Object[] objectArray, int n2, int n3, int n4, int n5, String string, TrinityCollectionInfo trinityCollectionInfo) {
        return this.beginThumbnailQuery(n, stringArray, objectArray, n2, n3, true, n4, n5, string, trinityCollectionInfo);
    }

    public int beginThumbnailQuery(int n, String[] stringArray, Object[] objectArray, int n2, int n3, boolean bl, int n4, int n5, String string, TrinityCollectionInfo trinityCollectionInfo) {
        BrowserInsightTrinityProxy.debugFile("in beginThumbnailQuery().");
        try {
            int n6;
            BrowserInsightTrinityProxy.debugFile("theFields: " + stringArray);
            if (stringArray != null) {
                BrowserInsightTrinityProxy.debugFile("theFields.length: " + stringArray.length);
            }
            for (n6 = 0; stringArray != null && n6 < stringArray.length; ++n6) {
                BrowserInsightTrinityProxy.debugFile("theFields[" + n6 + "]: " + stringArray[n6]);
            }
            BrowserInsightTrinityProxy.debugFile("sortFieldNames: " + this.sortFieldNames);
            if (this.sortFieldNames != null) {
                BrowserInsightTrinityProxy.debugFile("sortFieldNames.length: " + this.sortFieldNames.length);
            }
            for (n6 = 0; this.sortFieldNames != null && n6 < this.sortFieldNames.length; ++n6) {
                BrowserInsightTrinityProxy.debugFile("sortFieldNames[" + n6 + "]: " + this.sortFieldNames[n6]);
            }
            this.resultsIndex = 0;
            this.resultsTotalRecords = 0;
            this.resultsPageLength = n5;
            this.imageCountCached = false;
            if (this.theBackendConnector != null) {
                ThumbnailQuery thumbnailQuery = new ThumbnailQuery(new CollectionKeyWrapper(trinityCollectionInfo.getInstitutionID(), trinityCollectionInfo.getCollectionID(), trinityCollectionInfo.getVCID()), "", n, null, null, objectArray, false, this.thumbnailSize, n2, n3, trinityCollectionInfo.isPersonalCollection());
                this.results = this.theBackendConnector.doBrowserInsightThumbnailQuery(n, stringArray, this.sortFieldNames, objectArray, false, this.thumbnailSize, n2, n3, bl, n4, n5, trinityCollectionInfo.getUniqueCollectionID());
                thumbnailQuery.resultCount = this.resultsTotalRecords = this.theBackendConnector.getTotalRecords();
                this.logSearchQuery(thumbnailQuery, string, trinityCollectionInfo);
            } else {
                BrowserInsightTrinityProxy.debugFile("InsightBackendConnector not defined.");
                this.results = new Vector(0);
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("Exception in beginThumbnailQuery():\n" + InsightUtilities.convertStackTraceToString(exception));
            this.results = new Vector(0);
        }
        catch (Error error) {
            BrowserInsightTrinityProxy.debugFile("Error in beginThumbnailQuery():\n" + InsightUtilities.convertStackTraceToString(error));
            this.results = new Vector(0);
        }
        return -1;
    }

    public int beginFreeTextThumbnailQuery(int n, String[] stringArray, String[] stringArray2, int n2, int n3, String string, TrinityCollectionInfo trinityCollectionInfo) {
        return this.beginFreeTextThumbnailQuery(n, stringArray, stringArray2, n2, n3, false, 0, 0, string, trinityCollectionInfo);
    }

    public int beginFreeTextThumbnailQuery(int n, String[] stringArray, String[] stringArray2, int n2, int n3, int n4, int n5, String string, TrinityCollectionInfo trinityCollectionInfo) {
        return this.beginFreeTextThumbnailQuery(n, stringArray, stringArray2, n2, n3, true, n4, n5, string, trinityCollectionInfo);
    }

    public int beginFreeTextThumbnailQuery(int n, String[] stringArray, String[] stringArray2, int n2, int n3, boolean bl, int n4, int n5, String string, TrinityCollectionInfo trinityCollectionInfo) {
        BrowserInsightTrinityProxy.debugFile("in beginFreeTextThumbnailQuery().");
        try {
            int n6;
            BrowserInsightTrinityProxy.debugFile("theFields: " + stringArray);
            for (n6 = 0; stringArray != null && n6 < stringArray.length; ++n6) {
                BrowserInsightTrinityProxy.debugFile("theFields[" + n6 + "]: " + stringArray[n6]);
            }
            BrowserInsightTrinityProxy.debugFile("sortFieldNames: " + this.sortFieldNames);
            for (n6 = 0; this.sortFieldNames != null && n6 < this.sortFieldNames.length; ++n6) {
                BrowserInsightTrinityProxy.debugFile("sortFieldNames[" + n6 + "]: " + this.sortFieldNames[n6]);
            }
            this.resultsIndex = 0;
            this.resultsTotalRecords = 0;
            this.resultsPageLength = n5;
            this.imageCountCached = false;
            if (this.theBackendConnector != null) {
                ThumbnailQuery thumbnailQuery = new ThumbnailQuery(new CollectionKeyWrapper(trinityCollectionInfo.getInstitutionID(), trinityCollectionInfo.getCollectionID(), trinityCollectionInfo.getVCID()), "", n, null, null, stringArray2, true, this.thumbnailSize, n2, n3, trinityCollectionInfo.isPersonalCollection());
                this.results = this.theBackendConnector.doBrowserInsightThumbnailQuery(n, stringArray, this.sortFieldNames, stringArray2, true, this.thumbnailSize, n2, n3, bl, n4, n5, trinityCollectionInfo.getUniqueCollectionID());
                thumbnailQuery.resultCount = this.resultsTotalRecords = this.theBackendConnector.getTotalRecords();
                this.logSearchQuery(thumbnailQuery, string, trinityCollectionInfo);
            } else {
                BrowserInsightTrinityProxy.debugFile("InsightBackendConnector not defined.");
                this.results = new Vector(0);
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFileWriteStackTrack(exception);
            this.results = new Vector(0);
        }
        return -1;
    }

    public int getRecordCount() {
        return this.resultsTotalRecords;
    }

    public int firstItem() {
        this.resultsIndex = this.resultsOffset;
        return -1;
    }

    public int nextItem() {
        ++this.resultsIndex;
        return -1;
    }

    public int moveTo(int n) {
        if (this.resultsOffset + n < this.results.size() && n < this.resultsPageLength) {
            this.resultsIndex = this.resultsOffset + n;
            return -1;
        }
        return -4;
    }

    public boolean endOfList() {
        return this.resultsIndex >= this.results.size() || this.resultsIndex >= this.resultsOffset + this.resultsPageLength;
    }

    public long getObjectID() {
        long l = 0L;
        try {
            if (this.resultsIndex < this.results.size() && this.resultsIndex < this.resultsOffset + this.resultsPageLength) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(this.resultsIndex);
                l = insightSmartClientResults.objectID;
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("Exception at getObjectID(): " + exception);
        }
        return l;
    }

    public boolean isMultipage() {
        boolean bl = false;
        try {
            if (this.resultsIndex < this.results.size() && this.resultsIndex < this.resultsOffset + this.resultsPageLength) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(this.resultsIndex);
                bl = insightSmartClientResults.isMultipage();
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("Exception at isMultipage(): " + exception);
        }
        return bl;
    }

    public boolean isMultiview() {
        boolean bl = false;
        try {
            if (this.resultsIndex < this.results.size() && this.resultsIndex < this.resultsOffset + this.resultsPageLength) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(this.resultsIndex);
                bl = insightSmartClientResults.isMultiview();
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("Exception at isMultiview(): " + exception);
        }
        return bl;
    }

    public String getImageID() {
        String string = "-1";
        try {
            if (this.resultsIndex < this.results.size() && this.resultsIndex < this.resultsOffset + this.resultsPageLength) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(this.resultsIndex);
                string = insightSmartClientResults.imageID + "";
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("Exception at getImageID():\n" + InsightUtilities.getStackTrace(exception));
        }
        return string;
    }

    public int getImageWidth() {
        int n = 0;
        try {
            if (this.resultsIndex < this.results.size() && this.resultsIndex < this.resultsOffset + this.resultsPageLength) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(this.resultsIndex);
                n = insightSmartClientResults.thumbDimension.width;
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("Exception at getImageWidth(): " + exception);
        }
        return n;
    }

    public int getImageHeight() {
        int n = 0;
        try {
            if (this.resultsIndex < this.results.size() && this.resultsIndex < this.resultsOffset + this.resultsPageLength) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(this.resultsIndex);
                n = insightSmartClientResults.thumbDimension.height;
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("Exception at getImageHeight(): " + exception);
        }
        return n;
    }

    public String getThumbnail() {
        String string = "Error: BITP/getThumbnail().";
        try {
            if (this.resultsIndex < this.results.size() && this.resultsIndex < this.resultsOffset + this.resultsPageLength) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(this.resultsIndex);
                string = insightSmartClientResults.thumbnailURL;
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("Exception at getThumbnail(): " + exception);
        }
        return string;
    }

    public String getText(int n) {
        BrowserInsightTrinityProxy.debugFile("in getText(" + n + ").");
        String string = "Error: BITP/getText(" + n + ").";
        try {
            if (this.resultsIndex < this.results.size() && this.resultsIndex < this.resultsOffset + this.resultsPageLength) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(this.resultsIndex);
                string = insightSmartClientResults.fieldData[n];
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("Exception at getText(): " + exception);
        }
        BrowserInsightTrinityProxy.debugFile("Returning text: '" + string + "'.");
        return string;
    }

    public Field[] getFieldList(Integer n) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getFieldList(n);
        }
        BrowserInsightTrinityProxy.debugFile("getFieldList(): The InsightBackendConnector is not defined.");
        return new Field[0];
    }

    public Field[] getSearchableFieldList(Integer n) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getSearchableFieldList(n);
        }
        BrowserInsightTrinityProxy.debugFile("getSearchableFieldList(): The InsightBackendConnector is not defined.");
        return new Field[0];
    }

    public Field[] getPickableFieldList(Integer n) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getPickableFieldList(n);
        }
        BrowserInsightTrinityProxy.debugFile("getPickableFieldList(): The InsightBackendConnector is not defined.");
        return new Field[0];
    }

    public String[] getUniqueList(int n, int n2, int n3, String string, boolean bl) {
        BrowserInsightTrinityProxy.debugFile("in getUniqueList, theBackendConnector: " + this.theBackendConnector);
        if (this.theBackendConnector != null) {
            if (bl) {
                this.checkAllCollectionMaxEntityChangeID(n);
            }
            Object[] objectArray = this.theBackendConnector.getUniqueList(n, n2, n3, 3, string, -1, bl, null);
            Vector vector = InsightUtilities.toVector(objectArray);
            Collections.sort(vector);
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = ((CriterionValue)vector.get(i)).getDisplayValue();
            }
            return stringArray;
        }
        BrowserInsightTrinityProxy.debugFile("getUniqueList(): The InsightBackendConnector is not defined.");
        return new String[0];
    }

    public String getFullInformationWrap(long l, String string) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getFullInformationWrap(l, string);
        }
        BrowserInsightTrinityProxy.debugFile("getFullInformationWrap(): The InsightBackendConnector is not defined.");
        return "ERROR BITP/getFullInformationWrap";
    }

    public String[] getFullInformation(long l) {
        if (this.theBackendConnector != null) {
            FieldValue[] fieldValueArray = this.theBackendConnector.getFullInformation(l);
            Vector<String> vector = new Vector<String>(fieldValueArray.length * 2);
            for (int i = 0; i < fieldValueArray.length; ++i) {
                vector.addElement(fieldValueArray[i].displayName);
                vector.addElement(fieldValueArray[i].value);
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        BrowserInsightTrinityProxy.debugFile("getFullInformation(): The InsightBackendConnector is not defined.");
        return new String[0];
    }

    public String[] getFullMediaData(String string, int n) {
        try {
            return this.getFullMediaData(Long.parseLong(string), n);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public String[] getFullMediaData(long l, int n) {
        if (this.theBackendConnector != null) {
            MediaMetaData mediaMetaData = this.theBackendConnector.getFullMediaData(l, n);
            Vector vector = mediaMetaData.getMediaFields();
            if (vector == null) {
                vector = new Vector();
            }
            String[] stringArray = new String[vector.size() * 2];
            for (int i = 0; i < vector.size(); ++i) {
                MediaField mediaField = (MediaField)vector.elementAt(i);
                if (mediaField == null) continue;
                stringArray[i * 2] = mediaField.getName();
                stringArray[i * 2 + 1] = mediaField.getValue();
            }
            return stringArray;
        }
        BrowserInsightTrinityProxy.debugFile("getFullMediaData(): The InsightBackendConnector is not defined.");
        return new String[0];
    }

    public String getArtistInformationWrap(String string) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.getArtistInformationWrap(string);
        }
        BrowserInsightTrinityProxy.debugFile("getArtistInformationWrap(): The InsightBackendConnector is not defined.");
        return "ERROR BITP/getArtistInformationWrap()";
    }

    public int getMaxResolutionSize(String string) {
        int n = -1;
        try {
            if (this.theBackendConnector != null) {
                n = this.theBackendConnector.getMaxResolutionSize(Long.parseLong(string));
            }
        }
        catch (Exception exception) {
            BrowserInsightTrinityProxy.debugFile("getMaxResolutionSize: Error in getting the max resolution size for image ID: " + string);
        }
        return n;
    }

    public Object[] getURLsAndDimensions(String[] stringArray, int n, int n2) {
        if (this.theBackendConnector != null) {
            try {
                return this.theBackendConnector.getURLsAndDimensions(stringArray, n, n2);
            }
            catch (Exception exception) {
                BrowserInsightTrinityProxy.debugFile("Exception in getURLsAndDimensions() for images:\n" + InsightUtilities.getStackTrace(exception));
                return new Object[stringArray.length];
            }
        }
        BrowserInsightTrinityProxy.debugFile("getURLsAndDimensions() for images: The InsightBackendConnector is not defined.");
        return new Object[stringArray.length];
    }

    public Object[] getURLsAndDimensions(String string, int n, int n2, Integer n3) {
        if (this.theBackendConnector != null) {
            try {
                return this.theBackendConnector.getURLsAndDimensions(Long.parseLong(string), n, n2, n3);
            }
            catch (Exception exception) {
                BrowserInsightTrinityProxy.debugFile("Exception in getURLsAndDimensions():\n" + InsightUtilities.getStackTrace(exception));
                return new Object[0];
            }
        }
        BrowserInsightTrinityProxy.debugFile("getURLsAndDimensions(): The InsightBackendConnector is not defined.");
        return new Object[0];
    }

    public String getImage(String string, int n, int n2, int n3) {
        if (this.theBackendConnector != null) {
            try {
                return this.theBackendConnector.getImage(Long.parseLong(string), n, n2, n3);
            }
            catch (Exception exception) {
                BrowserInsightTrinityProxy.debugFile("Exception in getImage():\n" + InsightUtilities.getStackTrace(exception));
                return "ERROR BITP/getImage()";
            }
        }
        BrowserInsightTrinityProxy.debugFile("getImage(): The InsightBackendConnector is not defined.");
        return "ERROR BITP/getImage()";
    }

    public String getMediaTicket(String string, TrinityCollectionInfo trinityCollectionInfo) {
        String string2 = null;
        if (this.theBackendConnector != null) {
            BrowserInsightTrinityProxy.debugFile("in getMediaTicket()");
            int[] nArray = this.theBackendConnector.getPrivs(trinityCollectionInfo.getProfileID(), trinityCollectionInfo.getUserCollection());
            if (nArray != null && nArray.length >= 5) {
                int n = nArray[4];
                BrowserInsightTrinityProxy.debugFile("Retrieved max resolution: " + n);
                if (this.MEDIA_SECURITY_ENABLED && this.mediaSecurityHandler != null) {
                    try {
                        string2 = MediaSecurityHandler.generateTicket();
                        String string3 = MediaSecurityUtilities.getRegisterTicketParams(string2, this.mediaSecurityHandler.getTicketDuration(), n, string);
                        String string4 = this.mediaSecurityHandler.encrypt(string3);
                        BrowserInsightTrinityProxy.debugFile("ticketParams = " + string3);
                        BrowserInsightTrinityProxy.debugFile("base url = " + this.mediaSecurityHandler.getServletBaseUrl());
                        BrowserInsightTrinityProxy.debugFile("encrypt  = " + string4);
                        MediaSecurityUtilities.registerTicket(this.mediaSecurityHandler.getServletBaseUrl(), string4);
                    }
                    catch (Exception exception) {
                        BrowserInsightTrinityProxy.debugFile("Exception in getMediaSecurityTicket():\n" + InsightUtilities.getStackTrace(exception));
                        string2 = null;
                    }
                }
                BrowserInsightTrinityProxy.debugFile("Registered ticket: " + string2);
            } else {
                BrowserInsightTrinityProxy.debugFile("Failed to get max resolution, returning ticket: " + string2);
            }
        } else {
            BrowserInsightTrinityProxy.debugFile("getMediaTicket(): The InsightBackendConnector is not defined.");
        }
        trinityCollectionInfo.setMediaTicket(string2);
        return string2;
    }

    public int attemptBrowserLogin(String string, String string2, int n) {
        if (this.theBackendConnector != null) {
            return this.theBackendConnector.attemptBrowserLogin(string, string2, n);
        }
        BrowserInsightTrinityProxy.debugFile("attemptBrowserLogin(): The InsightBackendConnector is not defined.");
        return 0;
    }

    public Hashtable getBackendParameters() {
        return this.getBackendParameters(false);
    }

    public Hashtable getBackendParameters(boolean bl) {
        if (this.backendParameters == null || bl) {
            this.backendParameters = InsightBackendConnector.packageParameters(this.connectString, this.msAccessMode, this.charWildcard, this.stringWildcard, this.leftEscapeDelim, this.rightEscapeDelim, this.locale, this.queryMode, this.globalEscapeDelimiter, this.unicodeFieldPrefix, this.useLowerCaseCommand, this.useLowerCaseCommandOnSearchValue, this.useValueFromSubQuery, false, this.useDistinctKeyword, this.useUniqueListCache, this.caseInsensitiveComparison, this.useSqlCountForThreshold, this.useDistinctInCount, this.supportsFuzzyDates, this.databaseConnectorGenerator, this.mediaInfoTableName, null);
        }
        return this.backendParameters;
    }

    public int getBackendConnectionPoolSize() {
        return this.databaseConnectorGenerator.getConnectionPoolSize();
    }

    protected InsightBackendConnector getBackendConnector() {
        return this.getBackendConnector(false);
    }

    protected TrinityConnector getBackendConnector(boolean bl) {
        if (this.DB_VERSION >= TrinityConnector.TRINITY_VERSION) {
            BrowserInsightTrinityProxy.debugFile("Creating and returning a TrinityConnector.");
            return new TrinityConnector(this.getBackendParameters(bl));
        }
        BrowserInsightTrinityProxy.debugFile("Server version pre trinity not supported.");
        return null;
    }

    protected boolean isMSAccessMode(String string) {
        String string2 = "FIL=MS Access";
        String string3 = "FIL=MSAccess";
        if (BrowserInsightTrinityProxy.indexOfIgnoreCase(string, string2) > -1) {
            return true;
        }
        return BrowserInsightTrinityProxy.indexOfIgnoreCase(string, string3) > -1;
    }

    protected void logSearchQuery(ThumbnailQuery thumbnailQuery, String string, TrinityCollectionInfo trinityCollectionInfo) {
        String string2;
        if (QUERY_LOG_MODE && (string2 = this.getLogFileName(trinityCollectionInfo.getCollectionID())) != null) {
            string2 = QUERY_LOG_DIRECTORY + string2;
            ThumbnailQueryLogger.logSearchQuery(string2, "Browser", thumbnailQuery, trinityCollectionInfo.getCollectionName(), HOST_IP, "UNKNOWN", string, trinityCollectionInfo.getUserGroupName(), trinityCollectionInfo.getUserName());
        }
    }

    protected String getLogFileName(String string) {
        String string2 = null;
        if (QUERY_LOG_FILENAME != null && QUERY_LOG_FILENAME.length() > 0 && (string2 = (String)logFileNames.get(string)) == null) {
            string2 = "CID-" + string + "_" + QUERY_LOG_FILENAME;
            logFileNames.put(string, string2);
        }
        return string2;
    }

    public static void debugFile(String string) {
        if (DEBUG_MODE && DEBUG_FILENAME != null) {
            try {
                FileWriter fileWriter = new FileWriter(DEBUG_FILENAME, true);
                fileWriter.write(new Date() + ": " + string + "\r\n");
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void debugFileWriteStackTrack(Exception exception) {
        if (DEBUG_FILENAME != null && exception != null) {
            try {
                FileWriter fileWriter = new FileWriter(DEBUG_FILENAME, true);
                fileWriter.write(new Date() + ": " + "\r\n");
                exception.printStackTrace(new PrintWriter(fileWriter));
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        int n = -1;
        if (string != null && string2 != null && string.length() >= string2.length()) {
            int n2 = 0;
            while (n2 + string2.length() <= string.length()) {
                if (string.regionMatches(true, n2, string2, 0, string2.length())) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    public static void main(String[] stringArray) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string;
            String string2;
            do {
                System.out.println("\nEnter a source string: ");
                string2 = bufferedReader.readLine();
                System.out.println("\nEnter a target string: ");
                string = bufferedReader.readLine();
                int n = BrowserInsightTrinityProxy.indexOfIgnoreCase(string2, string);
                if (n > -1) {
                    System.out.println("String '" + string + "' was found in '" + string2 + "' at index " + n);
                    continue;
                }
                System.out.println("String '" + string + "' was not found in '" + string2 + "'.");
            } while (string2 != null && string != null);
        }
        catch (IOException iOException) {
            System.out.println("Unable to read string.");
        }
    }
}

