/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.Debug;
import com.luna.insight.server.TrinityCollectionInfo;
import java.util.List;
import java.util.Vector;

public class VirtualCollectionInfo
extends TrinityCollectionInfo {
    static final long serialVersionUID = 6443298765463618L;
    public static final String NO_VCID = "NA";
    protected List collections = new Vector(0);

    public static void debugOut(String string) {
        VirtualCollectionInfo.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("VCI: " + string, n);
    }

    public static Vector flattenSingleInfo(TrinityCollectionInfo trinityCollectionInfo) {
        Vector vector = new Vector();
        VirtualCollectionInfo.flattenCollectionList(trinityCollectionInfo, vector, true);
        return vector;
    }

    public static Vector flattenCollectionList(List list) {
        return VirtualCollectionInfo.flattenCollectionList(list, true);
    }

    public static Vector flattenCollectionList(List list, boolean bl) {
        Vector vector = new Vector();
        for (int i = 0; i < list.size(); ++i) {
            VirtualCollectionInfo.flattenCollectionList((TrinityCollectionInfo)list.get(i), vector, bl);
        }
        return vector;
    }

    public static void flattenCollectionList(TrinityCollectionInfo trinityCollectionInfo, List list, boolean bl) {
        if (trinityCollectionInfo != null) {
            if (trinityCollectionInfo instanceof VirtualCollectionInfo) {
                List list2 = ((VirtualCollectionInfo)trinityCollectionInfo).getCollections();
                for (int i = 0; i < list2.size(); ++i) {
                    VirtualCollectionInfo.flattenCollectionList((TrinityCollectionInfo)list2.get(i), list, bl);
                }
            } else {
                boolean bl2 = false;
                if (!bl) {
                    for (int i = 0; i < list.size(); ++i) {
                        TrinityCollectionInfo trinityCollectionInfo2 = (TrinityCollectionInfo)list.get(i);
                        if (!CollectionKeyDistributor.keysAgree(trinityCollectionInfo, trinityCollectionInfo2)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2) {
                    list.add(trinityCollectionInfo);
                }
            }
        }
    }

    public static String makeVCID(String string, String string2) {
        return string + "-" + string2;
    }

    public static String makeVCID(int n) {
        return "VirtualServer-" + n;
    }

    public VirtualCollectionInfo(int n, String string, String string2, String string3, String string4, int n2, String string5, String string6, int n3, String string7, String string8, int n4) {
        super(n, string, string2, string3, n2, string5, string6, n3, string7, string8, n4);
        this.vcID = string4;
        this.setVirtualCollection(this);
    }

    public void setCollections(List vector) {
        this.collections = vector;
        if (vector == null) {
            vector = new Vector(0);
        }
        if (!vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)vector.get(i);
                trinityCollectionInfo.setVirtualCollection(this);
            }
        }
    }

    public List getCollections() {
        return this.collections;
    }

    public void replaceCollection(TrinityCollectionInfo trinityCollectionInfo) {
        int n = this.collections.indexOf(trinityCollectionInfo);
        if (n > -1) {
            TrinityCollectionInfo trinityCollectionInfo2 = (TrinityCollectionInfo)this.collections.get(n);
            trinityCollectionInfo.sessionResults = trinityCollectionInfo2.sessionResults;
            trinityCollectionInfo.userGroupShells = trinityCollectionInfo2.userGroupShells;
            if (trinityCollectionInfo2.isDescriptionDataDefined()) {
                trinityCollectionInfo.setShortDescription(trinityCollectionInfo2.getShortDescription());
                trinityCollectionInfo.setLongDescriptionURL(trinityCollectionInfo2.getLongDescriptionURL());
                trinityCollectionInfo.setDescriptionDataDefined();
            }
            this.collections.set(n, trinityCollectionInfo);
        }
    }

    public void combineCollectionConfig() {
        for (int i = 0; i < this.collections.size(); ++i) {
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)this.collections.get(i);
            if (!trinityCollectionInfo.isInfoComplete()) continue;
            this.setInitialActivity(trinityCollectionInfo.getInitialActivity());
            this.setInitialGroupOpen(trinityCollectionInfo.getInitialGroupOpen());
            this.setDisplayArtistStories(trinityCollectionInfo.getDisplayArtistStories());
            this.setVerticalBarX(trinityCollectionInfo.getVerticalBarX());
            this.setHorizontalBarY(trinityCollectionInfo.getHorizontalBarY());
            this.setBackgroundColor(trinityCollectionInfo.getBackgroundColor());
            this.setUserCollection(trinityCollectionInfo.getUserCollection());
            this.setLargeThumbnailThreshold(trinityCollectionInfo.getLargeThumbnailThreshold());
            this.setDefaultViewResolution(trinityCollectionInfo.getDefaultViewResolution());
            this.setGroupTopInset(trinityCollectionInfo.getGroupTopInset());
            this.setGroupLeftInset(trinityCollectionInfo.getGroupLeftInset());
            this.setGroupSpacingH(trinityCollectionInfo.getGroupSpacingH());
            this.setGroupSpacingV(trinityCollectionInfo.getGroupSpacingV());
            this.setMenuXPosition(trinityCollectionInfo.getMenuXPosition());
            this.setMaximumWindows(trinityCollectionInfo.getMaximumWindows());
            this.setInterWindowSpacing(trinityCollectionInfo.getInterWindowSpacing());
            this.setMinImageWindowSize(trinityCollectionInfo.getMinImageWindowSize());
            this.setDragSpeedCoeffecient(trinityCollectionInfo.getDragSpeedCoeffecient());
            this.setInitialGroupROnly(trinityCollectionInfo.getInitialGroupROnly());
            this.setHelpGroup(trinityCollectionInfo.getHelpGroup());
            this.setHelpImage(trinityCollectionInfo.getHelpImage());
            this.setSimultaneousIWLoads(trinityCollectionInfo.getSimultaneousIWLoads());
            this.setSimultaneousGWLoads(trinityCollectionInfo.getSimultaneousGWLoads());
            this.setMacWidthAdjustment(trinityCollectionInfo.getMacWidthAdjustment());
            this.setBGURL(trinityCollectionInfo.getBGURL());
            this.setScaleFast(trinityCollectionInfo.getScaleFast());
            this.setServerVersion(trinityCollectionInfo.getServerVersion());
            this.setRemoteLaunchBaseUrl(trinityCollectionInfo.getRemoteLaunchBaseUrl());
            this.setSearchCriteria(trinityCollectionInfo.getSearchCriteria());
            this.dataFieldMappings = trinityCollectionInfo.dataFieldMappings;
            this.sortFieldMappings = trinityCollectionInfo.sortFieldMappings;
            this.setInfoComplete();
            break;
        }
    }

    public void setMinimumAgreedPrivileges() {
        for (int i = 0; i < this.collections.size(); ++i) {
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)this.collections.get(i);
            if (i == 0) {
                this.exportMaxResolution = trinityCollectionInfo.exportMaxResolution;
                this.printResolution = trinityCollectionInfo.printResolution;
                this.maxViewableSize = trinityCollectionInfo.maxViewableSize;
                this.objectEditorPriv = trinityCollectionInfo.objectEditorPriv;
                this.vocabEditorPriv = trinityCollectionInfo.vocabEditorPriv;
                this.htmlExportPriv = trinityCollectionInfo.htmlExportPriv;
                this.saveDBGroupsPriv = trinityCollectionInfo.saveDBGroupsPriv;
                this.deleteDBGroupsPriv = trinityCollectionInfo.deleteDBGroupsPriv;
                this.mviPriv = trinityCollectionInfo.mviPriv;
                this.linkPriv = trinityCollectionInfo.linkPriv;
                this.presentationExportMaxResolution = trinityCollectionInfo.presentationExportMaxResolution;
                continue;
            }
            if (trinityCollectionInfo.exportMaxResolution < this.exportMaxResolution) {
                this.exportMaxResolution = trinityCollectionInfo.exportMaxResolution;
            }
            if (trinityCollectionInfo.printResolution < this.printResolution) {
                this.printResolution = trinityCollectionInfo.printResolution;
            }
            if (trinityCollectionInfo.maxViewableSize < this.maxViewableSize) {
                this.maxViewableSize = trinityCollectionInfo.maxViewableSize;
            }
            if (trinityCollectionInfo.presentationExportMaxResolution < this.presentationExportMaxResolution) {
                this.presentationExportMaxResolution = trinityCollectionInfo.presentationExportMaxResolution;
            }
            if (!trinityCollectionInfo.objectEditorPriv) {
                this.objectEditorPriv = false;
            }
            if (!trinityCollectionInfo.vocabEditorPriv) {
                this.vocabEditorPriv = false;
            }
            if (!trinityCollectionInfo.htmlExportPriv) {
                this.htmlExportPriv = false;
            }
            if (!trinityCollectionInfo.saveDBGroupsPriv) {
                this.saveDBGroupsPriv = false;
            }
            if (!trinityCollectionInfo.deleteDBGroupsPriv) {
                this.deleteDBGroupsPriv = false;
            }
            if (!trinityCollectionInfo.mviPriv) {
                this.mviPriv = false;
            }
            if (trinityCollectionInfo.linkPriv) continue;
            this.linkPriv = false;
        }
    }
}

