/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.InsightUtilities;

public class UniqueListResult
implements Comparable {
    protected CriterionValue value;
    protected String comparableValue;
    protected int fieldType = 1;

    public UniqueListResult(CriterionValue criterionValue, int n) {
        this.value = criterionValue;
        this.fieldType = n;
        this.comparableValue = criterionValue.getDisplayValue().toLowerCase();
    }

    public boolean equals(Object object) {
        if (object instanceof UniqueListResult) {
            UniqueListResult uniqueListResult = (UniqueListResult)object;
            return uniqueListResult.getValue().getSearchValue().equalsIgnoreCase(this.value.getSearchValue());
        }
        return super.equals(object);
    }

    public String getComparableValue() {
        return this.comparableValue;
    }

    public int compareTo(Object object) {
        UniqueListResult uniqueListResult = (UniqueListResult)object;
        if (this.fieldType == 1) {
            return InsightUtilities.compareStrings(this.getComparableValue(), uniqueListResult.getComparableValue());
        }
        try {
            return Integer.parseInt(this.getComparableValue()) - Integer.parseInt(uniqueListResult.getComparableValue());
        }
        catch (Exception exception) {
            return InsightUtilities.compareStrings(this.getComparableValue(), uniqueListResult.getComparableValue());
        }
    }

    public CriterionValue getValue() {
        return this.value;
    }
}

