/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.server.CollectionInfo;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.VirtualCollectionInfo;
import com.luna.insight.server.inscribe.MedePrivileges;
import com.luna.insight.server.usergroup.UserGroupSessionResults;
import com.luna.insight.server.usergroup.UserGroupShell;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class TrinityCollectionInfo
extends CollectionInfo
implements CollectionKey {
    static final long serialVersionUID = 1406455215596082165L;
    private ContextMap contextMap = new ContextMap();
    protected String userGroupName = "(unnamed)";
    protected String userGroupCodeKey = "(unspecified)";
    protected int userGroupProfileID = 0;
    protected String groupDisplayName = "";
    protected String countryCodeUserServer = "";
    protected String languageCodeUserServer = "";
    protected Locale localeUserServer;
    protected Locale localeCollectionServer;
    protected String sessionGroupName = "";
    protected String sessionCodeKey = "";
    public int exportMaxResolution = 4;
    public int printResolution = 4;
    public boolean objectEditorPriv = false;
    public boolean vocabEditorPriv = false;
    public int maxViewableSize = 8;
    public boolean htmlExportPriv = false;
    public boolean saveDBGroupsPriv = true;
    public boolean deleteDBGroupsPriv = true;
    public boolean mviPriv = false;
    public boolean linkPriv = false;
    public boolean editMpdPriv = false;
    public boolean editPersonalCollections = false;
    public int presentationExportMaxResolution = 8;
    public boolean supportsLinkSearching = false;
    public boolean supportsKeywordsFieldSearching = true;
    public transient UserGroupSessionResults sessionResults = null;
    public UserGroupShell[] userGroupShells = null;
    public Vector dataFieldMappings = null;
    public Vector sortFieldMappings = null;
    private VirtualCollectionInfo vci = null;
    protected String vcID = null;
    protected TrinityCollectionInfo parentTCI = null;
    protected List virtualCollectionGroups = null;
    protected MedePrivileges medePrivileges = null;
    protected String collectionUniqueID = null;
    protected Integer uniqueCollectionID = null;
    protected int nativeStandardID = 0;
    protected String copyrightStatement = null;
    protected boolean forceCollectionName = true;
    protected InsightVersion serverVersion;
    protected Vector serverSerializedClasses;
    protected boolean mediaSecurityEnabled = false;
    protected boolean mediaSecurityTicketlessMode = false;
    protected String mediaTicket = "";
    protected Hashtable helpFileNames = new Hashtable();
    protected String remoteLaunchBaseUrl = null;
    protected String remoteLaunchHyperlinkTemplate = null;
    protected String browserRtlUrl = null;
    protected boolean isPersonalCollection = false;
    protected InsightUser pcOwner = null;
    protected String pcOwnerSessionGroupName = null;
    protected String pcOwnerSessionCodeKey = null;
    protected int pcUsrGrpMemberPrivs = 0;
    protected int pcNonUsrGrpMemberPrivs = 0;
    protected boolean licensedPersonalCollectionServer = false;
    protected boolean canCreatePersonalCollections = false;
    protected String createdTimestamp = null;

    public static void debugOut(String string) {
        TrinityCollectionInfo.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("TCI: " + string, n);
    }

    public static TrinityCollectionInfo getTci(List list, CollectionKey collectionKey) {
        if (collectionKey != null) {
            TrinityCollectionInfo trinityCollectionInfo = null;
            for (int i = 0; list != null && i < list.size(); ++i) {
                trinityCollectionInfo = (TrinityCollectionInfo)list.get(i);
                if (!CollectionKeyDistributor.keysAgree(trinityCollectionInfo, collectionKey)) continue;
                return trinityCollectionInfo;
            }
        }
        return null;
    }

    public static TrinityCollectionInfo getTci(List list, String string) {
        if (string != null) {
            TrinityCollectionInfo trinityCollectionInfo = null;
            for (int i = 0; list != null && i < list.size(); ++i) {
                trinityCollectionInfo = (TrinityCollectionInfo)list.get(i);
                if (!string.equalsIgnoreCase(trinityCollectionInfo.getCollectionName())) continue;
                return trinityCollectionInfo;
            }
        }
        return null;
    }

    public static TrinityCollectionInfo getTciByCollectionUniqueID(List list, String string) {
        if (string != null) {
            TrinityCollectionInfo trinityCollectionInfo = null;
            for (int i = 0; list != null && i < list.size(); ++i) {
                trinityCollectionInfo = (TrinityCollectionInfo)list.get(i);
                if (InsightUtilities.compareStrings(string, trinityCollectionInfo.getCollectionUniqueID()) == 0) {
                    return trinityCollectionInfo;
                }
                if (InsightUtilities.compareStrings(string, trinityCollectionInfo.getTriplet()) != 0) continue;
                return trinityCollectionInfo;
            }
        }
        return null;
    }

    public String getTriplet() {
        return CoreUtilities.constructTripletText(this.getInstitutionID(), this.getCollectionID(), this.getVCID());
    }

    public static List groupByServer(List list) {
        Vector vector = new Vector(0);
        Vector<TrinityCollectionInfo> vector2 = null;
        TrinityCollectionInfo trinityCollectionInfo = null;
        TrinityCollectionInfo trinityCollectionInfo2 = null;
        for (int i = 0; list != null && i < list.size(); ++i) {
            trinityCollectionInfo2 = (TrinityCollectionInfo)list.get(i);
            for (int j = 0; !(j >= vector.size() || (vector2 = (Vector<TrinityCollectionInfo>)vector.get(j)) != null && vector2.size() > 0 && (trinityCollectionInfo = (TrinityCollectionInfo)vector2.get(0)).getServerAddress().equalsIgnoreCase(trinityCollectionInfo2.getServerAddress()) && trinityCollectionInfo.getServerPort() == trinityCollectionInfo2.getServerPort()); ++j) {
                vector2 = null;
            }
            if (vector2 == null) {
                vector2 = new Vector<TrinityCollectionInfo>(0);
                vector.add(vector2);
            }
            vector2.add(trinityCollectionInfo2);
        }
        return vector;
    }

    public TrinityCollectionInfo() {
    }

    public TrinityCollectionInfo(String string, int n) {
        this(-1, "Not Specified", "Not Specified", "Not Specified", -1, "Not Specified", string, n, "Not Specified", "Not Specified", -1);
    }

    public TrinityCollectionInfo(int n, String string, String string2, String string3, int n2, String string4, String string5, int n3, String string6, String string7, int n4) {
        this.userID = n;
        this.userName = string;
        this.institutionID = string2;
        this.collectionID = string3;
        this.serverID = n2;
        this.collectionName = string4;
        this.serverAddress = string5;
        this.serverPort = n3;
        this.userGroupName = string6;
        this.userGroupCodeKey = string7;
        this.userGroupProfileID = n4;
    }

    public int getNativeStandardID() {
        return this.nativeStandardID;
    }

    public String getUserGroupName() {
        return this.userGroupName;
    }

    public String getUserGroupCodeKey() {
        return this.userGroupCodeKey;
    }

    public int getUserGroupProfileID() {
        return this.userGroupProfileID;
    }

    public String getSessionGroupName() {
        return this.sessionGroupName;
    }

    public String getSessionCodeKey() {
        return this.sessionCodeKey;
    }

    public String getGroupDisplayName() {
        return this.groupDisplayName;
    }

    public Locale getLocaleUserServer() {
        return this.localeUserServer;
    }

    public Locale getLocaleCollectionServer() {
        return this.localeCollectionServer;
    }

    public String getCopyrightStatement() {
        return this.copyrightStatement;
    }

    public boolean getForceCollectionName() {
        return this.forceCollectionName;
    }

    public VirtualCollectionInfo getVCIReference() {
        return this.vci;
    }

    public TrinityCollectionInfo getParentTci() {
        return this.parentTCI;
    }

    public MedePrivileges getMedePrivileges() {
        return this.medePrivileges;
    }

    public InsightVersion getServerVersion() {
        return this.serverVersion;
    }

    public Vector getServerSerializedClasses() {
        return this.serverSerializedClasses;
    }

    public boolean getMediaSecurityEnabled() {
        return this.mediaSecurityEnabled;
    }

    public boolean getMediaSecurityTicketlessMode() {
        return this.mediaSecurityTicketlessMode;
    }

    public String getMediaTicket() {
        return this.mediaTicket;
    }

    public Hashtable getHelpFileNames() {
        return this.helpFileNames;
    }

    public String getRemoteLaunchBaseUrl() {
        return this.remoteLaunchBaseUrl;
    }

    public String getRemoteLaunchHyperlinkTemplate() {
        return this.remoteLaunchHyperlinkTemplate;
    }

    public String getBrowserRtlUrl() {
        return this.browserRtlUrl;
    }

    public boolean isPersonalCollection() {
        return this.isPersonalCollection;
    }

    public InsightUser getPcOwner() {
        return this.pcOwner;
    }

    public String getPcOwnerSessionGroupName() {
        return this.pcOwnerSessionGroupName;
    }

    public String getPcOwnerSessionCodeKey() {
        return this.pcOwnerSessionCodeKey;
    }

    public int getPcUsrGrpMemberPrivs() {
        return this.pcUsrGrpMemberPrivs;
    }

    public int getPcNonUsrGrpMemberPrivs() {
        return this.pcNonUsrGrpMemberPrivs;
    }

    public boolean isLicensedPersonalCollectionServer() {
        return this.licensedPersonalCollectionServer;
    }

    public boolean hasVirtualCollections() {
        return this.virtualCollectionGroups != null && this.virtualCollectionGroups.size() > 0;
    }

    public int getPcPermissions() {
        if (InsightUtilities.isNonEmpty(this.getUserName()) && this.getPcOwner() != null && InsightUtilities.isNonEmpty(this.getPcOwner().getLoginName()) && this.getUserName().equalsIgnoreCase(this.getPcOwner().getLoginName())) {
            return -1;
        }
        if (InsightUtilities.isNonEmpty(this.getSessionGroupName()) && InsightUtilities.isNonEmpty(this.getSessionCodeKey()) && InsightUtilities.isNonEmpty(this.getPcOwnerSessionGroupName()) && InsightUtilities.isNonEmpty(this.getPcOwnerSessionCodeKey())) {
            if (this.getSessionGroupName().equalsIgnoreCase(this.getPcOwnerSessionGroupName()) && this.getSessionCodeKey().equalsIgnoreCase(this.getPcOwnerSessionCodeKey())) {
                return this.getPcUsrGrpMemberPrivs();
            }
            return this.getPcNonUsrGrpMemberPrivs();
        }
        return 0;
    }

    public void setUniqueCollectionID(Integer n) {
        this.uniqueCollectionID = n;
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public String getCollectionUniqueID() {
        return this.getCollectionUniqueID(true);
    }

    public String getCollectionUniqueID(boolean bl) {
        if (!bl || InsightUtilities.isNonEmpty(this.collectionUniqueID)) {
            return this.collectionUniqueID;
        }
        return this.getCollectionID();
    }

    public int getDefaultPresentationExportMaxResolution() {
        if (this.exportMaxResolution < 3) {
            return 0;
        }
        if (this.exportMaxResolution == 3) {
            return 2;
        }
        return 8;
    }

    public void setNativeStandardID(int n) {
        this.nativeStandardID = n;
    }

    public void setUserGroupName(String string) {
        this.userGroupName = string;
    }

    public void setUserGroupCodeKey(String string) {
        this.userGroupCodeKey = string;
    }

    public void setUserGroupProfileID(int n) {
        this.userGroupProfileID = n;
    }

    public void setProfileID(int n) {
        this.profileID = n;
    }

    public void setSessionGroupName(String string) {
        this.sessionGroupName = string;
    }

    public void setSessionCodeKey(String string) {
        this.sessionCodeKey = string;
    }

    public void setGroupDisplayName(String string) {
        this.groupDisplayName = string;
    }

    public void setLocaleUserServer(Locale locale) {
        this.localeUserServer = locale;
    }

    public void setLocaleCollectionServer(Locale locale) {
        this.localeCollectionServer = locale;
    }

    public void setCopyrightStatement(String string) {
        this.copyrightStatement = string;
    }

    public void setForceCollectionName(boolean bl) {
        this.forceCollectionName = bl;
    }

    public void setServerVersion(InsightVersion insightVersion) {
        this.serverVersion = insightVersion;
    }

    public void setServerSerializedClasses(Vector vector) {
        this.serverSerializedClasses = vector;
    }

    public void setMediaSecurityEnabled(boolean bl) {
        this.mediaSecurityEnabled = bl;
    }

    public void setMediaSecurityTicketlessMode(boolean bl) {
        this.mediaSecurityTicketlessMode = bl;
    }

    public void setMediaTicket(String string) {
        this.mediaTicket = string;
    }

    public void setHelpFileNames(Hashtable hashtable) {
        this.helpFileNames = hashtable;
    }

    public void setRemoteLaunchBaseUrl(String string) {
        this.remoteLaunchBaseUrl = string;
    }

    public void setRemoteLaunchHyperlinkTemplate(String string) {
        this.remoteLaunchHyperlinkTemplate = string;
    }

    public void setBrowserRtlUrl(String string) {
        this.browserRtlUrl = string;
    }

    public void setPersonalCollection(boolean bl) {
        this.isPersonalCollection = bl;
    }

    public void setPcOwner(InsightUser insightUser) {
        this.pcOwner = insightUser;
    }

    public void setPcOwnerSessionGroupName(String string) {
        this.pcOwnerSessionGroupName = string;
    }

    public void setPcOwnerSessionCodeKey(String string) {
        this.pcOwnerSessionCodeKey = string;
    }

    public void setPcUsrGrpMemberPrivs(int n) {
        this.pcUsrGrpMemberPrivs = n;
    }

    public void setPcNonUsrGrpMemberPrivs(int n) {
        this.pcNonUsrGrpMemberPrivs = n;
    }

    public void setCollectionUniqueID(String string) {
        this.collectionUniqueID = string;
    }

    public void setLicensedPersonalCollectionServer(boolean bl) {
        this.licensedPersonalCollectionServer = bl;
    }

    public void setMedePrivileges(MedePrivileges medePrivileges) {
        this.medePrivileges = medePrivileges;
    }

    public void setVirtualCollectionGroups(List list) {
        this.virtualCollectionGroups = list;
    }

    public void setVirtualCollection(VirtualCollectionInfo virtualCollectionInfo) {
        this.vci = virtualCollectionInfo;
        if (virtualCollectionInfo != null) {
            this.vcID = virtualCollectionInfo.getVCID();
        } else if (this.vcID == null) {
            this.vcID = "NA";
        }
    }

    public void setVCID(String string) {
        this.vcID = string;
    }

    public void setParentTci(TrinityCollectionInfo trinityCollectionInfo) {
        this.parentTCI = trinityCollectionInfo;
    }

    public void clearVCIReference() {
        this.vci = null;
    }

    public String getVCID() {
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof TrinityCollectionInfo) {
                TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)object;
                return this.collectionName != null && trinityCollectionInfo.getCollectionName() != null && this.collectionName.equals(trinityCollectionInfo.getCollectionName()) && CollectionKeyDistributor.keysAgree(this, trinityCollectionInfo) && this.serverAddress != null && trinityCollectionInfo.getServerAddress() != null && this.serverAddress.equals(trinityCollectionInfo.getServerAddress()) && this.serverPort == trinityCollectionInfo.getServerPort() && this.userGroupName != null && trinityCollectionInfo.getUserGroupName() != null && this.userGroupName.equals(trinityCollectionInfo.getUserGroupName()) && this.userGroupCodeKey != null && trinityCollectionInfo.getUserGroupCodeKey() != null && this.userGroupCodeKey.equals(trinityCollectionInfo.getUserGroupCodeKey());
            }
            if (object instanceof CollectionInfo) {
                CollectionInfo collectionInfo = (CollectionInfo)object;
                return this.collectionName != null && collectionInfo.getCollectionName() != null && this.collectionName.equals(collectionInfo.getCollectionName()) && this.institutionID.equalsIgnoreCase(collectionInfo.getInstitutionID()) && this.collectionID.equalsIgnoreCase(collectionInfo.getCollectionID()) && this.serverAddress != null && collectionInfo.getServerAddress() != null && this.serverAddress.equals(collectionInfo.getServerAddress()) && this.serverPort == collectionInfo.getServerPort();
            }
        }
        return false;
    }

    public String toString() {
        String string = "UserID                    = " + this.getUserID() + "\nUserName                = " + this.getUserName() + "\nCollectionID            = " + this.getCollectionID() + "\nCollectionName          = " + this.getCollectionName() + "\nServerID                = " + this.getServerID() + "\nProfileID               = " + this.getProfileID() + "\nInitialActivity         = " + this.getInitialActivity() + "\nDisplayArtistStories    = " + this.getDisplayArtistStories() + "\nVerticalBarX            = " + this.getVerticalBarX() + "\nHoriontalBarY           = " + this.getHorizontalBarY() + "\nUserCollection          = " + this.getUserCollection() + "\nLargeThumbnailThreshold = " + this.getLargeThumbnailThreshold() + "\nBGURL                   = " + this.getBGURL() + "\ncriteria count is         " + (this.searchCriteria != null ? this.searchCriteria.size() : 0) + "\ninfoComplete            = " + this.infoComplete + "\nuserGroupCodeKey        = " + this.userGroupCodeKey + "\nuserGroupProfileID      = " + this.userGroupProfileID + "\ngroupDisplayName        = " + this.groupDisplayName + "\nsessionGroupName        = " + this.sessionGroupName + "\nsessionCodeKey          = " + this.sessionCodeKey + "\nexportMaxResolution     = " + this.exportMaxResolution + "\nprintResolution         = " + this.printResolution + "\nobjectEditorPriv        = " + this.objectEditorPriv + "\nvocabEditorPriv         = " + this.vocabEditorPriv + "\nmaxViewableSize         = " + this.maxViewableSize + "\nhtmlExportPriv          = " + this.htmlExportPriv + "\nsaveDBGroupsPriv        = " + this.saveDBGroupsPriv + "\ndeleteDBGroupsPriv      = " + this.deleteDBGroupsPriv + "\nmviPriv                 = " + this.mviPriv + "\nlinkPriv                = " + this.linkPriv + "\neditMpdPriv             = " + this.editMpdPriv + "\nsessionResults          = " + this.sessionResults + "\nuserGroupShells         = " + this.userGroupShells + "\ndataFieldMappings       = " + this.dataFieldMappings + "\nsortFieldMappings       = " + this.sortFieldMappings + "\nvci                     = " + this.vci + "\nvcID                    = " + this.vcID;
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.contextMap == null) {
            this.contextMap = new ContextMap();
        }
    }

    public ContextMap getContextMap() {
        return this.contextMap;
    }

    void setContextMap(ContextMap contextMap) {
        this.contextMap = contextMap;
    }

    public Object contextPut(String string, Serializable serializable) {
        return this.contextMap.put(string, serializable);
    }

    public Object contextGet(String string) {
        return this.contextMap.get(string);
    }

    public boolean contextContainsKey(String string) {
        return this.contextMap.containsKey(string);
    }

    public boolean isCanCreatePersonalCollections() {
        return this.canCreatePersonalCollections;
    }

    public void setCanCreatePersonalCollections(boolean bl) {
        this.canCreatePersonalCollections = bl;
    }

    public String getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(String string) {
        this.createdTimestamp = string;
    }

    public class ContextMap
    extends HashMap {
        static final long serialVersionUID = -7286838280675645588L;

        public Object put(Object object, Object object2) throws IllegalArgumentException {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Non String keys are not allowed. (key " + object + ")");
            }
            if (!(object2 instanceof Serializable)) {
                throw new IllegalArgumentException("value is not serializable. (value " + object2 + ")");
            }
            return super.put(object, object2);
        }

        public void putAll(Map map) throws IllegalArgumentException {
            super.putAll(map);
        }
    }
}

