/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.MutableBoolean;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;

public class InsightUtilities {
    public static final int DEFAULT_DEBUG_LEVEL = 2;
    public static final String DEFAULT_DATE_FORMAT_STRING = "yyyy-MM-dd hh:mm:ss.S";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int DEFAULT_FORMAT = 0;
    public static final int FUZZY_DATE_FORMAT = 1;
    public static final String DOT = ".";
    public static final String SID_URL_MARKER = "/uffff";
    public static final String JP2_URL_MARKER = "/uffff";
    public static final char LAST_UNICODE_CHAR = '\uffff';
    public static final char[] INVALID_DIRECTORY_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    public static final char[] INVALID_EMAIL_CHARS = new char[]{'!', '#', '$', '%', '^', '&', '*', '(', ')', '+', '=', '~', '`', '?', '/', '{', '}', '>', '<', ',', '\\', ' '};
    public static final int BUFFER_SIZE = 32768;
    public static final int NO_PATH_INFO = 0;
    public static final int FULL_PATH_INFO = 1;
    public static final int RELATIVE_PATH_INFO = 2;
    public static final int SUB_RELATIVE_PATH_INFO = 3;
    public static final char[] badPCDataChars = new char[]{'<', '>', '&', '\'', '\"'};
    public static final String[] pCDataReplacements = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    public static final char[] badAttValueChars = new char[]{'<', '&', '\'', '\"'};
    public static final String[] attValueReplacements = new String[]{"&lt;", "&amp;", "&apos;", "&quot;"};
    public static final char[] uTFXMLChars = new char[]{'\t', '\n', '\r'};
    public static final char[][] uTFXMLRanges = new char[2][2];
    private static String invalidXMLReplacement;
    private static String userDir;
    private static String userHomeDir;
    public static final String javaUserHomeDir;
    private static String tmpDir;
    public static final String javaTmpDir;

    public static void setInvalidXMLReplacement(String string) {
        invalidXMLReplacement = string;
    }

    public static String getInvalidXMLReplacement() {
        return invalidXMLReplacement;
    }

    public static Dimension getScaleDimension(int n, int n2, int n3, int n4) {
        return InsightUtilities.getScaleDimension(new Dimension(n, n2), new Dimension(n3, n4));
    }

    public static Dimension getScaleDimension(Dimension dimension, Dimension dimension2) {
        if (dimension != null) {
            Dimension dimension3 = new Dimension(dimension);
            if (dimension2 != null && (dimension.width > dimension2.width || dimension.height > dimension2.height)) {
                double d = (double)dimension2.width / (double)dimension2.height;
                double d2 = (double)dimension.width / (double)dimension.height;
                if (d > d2) {
                    dimension3.height = dimension2.height;
                    dimension3.width = (int)((float)dimension.width * ((float)dimension3.height / (float)dimension.height));
                } else {
                    dimension3.width = dimension2.width;
                    dimension3.height = (int)((float)dimension.height * ((float)dimension3.width / (float)dimension.width));
                }
            }
            return dimension3;
        }
        return null;
    }

    public static String formatDate(long l) {
        return InsightUtilities.formatDate(l, 0);
    }

    public static String formatDate(long l, int n) {
        if (n == 1) {
            return DateFormat.getDateInstance(2).format(new Date(l));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        int n2 = calendar.get(1);
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        return n2 + "-" + InsightUtilities.zeroPad(n3, 2) + "-" + InsightUtilities.zeroPad(n4, 2);
    }

    public static String getTimeStringFromSeconds(int n) {
        int n2 = n / 3600;
        int n3 = (n %= 3600) / 60;
        return InsightUtilities.zeroPad(n2, 2) + ":" + InsightUtilities.zeroPad(n3, 2) + ":" + InsightUtilities.zeroPad(n %= 60, 2);
    }

    public static String zeroPad(int n, int n2) {
        return InsightUtilities.characterPad(n + "", '0', n2);
    }

    public static String characterPad(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, c);
        }
        return stringBuffer.toString();
    }

    public static String capitalizeFirstChar(String string) {
        if (InsightUtilities.isNonEmpty(string)) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase();
        }
        return string;
    }

    public static boolean isAsciiCharacter(char c) {
        return c >= '\u0000' && c <= '\u007f';
    }

    public static final boolean isNumber(String string) {
        try {
            int n = Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String convertNonAsciiCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string == null ? 0 : string.length());
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!InsightUtilities.isAsciiCharacter(c) || Character.isISOControl(c)) {
                    if (i > 0) {
                        stringBuffer.append('-');
                    }
                    stringBuffer.append("u" + Integer.toHexString(c));
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    public static String cleanFilename(String string) {
        return InsightUtilities.cleanFilename(string, false, -1);
    }

    public static String cleanFilename(String string, boolean bl) {
        return InsightUtilities.cleanFilename(string, bl, -1);
    }

    public static String cleanFilename(String string, boolean bl, int n) {
        if (InsightUtilities.isNonEmpty(string)) {
            String string2 = new String(string);
            for (int i = 0; INVALID_DIRECTORY_CHARS != null && i < INVALID_DIRECTORY_CHARS.length; ++i) {
                string2 = string2.replace(INVALID_DIRECTORY_CHARS[i], '-');
            }
            if (bl) {
                string2 = string2.replace(' ', '-');
            }
            if (n > -1 && string2.length() > n) {
                string2 = string2.substring(0, n);
            }
            return string2;
        }
        return string;
    }

    public static String truncate(String string, int n) {
        if (n < 0) {
            return string;
        }
        if (string != null && string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String truncateWithElipsis(String string, int n) {
        if (n < 0) {
            return string;
        }
        if ("...".length() > n) {
            return "...".substring(0, n);
        }
        if (string != null && string.length() > n) {
            return string.substring(0, n - "...".length()) + "...";
        }
        return string;
    }

    public static int tryCatchParseInt(String string) {
        return InsightUtilities.tryCatchParseInt(string, 0);
    }

    public static int tryCatchParseInt(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            InsightUtilities.debugOut("tryCatchParseInt - Parameter did not parse.");
        }
        return n2;
    }

    public static long tryCatchParseLong(String string) {
        return InsightUtilities.tryCatchParseLong(string, 0L);
    }

    public static long tryCatchParseLong(String string, long l) {
        long l2 = l;
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            InsightUtilities.debugOut("tryCatchParseLong - Parameter did not parse.");
        }
        return l2;
    }

    public static String convertStackTraceToString(Throwable throwable) {
        return InsightUtilities.getStackTrace(throwable);
    }

    public static String getStackTrace() {
        return InsightUtilities.getStackTrace(new Throwable());
    }

    public static String getStackTrace(Throwable throwable) {
        String string = "";
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            string = stringWriter.toString();
        }
        return string;
    }

    public static String convertRectToCleanString(Rectangle rectangle) {
        String string = "";
        if (rectangle != null) {
            string = string + rectangle.x + "-" + rectangle.y + "-" + rectangle.width + "-" + rectangle.height;
        }
        return string;
    }

    public static String getListString(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator != null && iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString().intern();
    }

    public static String getListString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; list != null && i < list.size(); ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(list.get(i).toString());
        }
        return stringBuffer.toString().intern();
    }

    public static List getListStringList(List list, int n) {
        Vector<String> vector = new Vector<String>(0);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (int i = 0; list != null && i < list.size(); ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(list.get(i).toString());
            if (++n2 < n || i >= list.size() - 1) continue;
            vector.add(stringBuffer.toString().intern());
            stringBuffer = new StringBuffer();
            n2 = 0;
        }
        vector.add(stringBuffer.toString().intern());
        return vector;
    }

    public static String getUniqueListString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; list != null && i < list.size(); ++i) {
            if (hashtable.containsKey(list.get(i).toString())) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(list.get(i).toString());
            hashtable.put(list.get(i).toString(), "");
        }
        return stringBuffer.toString().intern();
    }

    public static String getUniqueListString(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next().toString();
            if (!hashtable.containsKey(string)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                hashtable.put(string, "");
            }
            ++n;
        }
        return stringBuffer.toString().intern();
    }

    public static List getTokenizedList(String string) {
        return InsightUtilities.getTokenizedList(string, " \t\n\r\f");
    }

    public static List getTokenizedList(String string, String string2) {
        Vector<String> vector = new Vector<String>(0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    public static boolean isValidEmailAddress(String string) {
        if (string == null || string.trim().equals("")) {
            return false;
        }
        try {
            int n;
            int n2 = string.indexOf("@");
            if (n2 <= 0) {
                return false;
            }
            if (string.indexOf("@", n2 + 1) != -1) {
                return false;
            }
            for (n = 0; n < INVALID_EMAIL_CHARS.length; ++n) {
                if (string.indexOf(INVALID_EMAIL_CHARS[n]) < 0) continue;
                return false;
            }
            n = string.indexOf("[", n2);
            int n3 = -1;
            if (n != -1 && (n3 = string.indexOf("]", n)) == -1) {
                return false;
            }
            int n4 = n == -1 ? n2 : n;
            int n5 = string.lastIndexOf(DOT);
            if (n5 == -1) {
                return false;
            }
            int n6 = n3 == -1 ? string.length() : n3;
            String string2 = string.substring(n5 + 1, n6);
            int n7 = string2.length();
            if (n7 < 1) {
                return false;
            }
            return !(InsightUtilities.isNumber(string2.substring(0, 1)) ? n7 > 3 : n7 < 2 || n7 > 3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
    }

    public static Object deepCopy(Object object) {
        Object object2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object2 = objectInputStream.readObject();
        }
        catch (Exception exception) {
            InsightUtilities.debugOut("Exception in deepCopy(): " + exception, 2);
        }
        return object2;
    }

    public static long sizeOf(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            return byteArrayOutputStream.toByteArray().length;
        }
        catch (Exception exception) {
            InsightUtilities.debugOut("Exception in deepCopy(): " + exception, 2);
            return 0L;
        }
    }

    public static Vector toVector(Object[] objectArray) {
        Vector<Object> vector;
        if (objectArray == null) {
            vector = new Vector<Object>(0);
        } else {
            vector = new Vector(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                vector.addElement(objectArray[i]);
            }
        }
        return vector;
    }

    public static boolean stringsMatchIgnoreCase(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static long numeralizeDate(String string) throws ParseException {
        return InsightUtilities.numeralizeDate(string, DEFAULT_DATE_FORMAT_STRING);
    }

    public static long numeralizeDate(String string, String string2) throws ParseException {
        long l = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        Date date = simpleDateFormat.parse(string);
        l = date.getTime();
        return l;
    }

    public static int indexOf(String string, String string2) {
        return InsightUtilities.indexOf(string, string2, 0, true);
    }

    public static int indexOf(String string, String string2, boolean bl) {
        return InsightUtilities.indexOf(string, string2, 0, bl);
    }

    public static int indexOf(String string, String string2, int n, boolean bl) {
        int n2 = -1;
        if (string != null && string2 != null && string2.length() <= string.length() - n) {
            int n3 = n;
            boolean bl2 = false;
            while (n3 + string2.length() <= string.length()) {
                if (string.regionMatches(bl, n3, string2, 0, string2.length())) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static String replaceSubstrings(String string, String string2, String string3) {
        return InsightUtilities.replaceSubstrings(string, string2, string3, true);
    }

    public static String replaceSubstrings(String string, String string2, String string3, boolean bl) {
        if (bl) {
            return InsightUtilities.replaceSubstringsIgnoreCase(string, new String[]{string2}, new String[]{string3});
        }
        return InsightUtilities.replaceSubstrings(string, new String[]{string2}, new String[]{string3});
    }

    public static String replaceSubstrings(String string, String[] stringArray, String[] stringArray2) {
        return InsightUtilities.replaceSubstrings(string, string, stringArray, stringArray2);
    }

    public static String replaceSubstringsIgnoreCase(String string, String[] stringArray, String[] stringArray2) {
        String string2 = string.toUpperCase();
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i] = stringArray[i].toUpperCase();
        }
        return InsightUtilities.replaceSubstrings(string, string2, stringArray3, stringArray2);
    }

    public static String replaceSubstrings(String string, String string2, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; i < stringArray.length && i < stringArray2.length; ++i) {
                int n4 = string2.indexOf(stringArray[i], n);
                if (n4 < 0 || n4 >= n3 && n3 != -1) continue;
                n3 = n4;
                n2 = i;
            }
            if (n2 >= 0) {
                stringBuffer.append(string.substring(n, n3));
                stringBuffer.append(stringArray2[n2]);
                n = n3 + stringArray[n2].length();
                continue;
            }
            stringBuffer.append(string.substring(n));
            n = string.length();
        }
        return stringBuffer.toString();
    }

    public static String removeAllWhiteSpace(String string) {
        String string2 = string.trim();
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == ' ') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static int getStringWidth(String string, Font font) {
        return font.getStringBounds((String)string, (FontRenderContext)new FontRenderContext(null, (boolean)false, (boolean)false)).getBounds().width;
    }

    public static int getStringWidth(String string, FontMetrics fontMetrics) {
        return SwingUtilities.computeStringWidth(fontMetrics, string);
    }

    public static int getStringHeight(String string, Font font) {
        LineMetrics lineMetrics = font.getLineMetrics(string, new FontRenderContext(null, false, false));
        return Math.round(lineMetrics.getAscent());
    }

    public static int getStringHeight(String string, FontMetrics fontMetrics) {
        return fontMetrics.getMaxAscent();
    }

    public static int getFontHeight(Font font) {
        return InsightUtilities.getFontHeight(Toolkit.getDefaultToolkit().getFontMetrics(font));
    }

    public static int getFontHeight(FontMetrics fontMetrics) {
        return fontMetrics.getMaxAscent() + fontMetrics.getLeading();
    }

    public static String colorToHex(Color color) {
        StringBuffer stringBuffer = new StringBuffer("#");
        String string = Integer.toHexString(color.getRed());
        if (string.length() > 2) {
            string = string.substring(0, 2);
        } else if (string.length() < 2) {
            stringBuffer.append("0" + string);
        } else {
            stringBuffer.append(string);
        }
        string = Integer.toHexString(color.getGreen());
        if (string.length() > 2) {
            string = string.substring(0, 2);
        } else if (string.length() < 2) {
            stringBuffer.append("0" + string);
        } else {
            stringBuffer.append(string);
        }
        string = Integer.toHexString(color.getBlue());
        if (string.length() > 2) {
            string = string.substring(0, 2);
        } else if (string.length() < 2) {
            stringBuffer.append("0" + string);
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static Vector divideRectangle(Rectangle rectangle, int n, int n2) {
        Vector<Rectangle> vector;
        block4: {
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                vector = new Vector<Rectangle>();
                if (rectangle == null) break block4;
                n6 = rectangle.x;
                n5 = rectangle.y;
                n4 = 0;
                n3 = 0;
                if (n2 != 0) break block5;
                n4 = rectangle.width / n;
                n3 = rectangle.height;
                while (vector.size() < n) {
                    if (vector.size() == n - 1) {
                        n4 = rectangle.width - n6;
                    }
                    vector.addElement(new Rectangle(n6, n5, n4, n3));
                    n6 += n4;
                }
                break block4;
            }
            if (n2 != 1) break block4;
            n4 = rectangle.width;
            n3 = rectangle.height / n;
            while (vector.size() < n) {
                if (vector.size() == n - 1) {
                    n3 = rectangle.height - n5;
                }
                vector.addElement(new Rectangle(n6, n5, n4, n3));
                n5 += n3;
            }
        }
        return vector;
    }

    public static String getUserDirFilepath(String string) {
        File file = new File(userDir);
        if (!file.canWrite()) {
            InsightUtilities.debugOut("Can't write to user.dir: " + userDir, 1);
        }
        return InsightUtilities.concatFilepath(userDir, string);
    }

    public static boolean setUserHomeDir(String string) {
        if (InsightUtilities.testDirectoryWrite(string)) {
            userHomeDir = string;
            return true;
        }
        return false;
    }

    public static String getUserHomeDirFilepath() {
        return InsightUtilities.getUserHomeDirFilepath("");
    }

    public static String getUserHomeDirFilepath(String string) {
        if (!InsightUtilities.testDirectoryWrite(userHomeDir)) {
            InsightUtilities.debugOut("Can't write to user.home : " + userHomeDir, 1);
            InsightUtilities.debugOut("Trying user.dir", 3);
            return InsightUtilities.getUserDirFilepath(string);
        }
        return InsightUtilities.concatFilepath(userHomeDir, string);
    }

    public static String getUserHomeDirFilepath(String string, String string2) {
        String string3;
        String string4 = InsightUtilities.rightTrimSlashes(InsightUtilities.getUserHomeDirFilepath());
        if (!string4.equals(string3 = InsightUtilities.rightTrimSlashes(javaUserHomeDir))) {
            return InsightUtilities.getUserHomeDirFilepath(string);
        }
        return InsightUtilities.getUserHomeDirFilepath(InsightUtilities.concatFilepath(string2, string));
    }

    public static boolean setTmpDir(String string) {
        if (InsightUtilities.testDirectoryWrite(string)) {
            tmpDir = string;
            return true;
        }
        return false;
    }

    public static String getTempDirFilepath() {
        return InsightUtilities.getTempDirFilepath("");
    }

    public static String getTempDirFilepath(String string) {
        if (!InsightUtilities.testDirectoryWrite(tmpDir)) {
            InsightUtilities.debugOut("Can't write to tempdir!" + tmpDir, 1);
            InsightUtilities.debugOut("Trying user.home", 3);
            return InsightUtilities.getUserHomeDirFilepath(string);
        }
        return InsightUtilities.concatFilepath(tmpDir, string);
    }

    public static String getTempDirFilepath(String string, String string2) {
        String string3;
        String string4 = InsightUtilities.rightTrimSlashes(InsightUtilities.getTempDirFilepath());
        if (!string4.equals(string3 = InsightUtilities.rightTrimSlashes(javaTmpDir)) && !string4.equals(InsightUtilities.rightTrimSlashes(javaUserHomeDir))) {
            return InsightUtilities.getTempDirFilepath(string);
        }
        return InsightUtilities.getTempDirFilepath(InsightUtilities.concatFilepath(string2, string));
    }

    public static boolean testDirectoryWrite(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                InsightUtilities.debugOut("DIRECTORY DOESN'T EXIST:" + string, 3);
                return false;
            }
            if (!file.isDirectory()) {
                InsightUtilities.debugOut("NOT A DIRECTORY:" + string, 3);
                return false;
            }
            if (!file.canWrite()) {
                InsightUtilities.debugOut("DIRECTORY IS READ ONLY:" + string, 3);
                return false;
            }
            Random random = new Random();
            File file2 = new File(string + File.separator + "insight_temp" + random.nextInt() + ".tmp");
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write("insight".getBytes());
            fileOutputStream.close();
            if (!file2.canRead()) {
                InsightUtilities.debugOut("CAN'T READ FROM DIRECTORY:" + string, 3);
                return false;
            }
            file2.delete();
            return true;
        }
        catch (Exception exception) {
            System.out.println("couldn't create tempfile in: " + string);
            return false;
        }
    }

    public static String getFilenameInPath(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n == -1 && (n = string.lastIndexOf(47)) == -1) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getDirInPath(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n == -1 && (n = string.lastIndexOf(47)) == -1) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public static String concatFilepath(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = InsightUtilities.rightTrimSlashes(string);
        string2 = InsightUtilities.leftTrimSlashes(string2);
        return InsightUtilities.isEmpty(string) ? string2 : string + File.separator + string2;
    }

    public static String concatUrl(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.endsWith("/")) {
            if (!string2.startsWith("/")) {
                return string + string2;
            }
            if (string2.length() >= 2) {
                return string + string2.substring(1);
            }
            return string;
        }
        if (string2.startsWith("/")) {
            return string + string2;
        }
        if (!string.equals("")) {
            return string + "/" + string2;
        }
        return string2;
    }

    public static String leftTrimSlashes(String string) {
        if (string == null || string.length() == 0 || !string.startsWith("/") && !string.startsWith(File.separator)) {
            return string;
        }
        return InsightUtilities.leftTrimSlashes(string.substring(1));
    }

    public static String rightTrimSlashes(String string) {
        if (string == null || string.length() == 0 || !string.endsWith("/") && !string.endsWith(File.separator)) {
            return string;
        }
        return InsightUtilities.rightTrimSlashes(string.substring(0, string.length() - 1));
    }

    public static URL getUrl(String string) {
        URL uRL = null;
        if (string != null && string.length() > 0) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null) {
                try {
                    uRL = new File(string).toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    InsightUtilities.debugOut("Exception using file.toURL(): " + InsightUtilities.getStackTrace(malformedURLException));
                }
            }
        }
        return uRL;
    }

    public static String getFileFirstName(String string) {
        if (string != null) {
            return InsightUtilities.getFileFirstName(new File(string));
        }
        return "";
    }

    public static String getFileFirstName(File file) {
        int n;
        String string = "";
        if (file != null && (n = (string = file.getName()).lastIndexOf(DOT)) > -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String getFileExtension(String string) {
        if (string != null) {
            return InsightUtilities.getFileExtension(new File(string));
        }
        return "";
    }

    public static String getFileExtension(File file) {
        String string;
        int n;
        String string2 = "";
        if (file != null && (n = (string = file.getName()).lastIndexOf(DOT)) > -1) {
            string2 = string.substring(n);
        }
        return string2;
    }

    public static List getFilesWithFirstName(String string, List list, boolean bl) {
        if (string != null) {
            File file = new File(string);
            return InsightUtilities.getFilesWithFirstName(InsightUtilities.getFileFirstName(file), file.getParentFile(), list, bl);
        }
        return new Vector(0);
    }

    public static List getFilesWithFirstName(String string, File file, List list, boolean bl) {
        Vector<File> vector = new Vector<File>(1);
        if (string != null && file != null && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            boolean bl2 = false;
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                bl2 = false;
                if (!fileArray[i].isDirectory() && InsightUtilities.getFileFirstName(fileArray[i]).equalsIgnoreCase(string)) {
                    bl2 = list == null ? true : (list.contains(InsightUtilities.getFileExtension(fileArray[i]).toLowerCase()) ? !bl : bl);
                }
                if (!bl2) continue;
                vector.add(fileArray[i]);
            }
        }
        return vector;
    }

    public static int getObjectIndex(Object[] objectArray, Object object) {
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static List getEnumeratedPropertyValues(Map map, String string) {
        Vector vector = new Vector(0);
        if (map != null && InsightUtilities.isNonEmpty(string)) {
            Object v;
            for (int i = 0; (v = map.get(string + (i <= 0 ? "" : i + ""))) != null || i <= 5; ++i) {
                if (v == null) continue;
                vector.add(v);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadProperties(String string) {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        fileInputStream.close();
        Properties properties2 = properties;
        Object var5_5 = null;
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties2;
        catch (Exception exception) {
            try {
                InsightUtilities.debugOut("Cannot read configuration file '" + string + "':\n" + InsightUtilities.getStackTrace(exception));
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static EnhancedProperties getEnhancedProperties(String string) {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        EnhancedProperties enhancedProperties = new EnhancedProperties();
        enhancedProperties.load(fileInputStream);
        fileInputStream.close();
        EnhancedProperties enhancedProperties2 = enhancedProperties;
        Object var5_5 = null;
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return enhancedProperties2;
        catch (IOException iOException) {
            try {
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException3) {}
        }
        return null;
    }

    public static EnhancedProperties loadPropertiesFromString(String string) {
        return InsightUtilities.loadPropertiesFromString(string, true);
    }

    public static EnhancedProperties loadPropertiesFromString(String string, boolean bl) {
        if (InsightUtilities.isNonEmpty(string)) {
            try {
                if (bl) {
                    string = URLDecoder.decode(string, "UTF-8");
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                EnhancedProperties enhancedProperties = new EnhancedProperties(true);
                enhancedProperties.load(byteArrayInputStream);
                return enhancedProperties;
            }
            catch (Exception exception) {
                InsightUtilities.debugOut("Exception in loadPropertiesFromString():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return null;
    }

    public static String convertMapContentToString(Map map) {
        return InsightUtilities.convertMapContentToString(map, true);
    }

    public static String convertMapContentToString(Map map, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(entry.getKey() + "=" + entry.getValue());
            }
        }
        try {
            if (bl) {
                return URLEncoder.encode(stringBuffer.toString(), "UTF-8");
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static boolean arraysEqual(Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null && objectArray2 != null && objectArray.length == objectArray2.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null && objectArray2[i] != null || objectArray[i] != null && objectArray2[i] == null) {
                    return false;
                }
                if (objectArray[i] == null || objectArray2[i] == null || objectArray[i].equals(objectArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean listsEqual(List list, List list2) {
        if (list != null && list2 != null && list.size() == list2.size()) {
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                Object e2 = list2.get(i);
                if (e == null && e2 != null || e != null && e2 == null) {
                    return false;
                }
                if (e == null || e2 == null || e.equals(e2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List combineLists(List list, List list2) {
        Vector vector = new Vector(0);
        if (list != null) {
            vector.addAll(list);
        }
        if (list2 != null) {
            vector.addAll(list2);
        }
        return vector;
    }

    public static boolean listEmpty(List list) {
        return list == null || list.size() == 0;
    }

    public static String appendDateToFilename(String string, String string2) {
        Calendar calendar;
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(DOT);
        if (n2 > -1) {
            string = string.substring(0, n2);
        }
        String string3 = (n = (calendar = Calendar.getInstance()).get(2) + 1) >= 10 ? "" + n : "0" + n;
        int n3 = calendar.get(5);
        String string4 = n3 >= 10 ? "" + n3 : "0" + n3;
        return string + "-" + calendar.get(1) + string3 + string4 + string2;
    }

    public static String removeUrlQuery(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(63)) > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static boolean copyFileBytes(String string, String string2) {
        if (InsightUtilities.isNonEmpty(string) && InsightUtilities.isNonEmpty(string2)) {
            try {
                return InsightUtilities.exportFileBytes(string2, new FileInputStream(string));
            }
            catch (Exception exception) {
                InsightUtilities.debugOut("Exception in copyFileBytes():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return true;
    }

    public static int copyStreamBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        return InsightUtilities.copyStreamBytes(inputStream, outputStream, false);
    }

    public static int copyStreamBytes(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        if (inputStream != null && outputStream != null) {
            byte[] byArray = new byte[32768];
            int n = 0;
            if (bl) {
                InsightUtilities.debugOut("Wait for input stream content.");
            }
            InsightUtilities.waitForInput(inputStream);
            if (bl) {
                InsightUtilities.debugOut("Available content: " + inputStream.available());
            }
            int n2 = 0;
            while (inputStream.available() > 0 || n2 > -1) {
                n2 = inputStream.read(byArray);
                if (n2 > -1) {
                    if (bl) {
                        InsightUtilities.debugOut("Writing: " + n2 + " bytes.");
                    }
                    outputStream.write(byArray, 0, n2);
                    if (n2 > 0) {
                        n += n2;
                    }
                }
                if (!bl) continue;
                InsightUtilities.debugOut("Input stream available: " + inputStream.available());
            }
            return n;
        }
        return 0;
    }

    public static byte[] importFileBytes(String string) {
        return InsightUtilities.importFileBytes(new File(string));
    }

    public static byte[] importFileBytes(File file) {
        byte[] byArray = new byte[]{};
        if (file != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray2 = InsightUtilities.importBytes(fileInputStream);
                fileInputStream.close();
                return byArray2;
            }
            catch (Exception exception) {
                InsightUtilities.debugOut("Exception in importFileBytes():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return byArray;
    }

    public static byte[] importResourceFileBytes(String string) {
        byte[] byArray = new byte[]{};
        if (string != null && string.length() > 0) {
            try {
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                InputStream inputStream = new InsightUtilities().getClass().getResourceAsStream(string);
                byArray = InsightUtilities.importBytes(inputStream);
            }
            catch (Exception exception) {
                InsightUtilities.debugOut("Exception in importResourceFileBytes():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return byArray;
    }

    public static byte[] importBytes(InputStream inputStream) {
        byte[] byArray = new byte[]{};
        if (inputStream != null) {
            try {
                byte[] byArray2;
                int n;
                Vector<byte[]> vector = new Vector<byte[]>(0);
                Vector<Integer> vector2 = new Vector<Integer>(0);
                int n2 = 0;
                while (inputStream.available() > 0 && (n = inputStream.read(byArray2 = new byte[inputStream.available()])) > 0) {
                    n2 += n;
                    vector.add(byArray2);
                    vector2.add(new Integer(n));
                }
                inputStream.close();
                byArray = new byte[n2];
                n = 0;
                for (int i = 0; i < vector.size(); ++i) {
                    byArray2 = (byte[])vector.get(i);
                    int n3 = (Integer)vector2.get(i);
                    System.arraycopy(byArray2, 0, byArray, n, n3);
                    n += n3;
                }
            }
            catch (Exception exception) {
                InsightUtilities.debugOut("Exception in importBytes():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return byArray;
    }

    public static boolean exportFileBytes(String string, byte[] byArray) {
        if (InsightUtilities.isNonEmpty(string) && byArray != null) {
            return InsightUtilities.exportFileBytes(string, new ByteArrayInputStream(byArray));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean exportFileBytes(String string, InputStream inputStream) {
        block30: {
            if (InsightUtilities.isNonEmpty(string) && inputStream != null) {
                FileOutputStream fileOutputStream;
                block26: {
                    fileOutputStream = null;
                    File file = new File(string);
                    if (file.exists()) {
                        file.delete();
                    } else {
                        InsightUtilities.makeDirectories(file);
                    }
                    if (file.getParentFile() == null || !file.getParentFile().exists()) break block26;
                    fileOutputStream = new FileOutputStream(file);
                    InsightUtilities.copyStreamBytes(inputStream, fileOutputStream);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    inputStream.close();
                    boolean bl = true;
                    Object var6_6 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                }
                InsightUtilities.debugOut("Could not write file " + string + " because its parent directory was not created.");
                Object var6_7 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block30;
                }
                catch (IOException iOException) {}
                break block30;
                {
                    catch (Exception exception) {
                        InsightUtilities.debugOut("Exception in exportFileBytes():\n" + InsightUtilities.getStackTrace(exception));
                        Object var6_8 = null;
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block30;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return false;
    }

    public static void moveDirectory(String string, String string2) throws Exception {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists() || !file.isDirectory()) {
            throw new Exception("Source is not a directory.");
        }
        if (file2.exists()) {
            throw new Exception("Destination already exist.");
        }
        boolean bl = false;
        try {
            File file3 = file2.getParentFile();
            if (file3 != null) {
                boolean bl2 = file3.mkdirs();
            }
            bl = file.renameTo(file2);
        }
        catch (Exception exception) {
            InsightUtilities.debugOut("Exception moving directory:\n" + InsightUtilities.getStackTrace(exception));
            throw exception;
        }
        if (!bl) {
            throw new Exception("Directory move unsuccessful.");
        }
    }

    public static boolean copyDirectory(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        boolean bl = true;
        try {
            if (file.exists()) {
                if (!file2.exists()) {
                    file2.mkdir();
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                    String string3;
                    File file3 = fileArray[i];
                    if (file3.isFile()) {
                        string3 = file2.getAbsolutePath() + File.separator + file3.getName();
                        if (!InsightUtilities.copyFileBytes(file3.getAbsolutePath(), string3)) {
                            bl = false;
                        }
                    }
                    if (!file3.isDirectory()) continue;
                    string3 = string2 + File.separator + file3.getName();
                    if (InsightUtilities.copyDirectory(file3.getAbsolutePath(), string3)) continue;
                    bl = false;
                }
                return bl;
            }
            InsightUtilities.debugOut("copyDirectory(), Directory was not copied: The source directory was not found");
            return false;
        }
        catch (Exception exception) {
            InsightUtilities.debugOut("Exception copying directory " + InsightUtilities.getStackTrace(exception));
            return false;
        }
    }

    public static boolean cleanDirectory(String string) {
        return InsightUtilities.cleanDirectory(string, false);
    }

    public static boolean cleanDirectory(String string, boolean bl) {
        return InsightUtilities.cleanDirectory(string, bl, false);
    }

    public static boolean cleanDirectory(String string, boolean bl, boolean bl2) {
        File file = new File(string);
        return InsightUtilities.cleanDirectory(file, bl, bl2);
    }

    public static boolean cleanDirectory(String string, boolean bl, boolean bl2, boolean bl3) {
        File file = new File(string);
        return InsightUtilities.cleanDirectory(file, bl, bl2, bl3);
    }

    public static boolean cleanDirectory(File file) {
        return InsightUtilities.cleanDirectory(file, false);
    }

    public static boolean cleanDirectory(File file, boolean bl) {
        return InsightUtilities.cleanDirectory(file, bl, false);
    }

    public static boolean cleanDirectory(File file, boolean bl, boolean bl2) {
        return InsightUtilities.cleanDirectory(file, bl, bl2, bl2);
    }

    public static boolean cleanDirectory(File file, boolean bl, boolean bl2, boolean bl3) {
        if (file != null && file.exists() && file.isDirectory()) {
            System.gc();
            boolean bl4 = true;
            File[] fileArray = file.listFiles();
            File file2 = null;
            if (bl3) {
                bl2 = true;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (!bl2) continue;
                    InsightUtilities.cleanDirectory(file2, bl3, bl2, bl3);
                    continue;
                }
                if (file2.delete()) continue;
                bl4 = false;
            }
            if (bl && bl3 && !file.delete()) {
                bl4 = false;
            }
            return bl4;
        }
        return false;
    }

    public static List getDirectoryFiles(String string, boolean bl, boolean bl2) {
        return InsightUtilities.getDirectoryFiles(new File(string), bl, bl2);
    }

    public static List getDirectoryFiles(File file, boolean bl, boolean bl2) {
        Vector<File> vector = new Vector<File>(0);
        if (file != null && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    if (bl2) {
                        vector.add(fileArray[i]);
                    }
                    if (!bl) continue;
                    vector.addAll(InsightUtilities.getDirectoryFiles(fileArray[i], bl, bl2));
                    continue;
                }
                vector.add(fileArray[i]);
            }
        }
        return vector;
    }

    public static File compressDirectory(String string, String string2, int n) throws IOException {
        if (InsightUtilities.isNonEmpty(string) && InsightUtilities.isNonEmpty(string2)) {
            File file = new File(string);
            List list = InsightUtilities.getDirectoryFiles(file, true, false);
            return InsightUtilities.compressFiles(list, string2, n, file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File compressFiles(List list, String string, int n, File file) throws IOException {
        block20: {
            File file2;
            if (!InsightUtilities.isNonEmpty(list) || !InsightUtilities.isNonEmpty(string)) break block20;
            FileOutputStream fileOutputStream = null;
            try {
                File file3 = new File(string);
                if (file3.exists()) {
                    file3.delete();
                } else {
                    InsightUtilities.makeDirectories(file3);
                }
                fileOutputStream = new FileOutputStream(file3);
                ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                Vector<String> vector = new Vector<String>(0);
                FileInputStream fileInputStream = null;
                try {
                    for (int i = 0; list != null && i < list.size(); ++i) {
                        File file4 = (File)list.get(i);
                        String string2 = n == 2 && file != null ? InsightUtilities.getRelativePath(file, file4, true) : (n == 3 && file != null ? InsightUtilities.getRelativePath(file, file4, false) : (n == 1 ? file4.getCanonicalPath() : file4.getName()));
                        String string3 = string2;
                        int n2 = 1;
                        while (vector.contains(string3)) {
                            string3 = string2 + ++n2;
                        }
                        vector.add(string3);
                        string2 = string3;
                        ZipEntry zipEntry = new ZipEntry(string2);
                        zipOutputStream.putNextEntry(zipEntry);
                        fileInputStream = new FileInputStream(file4);
                        InsightUtilities.copyStreamBytes(fileInputStream, zipOutputStream);
                        fileInputStream.close();
                        zipOutputStream.closeEntry();
                    }
                    Object var16_16 = null;
                }
                catch (Throwable throwable) {
                    Object var16_17 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                zipOutputStream.finish();
                fileOutputStream.close();
                zipOutputStream.close();
                file2 = file3;
                Object var19_21 = null;
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file2;
        }
        return null;
    }

    public static boolean isFullFilepath(String string) {
        if (InsightUtilities.isNonEmpty(string)) {
            String string2 = string.trim().toLowerCase();
            File[] fileArray = File.listRoots();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                if (!string2.startsWith(fileArray[i].getAbsolutePath().trim().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidDirectoryName(String string) {
        if (string != null) {
            int n = -1;
            for (int i = 0; i < INVALID_DIRECTORY_CHARS.length; ++i) {
                n = string.indexOf(INVALID_DIRECTORY_CHARS[i]);
                if (n == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getRelativePath(File file, File file2, boolean bl) throws IOException {
        if (file2 != null) {
            if (file != null) {
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                if (bl && file != null) {
                    file = file.getParentFile();
                }
                if (file != null) {
                    return InsightUtilities.getRelativePath(file.getCanonicalPath(), file2.getCanonicalPath());
                }
            }
            return file2.getCanonicalPath();
        }
        return null;
    }

    public static String getRelativePath(String string, String string2) {
        if (InsightUtilities.isNonEmpty(string) && InsightUtilities.isNonEmpty(string2) && string2.toLowerCase().startsWith(string.toLowerCase())) {
            string2 = string2.substring(string.length());
            string2 = InsightUtilities.leftTrimSlashes(string2);
        }
        return string2;
    }

    public static boolean makeDirectories(String string) {
        return InsightUtilities.makeDirectories(new File(string));
    }

    public static boolean makeDirectories(File file) {
        if (file != null && !file.exists()) {
            if (file.isDirectory()) {
                return file.mkdirs();
            }
            File file2 = file.getParentFile();
            if (file2 != null) {
                return file2.mkdirs();
            }
        }
        return false;
    }

    public static int waitForInput(InputStream inputStream) {
        return InsightUtilities.waitForInput(inputStream, 200, 30000L);
    }

    public static int waitForInput(InputStream inputStream, int n, long l) {
        return InsightUtilities.waitForInput(inputStream, n, l, null);
    }

    public static int waitForInput(InputStream inputStream, int n, long l, MutableBoolean mutableBoolean) {
        int n2;
        block5: {
            int n3 = 1;
            long l2 = l;
            n2 = 0;
            try {
                if (inputStream == null) break block5;
                int n4 = 0;
                while (inputStream.available() < n3) {
                    n4 += n;
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((long)n4 < l2 && (mutableBoolean == null || mutableBoolean.getValue())) continue;
                }
                n2 = inputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static void addToSortedList(List list, Object object) {
        if (list != null && object != null) {
            int n = Collections.binarySearch(list, object);
            if (n < 0) {
                n = -(n + 1);
            }
            list.add(n, object);
        }
    }

    public static int compareStrings(String string, String string2) {
        if (InsightUtilities.isEmpty(string) && InsightUtilities.isEmpty(string2)) {
            return 0;
        }
        if (InsightUtilities.isEmpty(string)) {
            return -1;
        }
        if (InsightUtilities.isEmpty(string2)) {
            return 1;
        }
        return string.compareToIgnoreCase(string2);
    }

    public static boolean isNonEmpty(String string) {
        if (string != null) {
            return string.length() > 0;
        }
        return false;
    }

    public static boolean isEmpty(String string) {
        if (string != null) {
            return string.length() == 0;
        }
        return true;
    }

    public static boolean isNonEmpty(Collection collection) {
        if (collection != null) {
            return collection.size() > 0;
        }
        return false;
    }

    public static boolean isEmpty(Collection collection) {
        if (collection != null) {
            return collection.size() == 0;
        }
        return true;
    }

    public static boolean isNonEmpty(Object[] objectArray) {
        if (objectArray != null) {
            return objectArray.length > 0;
        }
        return false;
    }

    public static boolean isEmpty(Object[] objectArray) {
        if (objectArray != null) {
            return objectArray.length == 0;
        }
        return true;
    }

    public static String pluralize(int n) {
        if (n == 1) {
            return "";
        }
        return "s";
    }

    public static List findDifferences(List list, List list2) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; list != null && i < list.size(); ++i) {
            boolean bl = false;
            String string = (String)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                String string2 = (String)list2.get(j);
                if (!string2.equals(string)) continue;
                bl = true;
            }
            if (bl) continue;
            vector.add(string);
        }
        return vector;
    }

    public static Method getPrivateMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            int n = method.getModifiers();
            return method.getReturnType() == clazz2 && (n & 8) == 0 && (n & 2) != 0 ? method : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte readByte(InputStream inputStream, long l) throws IOException {
        if (InsightUtilities.waitForInput(inputStream, 10, l) <= 0) {
            throw new IOException("No data available on input stream.");
        }
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public static short readShort(InputStream inputStream, long l) throws IOException {
        if (InsightUtilities.waitForInput(inputStream, 10, l) <= 0) {
            throw new IOException("No data available on input stream.");
        }
        int n = inputStream.read();
        if (InsightUtilities.waitForInput(inputStream, 10, l) <= 0) {
            throw new IOException("No data available on input stream.");
        }
        int n2 = inputStream.read();
        if ((n | n2) < 0) {
            throw new EOFException();
        }
        return (short)((n << 8) + (n2 << 0));
    }

    public static int readUnsignedShort(InputStream inputStream, long l) throws IOException {
        if (InsightUtilities.waitForInput(inputStream, 10, l) <= 0) {
            throw new IOException("No data available on input stream.");
        }
        int n = inputStream.read();
        if (InsightUtilities.waitForInput(inputStream, 10, l) <= 0) {
            throw new IOException("No data available on input stream.");
        }
        int n2 = inputStream.read();
        if ((n | n2) < 0) {
            throw new EOFException();
        }
        return (n << 8) + (n2 << 0);
    }

    public static int readInt(InputStream inputStream, long l) throws IOException {
        int n;
        int n2;
        int n3;
        if (InsightUtilities.waitForInput(inputStream, 10, l) < 4) {
            throw new IOException("No data available on input stream.");
        }
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public static long readLong(InputStream inputStream, long l) throws IOException {
        return ((long)InsightUtilities.readInt(inputStream, l) << 32) + ((long)InsightUtilities.readInt(inputStream, l) & 0xFFFFFFFFL);
    }

    public static void readFully(InputStream inputStream, long l, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            if (InsightUtilities.waitForInput(inputStream, 10, l) <= 0) {
                throw new IOException("No data available on input stream.");
            }
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public static String readUTF(InputStream inputStream, long l) throws IOException {
        int n = InsightUtilities.readUnsignedShort(inputStream, l);
        char[] cArray = new char[n];
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        InsightUtilities.readFully(inputStream, l, byArray, 0, n);
        block5: while (n2 < n) {
            int n4 = byArray[n2] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | by & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n3);
    }

    public static void debugOut(String string) {
        Debug.debugOut("InsightUtilities: " + string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("InsightUtilities: " + string, n);
    }

    public static void main(String[] stringArray) {
        Debug.setDebugLevel(3);
        try {
            int n = 1;
            int n2 = ++n;
            InsightUtilities.debugOut("(j = ++i): " + n2);
            n = 1;
            n2 = n++;
            InsightUtilities.debugOut("(j = i++): " + n2);
        }
        catch (Exception exception) {
            InsightUtilities.debugOut("Exception in main():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            InsightUtilities.debugOut("Error in main():\n" + InsightUtilities.getStackTrace(error));
        }
    }

    public static StringBuffer XMLEncode(String string, char[] cArray, String[] stringArray) {
        if (string == null) {
            return null;
        }
        char[] cArray2 = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray2.length; ++i) {
            int n;
            boolean bl = false;
            char c = cArray2[i];
            for (n = 0; n < cArray.length; ++n) {
                if (c != cArray[n]) continue;
                bl = true;
                stringBuffer.append(stringArray[n]);
                break;
            }
            if (!bl && invalidXMLReplacement != null) {
                n = 0;
                for (int j = 0; j < 2; ++j) {
                    char c2 = uTFXMLRanges[j][0];
                    char c3 = uTFXMLRanges[j][1];
                    if (c < c2 || c > c3) continue;
                    n = 1;
                    break;
                }
                if (n == 0 && c != uTFXMLChars[0] && c != uTFXMLChars[1] && c != uTFXMLChars[2]) {
                    bl = true;
                    stringBuffer.append(invalidXMLReplacement);
                }
            }
            if (bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    public static StringBuffer attValueEncode(String string) {
        return InsightUtilities.XMLEncode(string, badAttValueChars, attValueReplacements);
    }

    public static StringBuffer pcDataEncode(String string) {
        return InsightUtilities.XMLEncode(string, badPCDataChars, pCDataReplacements);
    }

    static {
        InsightUtilities.uTFXMLRanges[0][0] = 32;
        InsightUtilities.uTFXMLRanges[0][1] = 55295;
        InsightUtilities.uTFXMLRanges[1][0] = 57344;
        InsightUtilities.uTFXMLRanges[1][1] = 65533;
        invalidXMLReplacement = "?";
        userDir = System.getProperty("user.dir");
        userHomeDir = System.getProperty("user.home");
        javaUserHomeDir = System.getProperty("user.home");
        tmpDir = System.getProperty("java.io.tmpdir");
        javaTmpDir = System.getProperty("java.io.tmpdir");
    }
}

