/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.util.BaseResourceBundle;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.ImageGroupFile;
import com.luna.insight.server.ImageGroupFileManager;
import com.luna.insight.server.InsightResourceBundle;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUserServer;
import com.luna.insight.server.InsightUserServicerCommands;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.SimpleDate;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.VirtualCollectionInfo;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.InsightTableNames;
import com.luna.insight.server.backend.JdbcConnectorError;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.io.InsightPkgRemoverOutputStream;
import com.luna.insight.server.io.InsightPkgSetterInputStream;
import com.luna.insight.server.presentation.ImageSeries;
import com.luna.insight.server.usergroup.IGFLocator;
import com.luna.insight.server.usergroup.ShareFolder;
import com.luna.insight.server.usergroup.UserGroupKey;
import com.luna.insight.server.usergroup.UserGroupShell;
import com.luna.insight.server.usergroup.UserKey;
import com.luna.insight.server.usergroup.UserShareKey;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class InsightUserServicer
implements Runnable,
InsightUserServicerCommands,
InsightTableNames {
    protected static final int WAIT_LIMIT = 10000;
    protected static final int WAIT_PAUSE = 200;
    protected static final int ALL_USERS = 0;
    protected static final int FILTER_USERS_BY_GROUP = 1;
    protected static final int FILTER_USERS_BY_SHARE = 2;
    protected static final String LOCALE_FILE_DIR = "Locale-Files";
    private static final Set LOCKED_USERS = new HashSet();
    private static final Set LOCKED_GROUPS = new HashSet();
    private static final Set LOCKED_SHARES = new HashSet();
    private static final Object NEW_AUTHORIZATION_ENTITY_LOCK = new Object();
    private static final Object NEW_SHARE_MAXFOLDERID = new Object();
    protected Socket theSocket;
    protected String ipAddress;
    protected String internalIPAddress;
    protected ObjectInputStream ois;
    protected ObjectOutputStream oos;
    protected InsightUserServer ius;
    protected String connectString;
    protected Vector resourceBundles = new Vector();
    private boolean useDistinctKeyword = true;
    protected InsightVersion clientVersion;

    public static String pluralize(int n) {
        if (n == 1) {
            return "";
        }
        return "s";
    }

    public InsightUserServicer(Socket socket, String string, InsightUserServer insightUserServer) {
        this.ius = insightUserServer;
        this.theSocket = socket;
        this.connectString = string;
        this.ipAddress = this.theSocket.getInetAddress().getHostAddress();
        this.useDistinctKeyword = insightUserServer.USE_DISTINCT_KEYWORD;
        this.internalIPAddress = this.theSocket.getLocalAddress().getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block75: {
            int n = 0;
            boolean bl = true;
            InputStream inputStream = this.theSocket.getInputStream();
            OutputStream outputStream = this.theSocket.getOutputStream();
            this.debugOut("waiting for input");
            if (InsightUtilities.waitForInput(inputStream, 200, 10000L) > 0) {
                this.oos = InsightPkgRemoverOutputStream.getInstance(outputStream);
                this.ois = new InsightPkgSetterInputStream(inputStream);
            } else {
                this.debugOut("no data found on input stream");
                bl = false;
            }
            while (bl) {
                this.debugOut("Asking for request #" + ++n + ".");
                if (InsightUtilities.waitForInput(inputStream, 200, 10000L) > 0) {
                    int n2 = this.ois.readInt();
                    switch (n2) {
                        case 3: {
                            this.startSession();
                            break;
                        }
                        case 6: {
                            this.getImageGroupFileList();
                            break;
                        }
                        case 7: {
                            this.getImageGroupFile();
                            break;
                        }
                        case 8: {
                            this.saveImageGroupFile();
                            break;
                        }
                        case 9: {
                            this.deleteImageGroupFile();
                            break;
                        }
                        case 11: {
                            this.getLegacyShareList_5_0_07();
                            break;
                        }
                        case 14: {
                            this.getLegacyCollections_5_0_07();
                            break;
                        }
                        case 28: {
                            this.getCollections();
                            break;
                        }
                        case 21: {
                            this.getCollectionsByUserGroups();
                            break;
                        }
                        case 15: {
                            this.getCollectionsLanguages();
                            break;
                        }
                        case 13: {
                            this.doesImageGroupFileExist();
                            break;
                        }
                        case 0: {
                            bl = false;
                            break;
                        }
                        case 16: {
                            this.getInsightResourceBundle();
                            break;
                        }
                        case 17: {
                            this.getDefaultBGURL();
                            break;
                        }
                        case 18: {
                            this.getDefaultFuzzyHelpMessage();
                            break;
                        }
                        case 19: {
                            this.getLegacyMedeCollections_5_0_07();
                            break;
                        }
                        case 29: {
                            this.getMedeCollections();
                            break;
                        }
                        case 20: {
                            this.getInsightUser();
                            break;
                        }
                        case 22: {
                            this.getInsightSecuritySettings();
                            break;
                        }
                        case 23: {
                            this.getServerVersion();
                            break;
                        }
                        case 24: {
                            this.setClientVersion();
                            break;
                        }
                        case 25: {
                            this.getPresentationNames();
                            break;
                        }
                        case 26: {
                            this.getPresentation();
                            break;
                        }
                        case 27: {
                            this.getResourceBundle();
                            break;
                        }
                        case 32: {
                            this.getUserKeyList(null, 0);
                            break;
                        }
                        case 30: {
                            this.getUserGroupKeyList(null);
                            break;
                        }
                        case 31: {
                            this.getShareKeyList(null);
                            break;
                        }
                        case 33: {
                            this.getUserGroupsAndSharesForUser();
                            break;
                        }
                        case 34: {
                            this.getUserKeyListByGroup();
                            break;
                        }
                        case 35: {
                            this.getUserKeyListByShare();
                            break;
                        }
                        case 36: {
                            this.setUserShareRights();
                            break;
                        }
                        case 37: {
                            this.addUserToGroup();
                            break;
                        }
                        case 38: {
                            this.addUserToShare();
                            break;
                        }
                        case 47: {
                            this.addCollectionToGroup();
                            break;
                        }
                        case 46: {
                            this.addCollection();
                            break;
                        }
                        case 55: {
                            this.deleteCollection();
                            break;
                        }
                        case 39: {
                            this.removeUserFromGroup();
                            break;
                        }
                        case 40: {
                            this.removeUserFromShare();
                            break;
                        }
                        case 41: {
                            this.addAuthorizationEntity();
                            break;
                        }
                        case 48: {
                            this.getAuthorizationEntityInfo();
                            break;
                        }
                        case 42: {
                            this.removeAuthorizationEntity();
                            break;
                        }
                        case 49: {
                            this.saveAuthorizationEntity();
                            break;
                        }
                        case 43: {
                            this.getMasterServerList();
                            break;
                        }
                        case 44: {
                            this.getApplicationHelpBundle();
                            break;
                        }
                        case 45: {
                            this.authenticateUsernameAndPassword();
                            break;
                        }
                        case 51: {
                            this.createShareSubfolder();
                            break;
                        }
                        case 52: {
                            this.deleteShareSubfolder();
                            break;
                        }
                        case 50: {
                            this.getShareSubfolderList();
                            break;
                        }
                        case 53: {
                            this.getShareTreeList();
                            break;
                        }
                        case 54: {
                            this.getShareGroupCount();
                        }
                    }
                    continue;
                }
                bl = false;
            }
            Object var7_7 = null;
            this.debugOut("Closing.");
            try {
                this.theSocket.close();
            }
            catch (IOException iOException) {
                this.debugOut("IOException on theSocket.close().");
            }
            try {
                this.ois.close();
            }
            catch (IOException iOException) {
                this.debugOut("IOException on ois.close().");
            }
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
                this.debugOut("IOException on oos.close().");
            }
            this.debugOut("Servicer thread closed for address: " + this.ipAddress);
            {
                break block75;
                catch (Exception exception) {
                    this.debugOut("Exception during communication:\n" + InsightUtilities.getStackTrace(exception));
                    Object var7_8 = null;
                    this.debugOut("Closing.");
                    try {
                        this.theSocket.close();
                    }
                    catch (IOException iOException) {
                        this.debugOut("IOException on theSocket.close().");
                    }
                    try {
                        this.ois.close();
                    }
                    catch (IOException iOException) {
                        this.debugOut("IOException on ois.close().");
                    }
                    try {
                        this.oos.close();
                    }
                    catch (IOException iOException) {
                        this.debugOut("IOException on oos.close().");
                    }
                    this.debugOut("Servicer thread closed for address: " + this.ipAddress);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.debugOut("Closing.");
                try {
                    this.theSocket.close();
                }
                catch (IOException iOException) {
                    this.debugOut("IOException on theSocket.close().");
                }
                try {
                    this.ois.close();
                }
                catch (IOException iOException) {
                    this.debugOut("IOException on ois.close().");
                }
                try {
                    this.oos.close();
                }
                catch (IOException iOException) {
                    this.debugOut("IOException on oos.close().");
                }
                this.debugOut("Servicer thread closed for address: " + this.ipAddress);
                throw throwable;
            }
        }
    }

    protected void log(String string) {
        this.ius.log(string);
    }

    protected void getServerVersion() {
        this.debugOut("in getServerVersion().");
        try {
            this.oos.writeObject(new InsightVersion());
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getServerVersion():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void setClientVersion() {
        this.debugOut("in setClientVersion().");
        try {
            this.clientVersion = (InsightVersion)this.ois.readObject();
            this.debugOut("Setting client version: " + this.clientVersion);
        }
        catch (Exception exception) {
            this.debugOut("Exception in setClientVersion():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSession() {
        this.debugOut("in startSession().");
        Object object = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            String string3 = (String)this.ois.readObject();
            object = this.getUserManagementLock(string, null, null);
            this.oos.writeInt(30);
            this.log(Calendar.getInstance().getTime() + "," + this.ipAddress + "," + this.internalIPAddress + "," + string + "," + "Mimic Session");
            this.oos.flush();
            this.releaseUserManagementLock(object);
        }
        catch (Exception exception) {
            this.debugOut("Exception in startSession():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            this.releaseUserManagementLock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCollections(boolean bl, boolean bl2) {
        this.debugOut("in getCollections().");
        Vector<TrinityCollectionInfo> vector = new Vector<TrinityCollectionInfo>();
        DatabaseConnector databaseConnector = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            this.debugOut("Retrieving available collections for " + string);
            this.log(Calendar.getInstance().getTime() + "," + this.ipAddress + "," + this.internalIPAddress + "," + string + "," + "Retrieving collections");
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("USERLIST", null, new String[]{"UserID", "UserName"});
            sqlQueryGenerator.addTable("COLLECTIONS", null, "*");
            sqlQueryGenerator.addTable("USERGROUPS", null, "*");
            sqlQueryGenerator.addJoin("USERLIST", "USERGROUPMAP", "userID", 0);
            sqlQueryGenerator.addJoin("USERGROUPMAP", "USERGROUPS", "GroupID", 0);
            sqlQueryGenerator.addJoin("USERGROUPS", "USERGROUPSERVERMAP", "GroupID", 0);
            sqlQueryGenerator.addJoin("USERGROUPSERVERMAP", "COLLECTIONS", "ServerID", 0);
            if (string2 != null) {
                sqlQueryGenerator.appendToWhere("((USERLIST.UserName=" + sqlQueryGenerator.prepStringForQuery(string) + ")" + " AND (" + "USERLIST" + ".Password=" + sqlQueryGenerator.prepStringForQuery(string2) + "))");
            } else {
                sqlQueryGenerator.appendToWhere("(USERLIST.UserName=" + sqlQueryGenerator.prepStringForQuery(string) + ")");
            }
            if (bl) {
                sqlQueryGenerator.appendToWhere("(COLLECTIONS.MedeEnabled=1)");
            }
            if (bl2) {
                sqlQueryGenerator.appendToWhere("(COLLECTIONS.Type = 0)");
            }
            sqlQueryGenerator.addOrderBy("COLLECTIONS", "CollectionName");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Collections query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    TrinityCollectionInfo trinityCollectionInfo = null;
                    int n = databaseConnector.getIntegerField("UserID");
                    String string3 = databaseConnector.getFieldByName("UserName");
                    String string4 = databaseConnector.getFieldByName("InstitutionID");
                    String string5 = databaseConnector.getFieldByName("CollectionID");
                    String string6 = databaseConnector.getFieldByName("VCID");
                    int n2 = databaseConnector.getIntegerFieldByName("ServerID");
                    String string7 = databaseConnector.getFieldByName("CollectionName");
                    String string8 = databaseConnector.getFieldByName("GroupName");
                    String string9 = databaseConnector.getFieldByName("GroupCodeKey");
                    if (databaseConnector.getIntegerFieldByName("IsVirtualCollection") == 1) {
                        trinityCollectionInfo = this.getVirtualCollection(n, string3, string4, string5, string6, n2, string7, databaseConnector.getFieldByName("ServerAddress"), databaseConnector.getIntegerFieldByName("ServerPort"), string8, string9, n);
                    } else {
                        trinityCollectionInfo = new TrinityCollectionInfo(n, string3, string4, string5, n2, string7, databaseConnector.getFieldByName("ServerAddress"), databaseConnector.getIntegerFieldByName("ServerPort"), string8, string9, n);
                        trinityCollectionInfo.setUserServerRecordType(databaseConnector.getIntegerField("Type"));
                    }
                    if (trinityCollectionInfo != null) {
                        Locale locale;
                        String string10;
                        String string11;
                        if (!bl2) {
                            trinityCollectionInfo.userGroupShells = this.getShareListByUserID(n).toArray(new UserGroupShell[0]);
                        }
                        trinityCollectionInfo.setGroupDisplayName(databaseConnector.getFieldByName("DisplayName"));
                        try {
                            string11 = databaseConnector.getFieldByName("LanguageCode");
                            string10 = databaseConnector.getFieldByName("CountryCode");
                        }
                        catch (Exception exception) {
                            string11 = System.getProperty("user.language", "en");
                            String string12 = string10 = System.getProperty("user.region") != null ? System.getProperty("user.region") : System.getProperty("user.country", "US");
                        }
                        if (string11 == null || string11.length() == 0 || string10 == null || string10.length() == 0) {
                            string11 = System.getProperty("user.language", "en");
                            string10 = System.getProperty("user.region") != null ? System.getProperty("user.region") : System.getProperty("user.country", "US");
                        }
                        if ((locale = string11 != null && string11.length() > 0 && string10 != null && string10.length() > 0 ? new Locale(string11, string10) : null) != null) {
                            trinityCollectionInfo.setLocaleUserServer(locale);
                        }
                        trinityCollectionInfo.setSessionGroupName(trinityCollectionInfo.getUserGroupName());
                        trinityCollectionInfo.setSessionCodeKey(trinityCollectionInfo.getUserGroupCodeKey());
                        try {
                            trinityCollectionInfo.setCollectionUniqueID(databaseConnector.getStringField("CollectionUniqueID"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.debugOut("InstitutionID: " + trinityCollectionInfo.getInstitutionID() + "  CollectionID: " + trinityCollectionInfo.getCollectionID());
                        if (!vector.contains(trinityCollectionInfo)) {
                            vector.addElement(trinityCollectionInfo);
                        }
                    }
                    databaseConnector.next();
                }
                this.log(Calendar.getInstance().getTime() + "," + this.ipAddress + "," + this.internalIPAddress + "," + string + "," + "Authenticated" + "," + vector.size());
            } else {
                this.log(Calendar.getInstance().getTime() + "," + this.ipAddress + "," + this.internalIPAddress + "," + string + "," + "Invalid Login" + ",");
            }
            databaseConnector.close();
            this.oos.writeObject(vector);
            this.oos.writeBoolean(this.ius.assumeSynchronizedFieldStandards);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    protected void getLegacyCollections_5_0_07() {
        this.getCollections(false, true);
    }

    protected void getCollections() {
        this.getCollections(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCollectionsByUserGroups() {
        this.debugOut("in getCollectionsByUserGroups().");
        Vector<TrinityCollectionInfo> vector = new Vector<TrinityCollectionInfo>();
        DatabaseConnector databaseConnector = null;
        try {
            int n = -1;
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            boolean bl = false;
            InsightVersion insightVersion = new InsightVersion(4, 0, 50);
            if (InsightVersion.compareVersions(insightVersion, this.clientVersion, 8)) {
                this.debugOut("Reading value of medeOnly parameter.");
                bl = this.ois.readBoolean();
            }
            this.debugOut("Retrieving available collections for user: " + string + ", groupsAndShares: " + string2);
            List list = this.parseUserGroupsAndShares(string2);
            if (list.size() > 0) {
                databaseConnector = this.getDatabaseConnector();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                if (this.useDistinctKeyword) {
                    sqlQueryGenerator.setDistinctKeyword("DISTINCT");
                }
                sqlQueryGenerator.addTable("COLLECTIONS", null, "*");
                sqlQueryGenerator.addTable("USERGROUPS", null, "*");
                sqlQueryGenerator.addJoin("USERGROUPS", "USERGROUPSERVERMAP", "GroupID", 0);
                sqlQueryGenerator.addJoin("USERGROUPSERVERMAP", "COLLECTIONS", "ServerID", 0);
                sqlQueryGenerator.appendToWhere("(USERGROUPS.GroupID IN (" + InsightUtilities.getUniqueListString((List)list.get(0)) + "))");
                if (bl) {
                    sqlQueryGenerator.appendToWhere("(COLLECTIONS.MedeEnabled = 1)");
                }
                if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 0, 0), 8)) {
                    sqlQueryGenerator.appendToWhere("COLLECTIONS.Type = 0");
                }
                sqlQueryGenerator.addOrderBy("COLLECTIONS", "CollectionName");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Collections query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runQuerySafe();
                if (databaseConnector.more()) {
                    while (databaseConnector.more()) {
                        TrinityCollectionInfo trinityCollectionInfo = null;
                        if (databaseConnector.getIntegerField("IsVirtualCollection") == 1) {
                            trinityCollectionInfo = this.getVirtualCollection(n, string, databaseConnector.getFieldByName("InstitutionID"), databaseConnector.getFieldByName("CollectionID"), databaseConnector.getFieldByName("VCID"), databaseConnector.getIntegerFieldByName("ServerID"), databaseConnector.getFieldByName("CollectionName"), databaseConnector.getFieldByName("ServerAddress"), databaseConnector.getIntegerFieldByName("ServerPort"), databaseConnector.getFieldByName("GroupName"), databaseConnector.getFieldByName("GroupCodeKey"), n);
                        } else {
                            trinityCollectionInfo = new TrinityCollectionInfo(n, string, databaseConnector.getFieldByName("InstitutionID"), databaseConnector.getFieldByName("CollectionID"), databaseConnector.getIntegerFieldByName("ServerID"), databaseConnector.getFieldByName("CollectionName"), databaseConnector.getFieldByName("ServerAddress"), databaseConnector.getIntegerFieldByName("ServerPort"), databaseConnector.getFieldByName("GroupName"), databaseConnector.getFieldByName("GroupCodeKey"), n);
                            trinityCollectionInfo.setUserServerRecordType(databaseConnector.getIntegerField("Type"));
                        }
                        if (trinityCollectionInfo != null) {
                            Locale locale;
                            String string3;
                            String string4;
                            trinityCollectionInfo.userGroupShells = ((List)list.get(1)).toArray(new UserGroupShell[0]);
                            trinityCollectionInfo.setGroupDisplayName(databaseConnector.getFieldByName("DisplayName"));
                            try {
                                string4 = databaseConnector.getFieldByName("LanguageCode");
                                string3 = databaseConnector.getFieldByName("CountryCode");
                            }
                            catch (Exception exception) {
                                string4 = System.getProperty("user.language", "en");
                                String string5 = string3 = System.getProperty("user.region") != null ? System.getProperty("user.region") : System.getProperty("user.country", "US");
                            }
                            if (string4 == null || string4.length() == 0 || string3 == null || string3.length() == 0) {
                                string4 = System.getProperty("user.language", "en");
                                string3 = System.getProperty("user.region") != null ? System.getProperty("user.region") : System.getProperty("user.country", "US");
                            }
                            if ((locale = string4 != null && string4.length() > 0 && string3 != null && string3.length() > 0 ? new Locale(string4, string3) : null) != null) {
                                trinityCollectionInfo.setLocaleUserServer(locale);
                            }
                            trinityCollectionInfo.setSessionGroupName(trinityCollectionInfo.getUserGroupName());
                            trinityCollectionInfo.setSessionCodeKey(trinityCollectionInfo.getUserGroupCodeKey());
                            try {
                                trinityCollectionInfo.setCollectionUniqueID(databaseConnector.getStringField("CollectionUniqueID"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.debugOut("InstitutionID: " + trinityCollectionInfo.getInstitutionID() + "  CollectionID: " + trinityCollectionInfo.getCollectionID());
                            if (!vector.contains(trinityCollectionInfo)) {
                                vector.addElement(trinityCollectionInfo);
                            }
                        }
                        databaseConnector.next();
                    }
                    this.log(Calendar.getInstance().getTime() + "," + this.ipAddress + "," + this.internalIPAddress + "," + string + "," + "Authenticated" + "," + vector.size());
                } else {
                    this.log(Calendar.getInstance().getTime() + "," + this.ipAddress + "," + this.internalIPAddress + "," + string + "," + "Invalid Login" + ",");
                }
                databaseConnector.close();
            } else {
                this.log(Calendar.getInstance().getTime() + "," + this.ipAddress + "," + this.internalIPAddress + "," + string + "," + "Invalid Login" + ",");
            }
            this.oos.writeObject(vector);
            this.oos.writeBoolean(this.ius.assumeSynchronizedFieldStandards);
            if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 10, 13), 7)) {
                this.oos.writeObject(list.size() > 0 ? list.get(1) : new Vector());
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionsByUserGroupProfiles():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getCollectionsByUserGroupProfiles():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    protected List parseUserGroupsAndShares(String string) {
        Object object;
        Object object2;
        this.debugOut("parsing groups and shares string " + string);
        String string2 = ":";
        String string3 = ",";
        String string4 = "/";
        ArrayList arrayList = new ArrayList();
        if (string == null) {
            return arrayList;
        }
        if ((string = string.trim()).equals("") || string.startsWith(":")) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n > 2) {
            this.debugOut("poorly formed groups and shares string");
            return arrayList;
        }
        String string5 = stringTokenizer.nextToken().trim();
        String string6 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken().trim();
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        stringTokenizer = new StringTokenizer(string5, string3);
        while (stringTokenizer.hasMoreTokens()) {
            block16: {
                object2 = stringTokenizer.nextToken().trim();
                if (((String)object2).equals("")) continue;
                object = null;
                try {
                    object = new Integer((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    object = new Integer(this.getUserGroupID((String)object2));
                    if (!((Integer)object).equals(new Integer(0))) break block16;
                    this.debugOut("no group id for name " + object2);
                    object = null;
                }
            }
            if (object == null) continue;
            hashSet.add((Integer)object);
        }
        if (hashSet.size() == 0) {
            return arrayList;
        }
        object2 = new ArrayList(hashSet);
        Collections.sort(object2);
        arrayList.add(object2);
        hashSet = new HashSet();
        object2 = new ArrayList<UserGroupShell>();
        if (string6 != null) {
            stringTokenizer = new StringTokenizer(string6, string3);
            while (stringTokenizer.hasMoreTokens()) {
                Object object3;
                object = stringTokenizer.nextToken().trim();
                if (((String)object).equals("")) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer((String)object, string4);
                String string7 = stringTokenizer2.nextToken().trim();
                UserGroupShell userGroupShell = null;
                try {
                    object3 = new Integer(string7);
                    userGroupShell = this.getShare((Integer)object3);
                }
                catch (NumberFormatException numberFormatException) {
                    userGroupShell = this.getShare(string7);
                }
                if (userGroupShell == null || !hashSet.add(new Integer(userGroupShell.getShareID()))) continue;
                if (stringTokenizer2.hasMoreTokens()) {
                    object3 = stringTokenizer2.nextToken().trim().toLowerCase();
                    if (((String)object3).indexOf(119) != -1) {
                        userGroupShell.setWritePriv(true);
                    }
                    if (((String)object3).indexOf(100) != -1) {
                        userGroupShell.setDeletePriv(true);
                    }
                    if (((String)object3).indexOf(99) != -1) {
                        userGroupShell.setCreateFolderPriv(true);
                    }
                }
                object2.add(userGroupShell);
            }
        }
        arrayList.add(object2);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getUserGroupProfileID(String string) {
        int n = 0;
        DatabaseConnector databaseConnector = null;
        try {
            this.debugOut("Retrieving user group profile ID for " + string);
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("UserGroupProfiles", null, "UserGroupProfileID");
            sqlQueryGenerator.appendToWhere("UserGroupProfileName = " + sqlQueryGenerator.prepStringForQuery(string));
            sqlQueryGenerator.addOrderBy("UserGroupProfiles", "UserGroupProfileID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get user group profile ID query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("UserGroupProfileID");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUserGroupProfileID():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getUserGroupProfileID():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getUserShareID(String string) {
        int n = 0;
        DatabaseConnector databaseConnector = null;
        try {
            this.debugOut("Retrieving user share ID for " + string);
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERSHARES", null, "ShareID");
            sqlQueryGenerator.appendToWhere("ShareName = " + sqlQueryGenerator.prepStringForQuery(string));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get user share ID query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("ShareID");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUserShareID():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getUserShareID():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getUserGroupID(String string) {
        int n = 0;
        DatabaseConnector databaseConnector = null;
        try {
            this.debugOut("Retrieving user group ID for " + string);
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("USERGROUPS", null, "GroupID");
            sqlQueryGenerator.appendToWhere("GroupName = " + sqlQueryGenerator.prepStringForQuery(string));
            sqlQueryGenerator.addOrderBy("USERGROUPS", "GroupID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get user group ID query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("GroupID");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUserGroupID():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getUserGroupID():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getUserGroupIDFromProfile(int n) {
        int n2 = 0;
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("UserGroupProfiles", null, "UserGroupID");
            sqlQueryGenerator.appendToWhere("UserGroupProfileID = " + n);
            sqlQueryGenerator.addOrderBy("UserGroupProfiles", "UserGroupID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get user group ID query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerField("UserGroupID");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUserGroupID():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getUserGroupID():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n2;
    }

    protected void getMedeCollections() {
        this.getCollections(true, false);
    }

    protected void getLegacyMedeCollections_5_0_07() {
        this.getCollections(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticateUsernameAndPassword() {
        this.debugOut("in authenticateUsernameAndPassword().");
        DatabaseConnector databaseConnector = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERLIST", null, "*");
            sqlQueryGenerator.appendToWhere("USERLIST.UserName = " + sqlQueryGenerator.prepStringForQuery(string));
            sqlQueryGenerator.appendToWhere("USERLIST.Password = " + sqlQueryGenerator.prepStringForQuery(string2));
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                this.oos.writeBoolean(true);
            } else {
                this.oos.writeBoolean(false);
            }
            databaseConnector.close();
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in authenticateUsernameAndPassword():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getInsightUser() {
        this.debugOut("in getInsightUser().");
        DatabaseConnector databaseConnector = null;
        Object object = null;
        try {
            try {
                String string = (String)this.ois.readObject();
                object = this.getUserManagementLock(string, null, null);
                this.debugOut("Retrieving user object for " + string);
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                if (this.useDistinctKeyword) {
                    sqlQueryGenerator.setDistinctKeyword("DISTINCT");
                }
                sqlQueryGenerator.addTable("USERLIST", null, new String[]{"*"});
                sqlQueryGenerator.appendToWhere("USERLIST.UserName = " + sqlQueryGenerator.prepStringForQuery(string));
                sqlQueryGenerator.addOrderBy("USERLIST", "UserID");
                InsightUser insightUser = new InsightUser();
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Insight user query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runQuery();
                boolean bl = false;
                if (databaseConnector.more()) {
                    bl = true;
                    insightUser.setUserID(databaseConnector.getIntegerField("UserID"));
                    insightUser.setPassword(databaseConnector.getFieldByName("Password"));
                    insightUser.setLoginName(databaseConnector.getFieldByName("UserName"));
                    insightUser.setFirstName(databaseConnector.getFieldByName("FirstName"));
                    insightUser.setLastName(databaseConnector.getFieldByName("LastName"));
                    insightUser.setOrganization(databaseConnector.getFieldByName("Organization"));
                    insightUser.setEmail(databaseConnector.getFieldByName("Email"));
                    insightUser.setAddress(databaseConnector.getFieldByName("Address"));
                    insightUser.setCity(databaseConnector.getFieldByName("City"));
                    insightUser.setState(databaseConnector.getFieldByName("State"));
                    insightUser.setPostalCode(databaseConnector.getFieldByName("PostalCode"));
                    insightUser.setCountry(databaseConnector.getFieldByName("Country"));
                    insightUser.setPhone(databaseConnector.getFieldByName("Phone"));
                    insightUser.setCreatedTimestamp(databaseConnector.getFieldByName("CreatedTimestamp"));
                }
                databaseConnector.close();
                if (bl) {
                    sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable("IAADMINISTRATIONACCOUNTS", null, "ServerAdminPermissions");
                    sqlQueryGenerator.appendToWhere("UserName = " + sqlQueryGenerator.prepStringForQuery(insightUser.getLoginName()));
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    databaseConnector.runQuery();
                    if (databaseConnector.more()) {
                        insightUser.setUserServerPrivs(databaseConnector.getIntegerField("ServerAdminPermissions", 0));
                    }
                    databaseConnector.close();
                }
                this.oos.writeObject(insightUser);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in getInsightUser():\n" + InsightUtilities.getStackTrace(exception));
                Object var8_9 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
            }
            Object var8_8 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCollectionsLanguages() {
        this.debugOut("in getCollectionsLanguages().");
        Vector<Locale> vector = new Vector<Locale>();
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("COLLECTIONS", null, new String[]{"LanguageCode", "CountryCode"});
            sqlQueryGenerator.addOrderBy("COLLECTIONS", "LanguageCode");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Languages query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                String string = null;
                String string2 = null;
                while (databaseConnector.more()) {
                    Locale locale;
                    string = databaseConnector.getFieldByName("LanguageCode");
                    string2 = databaseConnector.getFieldByName("CountryCode");
                    this.debugOut("Language code: " + string + ", Country code: " + string2);
                    if (string != null && string2 != null && !vector.contains(locale = new Locale(string, string2))) {
                        vector.addElement(locale);
                    }
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionsLanguages():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    protected void getInsightResourceBundle() {
        this.debugOut("in getInsightResourceBundle().");
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            int n = this.ois.readInt();
            boolean bl = true;
            InsightResourceBundle insightResourceBundle = null;
            insightResourceBundle = this.getCachedInsightBundle(string, string2);
            if (insightResourceBundle != null) {
                bl = insightResourceBundle.version != n;
            }
            this.debugOut("Retrieving bundle for language " + string + ", country " + string2 + ": " + bl);
            this.oos.writeBoolean(bl);
            if (bl) {
                this.oos.writeObject(insightResourceBundle);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getInsightResourceBundle():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getResourceBundle() {
        this.debugOut("in getResourceBundle().");
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            String string3 = (String)this.ois.readObject();
            int n = this.ois.readInt();
            boolean bl = true;
            BaseResourceBundle baseResourceBundle = null;
            baseResourceBundle = this.getCachedResourceBundle(string, string2, string3);
            if (baseResourceBundle != null) {
                boolean bl2 = bl = baseResourceBundle.version != n;
            }
            if (bl) {
                this.debugOut("Resource bundle for prefix: " + string + " language: " + string2 + " country: " + string3 + " is out of date and will be shipped to client");
            } else {
                this.debugOut("Resource bundle for prefix: " + string + " language: " + string2 + " country: " + string3 + " is up to date for this client.");
            }
            this.oos.writeBoolean(bl);
            if (bl) {
                this.oos.writeObject(baseResourceBundle);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getResourceBundle():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getApplicationHelpBundle() {
        this.debugOut("in getApplicationHelpBundle");
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            String string3 = (String)this.ois.readObject();
            File file = this.getLocaleBundle(string, string3, string2);
            if (file != null) {
                this.debugOut("Helpfile bundle for prefix: " + string + " language: " + string2 + " country: " + string3 + " is out of date and will be shipped to client");
            } else {
                this.debugOut("Helpfile bundle for prefix: " + string + " language: " + string2 + " country: " + string3 + " is not available for this client.");
            }
            this.oos.writeBoolean(file != null);
            if (file != null) {
                byte[] byArray = this.getFileAsByteArray(file);
                this.oos.writeInt(byArray.length);
                this.oos.write(byArray);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getApplicationHelpBundle()" + InsightUtilities.getStackTrace(exception));
        }
    }

    private File getLocaleBundle(String string, String string2, String string3) {
        String string4 = LOCALE_FILE_DIR + System.getProperty("file.separator") + string3 + "_" + string2 + System.getProperty("file.separator") + string + "Locale" + "_" + string3 + "_" + string2 + ".jar";
        File file = new File(string4);
        if (!file.exists() || !file.canRead()) {
            this.debugOut("Unable to locate locale bundle: " + string4);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getFileAsByteArray(File file) {
        int n;
        long l;
        FileInputStream fileInputStream;
        block12: {
            fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            l = file.length();
            if (l <= Integer.MAX_VALUE) break block12;
            byte[] byArray = new byte[]{};
            Object var10_7 = null;
            if (fileInputStream == null) return byArray;
            try {
                ((InputStream)fileInputStream).close();
                return byArray;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return byArray;
        }
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
        }
        if (n < byArray.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)fileInputStream).close();
        byte[] byArray2 = byArray;
        Object var10_8 = null;
        if (fileInputStream == null) return byArray2;
        try {
            ((InputStream)fileInputStream).close();
            return byArray2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray2;
        catch (Throwable throwable) {
            try {
                this.debugOut("Exception in getFileAsByteArray: " + InsightUtilities.getStackTrace(throwable));
                Object var10_9 = null;
                if (fileInputStream == null) return new byte[0];
            }
            catch (Throwable throwable2) {
                Object var10_10 = null;
                if (fileInputStream == null) throw throwable2;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable2;
            }
            try {
                ((InputStream)fileInputStream).close();
                return new byte[0];
            }
            catch (IOException iOException) {}
            return new byte[0];
        }
    }

    protected InsightResourceBundle getCachedInsightBundle(String string, String string2) {
        InsightResourceBundle insightResourceBundle = null;
        try {
            if (this.resourceBundles == null) {
                this.resourceBundles = new Vector();
            }
            for (int i = 0; i < this.resourceBundles.size(); ++i) {
                if (this.resourceBundles.elementAt(i) instanceof InsightResourceBundle) {
                    insightResourceBundle = (InsightResourceBundle)this.resourceBundles.elementAt(i);
                }
                if (insightResourceBundle.languageCode != string || insightResourceBundle.countryCode != string2) continue;
                return insightResourceBundle;
            }
            try {
                insightResourceBundle = new InsightResourceBundle(LOCALE_FILE_DIR + System.getProperty("file.separator") + string + "_" + string2 + System.getProperty("file.separator") + "InsightLocale_" + string + "_" + string2 + ".conf");
            }
            catch (Exception exception) {
                this.debugOut("There was a problem loading the requested InsightResourceBundle.  Creating the default one instead. exc:\n" + InsightUtilities.getStackTrace(exception));
                insightResourceBundle = new InsightResourceBundle(LOCALE_FILE_DIR + System.getProperty("file.separator") + "en_US" + System.getProperty("file.separator") + "InsightLocale_en_US.conf");
            }
            if (insightResourceBundle != null) {
                this.resourceBundles.addElement(insightResourceBundle);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCachedBundle():\n" + InsightUtilities.getStackTrace(exception));
        }
        return insightResourceBundle;
    }

    protected BaseResourceBundle getCachedResourceBundle(String string, String string2, String string3) {
        BaseResourceBundle baseResourceBundle = null;
        try {
            if (this.resourceBundles == null) {
                this.resourceBundles = new Vector();
            }
            for (int i = 0; i < this.resourceBundles.size(); ++i) {
                if (this.resourceBundles.elementAt(i) instanceof BaseResourceBundle) {
                    baseResourceBundle = (BaseResourceBundle)this.resourceBundles.elementAt(i);
                }
                if (baseResourceBundle.languageCode != string2 || baseResourceBundle.countryCode != string3) continue;
                return baseResourceBundle;
            }
            try {
                baseResourceBundle = new BaseResourceBundle(LOCALE_FILE_DIR + System.getProperty("file.separator") + string2 + "_" + string3 + System.getProperty("file.separator") + string + "_" + string2 + "_" + string3 + ".conf");
            }
            catch (Exception exception) {
                this.debugOut("There was a problem loading the requested InsightResourceBundle.  Creating the default one instead. exc:\n" + InsightUtilities.getStackTrace(exception));
                baseResourceBundle = new BaseResourceBundle(LOCALE_FILE_DIR + System.getProperty("file.separator") + "en_US" + System.getProperty("file.separator") + string + "_en_US.conf");
            }
            if (baseResourceBundle != null) {
                this.resourceBundles.addElement(baseResourceBundle);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCachedBundle():\n" + InsightUtilities.getStackTrace(exception));
        }
        return baseResourceBundle;
    }

    public void getDefaultBGURL() {
        int n;
        int n2;
        int n3;
        this.debugOut("in getDefaultBGURL()");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.debugOut("InsightUserServer.MULTIPLE_COLLECTION_IMAGE in UserServer is: " + InsightUserServer.MULTIPLE_COLLECTION_IMAGE);
        if (InsightUserServer.MULTIPLE_COLLECTION_IMAGE.equals("collection-images/back.gif")) {
            n3 = 51;
            n2 = 51;
            n = 51;
        } else {
            n3 = InsightUserServer.MULTIPLE_COLLECTION_COLOR_R;
            n2 = InsightUserServer.MULTIPLE_COLLECTION_COLOR_G;
            n = InsightUserServer.MULTIPLE_COLLECTION_COLOR_B;
        }
        Color color = new Color(n3, n2, n);
        hashtable.put("DefaultBGURL", InsightUserServer.MULTIPLE_COLLECTION_IMAGE);
        hashtable.put("DefaultColor", color);
        this.debugOut("DefaultBGURL is: " + hashtable.get("DefaultBGURL"));
        this.debugOut("DefaultColor is: " + hashtable.get("DefaultColor").toString());
        try {
            this.oos.writeObject(hashtable);
            this.oos.flush();
        }
        catch (IOException iOException) {
            this.debugOut("Caught an IOException flushing out the defaultBGColor and DefaultColor. exc:\n" + InsightUtilities.getStackTrace(iOException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtualCollectionInfo getVirtualCollection(int n, String string, String string2, String string3, String string4, int n2, String string5, String string6, int n3, String string7, String string8, int n4) {
        VirtualCollectionInfo virtualCollectionInfo;
        block9: {
            this.debugOut("in getVirtualCollectionInfo().");
            virtualCollectionInfo = null;
            DatabaseConnector databaseConnector = null;
            try {
                databaseConnector = this.getDatabaseConnector();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("COLLECTIONS", null, new String[]{"*"});
                sqlQueryGenerator.addJoin("VIRTUALCOLLECTIONMAP", "CollectionServerID", "COLLECTIONS", "ServerID", 0);
                sqlQueryGenerator.appendToWhere("VIRTUALCOLLECTIONMAP.VirtualCollectionServerID = " + n2);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Virtual collection query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runQuery();
                if (!databaseConnector.more()) break block9;
                virtualCollectionInfo = new VirtualCollectionInfo(n, string, string2, string3, string4, n2, string5, string6, n3, string7, string8, n4);
                Vector<TrinityCollectionInfo> vector = new Vector<TrinityCollectionInfo>();
                while (databaseConnector.more()) {
                    TrinityCollectionInfo trinityCollectionInfo = new TrinityCollectionInfo(n, string, databaseConnector.getFieldByName("InstitutionID"), databaseConnector.getFieldByName("CollectionID"), databaseConnector.getIntegerFieldByName("ServerID"), databaseConnector.getFieldByName("CollectionName"), databaseConnector.getFieldByName("ServerAddress"), databaseConnector.getIntegerFieldByName("ServerPort"), string7, string8, n4);
                    trinityCollectionInfo.setGroupDisplayName("VCI-Member");
                    trinityCollectionInfo.setSessionGroupName(trinityCollectionInfo.getUserGroupName());
                    trinityCollectionInfo.setSessionCodeKey(trinityCollectionInfo.getUserGroupCodeKey());
                    try {
                        trinityCollectionInfo.setCollectionUniqueID(databaseConnector.getStringField("CollectionUniqueID"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.debugOut("VC: Name: " + trinityCollectionInfo.getCollectionName() + ", InstitutionID: " + trinityCollectionInfo.getInstitutionID() + ", CollectionID: " + trinityCollectionInfo.getCollectionID() + ", Server address: " + trinityCollectionInfo.getServerAddress() + ", Server port: " + trinityCollectionInfo.getServerPort());
                    vector.addElement(trinityCollectionInfo);
                    databaseConnector.next();
                }
                virtualCollectionInfo.setCollections(vector);
            }
            catch (Exception exception) {
                virtualCollectionInfo = null;
                this.debugOut("Exception in getVirtualCollection():\n" + InsightUtilities.getStackTrace(exception));
            }
            finally {
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
            }
        }
        return virtualCollectionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserGroupShell getShare(int n) {
        UserGroupShell userGroupShell = null;
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERSHARES", null, new String[]{"ShareName", "LegacyCodeKey", "OwnerID"});
            sqlQueryGenerator.appendToWhere("ShareID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                userGroupShell = new UserGroupShell(n, databaseConnector.getIntegerField("OwnerID", -1), databaseConnector.getFieldByName("ShareName"), databaseConnector.getFieldByName("LegacyCodeKey"), false, false, false);
            }
        }
        catch (Exception exception) {
            this.debugOut("In getShare(id), exception:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return userGroupShell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserGroupShell getShare(String string) {
        UserGroupShell userGroupShell = null;
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERSHARES", null, new String[]{"ShareID", "LegacyCodeKey", "OwnerID"});
            sqlQueryGenerator.appendToWhere("ShareName = " + sqlQueryGenerator.prepStringForQuery(string));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                userGroupShell = new UserGroupShell(databaseConnector.getIntegerField("ShareID"), databaseConnector.getIntegerField("OwnerID", -1), string, databaseConnector.getFieldByName("LegacyCodeKey"), false, false, false);
            }
        }
        catch (Exception exception) {
            this.debugOut("In getShare(name), exception:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return userGroupShell;
    }

    protected void getUserGroupsAndSharesForUser() {
        try {
            String string = (String)this.ois.readObject();
            this.getUserGroupKeyList(string);
            this.getShareKeyList(string);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUserGroupKeysByUsername:\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getUserGroupKeyList(String string) {
        this.debugOut("In getUserGroupKeys().");
        DatabaseConnector databaseConnector = null;
        Object object = null;
        try {
            try {
                object = this.getUserManagementLock(string, null, null);
                databaseConnector = this.getDatabaseConnector();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("USERGROUPS", null, new String[]{"GroupName", "GroupCodeKey", "DisplayName"});
                if (string != null) {
                    sqlQueryGenerator.addJoin("USERGROUPS", "USERGROUPMAP", "GroupID", 0);
                    sqlQueryGenerator.addJoin("USERGROUPMAP", "USERLIST", "UserID", 0);
                    sqlQueryGenerator.appendToWhere("USERLIST.UserName = " + sqlQueryGenerator.prepStringForQuery(string));
                }
                sqlQueryGenerator.addOrderBy("USERGROUPS", "GroupName");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                ArrayList<UserGroupKey> arrayList = new ArrayList<UserGroupKey>();
                while (databaseConnector.more()) {
                    String string2 = databaseConnector.getFieldByName("GroupName");
                    String string3 = databaseConnector.getFieldByName("GroupCodeKey");
                    arrayList.add(new UserGroupKey(string2, string3));
                    databaseConnector.next();
                }
                this.oos.writeObject(arrayList);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception getting the user group key list:\n" + InsightUtilities.getStackTrace(exception));
                Object var9_10 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
            }
            Object var9_9 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getShareListByUserID(int n) {
        this.debugOut("in getShareListByUserID(userID).");
        DatabaseConnector databaseConnector = null;
        try {
            Vector<UserGroupShell> vector = new Vector<UserGroupShell>();
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERSHARES", null, new String[]{"ShareID", "ShareName", "LegacyCodeKey", "OwnerID"});
            sqlQueryGenerator.addTable("USERSHAREMAP", null, new String[]{"WritePriv", "DeletePriv", "CreateFolderPriv"});
            sqlQueryGenerator.addJoin("USERSHARES", "USERSHAREMAP", "ShareID", 0);
            sqlQueryGenerator.appendToWhere("USERSHAREMAP.UserID = " + n);
            sqlQueryGenerator.addOrderBy("USERSHARES", "ShareName");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("share list query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                try {
                    int n2 = databaseConnector.getIntegerFieldByName("ShareID");
                    int n3 = databaseConnector.getIntegerField("OwnerID", -1);
                    String string = databaseConnector.getFieldByName("ShareName");
                    String string2 = databaseConnector.getFieldByName("LegacyCodeKey");
                    boolean bl = databaseConnector.getIntegerFieldByName("WritePriv") == 1;
                    boolean bl2 = databaseConnector.getIntegerFieldByName("DeletePriv") == 1;
                    boolean bl3 = databaseConnector.getIntegerFieldByName("CreateFolderPriv") == 1;
                    UserGroupShell userGroupShell = string2 == null ? new UserGroupShell(n2, n3, string, bl, bl2, bl3) : new UserGroupShell(n2, n3, string, string2, bl, bl2, bl3);
                    vector.addElement(userGroupShell);
                }
                catch (Exception exception) {
                    this.debugOut("In getShareListByUserID(), exception adding UserGroupShell:\n" + InsightUtilities.getStackTrace(exception));
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            Vector<UserGroupShell> vector2 = vector;
            return vector2;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getShareList(userID):\n" + InsightUtilities.getStackTrace(exception));
            List list = null;
            return list;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    protected void getShareGroupCount() {
        this.debugOut("in getUGShellGroupCount()");
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            this.oos.writeInt(this.ius.getImageGroupFileManager().getGroupFileCountForShare(string, string2));
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("In getShareGroupCount, exception:\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getUserKeyListByGroup() {
        try {
            this.getUserKeyList((String)this.ois.readObject(), 1);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUserKeyListByGroup():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getUserKeyListByShare() {
        try {
            this.getUserKeyList((String)this.ois.readObject(), 2);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUserKeyListByShare():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getUserKeyList(String string, int n) {
        this.debugOut("in getUserKeyList().");
        DatabaseConnector databaseConnector = null;
        Object object = null;
        try {
            try {
                ArrayList<UserKey> arrayList = new ArrayList<UserKey>();
                if (n == 1) {
                    object = this.getUserManagementLock(null, string, null);
                } else if (n == 2) {
                    object = this.getUserManagementLock(null, null, string);
                }
                databaseConnector = this.getDatabaseConnector();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("USERLIST", null, new String[]{"UserName", "FirstName", "LastName"});
                if (n == 1 || n == 2) {
                    if (string == null || string.equals("")) {
                        this.oos.writeObject(arrayList);
                        this.oos.flush();
                        Object var9_8 = null;
                        if (databaseConnector != null) {
                            databaseConnector.close();
                        }
                        this.releaseUserManagementLock(object);
                        return;
                    }
                    if (n == 1) {
                        sqlQueryGenerator.addJoin("USERGROUPMAP", "USERLIST", "UserID", 0);
                        sqlQueryGenerator.addJoin("USERGROUPS", "USERGROUPMAP", "GroupID", 0);
                        sqlQueryGenerator.appendToWhere("USERGROUPS.GroupName = " + sqlQueryGenerator.prepStringForQuery(string));
                    } else if (n == 2) {
                        sqlQueryGenerator.addTable("USERSHAREMAP", null, new String[]{"WritePriv", "DeletePriv", "CreateFolderPriv"});
                        sqlQueryGenerator.addJoin("USERSHAREMAP", "USERLIST", "UserID", 0);
                        sqlQueryGenerator.addJoin("USERSHARES", "USERSHAREMAP", "ShareID", 0);
                        sqlQueryGenerator.appendToWhere("USERSHARES.ShareName = " + sqlQueryGenerator.prepStringForQuery(string));
                    }
                }
                sqlQueryGenerator.addOrderBy("USERLIST", "UserName");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    UserKey userKey = new UserKey(databaseConnector.getField("UserName"), databaseConnector.getField("FirstName"), databaseConnector.getField("LastName"));
                    if (n == 2) {
                        userKey.setShareWritePriv(databaseConnector.getBooleanField("WritePriv"));
                        userKey.setShareDeletePriv(databaseConnector.getBooleanField("DeletePriv"));
                        userKey.setShareCreatePriv(databaseConnector.getBooleanField("CreateFolderPriv"));
                    }
                    arrayList.add(userKey);
                    databaseConnector.next();
                }
                this.oos.writeObject(arrayList);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in getUserKeyList():\n" + InsightUtilities.getStackTrace(exception));
                Object var9_10 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
        Object var9_9 = null;
        if (databaseConnector != null) {
            databaseConnector.close();
        }
        this.releaseUserManagementLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getShareKeyList(String string) {
        this.debugOut("in getShareKeyList().");
        DatabaseConnector databaseConnector = null;
        Object object = null;
        try {
            try {
                ArrayList<UserShareKey> arrayList = new ArrayList<UserShareKey>();
                object = this.getUserManagementLock(string, null, null);
                databaseConnector = this.getDatabaseConnector();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("USERSHARES", null, new String[]{"ShareName", "LegacyCodeKey", "OwnerID"});
                if (string != null) {
                    sqlQueryGenerator.addTable("USERSHAREMAP", null, new String[]{"WritePriv", "DeletePriv", "CreateFolderPriv"});
                    sqlQueryGenerator.addJoin("USERSHARES", "USERSHAREMAP", "ShareID", 0);
                    sqlQueryGenerator.addJoin("USERSHAREMAP", "USERLIST", "UserID", 0);
                    sqlQueryGenerator.appendToWhere("USERLIST.UserName = " + sqlQueryGenerator.prepStringForQuery(string));
                }
                sqlQueryGenerator.addOrderBy("USERSHARES", "ShareName");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    String string2 = databaseConnector.getField("ShareName");
                    String string3 = databaseConnector.getField("LegacyCodeKey");
                    int n = databaseConnector.getIntegerField("OwnerID", -1);
                    UserShareKey userShareKey = new UserShareKey(string2, string3);
                    if (string != null) {
                        userShareKey.setWritePriv(databaseConnector.getBooleanField("WritePriv"));
                        userShareKey.setDeletePriv(databaseConnector.getBooleanField("DeletePriv"));
                        userShareKey.setCreatePriv(databaseConnector.getBooleanField("CreateFolderPriv"));
                    }
                    arrayList.add(userShareKey);
                    databaseConnector.next();
                }
                this.oos.writeObject(arrayList);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in getShareKeyList():\n" + InsightUtilities.getStackTrace(exception));
                Object var11_12 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
            }
            Object var11_11 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
    }

    protected void getLegacyShareList_5_0_07() {
        this.debugOut("in getLegacyShareList().");
        try {
            List list = this.getShareListByUserID(this.ois.readInt());
            if (list != null) {
                this.oos.writeObject(list);
                this.oos.flush();
            } else {
                this.debugOut("An error occured getting the share list.\n");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getLegacyShareList():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addUserToShare() {
        this.debugOut("in addUserToShare().");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        try {
            try {
                boolean bl = false;
                String string = (String)this.ois.readObject();
                String string2 = (String)this.ois.readObject();
                boolean bl2 = this.ois.readBoolean();
                boolean bl3 = this.ois.readBoolean();
                boolean bl4 = this.ois.readBoolean();
                object = this.getUserManagementLock(string, null, string2);
                List list = this.entitiesExist(string, null, string2);
                if (list != null) {
                    int n = (Integer)list.get(0);
                    int n2 = (Integer)list.get(2);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserID", 2, stringBuffer2, n);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ShareID", 2, stringBuffer2, n2);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "WritePriv", 2, stringBuffer2, bl2);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DeletePriv", 2, stringBuffer2, bl3);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreateFolderPriv", 2, stringBuffer2, bl4);
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery("INSERT INTO USERSHAREMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                    int n3 = databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    if (n3 == -1) {
                        this.oos.writeBoolean(false);
                        this.oos.flush();
                        Object var17_17 = null;
                        if (databaseConnector != null) {
                            databaseConnector.close();
                        }
                        this.releaseUserManagementLock(object);
                        return;
                    }
                    bl = true;
                }
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in addUserToShare():\n" + InsightUtilities.getStackTrace());
                Object var17_19 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
        Object var17_18 = null;
        if (databaseConnector != null) {
            databaseConnector.close();
        }
        this.releaseUserManagementLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setUserShareRights() {
        this.debugOut("in setUserShareRights().");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        try {
            try {
                boolean bl = false;
                String string = (String)this.ois.readObject();
                String string2 = (String)this.ois.readObject();
                boolean bl2 = this.ois.readBoolean();
                boolean bl3 = this.ois.readBoolean();
                boolean bl4 = this.ois.readBoolean();
                object = this.getUserManagementLock(string, null, string2);
                List list = this.entitiesExist(string, null, string2);
                if (list != null) {
                    int n = (Integer)list.get(0);
                    int n2 = (Integer)list.get(2);
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery("DELETE FROM USERSHAREMAP WHERE UserID = " + n + " AND ShareID = " + n2);
                    int n3 = databaseConnector.runUpdateQuerySafe();
                    databaseConnector.close();
                    if (n3 > -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserID", 2, stringBuffer2, n);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ShareID", 2, stringBuffer2, n2);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "WritePriv", 2, stringBuffer2, bl2);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DeletePriv", 2, stringBuffer2, bl3);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreateFolderPriv", 2, stringBuffer2, bl4);
                        databaseConnector.setQuery("INSERT INTO USERSHAREMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                        n3 = databaseConnector.runUpdateQuery();
                        databaseConnector.close();
                        if (n3 > -1) {
                            bl = true;
                        }
                    } else {
                        this.oos.writeBoolean(false);
                        this.oos.flush();
                        Object var17_17 = null;
                        if (databaseConnector != null) {
                            databaseConnector.close();
                        }
                        this.releaseUserManagementLock(object);
                        return;
                    }
                }
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in setUserShareRights():\n" + InsightUtilities.getStackTrace(exception));
                Object var17_19 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
        Object var17_18 = null;
        if (databaseConnector != null) {
            databaseConnector.close();
        }
        this.releaseUserManagementLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getShareSubfolderList() {
        this.debugOut("in getShareSubfolderList().");
        Object object = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = this.getShare(string).getCodeKey();
            int n = this.ois.readInt();
            object = this.getUserManagementLock(null, null, string);
            this.oos.writeObject(this.getShareSubfolders(string, string2, n));
            this.oos.flush();
            this.releaseUserManagementLock(object);
        }
        catch (Exception exception) {
            this.debugOut("In getShareSubfolderList, exception:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            this.releaseUserManagementLock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getShareSubfolders(String string, String string2, int n) {
        this.debugOut("in getShareSubfolderListWorker().");
        DatabaseConnector databaseConnector = null;
        ArrayList<ShareFolder> arrayList = new ArrayList<ShareFolder>();
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERSHAREFOLDERS", null, new String[]{"ShareID", "FolderID", "ParentFolderID", "FolderName", "OwnerID", "Private"});
            sqlQueryGenerator.addJoin("USERSHAREFOLDERS", "USERSHARES", "ShareID", 0);
            sqlQueryGenerator.appendToWhere("USERSHARES.ShareName = " + sqlQueryGenerator.prepStringForQuery(string));
            if (n > 0) {
                sqlQueryGenerator.appendToWhere("USERSHAREFOLDERS.ParentFolderID = " + n);
            } else if (n == 0) {
                sqlQueryGenerator.appendToWhere("USERSHAREFOLDERS.ParentFolderID is null");
            }
            String string3 = sqlQueryGenerator.getQuery();
            databaseConnector.setQuery(string3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerField("ShareID");
                int n3 = databaseConnector.getIntegerField("FolderID");
                n = databaseConnector.getIntegerField("ParentFolderID");
                String string4 = databaseConnector.getStringField("FolderName");
                int n4 = databaseConnector.getIntegerField("OwnerID");
                boolean bl = databaseConnector.getIntegerField("Private") == 1;
                arrayList.add(new ShareFolder(string, n2, n3, n4, n, bl, string4, this.getSubfolderChildCount(string, string2, n2, n3)));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("In getShareSubfolders, exception:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getShareTreeList() {
        this.debugOut("in getShareTreeList().");
        DatabaseConnector databaseConnector = null;
        Object object = null;
        try {
            try {
                databaseConnector = this.getDatabaseConnector();
                String string = (String)this.ois.readObject();
                String string2 = (String)this.ois.readObject();
                object = this.getUserManagementLock(null, null, string);
                List list = this.buildFolderSubtree(string, string2, "root", 0, 1);
                this.oos.writeObject(list);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("In getShareSubfolderList, exception:\n" + InsightUtilities.getStackTrace(exception));
                Object var7_8 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
            }
            Object var7_7 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
    }

    protected List buildFolderSubtree(String string, String string2, String string3, int n, int n2) {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        Vector vector = this.ius.getImageGroupFileManager().getImageGroupFileList(string, string2, n);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new IGFLocator((String)iterator.next(), string, string2, string3, n, n2));
        }
        List list = this.getShareSubfolders(string, string2, n);
        iterator = list.iterator();
        while (iterator.hasNext()) {
            ShareFolder shareFolder = (ShareFolder)iterator.next();
            shareFolder.setNestingLevel(n2);
            arrayList.add(shareFolder);
            arrayList.addAll(this.buildFolderSubtree(string, string2, shareFolder.getName(), shareFolder.getFolderID(), n2 + 1));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSubfolderChildCount(String string, String string2, int n, int n2) {
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT COUNT(*) AS CHILDCOUNT FROM USERSHAREFOLDERS where (ShareID = " + n + " and ParentFolderID = " + n2 + ")");
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                int n3 = databaseConnector.getIntegerField("CHILDCOUNT") + this.getSubFolderIGFCount(string, string2, n2);
                return n3;
            }
        }
        catch (Exception exception) {
            this.debugOut("In getSubfolderChildCount, exception:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return this.getSubFolderIGFCount(string, string2, n2);
    }

    protected int getSubFolderIGFCount(String string, String string2, int n) {
        return this.ius.getImageGroupFileManager().getImageGroupFileList(string, string2, n).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createShareSubfolder() {
        DatabaseConnector databaseConnector;
        Object object;
        block23: {
            block22: {
                this.debugOut("in createShareSubfolder().");
                object = null;
                databaseConnector = null;
                try {
                    try {
                        String string = (String)this.ois.readObject();
                        String string2 = (String)this.ois.readObject();
                        int n = this.ois.readInt();
                        String string3 = (String)this.ois.readObject();
                        int n2 = this.ois.readInt();
                        object = this.getUserManagementLock(null, null, string);
                        List list = this.entitiesExist(null, null, string);
                        if (list == null) {
                            this.oos.writeBoolean(false);
                            this.oos.flush();
                            Object var20_10 = null;
                            if (databaseConnector != null) {
                                databaseConnector.close();
                            }
                            this.releaseUserManagementLock(object);
                            return;
                        }
                        int n3 = (Integer)list.get(2);
                        int n4 = -1;
                        list = this.entitiesExist(string2, null, null);
                        if (list != null) {
                            n4 = (Integer)list.get(0);
                        }
                        Object object2 = NEW_SHARE_MAXFOLDERID;
                        synchronized (object2) {
                            int n5 = 0;
                            databaseConnector = this.getDatabaseConnector();
                            try {
                                databaseConnector.setQuery("SELECT MAX(FolderID) as MaxID FROM USERSHAREFOLDERS");
                                databaseConnector.runQuerySafe();
                                if (databaseConnector.more()) {
                                    n5 = databaseConnector.getIntegerField("MaxID") + 1;
                                }
                                databaseConnector.close();
                            }
                            catch (JdbcConnectorError jdbcConnectorError) {
                                this.debugOut("Error in addAuthorizationEntity():\n" + InsightUtilities.getStackTrace(jdbcConnectorError));
                                this.oos.writeBoolean(false);
                                this.oos.flush();
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 7] lbl42 : MonitorExitStatement: MONITOREXIT : var11_18
                                Object var20_11 = null;
                                if (databaseConnector != null) {
                                    databaseConnector.close();
                                }
                                this.releaseUserManagementLock(object);
                                return;
                            }
                            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                            StringBuffer stringBuffer = new StringBuffer();
                            StringBuffer stringBuffer2 = new StringBuffer();
                            SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
                            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "ShareID", 2, stringBuffer2, n3);
                            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "FolderID", 2, stringBuffer2, n5);
                            if (n > 0) {
                                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "ParentFolderID", 2, stringBuffer2, n);
                            }
                            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "FolderName", 1, stringBuffer2, string3);
                            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "OwnerID", 2, stringBuffer2, n4);
                            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Private", 2, stringBuffer2, n2);
                            databaseConnector = this.getDatabaseConnector();
                            databaseConnector.setQuery("INSERT INTO USERSHAREFOLDERS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                            int n6 = databaseConnector.runUpdateQuery();
                            if (n6 == -1) {
                                this.oos.writeBoolean(false);
                                this.oos.flush();
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 21, 6] lbl66 : MonitorExitStatement: MONITOREXIT : var11_18
                                break block22;
                            }
                            this.oos.writeBoolean(true);
                            this.oos.flush();
                            break block23;
                        }
                    }
                    catch (Exception exception) {
                        this.debugOut("In createShareSubfolder, exception:\n" + InsightUtilities.getStackTrace(exception));
                        Object var20_14 = null;
                        if (databaseConnector != null) {
                            databaseConnector.close();
                        }
                        this.releaseUserManagementLock(object);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var20_15 = null;
                    if (databaseConnector != null) {
                        databaseConnector.close();
                    }
                    this.releaseUserManagementLock(object);
                    throw throwable;
                }
            }
            Object var20_12 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            return;
        }
        Object var20_13 = null;
        if (databaseConnector != null) {
            databaseConnector.close();
        }
        this.releaseUserManagementLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteShareSubfolder() {
        DatabaseConnector databaseConnector;
        Object object;
        block16: {
            block15: {
                block14: {
                    this.debugOut("in deleteShareSubfolder().");
                    object = null;
                    databaseConnector = null;
                    try {
                        try {
                            String string = (String)this.ois.readObject();
                            String string2 = this.getShare(string).getCodeKey();
                            object = this.getUserManagementLock(null, null, string);
                            int n = this.ois.readInt();
                            boolean bl = this.ois.readBoolean();
                            List list = this.entitiesExist(null, null, string);
                            if (list == null) {
                                this.oos.writeBoolean(false);
                                this.oos.flush();
                                Object var11_9 = null;
                                if (databaseConnector != null) {
                                    databaseConnector.close();
                                }
                                this.releaseUserManagementLock(object);
                                return;
                            }
                            int n2 = (Integer)list.get(2);
                            if (this.getSubfolderChildCount(string, string2, n2, n) != 0) {
                                this.oos.writeBoolean(false);
                                this.oos.flush();
                                break block14;
                            }
                            databaseConnector = this.getDatabaseConnector();
                            databaseConnector.setQuery("DELETE FROM USERSHAREFOLDERS where (ShareID = " + n2 + " and FolderID = " + n + ")");
                            int n3 = databaseConnector.runUpdateQuery();
                            if (n3 == -1) {
                                this.oos.writeBoolean(false);
                                this.oos.flush();
                                break block15;
                            }
                            this.oos.writeBoolean(true);
                            this.oos.flush();
                            break block16;
                        }
                        catch (Exception exception) {
                            this.debugOut("In deleteShareSubfolder, exception:\n" + InsightUtilities.getStackTrace(exception));
                            Object var11_13 = null;
                            if (databaseConnector != null) {
                                databaseConnector.close();
                            }
                            this.releaseUserManagementLock(object);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        if (databaseConnector != null) {
                            databaseConnector.close();
                        }
                        this.releaseUserManagementLock(object);
                        throw throwable;
                    }
                }
                Object var11_10 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
                return;
            }
            Object var11_11 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            return;
        }
        Object var11_12 = null;
        if (databaseConnector != null) {
            databaseConnector.close();
        }
        this.releaseUserManagementLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void deleteCollection() {
        block19: {
            this.debugOut("in deleteCollection");
            boolean bl = false;
            DatabaseConnector databaseConnector = null;
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)this.ois.readObject();
            int n = trinityCollectionInfo.getServerID();
            databaseConnector = this.getDatabaseConnector();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            databaseConnector.setQuery("SELECT IsVirtualCollection FROM COLLECTIONS WHERE ServerID = " + n);
            databaseConnector.runQuery();
            if (databaseConnector.getIntegerField("IsVirtualCollection") == 0) {
                String string = trinityCollectionInfo.getCollectionID();
                String string2 = trinityCollectionInfo.getInstitutionID();
                String string3 = trinityCollectionInfo.getServerAddress();
                int n2 = trinityCollectionInfo.getServerPort();
                String string4 = "SELECT ServerID FROM COLLECTIONS WHERE CollectionID = " + string + " AND InstitutionID = '" + string2 + "' AND ServerAddress = '" + string3 + "' AND ServerPort = " + n2 + " AND IsVirtualCollection = 1";
                databaseConnector.setQuery(string4);
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    Integer n3 = new Integer(databaseConnector.getIntegerField("ServerID"));
                    arrayList.add(n3);
                    databaseConnector.next();
                }
            }
            arrayList.add(new Integer(trinityCollectionInfo.getServerID()));
            for (int i = 0; i < arrayList.size(); ++i) {
                databaseConnector.setQuery("DELETE FROM COLLECTIONS WHERE ServerID = " + arrayList.get(i) + " AND Type = 0");
                int n4 = databaseConnector.runUpdateQuerySafe();
                if (n4 <= 0) continue;
                databaseConnector.setQuery("DELETE FROM USERGROUPSERVERMAP WHERE ServerID = " + arrayList.get(i));
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.setQuery("DELETE FROM VIRTUALCOLLECTIONMAP WHERE VirtualCollectionServerID = " + arrayList.get(i));
                databaseConnector.runUpdateQuery();
            }
            databaseConnector.setQuery("DELETE FROM USERGROUPS WHERE GroupID NOT IN (SELECT GroupID FROM USERGROUPSERVERMAP)");
            databaseConnector.runUpdateQuery();
            bl = true;
            Object var13_16 = null;
            try {
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (IOException iOException) {
                this.debugOut("IOException in deleteCollection() writing status:\n" + InsightUtilities.getStackTrace(iOException));
            }
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            break block19;
            {
                catch (Exception exception) {
                    this.debugOut("Exception in deleteCollection():\n" + InsightUtilities.getStackTrace(exception));
                    Object var13_17 = null;
                    try {
                        this.oos.writeBoolean(bl);
                        this.oos.flush();
                    }
                    catch (IOException iOException) {
                        this.debugOut("IOException in deleteCollection() writing status:\n" + InsightUtilities.getStackTrace(iOException));
                    }
                    if (databaseConnector != null) {
                        databaseConnector.close();
                    }
                    break block19;
                }
                catch (Error error) {
                    this.debugOut("Exception in deleteCollection():\n" + InsightUtilities.getStackTrace(error));
                    Object var13_18 = null;
                    try {
                        this.oos.writeBoolean(bl);
                        this.oos.flush();
                    }
                    catch (IOException iOException) {
                        this.debugOut("IOException in deleteCollection() writing status:\n" + InsightUtilities.getStackTrace(iOException));
                    }
                    if (databaseConnector != null) {
                        databaseConnector.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                try {
                    this.oos.writeBoolean(bl);
                    this.oos.flush();
                }
                catch (IOException iOException) {
                    this.debugOut("IOException in deleteCollection() writing status:\n" + InsightUtilities.getStackTrace(iOException));
                }
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCollection() {
        this.debugOut("in addCollection");
        DatabaseConnector databaseConnector = null;
        try {
            Object object = NEW_AUTHORIZATION_ENTITY_LOCK;
            synchronized (object) {
                int n;
                TrinityCollectionInfo trinityCollectionInfo;
                block17: {
                    trinityCollectionInfo = (TrinityCollectionInfo)this.ois.readObject();
                    n = 0;
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery("Select Max(ServerID) AS MaxID FROM COLLECTIONS");
                    databaseConnector.runQuery();
                    if (databaseConnector.more()) {
                        n = databaseConnector.getIntegerField("MaxID") + 1;
                    }
                    databaseConnector.close();
                    if (n != 0) break block17;
                    this.oos.writeBoolean(false);
                    this.oos.flush();
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                String string = trinityCollectionInfo.getVCID();
                boolean bl = !string.equals("NA");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ServerID", 2, stringBuffer2, n);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InstitutionID", 1, stringBuffer2, trinityCollectionInfo.getInstitutionID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CollectionID", 1, stringBuffer2, trinityCollectionInfo.getCollectionID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CollectionName", 1, stringBuffer2, trinityCollectionInfo.getCollectionName());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ServerAddress", 1, stringBuffer2, trinityCollectionInfo.getServerAddress());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ServerPort", 2, stringBuffer2, trinityCollectionInfo.getServerPort());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MedeEnabled", 2, stringBuffer2, !bl);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsVirtualCollection", 2, stringBuffer2, bl);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "VCID", 1, stringBuffer2, string);
                if (trinityCollectionInfo.getLocaleUserServer() != null) {
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LanguageCode", 1, stringBuffer2, trinityCollectionInfo.getLocaleUserServer().getLanguage());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CountryCode", 1, stringBuffer2, trinityCollectionInfo.getLocaleUserServer().getCountry());
                } else {
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LanguageCode", 1, stringBuffer2, "en");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CountryCode", 1, stringBuffer2, "US");
                }
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Type", 2, stringBuffer2, 0);
                databaseConnector.setQuery("INSERT INTO COLLECTIONS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                boolean bl2 = false;
                if (databaseConnector.runUpdateQuery() == 1) {
                    bl2 = true;
                }
                databaseConnector.close();
                if (bl2 && bl) {
                    sqlQueryGenerator = this.getQueryGeneratorUtil();
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "VirtualCollectionServerID", 2, stringBuffer2, n);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CollectionServerID", 2, stringBuffer2, n);
                    databaseConnector.setQuery("INSERT INTO VIRTUALCOLLECTIONMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                    bl2 = databaseConnector.runUpdateQuery() == 1;
                    databaseConnector.close();
                }
                this.oos.writeBoolean(bl2);
                if (bl2 && InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 10, 14), 7)) {
                    this.oos.writeInt(n);
                }
                this.oos.flush();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in addCollection():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCollectionToGroup() {
        this.debugOut("in addCollectionToGroup");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        try {
            try {
                boolean bl = false;
                CollectionKey collectionKey = (CollectionKey)this.ois.readObject();
                String string = (String)this.ois.readObject();
                int n = this.ois.readInt();
                String string2 = (String)this.ois.readObject();
                object = this.getUserManagementLock(null, string2, null);
                List list = this.entitiesExist(null, string2, null);
                if (list != null) {
                    int n2 = (Integer)list.get(1);
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable("COLLECTIONS", null, "ServerID");
                    sqlQueryGenerator.appendToWhere("CollectionID = " + sqlQueryGenerator.prepStringForQuery(collectionKey.getCollectionID()));
                    sqlQueryGenerator.appendToWhere("InstitutionID = " + sqlQueryGenerator.prepStringForQuery(collectionKey.getInstitutionID()));
                    sqlQueryGenerator.appendToWhere("VCID = " + sqlQueryGenerator.prepStringForQuery(collectionKey.getVCID()));
                    sqlQueryGenerator.appendToWhere("ServerAddress = " + sqlQueryGenerator.prepStringForQuery(string));
                    sqlQueryGenerator.appendToWhere("ServerPort = " + n);
                    sqlQueryGenerator.appendToWhere("Type = 0");
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    databaseConnector.runQuery();
                    boolean bl2 = true;
                    int n3 = 0;
                    if (databaseConnector.more()) {
                        n3 = databaseConnector.getIntegerField("ServerID");
                        databaseConnector.next();
                    } else {
                        bl2 = false;
                    }
                    if (databaseConnector.more()) {
                        bl2 = false;
                    }
                    databaseConnector.close();
                    if (bl2) {
                        sqlQueryGenerator = this.getQueryGenerator();
                        sqlQueryGenerator.addTable("USERGROUPSERVERMAP", "*");
                        sqlQueryGenerator.appendToWhere("ServerID = " + n3);
                        sqlQueryGenerator.appendToWhere("GroupID = " + n2);
                        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                        databaseConnector.runQuery();
                        if (!databaseConnector.more()) {
                            databaseConnector.close();
                            StringBuffer stringBuffer = new StringBuffer();
                            StringBuffer stringBuffer2 = new StringBuffer();
                            SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
                            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "ServerID", 2, stringBuffer2, n3);
                            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer2, n2);
                            databaseConnector.setQuery("INSERT INTO USERGROUPSERVERMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                            if (databaseConnector.runUpdateQuery() == 1) {
                                bl = true;
                            }
                            databaseConnector.close();
                        } else {
                            databaseConnector.close();
                            bl = true;
                        }
                    }
                }
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in addCollectionToGroup():\n" + InsightUtilities.getStackTrace());
                Object var17_18 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
            }
            Object var17_17 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addUserToGroup() {
        this.debugOut("in addUserToGroup().");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        try {
            try {
                boolean bl = false;
                String string = (String)this.ois.readObject();
                String string2 = (String)this.ois.readObject();
                object = this.getUserManagementLock(string, string2, null);
                List list = this.entitiesExist(string, string2, null);
                if (list != null) {
                    int n = (Integer)list.get(0);
                    int n2 = (Integer)list.get(1);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserID", 2, stringBuffer2, n);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer2, n2);
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery("INSERT INTO USERGROUPMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                    int n3 = databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    if (n3 == -1) {
                        this.oos.writeBoolean(false);
                        this.oos.flush();
                        Object var14_14 = null;
                        if (databaseConnector != null) {
                            databaseConnector.close();
                        }
                        this.releaseUserManagementLock(object);
                        return;
                    }
                    bl = true;
                }
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in addUserToGroup():\n" + InsightUtilities.getStackTrace());
                Object var14_16 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
        Object var14_15 = null;
        if (databaseConnector != null) {
            databaseConnector.close();
        }
        this.releaseUserManagementLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeUserFromGroup() {
        this.debugOut("in removeUserFromGroup().");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        try {
            try {
                boolean bl = false;
                String string = (String)this.ois.readObject();
                String string2 = (String)this.ois.readObject();
                object = this.getUserManagementLock(string, string2, null);
                List list = this.entitiesExist(string, string2, null);
                if (list != null) {
                    int n = (Integer)list.get(0);
                    int n2 = (Integer)list.get(1);
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery("DELETE FROM USERGROUPMAP WHERE UserID = " + n + " AND GroupID = " + n2);
                    int n3 = databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    if (n3 == -1) {
                        this.oos.writeBoolean(false);
                        this.oos.flush();
                        Object var11_11 = null;
                        if (databaseConnector != null) {
                            databaseConnector.close();
                        }
                        this.releaseUserManagementLock(object);
                        return;
                    }
                    bl = true;
                }
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in removeUserFromGroup():\n" + InsightUtilities.getStackTrace());
                Object var11_13 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
        Object var11_12 = null;
        if (databaseConnector != null) {
            databaseConnector.close();
        }
        this.releaseUserManagementLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeUserFromShare() {
        this.debugOut("in removeUserFromShare().");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        try {
            try {
                boolean bl = false;
                String string = (String)this.ois.readObject();
                String string2 = (String)this.ois.readObject();
                object = this.getUserManagementLock(string, null, string2);
                List list = this.entitiesExist(string, null, string2);
                if (list != null) {
                    int n = (Integer)list.get(0);
                    int n2 = (Integer)list.get(2);
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery("DELETE FROM USERSHAREMAP WHERE UserID = " + n + " AND ShareID = " + n2);
                    int n3 = databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    if (n3 == -1) {
                        this.oos.writeBoolean(false);
                        this.oos.flush();
                        Object var11_11 = null;
                        if (databaseConnector != null) {
                            databaseConnector.close();
                        }
                        this.releaseUserManagementLock(object);
                        return;
                    }
                    bl = true;
                }
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in removeUserFromShare():\n" + InsightUtilities.getStackTrace());
                Object var11_13 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
        Object var11_12 = null;
        if (databaseConnector != null) {
            databaseConnector.close();
        }
        this.releaseUserManagementLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAuthorizationEntity() {
        this.debugOut("in saveAuthorizationEntity().");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
        try {
            try {
                boolean bl = false;
                int n = this.ois.readInt();
                Object object2 = this.ois.readObject();
                List list = null;
                String string = null;
                switch (n) {
                    case 0: {
                        Object object3 = (InsightUser)object2;
                        String string2 = ((InsightUser)object3).getLoginName();
                        object = this.getUserManagementLock(string2, null, null);
                        list = this.entitiesExist(string2, null, null);
                        string2 = sqlQueryGenerator.prepStringForQuery(string2);
                        String string3 = ((InsightUser)object3).getPassword() == null ? null : sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getPassword());
                        String string4 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getOrganization());
                        String string5 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getEmail());
                        String string6 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getPhone());
                        String string7 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getAddress());
                        String string8 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getCity());
                        String string9 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getState());
                        String string10 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getPostalCode());
                        String string11 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getCountry());
                        String string12 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getFirstName());
                        String string13 = sqlQueryGenerator.prepStringForQuery(((InsightUser)object3).getLastName());
                        string = "UPDATE USERLIST SET UserID = " + ((InsightUser)object3).getUserID() + ", " + "UserName = " + string2 + ", " + "Organization = " + string4 + ", " + "Email = " + string5 + ", " + "Phone = " + string6 + ", " + "Address = " + string7 + ", " + "City = " + string8 + ", " + "State = " + string9 + ", " + "PostalCode = " + string10 + ", " + "Country = " + string11 + ", " + "FirstName = " + string12 + ", " + "LastName = " + string13;
                        if (string3 != null) {
                            string = string + ", Password = " + string3;
                        }
                        string = string + " WHERE UserName = " + string2;
                        break;
                    }
                    case 1: {
                        Object object3 = (List)object2;
                        String string14 = (String)object3.get(1);
                        object = this.getUserManagementLock(null, string14, null);
                        list = this.entitiesExist(null, string14, null);
                        string14 = sqlQueryGenerator.prepStringForQuery(string14);
                        String string15 = sqlQueryGenerator.prepStringForQuery((String)object3.get(2));
                        String string16 = sqlQueryGenerator.prepStringForQuery((String)object3.get(3));
                        String string17 = sqlQueryGenerator.prepStringForQuery((String)object3.get(4));
                        string = "UPDATE USERGROUPS SET GroupID = " + object3.get(0) + ", " + "GroupName = " + string14 + ", " + "GroupCodeKey = " + string15 + ", " + "DisplayName = " + string16 + ", " + "Description = " + string17 + ", " + "ModifiedTimestamp = '" + new SimpleDate().get() + "' " + "WHERE GroupName = " + string14;
                        break;
                    }
                    case 2: {
                        Object object3 = (List)object2;
                        String string18 = (String)object3.get(1);
                        object = this.getUserManagementLock(null, null, string18);
                        list = this.entitiesExist(null, null, string18);
                        string18 = sqlQueryGenerator.prepStringForQuery(string18);
                        String string19 = sqlQueryGenerator.prepStringForQuery((String)object3.get(2));
                        string = "UPDATE USERSHARES SET ShareID = " + object3.get(0) + ", " + "ShareName = " + string18 + ", " + "LegacyCodeKey = " + string19 + ", " + "OwnerID = " + object3.get(3) + ", " + "ModifiedTimestamp = '" + new SimpleDate().get() + "' " + "WHERE ShareName = " + string18;
                    }
                }
                if (list != null) {
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery(string);
                    int n2 = databaseConnector.runUpdateQuery();
                    if (n2 == 1) {
                        bl = true;
                    }
                }
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in saveAuthorizationEntity():\n" + InsightUtilities.getStackTrace(exception));
                Object var23_31 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
            }
            Object var23_30 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
        }
        catch (Throwable throwable) {
            Object var23_32 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAuthorizationEntity() {
        this.debugOut("in removeAuthorizationEntity().");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
        try {
            try {
                boolean bl = false;
                int n = this.ois.readInt();
                String string = (String)this.ois.readObject();
                List list = null;
                int n2 = 0;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                switch (n) {
                    case 0: {
                        object = this.getUserManagementLock(string, null, null);
                        list = this.entitiesExist(string, null, null);
                        if (list != null) {
                            n2 = (Integer)list.get(0);
                        }
                        string2 = "DELETE FROM USERLIST WHERE UserName = " + sqlQueryGenerator.prepStringForQuery(string);
                        string3 = "DELETE FROM USERGROUPMAP WHERE UserID = " + n2;
                        string4 = "DELETE FROM USERSHAREMAP WHERE UserID = " + n2;
                        break;
                    }
                    case 1: {
                        object = this.getUserManagementLock(null, string, null);
                        list = this.entitiesExist(null, string, null);
                        if (list != null) {
                            n2 = (Integer)list.get(1);
                        }
                        string2 = "DELETE FROM USERGROUPS WHERE GroupName = " + sqlQueryGenerator.prepStringForQuery(string);
                        string3 = "DELETE FROM USERGROUPMAP WHERE GroupID = " + n2;
                        break;
                    }
                    case 2: {
                        object = this.getUserManagementLock(null, null, string);
                        list = this.entitiesExist(null, null, string);
                        if (list != null) {
                            n2 = (Integer)list.get(2);
                        }
                        string2 = "DELETE FROM USERSHARES WHERE ShareName = " + sqlQueryGenerator.prepStringForQuery(string);
                        string3 = "DELETE FROM USERSHAREMAP WHERE ShareID = " + n2;
                    }
                }
                if (list != null) {
                    try {
                        databaseConnector = this.getDatabaseConnector();
                        databaseConnector.setQuery(string2);
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                        databaseConnector.setQuery(string3);
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                        if (string4 != null) {
                            databaseConnector.setQuery(string4);
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        }
                        bl = true;
                    }
                    catch (JdbcConnectorError jdbcConnectorError) {
                        this.debugOut("Error in removeAuthorizationEntity():\n" + InsightUtilities.getStackTrace(jdbcConnectorError));
                        this.oos.writeBoolean(false);
                        this.oos.flush();
                        Object var14_14 = null;
                        if (databaseConnector != null) {
                            databaseConnector.close();
                        }
                        this.releaseUserManagementLock(object);
                        return;
                    }
                }
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in removeAuthorizationEntity():\n" + InsightUtilities.getStackTrace(exception));
                Object var14_16 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
            }
            Object var14_15 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAuthorizationEntityInfo() {
        this.debugOut("in getAuthorizationEntityInfo().");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        try {
            block23: {
                try {
                    int n = this.ois.readInt();
                    String string = (String)this.ois.readObject();
                    List list = null;
                    switch (n) {
                        case 0: {
                            object = this.getUserManagementLock(string, null, null);
                            list = this.entitiesExist(string, null, null);
                            break;
                        }
                        case 1: {
                            object = this.getUserManagementLock(null, string, null);
                            list = this.entitiesExist(null, string, null);
                            break;
                        }
                        case 2: {
                            object = this.getUserManagementLock(null, null, string);
                            list = this.entitiesExist(null, null, string);
                        }
                    }
                    ArrayList<Object> arrayList = null;
                    if (list == null) break block23;
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                    switch (n) {
                        case 0: {
                            arrayList = new ArrayList<Object>();
                            break;
                        }
                        case 1: {
                            sqlQueryGenerator.addTable("USERGROUPS", null, "*");
                            sqlQueryGenerator.appendToWhere("GroupName = " + sqlQueryGenerator.prepStringForQuery(string));
                            break;
                        }
                        case 2: {
                            sqlQueryGenerator.addTable("USERSHARES", null, "*");
                            sqlQueryGenerator.appendToWhere("ShareName = " + sqlQueryGenerator.prepStringForQuery(string));
                        }
                    }
                    if (n != 0) {
                        databaseConnector = this.getDatabaseConnector();
                        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                        databaseConnector.runQuery();
                        if (databaseConnector.more()) {
                            arrayList = new ArrayList();
                            switch (n) {
                                case 1: {
                                    arrayList.add(new Integer(databaseConnector.getIntegerField("GroupID")));
                                    arrayList.add(databaseConnector.getStringField("GroupName"));
                                    arrayList.add(databaseConnector.getStringField("GroupCodeKey"));
                                    arrayList.add(databaseConnector.getStringField("DisplayName"));
                                    arrayList.add(databaseConnector.getStringField("Description"));
                                    arrayList.add(databaseConnector.getStringField("CreatedTimestamp"));
                                    arrayList.add(databaseConnector.getStringField("ModifiedTimestamp"));
                                    break;
                                }
                                case 2: {
                                    arrayList.add(new Integer(databaseConnector.getIntegerField("ShareID")));
                                    arrayList.add(databaseConnector.getStringField("ShareName"));
                                    arrayList.add(databaseConnector.getStringField("LegacyCodeKey"));
                                    arrayList.add(new Integer(databaseConnector.getIntegerField("OwnerID")));
                                    arrayList.add(databaseConnector.getStringField("CreatedTimestamp"));
                                    arrayList.add(databaseConnector.getStringField("ModifiedTimestamp"));
                                }
                            }
                            databaseConnector.next();
                        }
                        databaseConnector.close();
                    }
                    this.oos.writeObject(arrayList);
                    this.oos.flush();
                }
                catch (Exception exception) {
                    this.debugOut("Exception in getAuthorizationEntityInfo():\n" + InsightUtilities.getStackTrace(exception));
                    Object var9_10 = null;
                    if (databaseConnector != null) {
                        databaseConnector.close();
                    }
                    this.releaseUserManagementLock(object);
                }
            }
            Object var9_9 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuthorizationEntity() {
        this.debugOut("in addAuthorizationEntity().");
        Object object = null;
        DatabaseConnector databaseConnector = null;
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
        try {
            try {
                String string;
                boolean bl = false;
                int n = this.ois.readInt();
                Object object2 = this.ois.readObject();
                String string2 = null;
                if (n == 1) {
                    string = (String)((List)object2).get(0);
                    string2 = (String)((List)object2).get(1);
                } else {
                    string = (String)object2;
                }
                List list = null;
                String string3 = null;
                switch (n) {
                    case 0: {
                        object = this.getUserManagementLock(string, null, null);
                        list = this.entitiesExist(string, null, null);
                        string3 = "SELECT MAX(UserID) AS MaxID FROM (Select UserID FROM USERLIST UNION SELECT UserID FROM USERGROUPMAP) MaxUnion";
                        break;
                    }
                    case 1: {
                        object = this.getUserManagementLock(null, string, null);
                        list = this.entitiesExist(null, string, null);
                        string3 = "SELECT MAX(GroupID) AS MaxID FROM (Select GroupID FROM USERGROUPS UNION SELECT GroupID FROM USERGROUPMAP) MaxUnion";
                        break;
                    }
                    case 2: {
                        object = this.getUserManagementLock(null, null, string);
                        list = this.entitiesExist(null, null, string);
                        string3 = "SELECT MAX(ShareID) AS MaxID FROM (Select ShareID FROM USERSHARES UNION Select ShareID FROM USERSHAREMAP) MaxUnion";
                    }
                }
                if (list == null) {
                    Object object3 = NEW_AUTHORIZATION_ENTITY_LOCK;
                    synchronized (object3) {
                        int n2 = 0;
                        databaseConnector = this.getDatabaseConnector();
                        databaseConnector.setQuery(string3);
                        try {
                            databaseConnector.runQuerySafe();
                            if (databaseConnector.more()) {
                                n2 = databaseConnector.getIntegerField("MaxID");
                            }
                            databaseConnector.close();
                        }
                        catch (JdbcConnectorError jdbcConnectorError) {
                            this.debugOut("Error in addAuthorizationEntity():\n" + InsightUtilities.getStackTrace(jdbcConnectorError));
                            this.oos.writeBoolean(false);
                            this.oos.flush();
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 17, 2, 6, 30] lbl51 : MonitorExitStatement: MONITOREXIT : var11_12
                            Object var19_16 = null;
                            if (databaseConnector != null) {
                                databaseConnector.close();
                            }
                            this.releaseUserManagementLock(object);
                            return;
                        }
                        String string4 = null;
                        switch (n) {
                            case 0: {
                                StringBuffer stringBuffer = new StringBuffer();
                                StringBuffer stringBuffer2 = new StringBuffer();
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserID", 2, stringBuffer2, ++n2);
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserName", 1, stringBuffer2, string);
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, new SimpleDate().get());
                                string4 = "INSERT INTO USERLIST (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                                break;
                            }
                            case 1: {
                                StringBuffer stringBuffer = new StringBuffer();
                                StringBuffer stringBuffer3 = new StringBuffer();
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer3, ++n2);
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupName", 1, stringBuffer3, string);
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupCodeKey", 1, stringBuffer3, string2);
                                String string5 = new SimpleDate().get();
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer3, string5);
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ModifiedTimestamp", 1, stringBuffer3, string5);
                                string4 = "INSERT INTO USERGROUPS (" + stringBuffer + ") VALUES (" + stringBuffer3 + ")";
                                break;
                            }
                            case 2: {
                                StringBuffer stringBuffer = new StringBuffer();
                                StringBuffer stringBuffer4 = new StringBuffer();
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ShareID", 2, stringBuffer4, ++n2);
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ShareName", 1, stringBuffer4, string);
                                String string6 = new SimpleDate().get();
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer4, string6);
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ModifiedTimestamp", 1, stringBuffer4, string6);
                                string4 = "INSERT INTO USERSHARES (" + stringBuffer + ") VALUES (" + stringBuffer4 + ")";
                            }
                        }
                        databaseConnector.setQuery(string4);
                        try {
                            if (databaseConnector.runUpdateQuerySafe() > -1) {
                                bl = true;
                            }
                        }
                        catch (JdbcConnectorError jdbcConnectorError) {
                            this.debugOut("Error in addAuthorizationEntity():\n" + InsightUtilities.getStackTrace(jdbcConnectorError));
                        }
                    }
                }
                this.oos.writeBoolean(bl);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in addAuthorizationEntity():\n" + InsightUtilities.getStackTrace(exception));
                Object var19_18 = null;
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
                this.releaseUserManagementLock(object);
            }
            Object var19_17 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            this.releaseUserManagementLock(object);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMasterServerList() {
        this.debugOut("in getMasterServerList().");
        DatabaseConnector databaseConnector = null;
        try {
            InsightUser insightUser = (InsightUser)this.ois.readObject();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("COLLECTIONS", null, "*");
            sqlQueryGenerator.appendToWhere("Type = 2");
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("get master server list query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            ArrayList<TrinityCollectionInfo> arrayList = new ArrayList<TrinityCollectionInfo>();
            while (databaseConnector.more()) {
                TrinityCollectionInfo trinityCollectionInfo = new TrinityCollectionInfo(insightUser.getUserID(), insightUser.getLoginName(), databaseConnector.getFieldByName("InstitutionID"), databaseConnector.getFieldByName("CollectionID"), databaseConnector.getIntegerFieldByName("ServerID"), databaseConnector.getFieldByName("CollectionName"), databaseConnector.getFieldByName("ServerAddress"), databaseConnector.getIntegerFieldByName("ServerPort"), null, null, -1);
                trinityCollectionInfo.setUserServerRecordType(databaseConnector.getIntegerField("Type"));
                arrayList.add(trinityCollectionInfo);
                databaseConnector.next();
            }
            this.oos.writeObject(arrayList);
            this.oos.flush();
        }
        catch (Error error) {
            this.debugOut("Error in getMasterServerList():\n" + InsightUtilities.getStackTrace(error));
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMasterServerList():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doesImageGroupFileExist() {
        this.debugOut("in doesImageGroupFileExist().");
        Object object = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            String string3 = (String)this.ois.readObject();
            int n = 0;
            if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 1, 0), 7)) {
                n = this.ois.readInt();
            }
            boolean bl = false;
            object = this.getUserManagementLock(null, null, string);
            ImageGroupFileManager imageGroupFileManager = this.ius.getImageGroupFileManager();
            synchronized (imageGroupFileManager) {
                bl = this.ius.getImageGroupFileManager().doesImageGroupFileExist(string, string2, n, string3);
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
            this.releaseUserManagementLock(object);
        }
        catch (Exception exception) {
            this.debugOut("Exception in doesImageGroupFileExist():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            this.releaseUserManagementLock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getImageGroupFileList() {
        this.debugOut("in getImageGroupFileList().");
        Object object = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            int n = 0;
            if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 1, 0), 7)) {
                n = this.ois.readInt();
            }
            Vector vector = new Vector(0);
            Hashtable<String, List> hashtable = new Hashtable<String, List>(0);
            object = this.getUserManagementLock(null, null, string);
            ImageGroupFileManager imageGroupFileManager = this.ius.getImageGroupFileManager();
            synchronized (imageGroupFileManager) {
                vector = this.ius.getImageGroupFileManager().getImageGroupFileList(string, string2, n);
                for (int i = 0; vector != null && i < vector.size(); ++i) {
                    String string3 = (String)vector.get(i);
                    hashtable.put(string3, this.ius.getImageGroupFileManager().getPresentationNames(string, string2, n, string3));
                }
            }
            this.oos.writeObject(vector);
            if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(4, 0, 1), 7)) {
                this.oos.writeObject(hashtable);
            }
            this.oos.flush();
            this.releaseUserManagementLock(object);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageGroupFileList():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            this.releaseUserManagementLock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getImageGroupFile() {
        this.debugOut("in getImageGroupFile().");
        Object object = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            int n = 0;
            if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 1, 0), 7)) {
                n = this.ois.readInt();
            }
            String string3 = (String)this.ois.readObject();
            ImageGroupFile imageGroupFile = null;
            object = this.getUserManagementLock(null, null, string);
            ImageGroupFileManager imageGroupFileManager = this.ius.getImageGroupFileManager();
            synchronized (imageGroupFileManager) {
                imageGroupFile = this.ius.getImageGroupFileManager().getImageGroupFile(string, string2, n, string3);
            }
            if (imageGroupFile != null) {
                imageGroupFile.trimToSize();
            }
            this.oos.writeObject(imageGroupFile);
            this.oos.flush();
            this.releaseUserManagementLock(object);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageGroupFile():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            this.releaseUserManagementLock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImageGroupFile() {
        this.debugOut("in saveImageGroupFile().");
        Object object = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            int n = 0;
            if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 1, 0), 7)) {
                n = this.ois.readInt();
            }
            ImageGroupFile imageGroupFile = (ImageGroupFile)this.ois.readObject();
            boolean bl = this.ois.readBoolean();
            boolean bl2 = false;
            object = this.getUserManagementLock(null, null, string);
            ImageGroupFileManager imageGroupFileManager = this.ius.getImageGroupFileManager();
            synchronized (imageGroupFileManager) {
                bl2 = this.ius.getImageGroupFileManager().saveImageGroupFile(string, string2, n, imageGroupFile, bl);
            }
            this.oos.writeBoolean(bl2);
            this.oos.flush();
            this.releaseUserManagementLock(object);
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveImageGroupFile():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            this.releaseUserManagementLock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteImageGroupFile() {
        this.debugOut("in deleteImageGroupFile().");
        Object object = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            String string3 = (String)this.ois.readObject();
            String string4 = (String)this.ois.readObject();
            int n = 0;
            if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 1, 0), 7)) {
                n = this.ois.readInt();
            }
            String string5 = (String)this.ois.readObject();
            boolean bl = this.ois.readBoolean();
            boolean bl2 = false;
            object = this.getUserManagementLock(string, null, string3);
            ImageGroupFileManager imageGroupFileManager = this.ius.getImageGroupFileManager();
            synchronized (imageGroupFileManager) {
                bl2 = this.ius.getImageGroupFileManager().deleteImageGroupFile(string, string2, string3, string4, n, string5, bl);
            }
            this.oos.writeBoolean(bl2);
            this.oos.flush();
            this.releaseUserManagementLock(object);
        }
        catch (Exception exception) {
            this.debugOut("Exception in deleteImageGroupFile():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            this.releaseUserManagementLock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getPresentationNames() {
        this.debugOut("in getPresentationNames().");
        Object object = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            int n = 0;
            if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 1, 0), 7)) {
                n = this.ois.readInt();
            }
            String string3 = (String)this.ois.readObject();
            Vector vector = null;
            object = this.getUserManagementLock(null, null, string);
            ImageGroupFileManager imageGroupFileManager = this.ius.getImageGroupFileManager();
            synchronized (imageGroupFileManager) {
                vector = this.ius.getImageGroupFileManager().getPresentationNames(string, string2, n, string3);
            }
            if (vector == null) {
                vector = new Vector(0);
            }
            this.oos.writeObject(vector);
            this.oos.flush();
            this.releaseUserManagementLock(object);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getPresentationNames():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            this.releaseUserManagementLock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getPresentation() {
        this.debugOut("in getPresentation().");
        Object object = null;
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            int n = 0;
            if (InsightVersion.compareVersions(this.clientVersion, new InsightVersion(5, 1, 0), 7)) {
                n = this.ois.readInt();
            }
            String string3 = (String)this.ois.readObject();
            String string4 = (String)this.ois.readObject();
            ImageSeries imageSeries = null;
            object = this.getUserManagementLock(null, null, string);
            ImageGroupFileManager imageGroupFileManager = this.ius.getImageGroupFileManager();
            synchronized (imageGroupFileManager) {
                imageSeries = this.ius.getImageGroupFileManager().getPresentation(string, string2, n, string3, string4);
            }
            this.oos.writeObject(imageSeries);
            this.oos.flush();
            this.releaseUserManagementLock(object);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getPresentation():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            this.releaseUserManagementLock(object);
        }
    }

    protected void getDefaultFuzzyHelpMessage() {
        this.debugOut("in getDefaultFuzzyHelpMessage().");
        try {
            this.oos.writeObject(this.ius.getDefaultFuzzyHelpMessage());
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getDefaultFuzzyHelpMessage():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getInsightSecuritySettings() {
        this.debugOut("in getInsightSecuritySettings().");
        try {
            this.oos.writeObject(this.ius.getSecuritySettings());
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getInsightSecuritySettings():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected DatabaseConnector getDatabaseConnector() {
        return this.ius.getDatabaseConnectorGenerator().getConnector(this.connectString);
    }

    protected SqlQueryGenerator getQueryGenerator() {
        return this.ius.getQueryGenerator();
    }

    protected SqlQueryGenerator getQueryGeneratorUtil() {
        return this.ius.getQueryGeneratorUtil();
    }

    protected void debugOut(String string) {
        InsightUserServer.debugOut("IUS/" + this.ipAddress + ": " + string);
    }

    protected void debugOutStay(String string) {
        InsightUserServer.debugOutStay("IUS/" + this.ipAddress + ": " + string);
    }

    protected void debugOut(String string, int n) {
        InsightUserServer.debugOut("IUS/" + this.ipAddress + ": " + string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUserManagementLock(String string, String string2, String string3) {
        String string4;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            string4 = string.intern();
            synchronized (string4) {
                while (LOCKED_USERS.contains(string)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                LOCKED_USERS.add(string);
                arrayList.add(string);
            }
        } else {
            arrayList.add(null);
        }
        if (string2 != null) {
            string4 = string2.intern();
            synchronized (string4) {
                while (LOCKED_GROUPS.contains(string2)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                LOCKED_GROUPS.add(string2);
                arrayList.add(string2);
            }
        } else {
            arrayList.add(null);
        }
        if (string3 != null) {
            string4 = string3.intern();
            synchronized (string4) {
                while (LOCKED_SHARES.contains(string3)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                LOCKED_SHARES.add(string3);
                arrayList.add(string3);
            }
        } else {
            arrayList.add(null);
        }
        return arrayList;
    }

    private void releaseUserManagementLock(Object object) {
        if (object != null) {
            LOCKED_USERS.remove(((List)object).get(0));
            LOCKED_GROUPS.remove(((List)object).get(1));
            LOCKED_SHARES.remove(((List)object).get(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List entitiesExist(String string, String string2, String string3) {
        this.debugOut("In entitiesExist()");
        DatabaseConnector databaseConnector = null;
        boolean bl = true;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            String[] stringArray = new String[]{string, string2, string3};
            String[] stringArray2 = new String[]{"USERLIST", "USERGROUPS", "USERSHARES"};
            String[] stringArray3 = new String[]{"UserName", "GroupName", "ShareName"};
            String[] stringArray4 = new String[]{"UserID", "GroupID", "ShareID"};
            for (int i = 0; i < 3; ++i) {
                if (!bl) {
                    break;
                }
                String string4 = stringArray[i];
                if (string4 != null) {
                    bl = false;
                    if (databaseConnector == null) {
                        databaseConnector = this.getDatabaseConnector();
                    }
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable(stringArray2[i], null, new String[]{stringArray4[i]});
                    sqlQueryGenerator.appendToWhere(stringArray3[i] + " = " + sqlQueryGenerator.prepStringForQuery(stringArray[i]));
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("entitiesExist query " + i + "is: " + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        if (bl) {
                            bl = false;
                            break;
                        }
                        bl = true;
                        arrayList.add(new Integer(databaseConnector.getIntegerField(stringArray4[i])));
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    continue;
                }
                arrayList.add(null);
            }
        }
        catch (Exception exception) {
            bl = false;
            this.debugOut("Exception in entitiesExist:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl ? arrayList : null;
    }
}

