/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.license.InsightLicenseManager;
import com.luna.insight.server.Debug;
import com.luna.insight.server.EventLog;
import com.luna.insight.server.ImageGroupFileManager;
import com.luna.insight.server.InsightUserServicer;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.ThreadCounter;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.security.InsightSecuritySettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Properties;

public class InsightUserServer
extends Thread {
    public static final int DEBUG_LEVEL = 2;
    public static final String COMPONENT_NAME = "Insight User Server";
    public static final String COMPONENT_CODE = "IUS";
    public static String DEFAULT_CONNECT_STRING = "";
    public static final boolean DNS_LOOKUP = false;
    public static int LISTEN_PORT_NUMBER = 2840;
    public static final String DEFAULT_FUZZY_HELP_MESSAGE = "No help available.";
    public static String MULTIPLE_COLLECTION_IMAGE = "collection-images/back.gif";
    public static int MULTIPLE_COLLECTION_COLOR_R = 0;
    public static int MULTIPLE_COLLECTION_COLOR_G = 41;
    public static int MULTIPLE_COLLECTION_COLOR_B = 74;
    public static boolean LICENSED_USER_MANAGER = false;
    public static final String DEFAULT_LICENSE_FILE_PATH = "License-Files";
    public static String licenseFilePath = "License-Files";
    public int DATABASE_QUERY_MODE = 0;
    public String DATABASE_GLOBALESCAPEDELIMITER = null;
    public String DATABASE_UNICODEFIELDPREFIX = null;
    public SqlQueryGenerator sqlQueryGeneratorUtil = this.getQueryGenerator();
    public boolean USE_DISTINCT_KEYWORD = true;
    public String BOUND_SERVER_HOSTNAME = null;
    public String connectString = "";
    protected ThreadGroup threadGroup = new ThreadGroup("Insight User Servicers");
    protected boolean needThreadCounter = true;
    protected Properties properties;
    protected String logFilename = null;
    protected EventLog eventLog = null;
    protected String preferredConnector;
    protected boolean assumeSynchronizedFieldStandards = false;
    protected ImageGroupFileManager igfManager = new ImageGroupFileManager();
    protected DatabaseConnectorGenerator dbConnectorGenerator = null;
    public String FUZZY_HELP_FILE = "FuzzyHelpText.txt";
    public String FUZZY_DATE_HELP_TEXT = null;
    public InsightSecuritySettings securitySettings = null;
    private int TCP_BACKLOG = 64;

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase("-version")) continue;
                System.out.println("Insight User Server - Build of " + InsightVersion.releaseName());
                return;
            }
        }
        System.out.println("\nInsight User Server");
        System.out.println("Build " + InsightVersion.releaseName() + "\n");
        System.out.println("IUS: Operating on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        System.out.println("IUS: Java version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        Debug.setDebugLevel(0);
        InsightUserServer.gatherCommandLine(stringArray);
        InsightUserServer insightUserServer = new InsightUserServer(DEFAULT_CONNECT_STRING, null, Debug.getDebugLevel() == 0);
        insightUserServer.start();
    }

    public static void gatherCommandLine(String[] stringArray) {
        if (stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-p")) continue;
                if (stringArray[i].equalsIgnoreCase("-connectstring")) {
                    if (stringArray.length <= i + 1 || stringArray[i + 1] == null) continue;
                    DEFAULT_CONNECT_STRING = stringArray[++i];
                    continue;
                }
                if (!stringArray[i].equals("-d") || stringArray.length <= i + 1 || stringArray[i + 1] == null) continue;
                ++i;
                try {
                    int n = Integer.parseInt(stringArray[i]);
                    Debug.setDebugLevel(n);
                    System.out.println("IUS: Setting debug level to " + Debug.LEVELS[Debug.getDebugLevel()] + ".");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public static String pluralize(int n) {
        if (n == 1) {
            return "";
        }
        return "s";
    }

    public static void debugOut(String string) {
        Debug.debugOut("IUS: " + string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("IUS: " + string, n);
    }

    public static void debugOutStay(String string) {
        Debug.debugOutStay(string, 2);
    }

    public InsightUserServer(String string, ThreadGroup threadGroup) {
        this(string, threadGroup, true);
    }

    public InsightUserServer(String string, ThreadGroup threadGroup, boolean bl) {
        super("InsightUserServer");
        String string2;
        System.out.println("IUS: Starting up.");
        this.properties = this.loadProperties();
        try {
            this.TCP_BACKLOG = Integer.parseInt(this.properties.getProperty("TCPBacklog"));
            System.out.println("IUS: TCP_BACKLOG: (" + this.TCP_BACKLOG + ")");
        }
        catch (Exception exception) {
            System.out.println("IUS: TCP_BACKLOG: default (" + this.TCP_BACKLOG + ")");
        }
        this.dbConnectorGenerator = DatabaseConnectorGenerator.getCustomGenerator(this.properties);
        if (this.properties.getProperty("LogFilename") != null) {
            this.logFilename = this.properties.getProperty("LogFilename");
            String string3 = InsightUtilities.appendDateToFilename(this.logFilename, ".txt");
            this.eventLog = new EventLog(this.logFilename, false);
        }
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("default")) {
            string = this.properties.getProperty("UserDatabaseConnect");
        }
        if (bl) {
            try {
                int n = Integer.parseInt(this.properties.getProperty("DebugLevel"));
                Debug.setDebugLevel(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            string2 = this.properties.getProperty("AssumeSynchronizedFieldStandards");
            this.assumeSynchronizedFieldStandards = string2 != null && string2.equals("1");
        }
        catch (Exception exception) {
            this.assumeSynchronizedFieldStandards = false;
        }
        try {
            this.DATABASE_QUERY_MODE = Integer.parseInt(this.properties.getProperty("DatabaseQueryMode", "" + this.DATABASE_QUERY_MODE));
        }
        catch (Exception exception) {
            this.DATABASE_QUERY_MODE = 0;
        }
        if (this.properties.getProperty("GlobalEscapeDelimiter") != null) {
            this.DATABASE_GLOBALESCAPEDELIMITER = this.properties.getProperty("GlobalEscapeDelimiter");
        }
        if (this.properties.getProperty("UnicodeFieldPrefix") != null) {
            this.DATABASE_UNICODEFIELDPREFIX = this.properties.getProperty("UnicodeFieldPrefix");
        }
        this.sqlQueryGeneratorUtil = this.getQueryGenerator();
        if (this.properties.getProperty("BoundServerHostname") != null) {
            this.BOUND_SERVER_HOSTNAME = this.properties.getProperty("BoundServerHostname");
        }
        try {
            string2 = this.properties.getProperty("UseDistinctKeyword");
            this.USE_DISTINCT_KEYWORD = string2.equals("1");
        }
        catch (Exception exception) {
            this.USE_DISTINCT_KEYWORD = true;
        }
        if (this.properties.getProperty("MultipleCollectionImage") != null && this.properties.getProperty("MultipleCollectionColorR") != null && this.properties.getProperty("MultipleCollectionColorG") != null && this.properties.getProperty("MultipleCollectionColorB") != null) {
            MULTIPLE_COLLECTION_IMAGE = this.properties.getProperty("MultipleCollectionImage");
            try {
                MULTIPLE_COLLECTION_COLOR_R = Integer.parseInt(this.properties.getProperty("MultipleCollectionColorR"));
                MULTIPLE_COLLECTION_COLOR_G = Integer.parseInt(this.properties.getProperty("MultipleCollectionColorG"));
                MULTIPLE_COLLECTION_COLOR_B = Integer.parseInt(this.properties.getProperty("MultipleCollectionColorB"));
            }
            catch (NumberFormatException numberFormatException) {
                InsightUserServer.debugOut("Caught a NumberFormatException while assigning MultipleCollectionColor values.");
                MULTIPLE_COLLECTION_IMAGE = "collection-images/back.gif";
                MULTIPLE_COLLECTION_COLOR_R = 0;
                MULTIPLE_COLLECTION_COLOR_G = 41;
                MULTIPLE_COLLECTION_COLOR_B = 74;
            }
        }
        this.securitySettings = new InsightSecuritySettings(this.properties);
        this.FUZZY_HELP_FILE = this.properties.getProperty("DefaultFuzzyDateHelpFile");
        if (this.properties.getProperty("LicenseFilePath") != null) {
            licenseFilePath = this.properties.getProperty("LicenseFilePath");
        }
        this.connectString = string;
        if (threadGroup != null) {
            this.threadGroup = threadGroup;
            this.needThreadCounter = false;
        }
    }

    public ImageGroupFileManager getImageGroupFileManager() {
        return this.igfManager;
    }

    public DatabaseConnectorGenerator getDatabaseConnectorGenerator() {
        return this.dbConnectorGenerator;
    }

    public String getDefaultFuzzyHelpMessage() {
        if (this.FUZZY_DATE_HELP_TEXT == null) {
            this.FUZZY_DATE_HELP_TEXT = this.readTextFromFile(this.FUZZY_HELP_FILE);
            if (this.FUZZY_DATE_HELP_TEXT.length() < 1) {
                this.FUZZY_DATE_HELP_TEXT = DEFAULT_FUZZY_HELP_MESSAGE;
            }
        }
        return this.FUZZY_DATE_HELP_TEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block21: {
            InsightLicenseManager insightLicenseManager = new InsightLicenseManager(licenseFilePath);
            LICENSED_USER_MANAGER = insightLicenseManager.checkUserManagerLicense();
            if (!LICENSED_USER_MANAGER) {
                Debug.debugOutAlways("No Valid License Found, shutting down.");
                System.exit(0);
            }
            ThreadCounter threadCounter = null;
            try {
                if (this.needThreadCounter) {
                    threadCounter = new ThreadCounter(this.threadGroup);
                    threadCounter.start();
                }
                String string = "0";
                boolean bl = true;
                DatabaseConnector databaseConnector = null;
                try {
                    databaseConnector = this.getDatabaseConnectorGenerator().getConnector(this.connectString);
                    databaseConnector.setQuery("select version from UMVERSION");
                    databaseConnector.runQuerySafe();
                    if (databaseConnector.more()) {
                        string = databaseConnector.getStringField("Version");
                        InsightUserServer.debugOut("Insight User Database Version: " + string);
                    }
                }
                catch (Exception exception) {
                    System.err.println("IUS: Couldn't Connect to database" + exception.getMessage());
                    Debug.debugOutAlways("Exception in run():\n" + exception.getMessage());
                    bl = false;
                }
                catch (Error error) {
                    System.err.println("IUS: Couldn't Connect to database" + error.getMessage());
                    Debug.debugOutAlways("Error in run():\n" + error.getMessage());
                    bl = false;
                }
                finally {
                    if (databaseConnector != null) {
                        databaseConnector.close();
                    }
                }
                if (string == "0") {
                    System.err.println("IUS: Database is not configured correctly");
                    bl = false;
                }
                if (!bl) break block21;
                InsightUserServer.debugOut("Listening to port " + LISTEN_PORT_NUMBER + ".");
                InetAddress inetAddress = null;
                if (InsightUtilities.isNonEmpty(this.BOUND_SERVER_HOSTNAME)) {
                    InsightUserServer.debugOut("Attempting to bind to server hostname: " + this.BOUND_SERVER_HOSTNAME);
                    try {
                        inetAddress = InetAddress.getByName(this.BOUND_SERVER_HOSTNAME);
                    }
                    catch (Exception exception) {
                        InsightUserServer.debugOut("Failed to bind to server hostname: " + this.BOUND_SERVER_HOSTNAME);
                        inetAddress = null;
                    }
                }
                ServerSocket serverSocket = inetAddress != null ? new ServerSocket(LISTEN_PORT_NUMBER, this.TCP_BACKLOG, inetAddress) : new ServerSocket(LISTEN_PORT_NUMBER, this.TCP_BACKLOG);
                Debug.debugOutAlways("Accepting connection.");
                while (true) {
                    InsightUserServer.debugOut("Accepting connection.");
                    Socket socket = serverSocket.accept();
                    InetAddress inetAddress2 = socket.getInetAddress();
                    InsightUserServer.debugOut("Connection received at " + new Date() + ".");
                    InsightUserServer.debugOut("Servicing connection from " + inetAddress2.getHostAddress() + ".");
                    InsightUserServicer insightUserServicer = new InsightUserServicer(socket, this.connectString, this);
                    Thread thread = new Thread(this.threadGroup, insightUserServicer);
                    try {
                        thread.setName("InsightUserServicer");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    InsightUserServer.debugOut("Starting servicer thread.");
                    thread.start();
                }
            }
            catch (IOException iOException) {
                InsightUserServer.debugOut("IOException on listener open.");
                InsightUserServer.debugOut("Server port cannot be opened.  Terminating.");
                if (threadCounter == null) break block21;
                threadCounter.setStillNeeded(false);
            }
        }
    }

    public void log(String string) {
        if (this.logFilename != null) {
            String string2 = InsightUtilities.appendDateToFilename(this.logFilename, ".txt");
            this.eventLog = new EventLog(string2, false);
            this.eventLog.log(string);
        }
    }

    public SqlQueryGenerator getQueryGenerator() {
        return new SqlQueryGenerator(this.DATABASE_QUERY_MODE, this.DATABASE_GLOBALESCAPEDELIMITER, this.DATABASE_UNICODEFIELDPREFIX);
    }

    public SqlQueryGenerator getQueryGeneratorUtil() {
        return this.sqlQueryGeneratorUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Properties loadProperties() {
        Properties properties;
        block11: {
            properties = new Properties();
            FileInputStream fileInputStream = null;
            InsightUserServer.debugOut("Configuration file is InsightUserServer.dat.");
            fileInputStream = new FileInputStream("InsightUserServer.dat");
            properties.load(fileInputStream);
            fileInputStream.close();
            Object var6_3 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (IOException iOException) {
                    InsightUserServer.debugOut("IUS: Cannot read configuration file!");
                    InsightUserServer.debugOut("IUS: Server terminating due to configuration file problems.");
                    System.exit(0);
                    Object var6_4 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String readTextFromFile(String string) {
        String string2;
        block13: {
            FileInputStream fileInputStream;
            block12: {
                string2 = "";
                fileInputStream = null;
                InsightUserServer.debugOut("Reading text from file " + string + ".");
                File file = new File(string);
                byte[] byArray = new byte[(int)file.length()];
                fileInputStream = new FileInputStream(file);
                int n = fileInputStream.read(byArray);
                fileInputStream.close();
                if (n == byArray.length) {
                    string2 = new String(byArray);
                    break block12;
                }
                InsightUserServer.debugOut("IUS: The required bytes were not read.");
            }
            Object var8_8 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block13;
            }
            catch (IOException iOException) {}
            break block13;
            {
                catch (Exception exception) {
                    InsightUserServer.debugOut("IUS: Exception in readTextFromFile, exc: " + exception);
                    string2 = "";
                    Object var8_9 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block13;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string2;
    }

    protected InsightSecuritySettings getSecuritySettings() {
        return this.securitySettings;
    }
}

