/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.DefaultTheme;
import com.luna.insight.server.CollectionConnection;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Debug;
import com.luna.insight.server.DynamicDistributionBucketInfo;
import com.luna.insight.server.DynamicDistributionThumbnailQuery;
import com.luna.insight.server.DynamicThumbnailDistribution;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.FieldListResult;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldStandard;
import com.luna.insight.server.FieldStandardMismatches;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.GroupInformation;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.ImageGroupFile;
import com.luna.insight.server.ImageInGroup;
import com.luna.insight.server.ImageToProcess;
import com.luna.insight.server.InsightJtipImage;
import com.luna.insight.server.InsightJtipListener;
import com.luna.insight.server.InsightJtipTile;
import com.luna.insight.server.InsightRequest;
import com.luna.insight.server.InsightServicerCommands;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightTransientPackager;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.KeepAliveMessage;
import com.luna.insight.server.MediaMetaData;
import com.luna.insight.server.MutableBoolean;
import com.luna.insight.server.MutableObject;
import com.luna.insight.server.ObjectDataRecord;
import com.luna.insight.server.ObjectDimension;
import com.luna.insight.server.ObjectIndicatorFieldCriterion;
import com.luna.insight.server.ObjectKey;
import com.luna.insight.server.ProxyPagingList;
import com.luna.insight.server.QueryGetter;
import com.luna.insight.server.QueryResultCollector;
import com.luna.insight.server.ResultsControllerInterface;
import com.luna.insight.server.ResultsProgressListener;
import com.luna.insight.server.StopRetrievalException;
import com.luna.insight.server.ThumbnailGetter;
import com.luna.insight.server.ThumbnailQuery;
import com.luna.insight.server.ThumbnailResultCollector;
import com.luna.insight.server.ThumbnailTallyMark;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.UniqueListGetter;
import com.luna.insight.server.UniqueListResultCollector;
import com.luna.insight.server.VersionResult;
import com.luna.insight.server.VirtualCollectionInfo;
import com.luna.insight.server.collectionmanagement.CollectionBuildingObject;
import com.luna.insight.server.hierarchy.HierarchyAncillaryData;
import com.luna.insight.server.hierarchy.HierarchyNodeData;
import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.MedePrivileges;
import com.luna.insight.server.io.InsightPkgRemoverOutputStream;
import com.luna.insight.server.io.InsightPkgSetterInputStream;
import com.luna.insight.server.links.ImageLinkData;
import com.luna.insight.server.links.LinkData;
import com.luna.insight.server.links.LinkFieldCriterion;
import com.luna.insight.server.links.LinkFieldMapping;
import com.luna.insight.server.mediacreation.IMediaBatch;
import com.luna.insight.server.mediacreation.IMediaBatchElement;
import com.luna.insight.server.mediacreation.ImportMediaResult;
import com.luna.insight.server.mpd.MpdSearchResults;
import com.luna.insight.server.mpd.MultipageDocumentSeries;
import com.luna.insight.server.mvi.MultiviewImageSeries;
import com.luna.insight.server.mvi.MultiviewImageSlide;
import com.luna.insight.server.personalcollections.PersonalCollection;
import com.luna.insight.server.presentation.ImageSeries;
import com.luna.insight.server.presentation.ImageSeriesSlide;
import com.luna.insight.server.ucb.FuzzyDateFieldCriterion;
import com.luna.insight.server.ucb.FuzzyDateJulianRange;
import com.luna.insight.server.usergroup.CollectionUserGroupKey;
import com.luna.insight.server.usergroup.UserGroupSessionResults;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;

public class InsightSmartClient
implements InsightServicerCommands {
    public static final int DEBUG_LEVEL = 3;
    public static final String COMPONENT_CODE = "ISC";
    public static final int DEFAULT_PORT_NUMBER = 2845;
    public static final int RESOLUTIONS = 8;
    protected static long WAIT_LIMIT = 30000L;
    protected static final int WAIT_PAUSE = 200;
    public static int TOTAL_CONNECTIONS = 0;
    public static final String COLLECTION_NAME_THUMB_FIELD = "Collection Name";
    public static final int COLLECTION_NAME_THUMB_FIELD_ID = 0;
    public static final String NONE_THUMB_FIELD = "None";
    public static final int NONE_THUMB_FIELD_ID = -1;
    public static boolean ASSUME_SYNCHRONIZED_FIELD_STANDARDS = false;
    private static final ProxyPagingList proxyPagingList = new ProxyPagingList(0);
    protected static boolean usingPackageRemoverOutputSream = true;
    protected Vector collections;
    protected Vector failedConnections = new Vector(1);
    protected Vector successfulConnections = new Vector(1);
    protected Vector collectionConnections = new Vector(1);
    public boolean continueThumbRetrieval = true;
    public boolean continueUniqueListRetrieval = true;
    public int skippedThumbnails;
    public int tallyCount;
    public Vector thumbnailDistributions;

    protected static void debugOut(String string) {
        Debug.debugOut("ISC: " + string, 3);
    }

    protected static void debugOut(String string, int n) {
        Debug.debugOut("ISC: " + string, n);
    }

    public static void setWaitLimit(long l) {
        WAIT_LIMIT = l;
    }

    public static Vector getCollectionNameFieldIndices(Vector vector) {
        Vector<Integer> vector2 = new Vector<Integer>(0);
        FieldMapping fieldMapping = null;
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            fieldMapping = (FieldMapping)vector.get(i);
            if (fieldMapping == null || fieldMapping.fieldID != 0) continue;
            vector2.add(new Integer(i));
        }
        return vector2;
    }

    public static Vector getCollectionNameFieldIndices(FieldMapping[] fieldMappingArray) {
        Vector<Integer> vector = new Vector<Integer>(0);
        FieldMapping fieldMapping = null;
        for (int i = 0; fieldMappingArray != null && i < fieldMappingArray.length; ++i) {
            fieldMapping = fieldMappingArray[i];
            if (fieldMapping == null || fieldMapping.fieldID != 0) continue;
            vector.add(new Integer(i));
        }
        return vector;
    }

    public static void setCollectionName(InsightSmartClientResults insightSmartClientResults, Vector vector, String string) {
        if (insightSmartClientResults != null && insightSmartClientResults.fieldData != null) {
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                int n = (Integer)vector.get(i);
                if (n < 0 || n >= insightSmartClientResults.fieldData.length) continue;
                insightSmartClientResults.fieldData[n] = string;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableProxyServerMode(int n) {
        ProxyPagingList proxyPagingList = InsightSmartClient.proxyPagingList;
        synchronized (proxyPagingList) {
            InsightSmartClient.proxyPagingList.setMaxQueryListSize(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableProxyServerMode() {
        ProxyPagingList proxyPagingList = InsightSmartClient.proxyPagingList;
        synchronized (proxyPagingList) {
            InsightSmartClient.proxyPagingList.setMaxQueryListSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProxyServerMode() {
        ProxyPagingList proxyPagingList = InsightSmartClient.proxyPagingList;
        synchronized (proxyPagingList) {
            return InsightSmartClient.proxyPagingList.getMaxQueryListSize() > 0;
        }
    }

    public static void main(String[] stringArray) {
        Vector vector = new Vector();
        InsightSmartClient insightSmartClient = new InsightSmartClient(vector);
    }

    public static void setUsingPackageRemoverOutputStream(boolean bl) {
        usingPackageRemoverOutputSream = bl;
    }

    public static boolean isUsingPackageRemoverOutputStream() {
        return usingPackageRemoverOutputSream;
    }

    public InsightSmartClient(List list) {
        this.collections = VirtualCollectionInfo.flattenCollectionList(list);
        for (int i = 0; i < this.collections.size(); ++i) {
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)this.collections.get(i);
            CollectionConnection collectionConnection = this.createCollectionConnection(trinityCollectionInfo);
            if (collectionConnection == null) {
                this.failedConnections.add(trinityCollectionInfo);
                continue;
            }
            this.collectionConnections.add(collectionConnection);
            this.successfulConnections.add(trinityCollectionInfo);
            TOTAL_CONNECTIONS = this.successfulConnections.size();
        }
    }

    public InsightSmartClient(List list, CollectionKey collectionKey) {
        this.collections = VirtualCollectionInfo.flattenCollectionList(list);
        TrinityCollectionInfo trinityCollectionInfo = this.getTrinityCollectionInfo(collectionKey);
        if (trinityCollectionInfo != null) {
            CollectionConnection collectionConnection = this.createCollectionConnection(trinityCollectionInfo);
            if (collectionConnection == null) {
                this.failedConnections.add(trinityCollectionInfo);
            } else {
                this.collectionConnections.add(collectionConnection);
                this.successfulConnections.add(trinityCollectionInfo);
                TOTAL_CONNECTIONS = this.successfulConnections.size();
            }
        }
    }

    public InsightSmartClient(String string, int n) {
        this(new TrinityCollectionInfo(string, n));
    }

    public InsightSmartClient(TrinityCollectionInfo trinityCollectionInfo) {
        this.collections = VirtualCollectionInfo.flattenSingleInfo(trinityCollectionInfo);
        for (int i = 0; i < this.collections.size(); ++i) {
            TrinityCollectionInfo trinityCollectionInfo2 = (TrinityCollectionInfo)this.collections.get(i);
            CollectionConnection collectionConnection = this.createCollectionConnection(trinityCollectionInfo2);
            if (collectionConnection == null) {
                this.failedConnections.add(trinityCollectionInfo);
                continue;
            }
            this.collectionConnections.add(collectionConnection);
            this.successfulConnections.add(trinityCollectionInfo);
            TOTAL_CONNECTIONS = this.successfulConnections.size();
        }
    }

    public CollectionConnection createCollectionConnection(TrinityCollectionInfo trinityCollectionInfo) {
        try {
            InsightSmartClient.debugOut("Creating collection connection for: " + trinityCollectionInfo.getCollectionName());
            CollectionConnection collectionConnection = new CollectionConnection();
            InsightSmartClient.debugOut("Connecting to " + trinityCollectionInfo.serverAddress + " on port " + trinityCollectionInfo.serverPort + ".");
            collectionConnection.connectSocket = new Socket(trinityCollectionInfo.serverAddress, trinityCollectionInfo.serverPort);
            if (!usingPackageRemoverOutputSream) {
                collectionConnection.connectSocket.setTcpNoDelay(true);
            }
            InsightSmartClient.debugOut("Creating streams.");
            collectionConnection.theInputStream = collectionConnection.connectSocket.getInputStream();
            collectionConnection.theOutputStream = collectionConnection.connectSocket.getOutputStream();
            InsightSmartClient.debugOut("Creating output object stream.");
            collectionConnection.oos = usingPackageRemoverOutputSream ? InsightPkgRemoverOutputStream.getInstance(collectionConnection.theOutputStream) : new ObjectOutputStream(collectionConnection.theOutputStream);
            InsightSmartClient.debugOut("Creating input object stream.");
            collectionConnection.ois = new InsightPkgSetterInputStream(collectionConnection.theInputStream);
            collectionConnection.tci = trinityCollectionInfo;
            if (collectionConnection.connectSocket != null && collectionConnection.oos != null && collectionConnection.ois != null) {
                return collectionConnection;
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in createCollectionConnection(): " + exception, 2);
        }
        return null;
    }

    public boolean areConnectionsGood() {
        return this.failedConnections.size() == 0;
    }

    public boolean isConnectionGood(CollectionKey collectionKey) {
        return this.getCollectionConnection(collectionKey) != null;
    }

    public Vector getFailedConnections() {
        return this.failedConnections;
    }

    public Vector getSuccessfulConnections() {
        return this.successfulConnections;
    }

    public void closeConnections() {
        InsightSmartClient.debugOut("Requesting close connection to all collections.");
        Enumeration enumeration = this.collectionConnections.elements();
        while (enumeration.hasMoreElements()) {
            CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
            if (collectionConnection.oos == null) continue;
            try {
                for (int i = 0; i < 80; ++i) {
                    collectionConnection.oos.writeInt(0);
                }
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Closing socket.");
                collectionConnection.connectSocket.close();
            }
            catch (Exception exception) {
                InsightSmartClient.debugOut("Exception in closeConnections(): " + exception, 2);
            }
        }
    }

    protected CollectionConnection getFirstCollectionConnection() {
        if (this.collectionConnections != null && this.collectionConnections.size() > 0) {
            return (CollectionConnection)this.collectionConnections.get(0);
        }
        return null;
    }

    protected CollectionConnection getCollectionConnection(CollectionKey collectionKey) {
        if (collectionKey != null) {
            CollectionConnection collectionConnection = null;
            for (int i = 0; i < this.collectionConnections.size(); ++i) {
                collectionConnection = (CollectionConnection)this.collectionConnections.get(i);
                if (!CollectionKeyDistributor.keysAgree(collectionConnection.tci, collectionKey)) continue;
                return collectionConnection;
            }
            InsightSmartClient.debugOut("The CollectionConnection for [InstitutionID = '" + collectionKey.getInstitutionID() + "', CollectionID = '" + collectionKey.getCollectionID() + "', VCID = '" + collectionKey.getVCID() + "'] was not found.", 2);
        } else {
            InsightSmartClient.debugOut("The CollectionConnection could not be found for CollectionKey: " + collectionKey, 2);
        }
        return null;
    }

    protected TrinityCollectionInfo getTrinityCollectionInfo(CollectionKey collectionKey) {
        if (collectionKey != null) {
            TrinityCollectionInfo trinityCollectionInfo = null;
            for (int i = 0; i < this.collections.size(); ++i) {
                trinityCollectionInfo = (TrinityCollectionInfo)this.collections.get(i);
                if (!CollectionKeyDistributor.keysAgree(trinityCollectionInfo, collectionKey)) continue;
                return trinityCollectionInfo;
            }
            InsightSmartClient.debugOut("The TrinityCollectionInfo for [InstitutionID = '" + collectionKey.getInstitutionID() + "', CollectionID = '" + collectionKey.getCollectionID() + "', VCID = '" + collectionKey.getVCID() + "'] was not found.", 2);
        } else {
            InsightSmartClient.debugOut("The TrinityCollectionInfo could not be found for CollectionKey: " + collectionKey, 2);
        }
        return null;
    }

    public void stopRetrieval() {
        this.continueThumbRetrieval = false;
        this.continueUniqueListRetrieval = false;
    }

    public boolean continueThumbRetrieval() {
        return this.continueThumbRetrieval;
    }

    public boolean continueUniqueListRetrieval() {
        return this.continueUniqueListRetrieval;
    }

    public String getClientIP(CollectionKey collectionKey) {
        String string = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(87, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                string = (String)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getClientIP():\n" + InsightUtilities.convertStackTraceToString(exception), 2);
            string = null;
        }
        return string;
    }

    public String getLocalAddress() {
        InetAddress inetAddress = ((CollectionConnection)this.collectionConnections.get((int)0)).connectSocket.getLocalAddress();
        if (inetAddress != null) {
            return inetAddress.getHostAddress();
        }
        return "(none)";
    }

    public Vector startSessions() {
        UserGroupSessionResults userGroupSessionResults = new UserGroupSessionResults();
        Vector<TrinityCollectionInfo> vector = new Vector<TrinityCollectionInfo>();
        Enumeration enumeration = this.collectionConnections.elements();
        while (enumeration.hasMoreElements()) {
            CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
            try {
                InsightSmartClient.debugOut("Starting a session.", 3);
                InsightRequest insightRequest = InsightRequest.newRequest(119, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addCollectionKeyParam(collectionConnection.tci);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for a response.", 3);
                if (this.waitForInput(collectionConnection) <= 0) continue;
                userGroupSessionResults = (UserGroupSessionResults)collectionConnection.ois.readObject();
                if (userGroupSessionResults != null && userGroupSessionResults.sessionStarted) {
                    collectionConnection.tci.sessionResults = userGroupSessionResults;
                    collectionConnection.tci.setProfileID(userGroupSessionResults.profileID);
                    vector.add(collectionConnection.tci);
                    continue;
                }
                InsightSmartClient.debugOut("No available sessions on server.");
            }
            catch (Exception exception) {
                InsightSmartClient.debugOut("Exception in startSessions(): " + exception, 2);
            }
        }
        return vector;
    }

    public void endSession() {
        Enumeration enumeration = this.collectionConnections.elements();
        while (enumeration.hasMoreElements()) {
            CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
            try {
                InsightSmartClient.debugOut("Ending session.", 3);
                InsightRequest insightRequest = InsightRequest.newRequest(120, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addCollectionKeyParam(collectionConnection.tci);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
            }
            catch (Exception exception) {
                InsightSmartClient.debugOut("Exception in endSession(): " + exception, 2);
            }
        }
    }

    public void sendKeepAlive() {
        try {
            Enumeration enumeration = this.collectionConnections.elements();
            while (enumeration.hasMoreElements()) {
                CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
                InsightSmartClient.debugOut("Contacting collection server; keeping alive.", 3);
                collectionConnection.oos.writeInt(56);
                collectionConnection.oos.writeObject(collectionConnection.tci.sessionGroupName);
                collectionConnection.oos.writeObject(collectionConnection.tci.sessionCodeKey);
                collectionConnection.oos.writeObject(this.getLocalAddress());
                collectionConnection.oos.flush();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in keepAlive().", 2);
        }
    }

    public void removeThumbnailCaches(Vector vector) {
        try {
            for (int i = 0; i < vector.size(); ++i) {
                GroupInformation groupInformation = (GroupInformation)vector.get(i);
                InsightSmartClient.debugOut("Remove thumbnail cache for group: " + groupInformation.getGroupID());
                CollectionConnection collectionConnection = this.getCollectionConnection(groupInformation.getTci());
                InsightRequest insightRequest = InsightRequest.newRequest(80, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", groupInformation.getGroupID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in removeThumbnailCaches(): " + exception, 2);
        }
    }

    public void removeThumbnailCache(GroupInformation groupInformation) {
        try {
            if (groupInformation != null && groupInformation.getTci() != null) {
                InsightSmartClient.debugOut("Remove thumbnail cache for group: " + groupInformation.getGroupID());
                CollectionConnection collectionConnection = this.getCollectionConnection(groupInformation.getTci());
                InsightRequest insightRequest = InsightRequest.newRequest(80, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", groupInformation.getGroupID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in removeThumbnailCache(): " + exception, 2);
        }
    }

    public InsightSmartClientResults[] getSpecifiedThumbnails(Vector vector, Vector vector2, FieldMapping[] fieldMappingArray) {
        Vector<ObjectIndicatorFieldCriterion> vector3 = new Vector<ObjectIndicatorFieldCriterion>();
        Vector vector4 = InsightUtilities.toVector(fieldMappingArray);
        Vector vector5 = InsightSmartClient.getCollectionNameFieldIndices(vector4);
        Object[] objectArray = vector2.elements();
        while (objectArray.hasMoreElements()) {
            Cloneable cloneable;
            Object object;
            GroupInformation groupInformation = (GroupInformation)objectArray.nextElement();
            CollectionConnection collectionConnection = null;
            Object object2 = this.collectionConnections.elements();
            while (object2.hasMoreElements()) {
                object = (CollectionConnection)object2.nextElement();
                if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)object).tci, groupInformation.getTci())) continue;
                collectionConnection = object;
                break;
            }
            Vector<ObjectIndicatorFieldCriterion> vector6 = new Vector<ObjectIndicatorFieldCriterion>();
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                object = (ThumbnailTallyMark)object2.nextElement();
                if (!((ThumbnailTallyMark)object).getInstitutionID().equalsIgnoreCase(collectionConnection.tci.getInstitutionID()) || !((ThumbnailTallyMark)object).getCollectionID().equalsIgnoreCase(collectionConnection.tci.getCollectionID())) continue;
                cloneable = new ObjectIndicatorFieldCriterion();
                cloneable.setObjectID(((ThumbnailTallyMark)object).getObjectID());
                cloneable.setImageID(((ThumbnailTallyMark)object).getImageID());
                vector6.add((ObjectIndicatorFieldCriterion)cloneable);
            }
            if (collectionConnection == null || vector6 == null || vector6.size() <= 0) continue;
            try {
                object2 = InsightRequest.newRequest(83, collectionConnection.tci, this.getLocalAddress());
                ((InsightRequest)object2).addCollectionKeyParam(collectionConnection.tci);
                ((InsightRequest)object2).addStringParam("COLLECTION_NAME", collectionConnection.tci.getCollectionName());
                ((InsightRequest)object2).addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                ((InsightRequest)object2).addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                ((InsightRequest)object2).addBooleanParam("EXCLUDE_SPS", false);
                ((InsightRequest)object2).addIntegerParam("GROUP_ID", groupInformation.getGroupID());
                ((InsightRequest)object2).addObjectParam("CAPTION_FIELDS", vector4);
                ((InsightRequest)object2).addObjectParam("SEARCH_CRITERIA", vector6);
                collectionConnection.oos.writeObject(object2);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitWhileKeepAlive(1, collectionConnection) <= 0) continue;
                InsightSmartClient.debugOut("Receiving data.", 3);
                object = (Vector)collectionConnection.ois.readObject();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    cloneable = (InsightSmartClientResults)((Vector)object).get(i);
                    InsightSmartClient.setCollectionName((InsightSmartClientResults)cloneable, vector5, collectionConnection.tci.getCollectionName());
                    vector3.add((ObjectIndicatorFieldCriterion)cloneable);
                }
            }
            catch (Exception exception) {
                InsightSmartClient.debugOut("Exception in getSpecifiedThumbnails():\n" + InsightUtilities.getStackTrace(exception), 2);
            }
        }
        objectArray = new InsightSmartClientResults[vector3.size()];
        vector3.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsightSmartClientResults[] getThumbnails(int n, int n2, String string, FieldMapping[] fieldMappingArray, FieldMapping[] fieldMappingArray2, List list, boolean bl, int n3, Vector vector) {
        ThumbnailResultCollector thumbnailResultCollector = new ThumbnailResultCollector();
        QueryResultCollector queryResultCollector = new QueryResultCollector();
        this.thumbnailDistributions = new Vector();
        Vector<ThumbnailTallyMark> vector2 = new Vector<ThumbnailTallyMark>();
        this.skippedThumbnails = 0;
        this.tallyCount = 0;
        String string2 = this.getLocalAddress();
        boolean bl2 = InsightSmartClient.isProxyServerMode();
        Vector<Object> vector3 = new Vector<Object>();
        try {
            ThumbnailTallyMark thumbnailTallyMark;
            Vector<ThumbnailTallyMark> vector4;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            boolean bl3 = false;
            if (!this.continueThumbRetrieval()) {
                throw new StopRetrievalException();
            }
            Vector vector5 = InsightUtilities.toVector(fieldMappingArray);
            Object[] objectArray = vector.elements();
            while (objectArray.hasMoreElements()) {
                if (!this.continueThumbRetrieval()) {
                    throw new StopRetrievalException();
                }
                object6 = (ResultsProgressListener)objectArray.nextElement();
                object5 = null;
                object4 = this.collectionConnections.elements();
                while (object4.hasMoreElements()) {
                    object3 = (CollectionConnection)object4.nextElement();
                    if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)object3).tci, object6.getGroupInfo().getTci())) continue;
                    object5 = object3;
                    break;
                }
                if (object5 != null) {
                    object4 = object6.getGroupInfo().getThumbnailDistribution();
                    if (object4 == null) {
                        bl3 = true;
                        queryResultCollector.clearResults();
                        break;
                    }
                    ((CollectionConnection)object5).totalRecords = ((DynamicThumbnailDistribution)object4).totalCount;
                    queryResultCollector.addResult((DynamicThumbnailDistribution)object4);
                    InsightSmartClient.debugOut("Found distribution for collection " + ((CollectionConnection)object5).tci.collectionName + ":");
                    for (int i = 0; i < ((DynamicThumbnailDistribution)object4).tally.length; ++i) {
                        InsightSmartClient.debugOut(" " + ((DynamicThumbnailDistribution)object4).tally[i]);
                    }
                    continue;
                }
                InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
            }
            if (bl3) {
                objectArray = list.toArray();
                object6 = vector.elements();
                while (object6.hasMoreElements()) {
                    if (!this.continueThumbRetrieval()) {
                        throw new StopRetrievalException();
                    }
                    object5 = (ResultsProgressListener)object6.nextElement();
                    object4 = null;
                    object3 = this.collectionConnections.elements();
                    while (object3.hasMoreElements()) {
                        object2 = (CollectionConnection)object3.nextElement();
                        if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)object2).tci, object5.getGroupInfo().getTci())) continue;
                        object4 = object2;
                        break;
                    }
                    if (object4 != null) {
                        if (ThumbnailQuery.isKeywordsFieldSearch(objectArray) && !((CollectionConnection)object4).tci.supportsKeywordsFieldSearching) {
                            InsightSmartClient.debugOut("Error in getThumbnails(): " + ((CollectionConnection)object4).tci.getCollectionName() + " does not support KEYWORDS in data field search", 2);
                            this.stopRetrieval();
                            throw new StopRetrievalException();
                        }
                        object5.serverContacted(true);
                        object3 = new ThumbnailQuery(new CollectionKeyWrapper(((CollectionConnection)object4).tci.getInstitutionID(), ((CollectionConnection)object4).tci.getCollectionID(), ((CollectionConnection)object4).tci.getVCID()), ((CollectionConnection)object4).tci.getCollectionName(), object5.getGroupInfo().getGroupID(), fieldMappingArray, fieldMappingArray2, objectArray, !bl, n3, ((CollectionConnection)object4).tci.getProfileID(), ((CollectionConnection)object4).tci.getUserCollection(), ((CollectionConnection)object4).tci.isPersonalCollection());
                        object5.getGroupInfo().setThumbnailQuery((ThumbnailQuery)object3);
                        if (InsightVersion.isBetweenVersions(((CollectionConnection)object4).tci.getServerVersion(), new InsightVersion(3, 10, 9), new InsightVersion(3, 50, 0))) {
                            object5.getGroupInfo().setThumbnailQuery(DynamicDistributionThumbnailQuery.getDynamicThumbnailQuery((ThumbnailQuery)object3));
                        }
                        if (bl2) {
                            int n4 = proxyPagingList.add((CollectionConnection)object4, (ThumbnailQuery)object3);
                            string2 = string2 + "(" + n4 + ")";
                        }
                        object2 = new QueryGetter(object5.getGroupInfo().getThumbnailQuery(), ((CollectionConnection)object4).tci, (CollectionConnection)object4, string2, (ResultsProgressListener)object5, queryResultCollector, string);
                        vector3.add(object2);
                        ((Thread)object2).start();
                        continue;
                    }
                    InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
                }
                while (!queryResultCollector.doneCollecting()) {
                    Thread.sleep(1000L);
                    if (this.continueThumbRetrieval()) continue;
                    InsightSmartClient.debugOut("Stopping QueryGetter threads.");
                    for (int i = 0; i < vector3.size(); ++i) {
                        ((QueryGetter)vector3.get(i)).stop();
                        queryResultCollector.removeClient();
                    }
                    throw new StopRetrievalException();
                }
            }
            this.thumbnailDistributions = queryResultCollector.getResults();
            for (int i = 0; i < this.thumbnailDistributions.size(); ++i) {
                if (!(this.thumbnailDistributions.get(i) instanceof DynamicThumbnailDistribution)) continue;
                objectArray = (DynamicThumbnailDistribution)this.thumbnailDistributions.get(i);
                if (objectArray.tally != null) continue;
                objectArray.tally = new DynamicDistributionBucketInfo[0];
            }
            int[] nArray = this.getDistributionIndexes(this.thumbnailDistributions, n);
            object5 = new Hashtable(this.thumbnailDistributions.size());
            if (nArray != null && nArray.length == this.thumbnailDistributions.size()) {
                for (int i = 0; i < this.thumbnailDistributions.size(); ++i) {
                    ((Hashtable)object5).put(this.thumbnailDistributions.get(i), new Integer(nArray[i]));
                }
            } else {
                throw new Exception("Error: tally mark indexes not correctly calculated! dynamicTallyIndexes: " + nArray);
            }
            InsightSmartClient.debugOut("Got tallyIndexes.");
            Object object7 = vector.elements();
            while (object7.hasMoreElements()) {
                if (!this.continueThumbRetrieval()) {
                    throw new StopRetrievalException();
                }
                object3 = (ResultsProgressListener)object7.nextElement();
                object2 = null;
                object = this.collectionConnections.elements();
                while (object.hasMoreElements()) {
                    vector4 = (CollectionConnection)object.nextElement();
                    if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)((Object)vector4)).tci, object3.getGroupInfo().getTci())) continue;
                    object2 = vector4;
                    break;
                }
                if (object2 != null) {
                    object3.serverContacted(true);
                    object3.findingPage();
                    object = null;
                    vector4 = null;
                    if (object3.getGroupInfo().getThumbnailDistribution() != null) {
                        vector4 = (Integer)((Hashtable)object5).get(object3.getGroupInfo().getThumbnailDistribution());
                    }
                    if (vector4 != null) {
                        InsightSmartClient.debugOut(((CollectionConnection)object2).tci.getCollectionName() + " -> " + (Integer)((Object)vector4));
                        object = this.getCollectionSpecificTallyMarks((Integer)((Object)vector4), n2, object3.getGroupInfo(), ((CollectionConnection)object2).tci, (CollectionConnection)object2, string2);
                    } else {
                        InsightSmartClient.debugOut("Could not find tally index for " + ((CollectionConnection)object2).tci.getCollectionName());
                    }
                    if (object != null) {
                        InsightSmartClient.debugOut("tm.size(): " + ((Vector)object).size());
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            thumbnailTallyMark = (ThumbnailTallyMark)((Vector)object).get(i);
                            vector2.add(thumbnailTallyMark);
                        }
                        continue;
                    }
                    InsightSmartClient.debugOut("No TTMs returned from collection [" + ((CollectionConnection)object2).tci.getInstitutionID() + ", " + ((CollectionConnection)object2).tci.getCollectionID() + "].");
                    continue;
                }
                InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
            }
            object7 = this.getRelevantTallyMarks(n, n2, vector2);
            InsightSmartClient.debugOut("Size of selectedTallyMarks: " + ((Vector)object7).size(), 3);
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                if (!this.continueThumbRetrieval()) {
                    throw new StopRetrievalException();
                }
                object2 = (ResultsProgressListener)object3.nextElement();
                object = null;
                vector4 = this.collectionConnections.elements();
                while (vector4.hasMoreElements()) {
                    CollectionConnection collectionConnection = (CollectionConnection)vector4.nextElement();
                    if (!CollectionKeyDistributor.keysAgree(collectionConnection.tci, object2.getGroupInfo().getTci())) continue;
                    object = collectionConnection;
                    break;
                }
                if (object != null) {
                    vector4 = new Vector<ThumbnailTallyMark>();
                    for (int i = 0; i < ((Vector)object7).size(); ++i) {
                        thumbnailTallyMark = (ThumbnailTallyMark)((Vector)object7).get(i);
                        if (!CollectionKeyDistributor.keysAgree(thumbnailTallyMark, ((CollectionConnection)object).tci)) continue;
                        vector4.add(thumbnailTallyMark);
                    }
                    InsightSmartClient.debugOut("collectionSpecificTallyMarks.size(): " + vector4.size());
                    if (vector4.size() <= 0) continue;
                    InsightSmartClient.debugOut("About to create ThumbnailGetter, asking for " + vector4.size() + " thumbs", 3);
                    ThumbnailGetter thumbnailGetter = new ThumbnailGetter(vector4, (ResultsProgressListener)object2, thumbnailResultCollector, (CollectionConnection)object, this, string2);
                    thumbnailGetter.start();
                    InsightSmartClient.debugOut("ThumbnailGetter started", 3);
                    continue;
                }
                InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
            }
            while (!thumbnailResultCollector.doneCollecting() && this.continueThumbRetrieval) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            if (exception instanceof StopRetrievalException) {
                InsightSmartClientResults[] insightSmartClientResultsArray = new InsightSmartClientResults[]{};
                return insightSmartClientResultsArray;
            }
            InsightSmartClient.debugOut("Exception in getThumbnails():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        finally {
            if (bl2) {
                proxyPagingList.finish();
            }
        }
        if (this.continueThumbRetrieval()) {
            return thumbnailResultCollector.getResults();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsightSmartClientResults[] getThumbnails(int n, int n2, String string, FieldMapping[] fieldMappingArray, List list, int n3, Vector vector) {
        ThumbnailResultCollector thumbnailResultCollector = new ThumbnailResultCollector();
        QueryResultCollector queryResultCollector = new QueryResultCollector();
        this.thumbnailDistributions = new Vector();
        Vector<ThumbnailTallyMark> vector2 = new Vector<ThumbnailTallyMark>();
        this.skippedThumbnails = 0;
        this.tallyCount = 0;
        String string2 = this.getLocalAddress();
        boolean bl = InsightSmartClient.isProxyServerMode();
        Vector<Object> vector3 = new Vector<Object>();
        try {
            ThumbnailTallyMark thumbnailTallyMark;
            Vector<ThumbnailTallyMark> vector4;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            boolean bl2 = false;
            if (!this.continueThumbRetrieval()) {
                throw new StopRetrievalException();
            }
            Vector vector5 = InsightUtilities.toVector(fieldMappingArray);
            Object[] objectArray = vector.elements();
            while (objectArray.hasMoreElements()) {
                if (!this.continueThumbRetrieval()) {
                    throw new StopRetrievalException();
                }
                object6 = (ResultsProgressListener)objectArray.nextElement();
                object5 = null;
                object4 = this.collectionConnections.elements();
                while (object4.hasMoreElements()) {
                    object3 = (CollectionConnection)object4.nextElement();
                    if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)object3).tci, object6.getGroupInfo().getTci())) continue;
                    object5 = object3;
                    break;
                }
                if (object5 != null) {
                    object4 = object6.getGroupInfo().getThumbnailDistribution();
                    if (object4 == null) {
                        bl2 = true;
                        queryResultCollector.clearResults();
                        break;
                    }
                    ((CollectionConnection)object5).totalRecords = ((DynamicThumbnailDistribution)object4).totalCount;
                    queryResultCollector.addResult((DynamicThumbnailDistribution)object4);
                    InsightSmartClient.debugOut("Found distribution for collection " + ((CollectionConnection)object5).tci.collectionName + ":");
                    for (int i = 0; i < ((DynamicThumbnailDistribution)object4).tally.length; ++i) {
                        InsightSmartClient.debugOut(" " + ((DynamicThumbnailDistribution)object4).tally[i]);
                    }
                    continue;
                }
                InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
            }
            if (bl2) {
                objectArray = list.toArray();
                object6 = vector.elements();
                while (object6.hasMoreElements()) {
                    if (!this.continueThumbRetrieval()) {
                        throw new StopRetrievalException();
                    }
                    object5 = (ResultsProgressListener)object6.nextElement();
                    object4 = null;
                    object3 = this.collectionConnections.elements();
                    while (object3.hasMoreElements()) {
                        object2 = (CollectionConnection)object3.nextElement();
                        if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)object2).tci, object5.getGroupInfo().getTci())) continue;
                        object4 = object2;
                        break;
                    }
                    if (object4 != null) {
                        object5.serverContacted(true);
                        object3 = new ThumbnailQuery(new CollectionKeyWrapper(((CollectionConnection)object4).tci.getInstitutionID(), ((CollectionConnection)object4).tci.getCollectionID(), ((CollectionConnection)object4).tci.getVCID()), ((CollectionConnection)object4).tci.getCollectionName(), object5.getGroupInfo().getGroupID(), fieldMappingArray, new FieldMapping[0], objectArray, false, n3, ((CollectionConnection)object4).tci.getProfileID(), ((CollectionConnection)object4).tci.getUserCollection(), ((CollectionConnection)object4).tci.isPersonalCollection(), true);
                        object5.getGroupInfo().setThumbnailQuery((ThumbnailQuery)object3);
                        if (InsightVersion.isBetweenVersions(((CollectionConnection)object4).tci.getServerVersion(), new InsightVersion(3, 10, 9), new InsightVersion(3, 50, 0))) {
                            object5.getGroupInfo().setThumbnailQuery(DynamicDistributionThumbnailQuery.getDynamicThumbnailQuery((ThumbnailQuery)object3));
                        }
                        if (bl) {
                            int n4 = proxyPagingList.add((CollectionConnection)object4, (ThumbnailQuery)object3);
                            string2 = string2 + "(" + n4 + ")";
                        }
                        object2 = new QueryGetter(object5.getGroupInfo().getThumbnailQuery(), ((CollectionConnection)object4).tci, (CollectionConnection)object4, string2, (ResultsProgressListener)object5, queryResultCollector, string);
                        vector3.add(object2);
                        ((Thread)object2).start();
                        continue;
                    }
                    InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
                }
                while (!queryResultCollector.doneCollecting()) {
                    Thread.sleep(1000L);
                    if (this.continueThumbRetrieval()) continue;
                    InsightSmartClient.debugOut("Stopping QueryGetter threads.");
                    for (int i = 0; i < vector3.size(); ++i) {
                        ((QueryGetter)vector3.get(i)).stop();
                        queryResultCollector.removeClient();
                    }
                    throw new StopRetrievalException();
                }
            }
            this.thumbnailDistributions = queryResultCollector.getResults();
            for (int i = 0; i < this.thumbnailDistributions.size(); ++i) {
                if (!(this.thumbnailDistributions.get(i) instanceof DynamicThumbnailDistribution)) continue;
                objectArray = (DynamicThumbnailDistribution)this.thumbnailDistributions.get(i);
                if (objectArray.tally != null) continue;
                objectArray.tally = new DynamicDistributionBucketInfo[0];
            }
            int[] nArray = this.getDistributionIndexes(this.thumbnailDistributions, n);
            object5 = new Hashtable(this.thumbnailDistributions.size());
            if (nArray != null && nArray.length == this.thumbnailDistributions.size()) {
                for (int i = 0; i < this.thumbnailDistributions.size(); ++i) {
                    ((Hashtable)object5).put(this.thumbnailDistributions.get(i), new Integer(nArray[i]));
                }
            } else {
                throw new Exception("Error: tally mark indexes not correctly calculated! dynamicTallyIndexes: " + nArray);
            }
            InsightSmartClient.debugOut("Got tallyIndexes.");
            Object object7 = vector.elements();
            while (object7.hasMoreElements()) {
                if (!this.continueThumbRetrieval()) {
                    throw new StopRetrievalException();
                }
                object3 = (ResultsProgressListener)object7.nextElement();
                object2 = null;
                object = this.collectionConnections.elements();
                while (object.hasMoreElements()) {
                    vector4 = (CollectionConnection)object.nextElement();
                    if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)((Object)vector4)).tci, object3.getGroupInfo().getTci())) continue;
                    object2 = vector4;
                    break;
                }
                if (object2 != null) {
                    object3.serverContacted(true);
                    object3.findingPage();
                    object = null;
                    vector4 = null;
                    if (object3.getGroupInfo().getThumbnailDistribution() != null) {
                        vector4 = (Integer)((Hashtable)object5).get(object3.getGroupInfo().getThumbnailDistribution());
                    }
                    if (vector4 != null) {
                        InsightSmartClient.debugOut(((CollectionConnection)object2).tci.getCollectionName() + " -> " + (Integer)((Object)vector4));
                        object = this.getCollectionSpecificTallyMarks((Integer)((Object)vector4), n2, object3.getGroupInfo(), ((CollectionConnection)object2).tci, (CollectionConnection)object2, string2);
                    } else {
                        InsightSmartClient.debugOut("Could not find tally index for " + ((CollectionConnection)object2).tci.getCollectionName());
                    }
                    if (object != null) {
                        InsightSmartClient.debugOut("tm.size(): " + ((Vector)object).size());
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            thumbnailTallyMark = (ThumbnailTallyMark)((Vector)object).get(i);
                            vector2.add(thumbnailTallyMark);
                        }
                        continue;
                    }
                    InsightSmartClient.debugOut("No TTMs returned from collection [" + ((CollectionConnection)object2).tci.getInstitutionID() + ", " + ((CollectionConnection)object2).tci.getCollectionID() + "].");
                    continue;
                }
                InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
            }
            object7 = this.getRelevantTallyMarks(n, n2, vector2);
            InsightSmartClient.debugOut("Size of selectedTallyMarks: " + ((Vector)object7).size(), 3);
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                if (!this.continueThumbRetrieval()) {
                    throw new StopRetrievalException();
                }
                object2 = (ResultsProgressListener)object3.nextElement();
                object = null;
                vector4 = this.collectionConnections.elements();
                while (vector4.hasMoreElements()) {
                    CollectionConnection collectionConnection = (CollectionConnection)vector4.nextElement();
                    if (!CollectionKeyDistributor.keysAgree(collectionConnection.tci, object2.getGroupInfo().getTci())) continue;
                    object = collectionConnection;
                    break;
                }
                if (object != null) {
                    vector4 = new Vector<ThumbnailTallyMark>();
                    for (int i = 0; i < ((Vector)object7).size(); ++i) {
                        thumbnailTallyMark = (ThumbnailTallyMark)((Vector)object7).get(i);
                        if (!CollectionKeyDistributor.keysAgree(thumbnailTallyMark, ((CollectionConnection)object).tci)) continue;
                        vector4.add(thumbnailTallyMark);
                    }
                    InsightSmartClient.debugOut("collectionSpecificTallyMarks.size(): " + vector4.size());
                    if (vector4.size() <= 0) continue;
                    InsightSmartClient.debugOut("About to create ThumbnailGetter, asking for " + vector4.size() + " thumbs", 3);
                    ThumbnailGetter thumbnailGetter = new ThumbnailGetter(vector4, (ResultsProgressListener)object2, thumbnailResultCollector, (CollectionConnection)object, this, string2);
                    thumbnailGetter.start();
                    InsightSmartClient.debugOut("ThumbnailGetter started", 3);
                    continue;
                }
                InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
            }
            while (!thumbnailResultCollector.doneCollecting() && this.continueThumbRetrieval) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            if (exception instanceof StopRetrievalException) {
                InsightSmartClientResults[] insightSmartClientResultsArray = new InsightSmartClientResults[]{};
                return insightSmartClientResultsArray;
            }
            InsightSmartClient.debugOut("Exception in getThumbnails():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        finally {
            if (bl) {
                proxyPagingList.finish();
            }
        }
        if (this.continueThumbRetrieval()) {
            return thumbnailResultCollector.getResults();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getImageListByCurrentSort(int n, int n2, String string, FieldMapping[] fieldMappingArray, FieldMapping[] fieldMappingArray2, List list, boolean bl, Vector vector) {
        QueryResultCollector queryResultCollector = new QueryResultCollector();
        this.thumbnailDistributions = new Vector();
        Vector<ThumbnailTallyMark> vector2 = new Vector<ThumbnailTallyMark>();
        String string2 = this.getLocalAddress();
        boolean bl2 = InsightSmartClient.isProxyServerMode();
        Vector<Object> vector3 = new Vector<Object>();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            boolean bl3 = false;
            if (!this.continueThumbRetrieval()) {
                throw new StopRetrievalException();
            }
            Vector vector4 = InsightUtilities.toVector(fieldMappingArray);
            Object[] objectArray = vector.elements();
            while (objectArray.hasMoreElements()) {
                if (!this.continueThumbRetrieval()) {
                    throw new StopRetrievalException();
                }
                object5 = (ResultsProgressListener)objectArray.nextElement();
                object4 = null;
                object3 = this.collectionConnections.elements();
                while (object3.hasMoreElements()) {
                    object2 = (CollectionConnection)object3.nextElement();
                    if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)object2).tci, object5.getGroupInfo().getTci())) continue;
                    object4 = object2;
                    break;
                }
                if (object4 != null) {
                    object3 = object5.getGroupInfo().getThumbnailDistribution();
                    if (object3 == null) {
                        bl3 = true;
                        queryResultCollector.clearResults();
                        break;
                    }
                    ((CollectionConnection)object4).totalRecords = ((DynamicThumbnailDistribution)object3).totalCount;
                    queryResultCollector.addResult((DynamicThumbnailDistribution)object3);
                    InsightSmartClient.debugOut("Found distribution for collection " + ((CollectionConnection)object4).tci.collectionName + ":");
                    for (int i = 0; i < ((DynamicThumbnailDistribution)object3).tally.length; ++i) {
                        InsightSmartClient.debugOut(" " + ((DynamicThumbnailDistribution)object3).tally[i]);
                    }
                    continue;
                }
                InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
            }
            if (bl3) {
                objectArray = list.toArray();
                object5 = vector.elements();
                while (object5.hasMoreElements()) {
                    if (!this.continueThumbRetrieval()) {
                        throw new StopRetrievalException();
                    }
                    object4 = (ResultsProgressListener)object5.nextElement();
                    object3 = null;
                    object2 = this.collectionConnections.elements();
                    while (object2.hasMoreElements()) {
                        object = (CollectionConnection)object2.nextElement();
                        if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)object).tci, object4.getGroupInfo().getTci())) continue;
                        object3 = object;
                        break;
                    }
                    if (object3 != null) {
                        if (ThumbnailQuery.isKeywordsFieldSearch(objectArray) && !((CollectionConnection)object3).tci.supportsKeywordsFieldSearching) {
                            InsightSmartClient.debugOut("Error in getThumbnails(): " + ((CollectionConnection)object3).tci.getCollectionName() + " does not support KEYWORDS in data field search", 2);
                            this.stopRetrieval();
                            throw new StopRetrievalException();
                        }
                        object4.serverContacted(true);
                        object2 = new ThumbnailQuery(new CollectionKeyWrapper(((CollectionConnection)object3).tci.getInstitutionID(), ((CollectionConnection)object3).tci.getCollectionID(), ((CollectionConnection)object3).tci.getVCID()), ((CollectionConnection)object3).tci.getCollectionName(), object4.getGroupInfo().getGroupID(), fieldMappingArray, fieldMappingArray2, objectArray, !bl, 0, ((CollectionConnection)object3).tci.getProfileID(), ((CollectionConnection)object3).tci.getUserCollection(), ((CollectionConnection)object3).tci.isPersonalCollection());
                        object4.getGroupInfo().setThumbnailQuery((ThumbnailQuery)object2);
                        if (InsightVersion.isBetweenVersions(((CollectionConnection)object3).tci.getServerVersion(), new InsightVersion(3, 10, 9), new InsightVersion(3, 50, 0))) {
                            object4.getGroupInfo().setThumbnailQuery(DynamicDistributionThumbnailQuery.getDynamicThumbnailQuery((ThumbnailQuery)object2));
                        }
                        if (bl2) {
                            int n3 = proxyPagingList.add((CollectionConnection)object3, (ThumbnailQuery)object2);
                            string2 = string2 + "(" + n3 + ")";
                        }
                        object = new QueryGetter(object4.getGroupInfo().getThumbnailQuery(), ((CollectionConnection)object3).tci, (CollectionConnection)object3, string2, (ResultsProgressListener)object4, queryResultCollector, string);
                        vector3.add(object);
                        ((Thread)object).start();
                        continue;
                    }
                    InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
                }
                while (!queryResultCollector.doneCollecting()) {
                    Thread.sleep(1000L);
                    if (this.continueThumbRetrieval()) continue;
                    InsightSmartClient.debugOut("Stopping QueryGetter threads.");
                    for (int i = 0; i < vector3.size(); ++i) {
                        ((QueryGetter)vector3.get(i)).stop();
                        queryResultCollector.removeClient();
                    }
                    throw new StopRetrievalException();
                }
            }
            this.thumbnailDistributions = queryResultCollector.getResults();
            for (int i = 0; i < this.thumbnailDistributions.size(); ++i) {
                if (!(this.thumbnailDistributions.get(i) instanceof DynamicThumbnailDistribution)) continue;
                objectArray = (DynamicThumbnailDistribution)this.thumbnailDistributions.get(i);
                if (objectArray.tally != null) continue;
                objectArray.tally = new DynamicDistributionBucketInfo[0];
            }
            int[] nArray = this.getDistributionIndexes(this.thumbnailDistributions, n);
            object4 = new Hashtable(this.thumbnailDistributions.size());
            if (nArray != null && nArray.length == this.thumbnailDistributions.size()) {
                for (int i = 0; i < this.thumbnailDistributions.size(); ++i) {
                    ((Hashtable)object4).put(this.thumbnailDistributions.get(i), new Integer(nArray[i]));
                }
            } else {
                throw new Exception("Error: tally mark indexes not correctly calculated! dynamicTallyIndexes: " + nArray);
            }
            InsightSmartClient.debugOut("Got tallyIndexes.");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object6;
                if (!this.continueThumbRetrieval()) {
                    throw new StopRetrievalException();
                }
                object2 = (ResultsProgressListener)enumeration.nextElement();
                object = null;
                Object object7 = this.collectionConnections.elements();
                while (object7.hasMoreElements()) {
                    object6 = (CollectionConnection)object7.nextElement();
                    if (!CollectionKeyDistributor.keysAgree(((CollectionConnection)object6).tci, object2.getGroupInfo().getTci())) continue;
                    object = object6;
                    break;
                }
                if (object != null) {
                    object2.serverContacted(true);
                    object2.findingPage();
                    object7 = null;
                    object6 = null;
                    if (object2.getGroupInfo().getThumbnailDistribution() != null) {
                        object6 = (Integer)((Hashtable)object4).get(object2.getGroupInfo().getThumbnailDistribution());
                    }
                    if (object6 != null) {
                        InsightSmartClient.debugOut(((CollectionConnection)object).tci.getCollectionName() + " -> " + (Integer)object6);
                        object7 = this.getCollectionSpecificTallyMarks((Integer)object6, n2, object2.getGroupInfo(), ((CollectionConnection)object).tci, (CollectionConnection)object, string2);
                    } else {
                        InsightSmartClient.debugOut("Could not find tally index for " + ((CollectionConnection)object).tci.getCollectionName());
                    }
                    if (object7 != null) {
                        InsightSmartClient.debugOut("tm.size(): " + ((Vector)object7).size());
                        for (int i = 0; i < ((Vector)object7).size(); ++i) {
                            ThumbnailTallyMark thumbnailTallyMark = (ThumbnailTallyMark)((Vector)object7).get(i);
                            vector2.add(thumbnailTallyMark);
                        }
                        continue;
                    }
                    InsightSmartClient.debugOut("No TTMs returned from collection [" + ((CollectionConnection)object).tci.getInstitutionID() + ", " + ((CollectionConnection)object).tci.getCollectionID() + "].");
                    continue;
                }
                InsightSmartClient.debugOut("Could not find correct CollectionConnection.", 2);
            }
            Collections.sort(vector2);
        }
        catch (Exception exception) {
            if (exception instanceof StopRetrievalException) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            InsightSmartClient.debugOut("Exception in getThumbnails():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        finally {
            if (bl2) {
                proxyPagingList.finish();
            }
        }
        return vector2;
    }

    protected int[] getDistributionIndexes(Vector vector, int n) {
        ++n;
        int[] nArray = null;
        try {
            if (vector != null && vector.size() > 0) {
                int n2;
                nArray = new int[vector.size()];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = 0;
                }
                n2 = -1;
                boolean bl = true;
                while (!this.areDistributionsExhausted(vector, nArray)) {
                    int n3;
                    bl = false;
                    this.skippedThumbnails = this.tallyCount;
                    if (n2 == -1) {
                        for (n3 = 0; n3 < vector.size(); ++n3) {
                            DynamicThumbnailDistribution dynamicThumbnailDistribution = (DynamicThumbnailDistribution)vector.get(n3);
                            if (dynamicThumbnailDistribution == null || nArray[n3] >= dynamicThumbnailDistribution.tally.length) continue;
                            this.tallyCount += dynamicThumbnailDistribution.tally[nArray[n3]].getCount();
                        }
                    } else {
                        DynamicThumbnailDistribution dynamicThumbnailDistribution = (DynamicThumbnailDistribution)vector.get(n2);
                        if (dynamicThumbnailDistribution != null && nArray[n2] < dynamicThumbnailDistribution.tally.length) {
                            this.tallyCount += dynamicThumbnailDistribution.tally[nArray[n2]].getCount();
                        }
                    }
                    if (n <= this.tallyCount) {
                        return nArray;
                    }
                    int n4 = n3 = this.getLeftmostDistributionIndex(vector, nArray);
                    nArray[n4] = nArray[n4] + 1;
                    n2 = n3;
                }
                if (bl) {
                    return nArray;
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getDistributionIndexes():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return null;
    }

    private boolean areDistributionsExhausted(Vector vector, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (((DynamicThumbnailDistribution)vector.get((int)i)).tally == null || nArray[i] >= ((DynamicThumbnailDistribution)vector.get((int)i)).tally.length) continue;
            return false;
        }
        return true;
    }

    private int getLeftmostDistributionIndex(Vector vector, int[] nArray) {
        int n = -1;
        String string = null;
        try {
            DynamicDistributionBucketInfo dynamicDistributionBucketInfo = null;
            for (int i = 0; i < vector.size(); ++i) {
                DynamicThumbnailDistribution dynamicThumbnailDistribution = (DynamicThumbnailDistribution)vector.get(i);
                try {
                    if (nArray[i] < dynamicThumbnailDistribution.tally.length) {
                        dynamicDistributionBucketInfo = dynamicThumbnailDistribution.tally[nArray[i]];
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string != null && (dynamicDistributionBucketInfo == null || dynamicDistributionBucketInfo.getStartString() == null || dynamicDistributionBucketInfo.getStartString().compareToIgnoreCase(string) >= 0) || dynamicDistributionBucketInfo == null) continue;
                string = dynamicDistributionBucketInfo.getStartString();
                n = i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            InsightSmartClient.debugOut("getLeftmostDistributionIndex(): Reached end of array bounds.  leftmostDistributionIndex=" + n);
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getLeftmostDistributionIndex():\n" + InsightUtilities.getStackTrace(exception));
        }
        return n;
    }

    protected Vector getCollectionSpecificTallyMarks(int n, int n2, GroupInformation groupInformation, TrinityCollectionInfo trinityCollectionInfo, CollectionConnection collectionConnection, String string) {
        Vector vector = null;
        InsightSmartClient.debugOut("in getCollectionSpecificTallyMarks()");
        try {
            InsightRequest insightRequest = InsightRequest.newRequest(73, collectionConnection.tci, string);
            insightRequest.addObjectParam("THUMBNAIL_QUERY", groupInformation.getThumbnailQuery());
            insightRequest.addIntegerParam("TALLY_INDEX", n);
            insightRequest.addIntegerParam("LENGTH", n2);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("getTallyMarks(): Waiting for data.");
            if (this.waitForInput(1, WAIT_LIMIT * 5L, collectionConnection) > 0) {
                InsightSmartClient.debugOut("getTallyMarks(): Data retrieval begun");
                Object object = collectionConnection.ois.readObject();
                if (object instanceof Vector) {
                    vector = (Vector)object;
                } else {
                    InsightSmartClient.debugOut("Error in getCollectionSpecificTallyMarks: Object returned is instanceof " + object.getClass());
                }
                InsightSmartClient.debugOut("Number of tallyMarks returned by ISS: " + vector.size());
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getCollectionSpecificTallyMarks():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return vector;
    }

    protected Vector getRelevantTallyMarks(int n, int n2, Vector vector) {
        InsightSmartClient.debugOut("in getRelevantTallyMarks(" + n + ", " + n2 + ", tallyMarks)", 3);
        Vector<ThumbnailTallyMark> vector2 = new Vector<ThumbnailTallyMark>();
        int n3 = n - this.skippedThumbnails;
        InsightSmartClient.debugOut("localIndex: " + n3);
        Collections.sort(vector);
        InsightSmartClient.debugOut("localIndex: " + n3 + ", skippedThumbnails: " + this.skippedThumbnails + ", tallyMarks.size(): " + vector.size());
        ThumbnailTallyMark thumbnailTallyMark = null;
        for (int i = n3; i < n2 + n3; ++i) {
            if (i >= vector.size()) continue;
            thumbnailTallyMark = (ThumbnailTallyMark)vector.get(i);
            vector2.add(thumbnailTallyMark);
        }
        return vector2;
    }

    public int getRecordCount() {
        int n = 0;
        try {
            CollectionConnection collectionConnection = null;
            Enumeration enumeration = this.collectionConnections.elements();
            while (enumeration.hasMoreElements()) {
                collectionConnection = (CollectionConnection)enumeration.nextElement();
                n += collectionConnection.totalRecords;
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getRecordCount().");
        }
        return n;
    }

    public void shutdown() {
        InsightSmartClient.debugOut("Shutdown server.");
        try {
            Enumeration enumeration = this.collectionConnections.elements();
            while (enumeration.hasMoreElements()) {
                CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
                collectionConnection.oos.writeInt(19);
                collectionConnection.oos.flush();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in shutdown().", 2);
        }
    }

    public Vector verifyVersion(int n, int n2, int n3) {
        InsightSmartClient.debugOut("Verifying that client version is correct.");
        Vector<VersionResult> vector = new Vector<VersionResult>();
        VersionResult versionResult = null;
        try {
            Enumeration enumeration = this.collectionConnections.elements();
            while (enumeration.hasMoreElements()) {
                CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
                collectionConnection.oos.writeInt(21);
                collectionConnection.oos.writeInt(n);
                collectionConnection.oos.writeInt(n2);
                collectionConnection.oos.writeInt(n3);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) <= 0) continue;
                boolean bl = collectionConnection.ois.readBoolean();
                if (!bl) {
                    boolean bl2 = collectionConnection.ois.readBoolean();
                    versionResult = new VersionResult();
                    if (bl2) {
                        versionResult.isZipUpdate = true;
                        versionResult.suitableUpdateURL = (String)collectionConnection.ois.readObject();
                        versionResult.message = (String)collectionConnection.ois.readObject();
                    } else {
                        versionResult.isZipUpdate = false;
                        versionResult.suitableUpdateURL = (String)collectionConnection.ois.readObject();
                        versionResult.message = (String)collectionConnection.ois.readObject();
                    }
                    versionResult.tci = collectionConnection.tci;
                    vector.add(versionResult);
                }
                try {
                    if (collectionConnection.theInputStream.available() > 0) {
                        InsightVersion insightVersion = (InsightVersion)collectionConnection.ois.readObject();
                        InsightSmartClient.debugOut("Server version: " + insightVersion, 2);
                        collectionConnection.tci.setServerVersion(insightVersion);
                        continue;
                    }
                    if (n < 3 || n2 > 0) continue;
                    collectionConnection.tci.setServerVersion(this.getServerVersion(collectionConnection, 3, 50, 21));
                }
                catch (Exception exception) {
                    InsightSmartClient.debugOut("Exception reading server version: " + InsightUtilities.getStackTrace(exception));
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in verifyVersion(): " + exception, 2);
        }
        int n4 = 0;
        while (vector != null && n4 < vector.size()) {
            versionResult = (VersionResult)vector.get(n4);
            if (versionResult.tci.getServerVersion() != null) {
                vector.removeElementAt(n4);
                continue;
            }
            ++n4;
        }
        return vector;
    }

    public InsightVersion getServerVersion() {
        return this.getServerVersion(5, 60, 3);
    }

    public InsightVersion getServerVersion(int n, int n2, int n3) {
        try {
            return this.getServerVersion((CollectionConnection)this.collectionConnections.get(0), 5, 60, 3);
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getServerVersion():\n" + InsightUtilities.getStackTrace(exception), 2);
            return null;
        }
    }

    public InsightVersion getServerVersion(CollectionConnection collectionConnection, int n, int n2, int n3) {
        InsightVersion insightVersion;
        block8: {
            InsightSmartClient.debugOut("in getServerVersion().");
            insightVersion = null;
            try {
                collectionConnection.oos.writeInt(21);
                collectionConnection.oos.writeInt(n);
                collectionConnection.oos.writeInt(n2);
                collectionConnection.oos.writeInt(n3);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) <= 0) break block8;
                boolean bl = collectionConnection.ois.readBoolean();
                if (!bl) {
                    boolean bl2 = collectionConnection.ois.readBoolean();
                    VersionResult versionResult = new VersionResult();
                    if (bl2) {
                        versionResult.isZipUpdate = true;
                        versionResult.suitableUpdateURL = (String)collectionConnection.ois.readObject();
                        versionResult.message = (String)collectionConnection.ois.readObject();
                    } else {
                        versionResult.isZipUpdate = false;
                        versionResult.suitableUpdateURL = (String)collectionConnection.ois.readObject();
                        versionResult.message = (String)collectionConnection.ois.readObject();
                    }
                }
                try {
                    if (collectionConnection.theInputStream.available() > 0) {
                        insightVersion = (InsightVersion)collectionConnection.ois.readObject();
                        InsightSmartClient.debugOut("Server version: " + insightVersion, 2);
                    }
                }
                catch (Exception exception) {
                    InsightSmartClient.debugOut("Exception reading server version:\n" + InsightUtilities.getStackTrace(exception));
                }
            }
            catch (Exception exception) {
                InsightSmartClient.debugOut("Exception in getServerVersion():\n" + InsightUtilities.getStackTrace(exception), 3);
            }
        }
        return insightVersion;
    }

    public Hashtable getServerProps() {
        InsightSmartClient.debugOut("Retrieving server properties.");
        Hashtable hashtable = null;
        boolean bl = true;
        try {
            Enumeration enumeration = this.collectionConnections.elements();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
                Hashtable hashtable2 = null;
                InsightRequest insightRequest = InsightRequest.newRequest(20, collectionConnection.tci, this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    hashtable2 = (Hashtable)collectionConnection.ois.readObject();
                    collectionConnection.tci.setLocaleCollectionServer((Locale)hashtable2.get("Language"));
                    serializable = collectionConnection.tci.getLocaleCollectionServer();
                    InsightSmartClient.debugOut("The tci locale for this collections is: " + serializable, 3);
                }
                if (bl) {
                    hashtable = hashtable2;
                } else {
                    if (!this.propertiesEqual(hashtable2, hashtable, "Implementation")) {
                        InsightSmartClient.debugOut("Non-matching implementations", 2);
                    }
                    if (!this.propertiesEqual(hashtable2, hashtable, "Version")) {
                        InsightSmartClient.debugOut("Non-matching versions", 2);
                    }
                    if (!this.propertiesEqual(hashtable2, hashtable, "LexiconTree")) {
                        InsightSmartClient.debugOut("Non-matching LexiconTree", 2);
                        if (hashtable2.get("LexiconTree") == null || hashtable2.get("LexiconTree").equals(Boolean.FALSE)) {
                            hashtable.put("LexiconTree", Boolean.FALSE);
                        }
                    }
                    if (!this.propertiesEqual(hashtable2, hashtable, "FuzzyDate")) {
                        InsightSmartClient.debugOut("Non-matching FuzzyDate", 2);
                        if (hashtable2.get("FuzzyDate") != null && hashtable2.get("FuzzyDate").equals(Boolean.TRUE)) {
                            hashtable.put("FuzzyDate", Boolean.TRUE);
                        }
                        if (hashtable.get("FuzzyDateHelpText") == null || !hashtable.get("FuzzyDateHelpText").equals(hashtable2.get("FuzzyDateHelpText"))) {
                            hashtable.put("FuzzyDateHelpText", "");
                        }
                    }
                    if (!this.propertiesEqual(hashtable2, hashtable, "JTIP")) {
                        InsightSmartClient.debugOut("Non-matching JTIP", 2);
                        if (hashtable2.get("JTIP") == null || hashtable2.get("JTIP").equals(Boolean.FALSE)) {
                            hashtable.put("JTIP", Boolean.FALSE);
                        }
                    }
                    if (!this.propertiesEqual(hashtable2, hashtable, "UCB_DB")) {
                        InsightSmartClient.debugOut("Non-matching UCB_DB", 2);
                        if (hashtable2.get("UCB_DB") == null || hashtable2.get("UCB_DB").equals(Boolean.FALSE)) {
                            hashtable.put("UCB_DB", Boolean.FALSE);
                        }
                    }
                    if (!this.propertiesEqual(hashtable2, hashtable, "ObjectsEditable")) {
                        InsightSmartClient.debugOut("Non-matching ObjectsEditable", 2);
                        if (hashtable2.get("ObjectsEditable") == null || hashtable2.get("ObjectsEditable").equals(Boolean.FALSE)) {
                            hashtable.put("ObjectsEditable", Boolean.FALSE);
                        }
                    }
                    if (!this.propertiesEqual(hashtable2, hashtable, "CollectionConfiguration")) {
                        InsightSmartClient.debugOut("Non-matching versions", 2);
                        if (hashtable2.get("CollectionConfiguration") == null || hashtable2.get("CollectionConfiguration").equals(Boolean.FALSE)) {
                            hashtable.put("CollectionConfiguration", Boolean.FALSE);
                        }
                    }
                    if (!this.propertiesEqual(hashtable2, hashtable, "AllowCollectionSortMax")) {
                        InsightSmartClient.debugOut("Non-matching AllowCollectionSortMax", 2);
                        if (hashtable2.get("AllowCollectionSortMax") instanceof Integer) {
                            serializable = (Integer)hashtable2.get("AllowCollectionSortMax");
                            if (hashtable.get("AllowCollectionSortMax") == null) {
                                hashtable.put("AllowCollectionSortMax", serializable);
                            } else if ((Integer)hashtable.get("AllowCollectionSortMax") > (Integer)serializable && (Integer)serializable > 0) {
                                hashtable.put("AllowCollectionSortMax", serializable);
                            }
                        }
                    }
                }
                bl = false;
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getServerProps(): " + exception + "\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return hashtable;
    }

    public boolean propertiesEqual(Hashtable hashtable, Hashtable hashtable2, String string) {
        boolean bl = false;
        if (hashtable != null && hashtable2 != null && string != null) {
            bl = hashtable.get(string) == null && hashtable2.get(string) == null ? true : (hashtable.get(string) == null || hashtable2.get(string) == null ? false : hashtable.get(string).equals(hashtable2.get(string)));
        }
        return bl;
    }

    public void removeVocabulary(String string, String string2, String string3, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Removing vocabulary \"" + string3 + "\" from " + string + "." + string2);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(28, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("TABLE_NAME", string);
            insightRequest.addObjectParam("FIELD_NAME", string2);
            insightRequest.addObjectParam("VALUE", string3);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in removeVocabulary(): " + exception, 2);
        }
    }

    public void addVocabulary(String string, String string2, String string3, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Adding vocabulary \"" + string3 + "\" to " + string + "." + string2);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(27, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("TABLE_NAME", string);
            insightRequest.addObjectParam("FIELD_NAME", string2);
            insightRequest.addObjectParam("VALUE", string3);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in addVocabulary(): " + exception, 2);
        }
    }

    public Vector getVocabulary(String string, String string2, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Getting vocabulary for " + string + "." + string2);
        Vector vector = new Vector();
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(26, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("TABLE_NAME", string);
            insightRequest.addObjectParam("FIELD_NAME", string2);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                vector = (Vector)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getVocabulary(): " + exception, 2);
        }
        return vector;
    }

    public Object[] getObjectData(ObjectKey objectKey) {
        InsightSmartClient.debugOut("Getting full object data for " + objectKey.getObjectID(), 3);
        Object[] objectArray = new Object[]{};
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(objectKey);
            InsightRequest insightRequest = InsightRequest.newRequest(23, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("OBJECT_ID", objectKey.getObjectID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                objectArray = (Object[])collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getObjectData(): " + exception, 2);
        }
        return objectArray;
    }

    public boolean addObject(Field[] fieldArray, String[] stringArray, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Add Object.");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(25, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("COLLECTION_NAME", collectionConnection.tci.getInitialGroupOpen());
            insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
            insightRequest.addObjectParam("FIELDS", InsightUtilities.toVector(fieldArray));
            insightRequest.addObjectParam("VALUES", InsightUtilities.toVector(stringArray));
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in addObject(): " + exception, 2);
        }
        return bl;
    }

    public boolean editObject(Field[] fieldArray, String[] stringArray, ObjectKey objectKey) {
        InsightSmartClient.debugOut("Edit Object.");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(objectKey);
            InsightRequest insightRequest = InsightRequest.newRequest(24, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("OBJECT_ID", objectKey.getObjectID());
            insightRequest.addObjectParam("FIELDS", InsightUtilities.toVector(fieldArray));
            insightRequest.addObjectParam("VALUES", InsightUtilities.toVector(stringArray));
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in editObject(): " + exception, 2);
        }
        return bl;
    }

    public boolean addImage(int n, long l, boolean bl, boolean bl2, int n2, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Add Image: group = " + n + ", image = " + l + ", hasMultiview = " + bl);
        boolean bl3 = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(5, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", n);
            insightRequest.addLongParam("MEDIA_ID", l);
            insightRequest.addBooleanParam("HAS_MVI", bl);
            insightRequest.addBooleanParam("HAS_MULTI_PAGE", bl2);
            insightRequest.addIntegerParam("ABSOLUTE_ORDER", n2);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                bl3 = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in addImage(): " + exception, 2);
        }
        return bl3;
    }

    public Vector addImages(Vector vector) {
        InsightSmartClient.debugOut("in addImages()");
        Vector<Vector> vector2 = new Vector<Vector>();
        try {
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    ImageToProcess imageToProcess;
                    CollectionConnection collectionConnection;
                    Vector vector3 = (Vector)vector.get(i);
                    if (vector3 == null || vector3.size() <= 0 || (collectionConnection = this.getCollectionConnection(imageToProcess = (ImageToProcess)vector3.get(0))) == null) continue;
                    InsightRequest insightRequest = InsightRequest.newRequest(79, collectionConnection.tci, this.getLocalAddress());
                    insightRequest.addObjectParam("IMAGES", vector3);
                    collectionConnection.oos.writeObject(insightRequest);
                    collectionConnection.oos.flush();
                    vector2.add(vector3);
                    if (this.waitForInput(collectionConnection) <= 0) continue;
                    Vector vector4 = (Vector)collectionConnection.ois.readObject();
                    vector2.add(vector4);
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in addImages(): " + exception, 2);
        }
        return vector2;
    }

    public void removeImage(int n, long l, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Remove Image: group = " + n + ", image = " + l);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(6, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", n);
            insightRequest.addLongParam("MEDIA_ID", l);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in removeImage(): " + exception, 2);
        }
    }

    public void removeImages(int n, Vector vector, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Removing images from group " + n);
        try {
            for (int i = 0; i < vector.size(); ++i) {
                long l = (Long)vector.get(i);
                InsightSmartClient.debugOut("Removing image " + l);
            }
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(78, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", n);
            insightRequest.addObjectParam("MEDIA_IDS", vector);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in removeImages(): " + exception, 2);
        }
    }

    public Vector newGroup() {
        Vector<Serializable> vector = new Vector<Serializable>();
        ImageGroupFile imageGroupFile = new ImageGroupFile();
        vector.add(imageGroupFile);
        InsightSmartClient.debugOut("New group.", 3);
        try {
            Enumeration enumeration = this.collectionConnections.elements();
            while (enumeration.hasMoreElements()) {
                GroupInformation groupInformation = null;
                CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
                InsightRequest insightRequest = InsightRequest.newRequest(7, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.", 3);
                if (this.waitForInput(collectionConnection) <= 0) continue;
                groupInformation = new GroupInformation();
                groupInformation.setGroupID(collectionConnection.ois.readInt());
                groupInformation.setTci(collectionConnection.tci);
                vector.add(groupInformation);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in newGroup(): " + exception, 2);
        }
        return vector;
    }

    public boolean saveGroup(ImageGroupFile imageGroupFile, int n, CollectionKey collectionKey) {
        boolean bl = false;
        if (imageGroupFile != null) {
            try {
                CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
                InsightRequest insightRequest = InsightRequest.newRequest(77, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("IMAGE_GROUP_FILE", imageGroupFile);
                insightRequest.addIntegerParam("GROUP_ID", n);
                insightRequest.addStringParam("VCID", collectionKey.getVCID());
                insightRequest.addBooleanParam("WAIT_FOR_SERVER", true);
                boolean bl2 = InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(5, 50, 5), 7);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (bl2) {
                    if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                        bl = collectionConnection.ois.readBoolean();
                    }
                } else if (this.waitForInput(collectionConnection) > 0) {
                    bl = collectionConnection.ois.readBoolean();
                }
            }
            catch (Exception exception) {
                InsightSmartClient.debugOut("Exception in saveGroup(): " + exception, 2);
            }
        }
        return bl;
    }

    public boolean saveVirtualGroup(ImageGroupFile imageGroupFile, Vector vector, CollectionKey collectionKey) {
        boolean bl = false;
        if (imageGroupFile != null) {
            try {
                Serializable serializable;
                int n;
                CollectionKeyDistributor collectionKeyDistributor = new CollectionKeyDistributor();
                Vector vector2 = imageGroupFile.getMviSerieses();
                for (int i = 0; i < vector2.size(); ++i) {
                    MultiviewImageSeries multiviewImageSeries = (MultiviewImageSeries)vector2.get(i);
                    collectionKeyDistributor.addCollectionKey(multiviewImageSeries);
                }
                CollectionKeyDistributor collectionKeyDistributor2 = new CollectionKeyDistributor();
                vector2 = imageGroupFile.getImageSerieses();
                for (n = 0; n < vector2.size(); ++n) {
                    serializable = (ImageSeries)vector2.get(n);
                    collectionKeyDistributor2.addCollectionKey((CollectionKey)((Object)serializable));
                }
                for (n = 0; n < vector.size(); ++n) {
                    CollectionConnection collectionConnection;
                    serializable = (GroupInformation)vector.get(n);
                    if (((GroupInformation)serializable).getTci().getVCID().equals("NA") || !((GroupInformation)serializable).getTci().getVCID().equals(collectionKey.getVCID()) || (collectionConnection = this.getCollectionConnection(((GroupInformation)serializable).getTci())) == null) continue;
                    ImageGroupFile imageGroupFile2 = new ImageGroupFile(imageGroupFile.getGroupName());
                    vector2 = collectionKeyDistributor2.getPartition(((GroupInformation)serializable).getTci());
                    if (vector2 != null) {
                        imageGroupFile2.setImageSerieses(vector2);
                    }
                    if ((vector2 = collectionKeyDistributor.getPartition(((GroupInformation)serializable).getTci())) != null) {
                        imageGroupFile2.setMviSerieses(vector2);
                    }
                    InsightRequest insightRequest = InsightRequest.newRequest(77, collectionConnection.tci, this.getLocalAddress());
                    insightRequest.addObjectParam("IMAGE_GROUP_FILE", imageGroupFile2);
                    insightRequest.addIntegerParam("GROUP_ID", ((GroupInformation)serializable).getGroupID());
                    insightRequest.addStringParam("VCID", ((GroupInformation)serializable).getTci().getVCID());
                    collectionConnection.oos.writeObject(insightRequest);
                    collectionConnection.oos.flush();
                    InsightSmartClient.debugOut("Waiting for data.");
                    if (this.waitForInput(collectionConnection) > 0) {
                        bl = collectionConnection.ois.readBoolean();
                    }
                    if (bl) continue;
                    InsightSmartClient.debugOut("Unable to save group '" + imageGroupFile2.getGroupName() + "' to server [InstID: " + ((GroupInformation)serializable).getTci().getInstitutionID() + ", CollID: " + ((GroupInformation)serializable).getTci().getCollectionID() + " , VCID: " + ((GroupInformation)serializable).getTci().getVCID() + "]", 2);
                    break;
                }
            }
            catch (Exception exception) {
                InsightSmartClient.debugOut("Exception in saveVirtualGroup(): " + exception, 2);
            }
        }
        return bl;
    }

    public boolean saveAs(int n, String string, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Save as: group = " + n + ", name = " + string);
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(8, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", n);
            insightRequest.addStringParam("GROUP_NAME", string);
            insightRequest.addStringParam("VCID", collectionKey.getVCID());
            insightRequest.addBooleanParam("WAIT_FOR_SERVER", true);
            boolean bl2 = InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(5, 50, 5), 7);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (bl2) {
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    bl = collectionConnection.ois.readBoolean();
                }
            } else if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in saveAs(): " + exception, 2);
        }
        return bl;
    }

    public void deleteGroup(Vector vector) {
        try {
            for (int i = 0; i < vector.size(); ++i) {
                GroupInformation groupInformation = (GroupInformation)vector.get(i);
                InsightSmartClient.debugOut("Delete group: " + groupInformation.getGroupID());
                CollectionConnection collectionConnection = this.getCollectionConnection(groupInformation.getTci());
                InsightRequest insightRequest = InsightRequest.newRequest(40, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", groupInformation.getGroupID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in deleteGroup(): " + exception, 2);
        }
    }

    public void closeGroup(Vector vector) {
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                GroupInformation groupInformation = (GroupInformation)enumeration.nextElement();
                InsightSmartClient.debugOut("Close group: " + groupInformation.getGroupID());
                CollectionConnection collectionConnection = this.getCollectionConnection(groupInformation.getTci());
                InsightRequest insightRequest = InsightRequest.newRequest(9, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", groupInformation.getGroupID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in closeGroup(): " + exception, 2);
        }
    }

    public boolean doesGroupExist(String string, CollectionKey collectionKey) {
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(68, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("GROUP_NAME", string);
            insightRequest.addStringParam("VCID", collectionKey.getVCID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in doesGroupExist(): " + exception, 2);
        }
        return bl;
    }

    public int getGroupId(String string, CollectionKey collectionKey) {
        int n = 0;
        InsightSmartClient.debugOut("Get group ID: " + string);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(10, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("GROUP_NAME", string);
            insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                n = collectionConnection.ois.readInt();
                InsightSmartClient.debugOut("Group ID: " + n);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getGroupID(): " + exception, 2);
        }
        return n;
    }

    public GroupInformation getGroupInfo(String string, CollectionKey collectionKey) {
        GroupInformation groupInformation = null;
        InsightSmartClient.debugOut("Get group information: " + string);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(38, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("GROUP_NAME", string);
            insightRequest.addStringParam("VCID", collectionKey.getVCID());
            insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
            insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
            insightRequest.addBooleanParam("EXCLUDE_SPS", false);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                groupInformation = (GroupInformation)collectionConnection.ois.readObject();
                InsightSmartClient.debugOut("Group ID: " + groupInformation.getGroupID());
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getGroupInfo(): " + exception, 2);
        }
        return groupInformation;
    }

    public Vector getSelectedImagesInGroup(Vector vector) {
        InsightSmartClient.debugOut("in getSelectedImagesInGroup()");
        Vector vector2 = new Vector();
        try {
            CollectionKeyDistributor collectionKeyDistributor = new CollectionKeyDistributor();
            for (int i = 0; i < vector.size(); ++i) {
                collectionKeyDistributor.addCollectionKey((ImageInGroup)vector.get(i));
            }
            Vector vector3 = collectionKeyDistributor.getDistribution();
            for (int i = 0; i < vector3.size(); ++i) {
                Vector vector4 = (Vector)vector3.get(i);
                ImageInGroup imageInGroup = null;
                Vector<Long> vector5 = new Vector<Long>(vector4.size());
                Vector<Long> vector6 = new Vector<Long>(vector4.size());
                for (int j = 0; j < vector4.size(); ++j) {
                    imageInGroup = (ImageInGroup)vector4.get(j);
                    vector5.add(new Long(imageInGroup.getObjectID()));
                    vector6.add(new Long(imageInGroup.getImageID()));
                }
                CollectionConnection collectionConnection = this.getCollectionConnection(imageInGroup);
                if (collectionConnection == null) continue;
                InsightRequest insightRequest = InsightRequest.newRequest(62, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addCollectionKeyParam(imageInGroup);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                insightRequest.addObjectParam("OBJECT_IDS", vector5);
                insightRequest.addObjectParam("MEDIA_IDS", vector6);
                insightRequest.addStringParam("INSTITUTION_ID", collectionConnection.tci.getInstitutionID());
                insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                boolean bl = false;
                if (InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(3, 50, 0), 7)) {
                    bl = this.waitWhileKeepAlive(1, collectionConnection) > 0;
                } else {
                    boolean bl2 = bl = this.waitForInput(collectionConnection) > 0;
                }
                if (!bl) continue;
                Vector vector7 = (Vector)collectionConnection.ois.readObject();
                for (int j = 0; j < vector7.size(); ++j) {
                    vector2.add(vector7.get(j));
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getSelectedImagesInGroup():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        InsightSmartClient.debugOut("Gathered " + vector2.size() + " selected images in the group.");
        return vector2;
    }

    public Vector getImagesInGroup(Vector vector, FieldMapping[] fieldMappingArray) {
        Vector<ImageInGroup> vector2 = new Vector<ImageInGroup>();
        if (fieldMappingArray == null) {
            fieldMappingArray = new FieldMapping[]{};
        }
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                GroupInformation groupInformation = (GroupInformation)enumeration.nextElement();
                InsightSmartClient.debugOut("Getting images in group " + groupInformation.getGroupID() + ".");
                CollectionConnection collectionConnection = this.getCollectionConnection(groupInformation.getTci());
                InsightRequest insightRequest = InsightRequest.newRequest(33, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", groupInformation.getGroupID());
                insightRequest.addIntegerParam("PROFILE_ID", groupInformation.getTci().getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", groupInformation.getTci().getUserCollection());
                insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                insightRequest.addObjectParam("SORT_FIELDS", InsightUtilities.toVector(fieldMappingArray));
                insightRequest.addCollectionKeyParam(groupInformation.getTci());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) <= 0) continue;
                int n = collectionConnection.ois.readInt();
                InsightSmartClient.debugOut("Awaiting " + n + " images.");
                for (int i = 0; i < n; ++i) {
                    ImageInGroup imageInGroup = (ImageInGroup)collectionConnection.ois.readObject();
                    vector2.add(imageInGroup);
                }
            }
            InsightSmartClient.debugOut("Gathered " + vector2.size() + " images in the group.");
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getImagesInGroup(): " + exception, 2);
        }
        Collections.sort(vector2);
        return vector2;
    }

    public Vector getImageFiles(long l, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Getting image files " + l + ".");
        Vector vector = new Vector();
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(34, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("MEDIA_ID", l);
            insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
            insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
            insightRequest.addBooleanParam("EXCLUDE_SPS", false);
            insightRequest.addStringParam("INSTITUTION_ID", collectionConnection.tci.getInstitutionID());
            insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                vector = (Vector)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getImageFiles():" + exception, 2);
        }
        return vector;
    }

    public ImageFile getImageFile(long l, CollectionKey collectionKey, int n) {
        InsightSmartClient.debugOut("Getting image file " + l + ".");
        ImageFile imageFile = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(35, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("MEDIA_ID", l);
            insightRequest.addIntegerParam("RESOLUTION", n);
            insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
            insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
            insightRequest.addBooleanParam("EXCLUDE_SPS", false);
            insightRequest.addStringParam("INSTITUTION_ID", collectionConnection.tci.getInstitutionID());
            insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                imageFile = (ImageFile)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getImageFile(): " + exception, 2);
        }
        return imageFile;
    }

    public int getImageCount(GroupInformation groupInformation) {
        InsightSmartClient.debugOut("Getting image count.");
        int n = 0;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(groupInformation.getTci());
            InsightRequest insightRequest = InsightRequest.newRequest(69, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("GROUP_INFORMATION", groupInformation);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                n = collectionConnection.ois.readInt();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getImageCount(): " + exception, 2);
        }
        return n;
    }

    public void updateImageGroupFile(ImageGroupFile imageGroupFile, String string, String string2, Vector vector) {
        try {
            if (imageGroupFile != null) {
                imageGroupFile.setImagesInGroup(this.getImagesInGroup(vector, null));
                imageGroupFile.setCreator(string, string2);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getImageGroupFile(): " + exception, 2);
        }
    }

    public Vector openImageGroupFile(ImageGroupFile imageGroupFile) {
        GroupInformation groupInformation = null;
        Vector<Serializable> vector = new Vector<Serializable>();
        vector.add(imageGroupFile);
        InsightSmartClient.debugOut("Open image group file: " + imageGroupFile.getGroupName());
        try {
            Vector vector2 = imageGroupFile.getImagesInGroup();
            Vector vector3 = imageGroupFile.getMviSerieses();
            for (int i = 0; i < this.collectionConnections.size(); ++i) {
                CollectionKey collectionKey;
                int n;
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(i);
                Vector<CollectionKey> vector4 = new Vector<CollectionKey>();
                Vector<Long> vector5 = new Vector<Long>();
                for (n = 0; n < vector2.size(); ++n) {
                    collectionKey = (ImageInGroup)vector2.get(n);
                    if (!CollectionKeyDistributor.keysAgree(collectionKey, collectionConnection.tci)) continue;
                    vector4.add(collectionKey);
                }
                for (n = 0; n < vector3.size(); ++n) {
                    collectionKey = (MultiviewImageSeries)vector3.get(n);
                    if (!CollectionKeyDistributor.keysAgree(collectionKey, collectionConnection.tci)) continue;
                    vector5.add(new Long(((MultiviewImageSeries)collectionKey).getImageID()));
                }
                InsightRequest insightRequest = InsightRequest.newRequest(58, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
                insightRequest.addObjectParam("IMAGES", vector4);
                insightRequest.addObjectParam("MVI_IDS", vector5);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitWhileKeepAlive(1, collectionConnection) <= 0) continue;
                groupInformation = (GroupInformation)collectionConnection.ois.readObject();
                groupInformation.setGroupName(imageGroupFile.getGroupName());
                groupInformation.setTci(collectionConnection.tci);
                vector.add(groupInformation);
                InsightSmartClient.debugOut("Group ID: " + groupInformation.getGroupID());
                for (int j = 0; j < vector3.size(); ++j) {
                    MultiviewImageSeries multiviewImageSeries = (MultiviewImageSeries)vector3.get(j);
                    if (!CollectionKeyDistributor.keysAgree(multiviewImageSeries, collectionConnection.tci)) continue;
                    multiviewImageSeries.setGroupID(groupInformation.getGroupID());
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in openImageGroupFile(): " + exception);
        }
        return vector;
    }

    public int openGroupFile(String string, Vector vector, CollectionKey collectionKey) {
        int n = 0;
        InsightSmartClient.debugOut("Open local group: " + string);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(32, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("GROUP_NAME", string);
            insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
            insightRequest.addObjectParam("IMAGES_IN_GROUP", vector);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                n = collectionConnection.ois.readInt();
                InsightSmartClient.debugOut("Group ID: " + n);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in openLocalGroup(): " + exception, 2);
        }
        return n;
    }

    public Vector openGroup(String string, CollectionKey collectionKey, String string2, int n, boolean bl) {
        Vector<Serializable> vector;
        block14: {
            vector = new Vector<Serializable>();
            ImageGroupFile imageGroupFile = new ImageGroupFile(string);
            InsightSmartClient.debugOut("Open group: " + string);
            if (bl) {
                imageGroupFile.setGroupName(string);
                vector.add(imageGroupFile);
                try {
                    CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
                    InsightRequest insightRequest = InsightRequest.newRequest(38, collectionConnection.tci, this.getLocalAddress());
                    insightRequest.addStringParam("GROUP_NAME", string);
                    insightRequest.addStringParam("VCID", collectionKey.getVCID());
                    insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                    insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                    insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                    collectionConnection.oos.writeObject(insightRequest);
                    collectionConnection.oos.flush();
                    InsightSmartClient.debugOut("Waiting for data.");
                    if (this.waitForInput(collectionConnection) <= 0) break block14;
                    GroupInformation groupInformation = null;
                    groupInformation = (GroupInformation)collectionConnection.ois.readObject();
                    if (groupInformation != null) {
                        groupInformation.setTci(collectionConnection.tci);
                        vector.add(groupInformation);
                        InsightSmartClient.debugOut("Received: " + vector);
                        imageGroupFile.setMviSerieses(this.getMultiviewImages(groupInformation.getGroupID(), collectionConnection.tci));
                        break block14;
                    }
                    InsightSmartClient.debugOut("Error opening group on server side.");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    InsightSmartClient.debugOut("Exception in openGroup().", 2);
                }
            } else {
                try {
                    CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
                    InsightRequest insightRequest = InsightRequest.newRequest(11, collectionConnection.tci, this.getLocalAddress());
                    insightRequest.addStringParam("GROUP_NAME", string);
                    CollectionKeyWrapper collectionKeyWrapper = new CollectionKeyWrapper(collectionKey.getInstitutionID(), collectionKey.getCollectionID(), string2);
                    insightRequest.addCollectionKeyParam(collectionKeyWrapper);
                    insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                    insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                    insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                    insightRequest.addIntegerParam("THUMBNAIL_SIZE", n);
                    collectionConnection.oos.writeObject(insightRequest);
                    collectionConnection.oos.flush();
                    InsightSmartClient.debugOut("Waiting for data.");
                    GroupInformation groupInformation = null;
                    int n2 = 0;
                    boolean bl2 = false;
                    if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                        imageGroupFile = (ImageGroupFile)collectionConnection.ois.readObject();
                        groupInformation = (GroupInformation)collectionConnection.ois.readObject();
                        n2 = collectionConnection.ois.readInt();
                        if (groupInformation != null) {
                            bl2 = true;
                        } else {
                            InsightSmartClient.debugOut("Error opening group on server side.");
                        }
                    }
                    imageGroupFile.setGroupName(string);
                    vector.add(imageGroupFile);
                    if (bl2) {
                        groupInformation.setGroupName(string);
                        groupInformation.setGroupID(n2);
                        groupInformation.setTci(collectionConnection.tci);
                        vector.add(groupInformation);
                        InsightSmartClient.debugOut("Received: " + vector);
                    }
                    Enumeration enumeration = this.collectionConnections.elements();
                    while (enumeration.hasMoreElements()) {
                        CollectionConnection collectionConnection2 = (CollectionConnection)enumeration.nextElement();
                        if (CollectionKeyDistributor.keysAgree(collectionKey, collectionConnection2.tci)) continue;
                        GroupInformation groupInformation2 = null;
                        insightRequest = InsightRequest.newRequest(7, collectionConnection2.tci, this.getLocalAddress());
                        insightRequest.addStringParam("VCID", collectionConnection2.tci.getVCID());
                        collectionConnection2.oos.writeObject(insightRequest);
                        collectionConnection2.oos.flush();
                        InsightSmartClient.debugOut("Waiting for data.");
                        if (this.waitForInput(collectionConnection2) > 0) {
                            groupInformation2 = new GroupInformation();
                            groupInformation2.setGroupName(string);
                            groupInformation2.setGroupID(collectionConnection2.ois.readInt());
                            groupInformation2.setTci(collectionConnection2.tci);
                        }
                        if (groupInformation2 != null) {
                            vector.add(groupInformation2);
                            continue;
                        }
                        InsightSmartClient.debugOut("Error opening group on server side.");
                        groupInformation2 = null;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    InsightSmartClient.debugOut("Exception in openGroup().", 2);
                }
            }
        }
        return vector;
    }

    public Vector openVirtualGroup(String string, CollectionKey collectionKey, int n, boolean bl) {
        Vector<Serializable> vector;
        block12: {
            vector = new Vector<Serializable>();
            ImageGroupFile imageGroupFile = new ImageGroupFile(string);
            vector.add(imageGroupFile);
            InsightSmartClient.debugOut("Open virtual group: " + string);
            try {
                if (bl) {
                    for (int i = 0; i < this.collectionConnections.size(); ++i) {
                        CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(i);
                        if (!collectionKey.getVCID().equals(collectionConnection.tci.getVCID())) continue;
                        InsightRequest insightRequest = InsightRequest.newRequest(38, collectionConnection.tci, this.getLocalAddress());
                        insightRequest.addStringParam("GROUP_NAME", string);
                        insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
                        insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                        insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                        insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                        collectionConnection.oos.writeObject(insightRequest);
                        collectionConnection.oos.flush();
                        InsightSmartClient.debugOut("Waiting for data.");
                        if (this.waitWhileKeepAlive(1, collectionConnection) <= 0) continue;
                        GroupInformation groupInformation = (GroupInformation)collectionConnection.ois.readObject();
                        if (groupInformation != null) {
                            groupInformation.setTci(collectionConnection.tci);
                            vector.add(groupInformation);
                            Vector vector2 = this.getMultiviewImages(groupInformation.getGroupID(), collectionConnection.tci);
                            for (int j = 0; j < vector2.size(); ++j) {
                                imageGroupFile.addMultiviewImage((MultiviewImageSeries)vector2.get(j));
                            }
                            continue;
                        }
                        InsightSmartClient.debugOut("Error opening group on server side.");
                    }
                    break block12;
                }
                for (int i = 0; i < this.collectionConnections.size(); ++i) {
                    Serializable serializable;
                    InsightRequest insightRequest;
                    CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(i);
                    boolean bl2 = false;
                    if (collectionKey.getVCID().equals(collectionConnection.tci.getVCID())) {
                        insightRequest = InsightRequest.newRequest(11, collectionConnection.tci, this.getLocalAddress());
                        insightRequest.addStringParam("GROUP_NAME", string);
                        insightRequest.addCollectionKeyParam(collectionConnection.tci);
                        insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                        insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
                        insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                        insightRequest.addIntegerParam("THUMBNAIL_SIZE", n);
                        collectionConnection.oos.writeObject(insightRequest);
                        collectionConnection.oos.flush();
                        InsightSmartClient.debugOut("Waiting for data.");
                        if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                            serializable = (ImageGroupFile)collectionConnection.ois.readObject();
                            GroupInformation groupInformation = (GroupInformation)collectionConnection.ois.readObject();
                            int n2 = collectionConnection.ois.readInt();
                            if (groupInformation != null) {
                                Vector vector3 = ((ImageGroupFile)serializable).getImageSerieses();
                                for (int j = 0; j < vector3.size(); ++j) {
                                    imageGroupFile.addImageSeries((ImageSeries)vector3.get(j));
                                }
                                Vector vector4 = ((ImageGroupFile)serializable).getMviSerieses();
                                for (int j = 0; j < vector4.size(); ++j) {
                                    imageGroupFile.addMultiviewImage((MultiviewImageSeries)vector4.get(j));
                                }
                                groupInformation.setGroupName(string);
                                groupInformation.setGroupID(n2);
                                groupInformation.setTci(collectionConnection.tci);
                                vector.add(groupInformation);
                                bl2 = true;
                            }
                        }
                    }
                    if (bl2) continue;
                    InsightSmartClient.debugOut("Constructing new group.");
                    insightRequest = InsightRequest.newRequest(7, collectionConnection.tci, this.getLocalAddress());
                    insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
                    collectionConnection.oos.writeObject(insightRequest);
                    collectionConnection.oos.flush();
                    InsightSmartClient.debugOut("Waiting for data.");
                    if (this.waitForInput(collectionConnection) <= 0) continue;
                    serializable = new GroupInformation();
                    ((GroupInformation)serializable).setGroupName(string);
                    ((GroupInformation)serializable).setGroupID(collectionConnection.ois.readInt());
                    ((GroupInformation)serializable).setTci(collectionConnection.tci);
                    vector.add(serializable);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                InsightSmartClient.debugOut("Exception in openVirtualGroup().", 2);
            }
        }
        return vector;
    }

    public Vector openInitialGroups() {
        Vector<ImageGroupFile> vector = new Vector<ImageGroupFile>();
        ImageGroupFile imageGroupFile = new ImageGroupFile();
        vector.add(imageGroupFile);
        MutableObject mutableObject = new MutableObject();
        MutableObject mutableObject2 = new MutableObject(new HashSet());
        Vector vector2 = new Vector();
        Object object = this.collectionConnections.elements();
        while (object.hasMoreElements()) {
            class InitialGroupDownloader
            extends Thread {
                MutableObject exception;
                MutableObject nonFinishedThreads;
                CollectionConnection cc;
                private final /* synthetic */ ImageGroupFile val$igf;
                private final /* synthetic */ Vector val$toReturn;

                public InitialGroupDownloader(MutableObject mutableObject, MutableObject mutableObject2, CollectionConnection collectionConnection, ImageGroupFile imageGroupFile, Vector vector) {
                    this.val$igf = imageGroupFile;
                    this.val$toReturn = vector;
                    this.exception = mutableObject;
                    this.nonFinishedThreads = mutableObject2;
                    this.cc = collectionConnection;
                    ((Set)mutableObject2.getValue()).add(this);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        String string = this.cc.tci.getInitialGroupOpen();
                        this.val$igf.setGroupName(string);
                        GroupInformation groupInformation = null;
                        InsightRequest insightRequest = InsightRequest.newRequest(38, this.cc.tci, InsightSmartClient.this.getLocalAddress());
                        insightRequest.addStringParam("GROUP_NAME", string);
                        insightRequest.addStringParam("VCID", this.cc.tci.getVCID());
                        insightRequest.addIntegerParam("PROFILE_ID", this.cc.tci.getProfileID());
                        insightRequest.addIntegerParam("USER_COLLECTION", this.cc.tci.getUserCollection());
                        insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                        this.cc.oos.writeObject(insightRequest);
                        this.cc.oos.flush();
                        InsightSmartClient.debugOut("Waiting for data.");
                        if (InsightSmartClient.this.waitForInput(this.cc) > 0) {
                            groupInformation = (GroupInformation)this.cc.ois.readObject();
                            if (groupInformation != null) {
                                groupInformation.setTci(this.cc.tci);
                                this.val$toReturn.add(groupInformation);
                                InsightSmartClient.debugOut("Received: " + this.val$toReturn);
                            } else {
                                InsightSmartClient.debugOut("Error opening group on server side.");
                            }
                        }
                    }
                    catch (Exception exception) {
                        MutableObject mutableObject = this.exception;
                        synchronized (mutableObject) {
                            if (this.exception.getValue() == null) {
                                this.exception.setValue(exception);
                            }
                        }
                    }
                    finally {
                        ((Set)this.nonFinishedThreads.getValue()).remove(this);
                    }
                }
            }
            new InitialGroupDownloader(mutableObject, mutableObject2, (CollectionConnection)object.nextElement(), imageGroupFile, vector).start();
        }
        while (mutableObject.getValue() == null && ((Set)mutableObject2.getValue()).size() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = (Exception)mutableObject.getValue();
        if (object != null) {
            InsightSmartClient.debugOut("Exception in openInitialGroups():\n" + InsightUtilities.getStackTrace((Throwable)object), 2);
        }
        imageGroupFile.setMviSerieses(vector2);
        return vector;
    }

    public Vector getMismatchedFields(CollectionKey collectionKey) {
        Vector<FieldStandardMismatches> vector = new Vector<FieldStandardMismatches>();
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            if (collectionConnection != null) {
                InsightRequest insightRequest = InsightRequest.newRequest(71, collectionConnection.tci, this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(1, WAIT_LIMIT * 5L, collectionConnection) > 0) {
                    int n = collectionConnection.ois.readInt();
                    for (int i = 0; i < n; ++i) {
                        vector.add((FieldStandardMismatches)collectionConnection.ois.readObject());
                    }
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getMismatchedFields(), exc: " + exception, 2);
        }
        return vector;
    }

    public Vector getStandardPreferences(CollectionKey collectionKey) {
        Vector<String> vector = new Vector<String>(0);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(70, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(collectionConnection.tci);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(1, WAIT_LIMIT * 5L, collectionConnection) > 0) {
                int n = collectionConnection.ois.readInt();
                vector = new Vector(n);
                InsightSmartClient.debugOut("Standard list (in order of preference) for: " + collectionConnection.tci.collectionName, 3);
                for (int i = 0; i < n; ++i) {
                    String string = (String)collectionConnection.ois.readObject();
                    InsightSmartClient.debugOut("Standard " + i + ": " + string, 3);
                    vector.add(string);
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getStandardPreferences(), exc: " + exception, 2);
        }
        return vector;
    }

    public boolean isFieldStandardNameUnique(String string) {
        boolean bl = false;
        try {
            InsightSmartClient.debugOut("in isFieldStandardNameUnique().");
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(147, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("FIELD_STANDARD_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in isFieldStandardNameUnique():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public FieldStandard getFieldStandard(String string) {
        InsightSmartClient.debugOut("in getFieldStandard(" + string + ").");
        FieldStandard fieldStandard = null;
        try {
            CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
            InsightRequest insightRequest = InsightRequest.newRequest(135, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("STANDARD_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(1, WAIT_LIMIT * 5L, collectionConnection) > 0) {
                fieldStandard = (FieldStandard)collectionConnection.ois.readObject();
                InsightSmartClient.debugOut("Received standard: " + fieldStandard);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getFieldStandard():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return fieldStandard;
    }

    public FieldStandard getFieldStandardTemplate(String string) {
        InsightSmartClient.debugOut("in getFieldStandardTemplate(" + string + ").");
        FieldStandard fieldStandard = null;
        try {
            CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
            InsightRequest insightRequest = InsightRequest.newRequest(155, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("STANDARD_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(1, WAIT_LIMIT * 5L, collectionConnection) > 0) {
                fieldStandard = (FieldStandard)collectionConnection.ois.readObject();
                InsightSmartClient.debugOut("Received standard: " + fieldStandard);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getFieldStandardTemplate():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return fieldStandard;
    }

    public String getStandardDescription(String string) {
        String string2 = new String();
        try {
            CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
            InsightRequest insightRequest = InsightRequest.newRequest(82, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("STANDARD_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(1, WAIT_LIMIT * 5L, collectionConnection) > 0) {
                string2 = (String)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getStandardDescription(), exc: " + exception, 2);
        }
        InsightSmartClient.debugOut("getStandardDescription url: " + string2, 2);
        return string2;
    }

    public String getCommonStandard() {
        InsightSmartClient.debugOut("in getCommonStandard().");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable<String, Integer> hashtable2 = null;
        int n = 100;
        String string = "";
        try {
            boolean bl = true;
            Integer n2 = new Integer(0);
            String string2 = "";
            Integer n3 = new Integer(0);
            Enumeration enumeration = this.collectionConnections.elements();
            while (enumeration.hasMoreElements()) {
                CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
                Vector vector = this.getStandardPreferences(collectionConnection.tci);
                boolean bl2 = false;
                hashtable2 = hashtable;
                hashtable = new Hashtable();
                for (int i = 0; i < vector.size(); ++i) {
                    string2 = (String)vector.get(i);
                    if (!hashtable2.containsKey(string2) && !bl) continue;
                    bl2 = true;
                    if (bl) {
                        int n4 = n - i;
                        hashtable.put(string2, new Integer(n4));
                        if (n4 <= n2) continue;
                        n2 = new Integer(n4);
                        string = string2;
                        continue;
                    }
                    Integer n5 = (Integer)hashtable2.get(string2);
                    int n6 = n5 + (n - i);
                    hashtable.put(string2, new Integer(n6));
                    if (n6 <= n2 && vector.contains(string)) continue;
                    n2 = new Integer(n6);
                    string = string2;
                }
                bl = false;
                if (bl2) continue;
                InsightSmartClient.debugOut("Can not reach a standard preferences agreement for server " + collectionConnection.tci.getCollectionName() + " " + collectionConnection.tci.toKeyString() + ". Returning common standard null.");
                string = null;
                break;
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getCommonStandard():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return string;
    }

    public Vector getFieldList(String string) {
        InsightSmartClient.debugOut("Getting field list.");
        InsightSmartClient.debugOut("Standard selected for cross-collection use: " + string, 2);
        Vector<FieldListResult> vector = new Vector<FieldListResult>();
        boolean bl = true;
        try {
            Enumeration enumeration = this.collectionConnections.elements();
            while (enumeration.hasMoreElements()) {
                CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
                InsightRequest insightRequest = InsightRequest.newRequest(15, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("STANDARD_NAME", string);
                insightRequest.addBooleanParam("INCLUDE_STANDARD_LIST", bl);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(1, WAIT_LIMIT * 5L, collectionConnection) > 0) {
                    int n;
                    Serializable serializable;
                    FieldListResult fieldListResult = null;
                    FieldListResult fieldListResult2 = null;
                    FieldListResult fieldListResult3 = null;
                    if (bl) {
                        fieldListResult = (FieldListResult)collectionConnection.ois.readObject();
                        fieldListResult2 = InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(3, 50, 0), 7) ? (FieldListResult)collectionConnection.ois.readObject() : new FieldListResult(fieldListResult.getStandardName(), new Vector());
                    } else {
                        fieldListResult3 = (FieldListResult)collectionConnection.ois.readObject();
                    }
                    FieldListResult fieldListResult4 = (FieldListResult)collectionConnection.ois.readObject();
                    if (bl) {
                        FieldMapping fieldMapping;
                        int n2;
                        FieldListResult fieldListResult5;
                        int n3;
                        serializable = null;
                        for (n3 = 0; n3 < vector.size(); ++n3) {
                            InsightSmartClient.debugOut("Checking to see if fieldListResults contains FLR.");
                            fieldListResult5 = (FieldListResult)vector.get(n3);
                            if (fieldListResult5.standardName == null || fieldListResult.standardName == null || !fieldListResult5.standardName.equals(fieldListResult.standardName)) continue;
                            serializable = fieldListResult5;
                            break;
                        }
                        if (serializable != null) {
                            for (n2 = 0; n2 < fieldListResult.fieldMappings.size(); ++n2) {
                                FieldMapping fieldMapping2 = (FieldMapping)fieldListResult.fieldMappings.get(n2);
                                n = ((FieldListResult)serializable).fieldMappings.indexOf(fieldMapping2);
                                if (n > -1) {
                                    fieldMapping = (FieldMapping)((FieldListResult)serializable).fieldMappings.get(n);
                                    if (fieldMapping2.finalFieldCount > 0) {
                                        ++fieldMapping.referenceCount;
                                    }
                                    if (fieldMapping.hierarchyMode <= Field.HIERARCHY_MODE_NONE || fieldMapping2.hierarchyMode >= Field.HIERARCHY_MODE_CURRENT_ONLY && fieldMapping2.hierarchyName.equals(fieldMapping.hierarchyName)) continue;
                                    fieldMapping.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                                    fieldMapping.hierarchyName = "";
                                    continue;
                                }
                                InsightSmartClient.debugOut("WARNING: The existing FLR " + ((FieldListResult)serializable).standardName + " does not contain field mapping: " + fieldMapping2.display() + ". This means that the list of standard fields returned by the first collection did not include this field mapping.", 3);
                            }
                        } else {
                            for (n = 0; n < fieldListResult.fieldMappings.size(); ++n) {
                                FieldMapping fieldMapping3 = (FieldMapping)fieldListResult.fieldMappings.get(n);
                                if (fieldMapping3.finalFieldCount <= 0) continue;
                                ++fieldMapping3.referenceCount;
                            }
                            vector.add(fieldListResult);
                        }
                        serializable = null;
                        for (n3 = 0; n3 < vector.size(); ++n3) {
                            fieldListResult5 = (FieldListResult)vector.get(n3);
                            if (fieldListResult5.standardName == null || fieldListResult2.standardName == null || !fieldListResult5.standardName.equals(fieldListResult2.standardName)) continue;
                            serializable = fieldListResult5;
                            break;
                        }
                        if (serializable != null) {
                            for (n2 = 0; n2 < fieldListResult2.fieldMappings.size(); ++n2) {
                                FieldMapping fieldMapping4 = (FieldMapping)fieldListResult2.fieldMappings.get(n2);
                                n = ((FieldListResult)serializable).getFieldMappings().indexOf(fieldMapping4);
                                if (n > -1) {
                                    fieldMapping = (FieldMapping)((FieldListResult)serializable).fieldMappings.get(n);
                                    if (!(fieldMapping4 instanceof LinkFieldMapping) && fieldMapping4.finalFieldCount <= 0) continue;
                                    ++fieldMapping.referenceCount;
                                    continue;
                                }
                                InsightSmartClient.debugOut("WARNING: The existing FLR " + ((FieldListResult)serializable).standardName + " does not contain field mapping: " + fieldMapping4.display() + ". This means that the list of standard fields returned by the first collection did not include this field mapping.", 3);
                            }
                        } else {
                            for (n = 0; n < fieldListResult2.fieldMappings.size(); ++n) {
                                FieldMapping fieldMapping5 = (FieldMapping)fieldListResult2.fieldMappings.get(n);
                                if (!(fieldMapping5 instanceof LinkFieldMapping) && fieldMapping5.finalFieldCount <= 0) continue;
                                ++fieldMapping5.referenceCount;
                            }
                            vector.add(fieldListResult2);
                        }
                    } else if (fieldListResult3 != null && fieldListResult3.fieldMappings != null && fieldListResult3.fieldMappings.size() > 0 && fieldListResult3.standardName != null) {
                        serializable = ((FieldListResult)vector.get((int)0)).fieldMappings;
                        Vector vector2 = fieldListResult3.fieldMappings;
                        if (fieldListResult3.standardName.equals(((FieldListResult)vector.get((int)0)).standardName)) {
                            for (n = 0; n < ((Vector)serializable).size(); ++n) {
                                FieldMapping fieldMapping = (FieldMapping)((Vector)serializable).get(n);
                                if (fieldMapping.hierarchyMode <= Field.HIERARCHY_MODE_NONE || vector2.contains(fieldMapping)) continue;
                                fieldMapping.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                                fieldMapping.hierarchyName = "";
                            }
                        }
                    }
                    if (fieldListResult4 != null && fieldListResult4.fieldMappings != null && !fieldListResult4.fieldMappings.isEmpty()) {
                        for (int i = 0; i < fieldListResult4.fieldMappings.size(); ++i) {
                            serializable = (FieldMapping)fieldListResult4.fieldMappings.get(i);
                            if (((FieldMapping)serializable).finalFieldCount <= 0) continue;
                            ++((FieldMapping)serializable).referenceCount;
                        }
                        vector.add(fieldListResult4);
                    }
                } else {
                    InsightSmartClient.debugOut("Did not receive field list from server.", 2);
                }
                if (!ASSUME_SYNCHRONIZED_FIELD_STANDARDS) continue;
                bl = false;
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getFieldList():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return vector;
    }

    public String getArtistStory(String string) {
        InsightSmartClient.debugOut("In getArtistStory.");
        String string2 = "Error retreiving artist information.";
        try {
            Enumeration enumeration = this.collectionConnections.elements();
            while (enumeration.hasMoreElements()) {
                CollectionConnection collectionConnection = (CollectionConnection)enumeration.nextElement();
                InsightRequest insightRequest = InsightRequest.newRequest(16, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("ARTIST_NAME", string);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) <= 0) continue;
                string2 = (String)collectionConnection.ois.readObject();
                InsightSmartClient.debugOut("Done receiving data.");
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getArtistStory().", 2);
        }
        return string2;
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, Vector vector, ResultsControllerInterface resultsControllerInterface) {
        return this.getUniqueList(fieldMapping, vector, 0, null, -1, resultsControllerInterface);
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, Vector vector, int n, ResultsControllerInterface resultsControllerInterface) {
        return this.getUniqueList(fieldMapping, vector, 0, null, n, resultsControllerInterface, null);
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, Vector vector, int n, ResultsControllerInterface resultsControllerInterface, Vector vector2) {
        return this.getUniqueList(fieldMapping, vector, n, resultsControllerInterface, vector2, false);
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, Vector vector, int n, ResultsControllerInterface resultsControllerInterface, Vector vector2, boolean bl) {
        return this.getUniqueList(fieldMapping, vector, 0, null, n, resultsControllerInterface, vector2, bl);
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, Vector vector, int n, String string, int n2, ResultsControllerInterface resultsControllerInterface) {
        return this.getUniqueList(fieldMapping, vector, n, string, n2, resultsControllerInterface, null);
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, Vector vector, int n, String string, int n2, ResultsControllerInterface resultsControllerInterface, Vector vector2) {
        return this.getUniqueList(fieldMapping, vector, n, string, n2, resultsControllerInterface, vector2, false);
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, Vector vector, int n, String string, int n2, ResultsControllerInterface resultsControllerInterface, Vector vector2, boolean bl) {
        InsightSmartClient.debugOut("Get unique list: " + fieldMapping);
        InsightSmartClient.debugOut("relationship  is " + n);
        InsightSmartClient.debugOut("comparator is " + string);
        InsightSmartClient.debugOut("threshold is " + n2);
        InsightSmartClient.debugOut("fieldName.fieldType is " + fieldMapping.fieldType);
        InsightSmartClient.debugOut("About to to to UniqueListResultCollector");
        UniqueListResultCollector uniqueListResultCollector = new UniqueListResultCollector(n, string, n2, fieldMapping.fieldType);
        try {
            Object object;
            ResultsProgressListener resultsProgressListener;
            Object object2;
            if (InsightUtilities.isEmpty(vector)) {
                object2 = (CollectionConnection)this.collectionConnections.get(0);
                if (object2 != null) {
                    resultsProgressListener = null;
                    object = new UniqueListGetter(fieldMapping, resultsProgressListener, n, string, n2, uniqueListResultCollector, (CollectionConnection)object2, this, vector2, bl);
                    ((Thread)object).start();
                } else {
                    InsightSmartClient.debugOut("Could not find correct CollectionConnection.");
                }
            } else {
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    resultsProgressListener = (ResultsProgressListener)object2.nextElement();
                    object = null;
                    InsightSmartClient.debugOut("Did it get past the ResultsProgressListener?");
                    Object object3 = this.collectionConnections.elements();
                    while (object3.hasMoreElements()) {
                        InsightSmartClient.debugOut("Is it enumrating the collectionConnections?");
                        CollectionConnection collectionConnection = (CollectionConnection)object3.nextElement();
                        if (CollectionKeyDistributor.keysAgree(collectionConnection.tci, resultsProgressListener.getGroupInfo().getTci())) {
                            InsightSmartClient.debugOut("The keys agreed?");
                            object = collectionConnection;
                            break;
                        }
                        InsightSmartClient.debugOut("The keys did not agree");
                    }
                    InsightSmartClient.debugOut("Is cc null? " + object);
                    if (object != null) {
                        object3 = new UniqueListGetter(fieldMapping, resultsProgressListener, n, string, n2, uniqueListResultCollector, (CollectionConnection)object, this, vector2, bl);
                        ((Thread)object3).start();
                        continue;
                    }
                    InsightSmartClient.debugOut("Could not find correct CollectionConnection.");
                }
            }
            while (!uniqueListResultCollector.doneCollecting() && this.continueUniqueListRetrieval) {
                Thread.sleep(200L);
            }
            if (resultsControllerInterface != null) {
                resultsControllerInterface.allResultsGathered();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getUniqueList().", 2);
        }
        InsightSmartClient.debugOut("Returning from getUniqueList() [Time: " + System.currentTimeMillis() + "]");
        return uniqueListResultCollector.getResults();
    }

    public List getPresentationNames(String string, CollectionKey collectionKey) {
        return this.getPresentationNames(string, -1, collectionKey);
    }

    public List getPresentationNames(int n, CollectionKey collectionKey) {
        return this.getPresentationNames(null, n, collectionKey);
    }

    protected List getPresentationNames(String string, int n, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("in getPresentationNames().");
        List list = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            if (collectionConnection != null && InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(4, 0, 1), 7)) {
                InsightRequest insightRequest = InsightRequest.newRequest(149, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", n);
                insightRequest.addStringParam("GROUP_NAME", string);
                insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    list = (List)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getPresentationNames():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        if (list == null) {
            list = new Vector(0);
        }
        return list;
    }

    public ImageSeries getImageSeries(int n, String string, CollectionKey collectionKey) {
        return this.getImageSeries(null, n, string, collectionKey);
    }

    public ImageSeries getImageSeries(String string, String string2, CollectionKey collectionKey) {
        return this.getImageSeries(string, -1, string2, collectionKey);
    }

    protected ImageSeries getImageSeries(String string, int n, String string2, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Get image series: " + string2);
        ImageSeries imageSeries = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(30, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", n);
            insightRequest.addStringParam("GROUP_NAME", string);
            insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
            insightRequest.addStringParam("SERIES_NAME", string2);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                imageSeries = (ImageSeries)collectionConnection.ois.readObject();
            }
            if (imageSeries != null && imageSeries.getSlideVector() != null) {
                Vector vector = imageSeries.getSlideVector();
                for (int i = 0; i < vector.size(); ++i) {
                    ImageSeriesSlide imageSeriesSlide = (ImageSeriesSlide)vector.get(i);
                    imageSeriesSlide.setInstitutionID(collectionKey.getInstitutionID());
                    imageSeriesSlide.setCollectionID(collectionKey.getCollectionID());
                    imageSeriesSlide.setVCID(collectionKey.getVCID());
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getImageSeries():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return imageSeries;
    }

    public ImageSeries[] getImageSeriesList(String string, CollectionKey collectionKey) {
        return this.getImageSeriesList(string, -1, collectionKey);
    }

    public ImageSeries[] getImageSeriesList(int n, CollectionKey collectionKey) {
        return this.getImageSeriesList(null, n, collectionKey);
    }

    protected ImageSeries[] getImageSeriesList(String string, int n, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Get image series list.");
        ImageSeries[] imageSeriesArray = new ImageSeries[]{};
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            if (collectionConnection != null) {
                InsightRequest insightRequest = InsightRequest.newRequest(29, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", n);
                insightRequest.addStringParam("GROUP_NAME", string);
                insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                if (this.waitForInput(collectionConnection) > 0) {
                    int n2 = collectionConnection.ois.readInt();
                    imageSeriesArray = new ImageSeries[n2];
                    for (int i = 0; i < n2; ++i) {
                        imageSeriesArray[i] = (ImageSeries)collectionConnection.ois.readObject();
                    }
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getImageSeriesList():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return imageSeriesArray;
    }

    public boolean saveImageSeries(int n, ImageSeries imageSeries, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Save image series.");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(31, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", n);
            insightRequest.addObjectParam("IMAGE_SERIES", imageSeries);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in saveImageSeries():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return bl;
    }

    public void removeImageSeries(int n, String string, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("Remove image series " + string + ".");
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(39, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", n);
            insightRequest.addStringParam("SERIES_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in removeImageSeries():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
    }

    public MultiviewImageSeries getMultiviewImage(int n, long l, CollectionKey collectionKey) {
        Cloneable cloneable;
        MultiviewImageSeries multiviewImageSeries = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            cloneable = InsightRequest.newRequest(59, collectionConnection.tci, this.getLocalAddress());
            ((InsightRequest)cloneable).addIntegerParam("GROUP_ID", n);
            ((InsightRequest)cloneable).addLongParam("MEDIA_ID", l);
            collectionConnection.oos.writeObject(cloneable);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                multiviewImageSeries = (MultiviewImageSeries)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getMultiviewImage():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        if (multiviewImageSeries != null && multiviewImageSeries.getSlides() != null) {
            for (int i = 0; i < multiviewImageSeries.getSlides().size(); ++i) {
                cloneable = (MultiviewImageSlide)multiviewImageSeries.getSlides().get(i);
                if (((MultiviewImageSlide)cloneable).getInstitutionID() != null) continue;
                ((MultiviewImageSlide)cloneable).setInstitutionID(collectionKey.getInstitutionID());
            }
        }
        return multiviewImageSeries;
    }

    public Vector getMultiviewImages(int n, CollectionKey collectionKey) {
        Cloneable cloneable;
        Vector vector = new Vector(0);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            cloneable = InsightRequest.newRequest(74, collectionConnection.tci, this.getLocalAddress());
            ((InsightRequest)cloneable).addIntegerParam("GROUP_ID", n);
            collectionConnection.oos.writeObject(cloneable);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                vector = (Vector)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getMultiviewImages().", 2);
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                cloneable = (MultiviewImageSeries)vector.get(i);
                for (int j = 0; j < ((MultiviewImageSeries)cloneable).getSlides().size(); ++j) {
                    MultiviewImageSlide multiviewImageSlide = (MultiviewImageSlide)((MultiviewImageSeries)cloneable).getSlides().get(j);
                    if (multiviewImageSlide.getInstitutionID() != null) continue;
                    multiviewImageSlide.setInstitutionID(collectionKey.getInstitutionID());
                }
            }
        }
        return vector;
    }

    public boolean saveMultiviewImage(MultiviewImageSeries multiviewImageSeries) {
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(multiviewImageSeries);
            InsightRequest insightRequest = InsightRequest.newRequest(60, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("MVI_SERIES", multiviewImageSeries);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in saveMultiviewImage().", 2);
        }
        return bl;
    }

    public boolean setMultiviewImage(MultiviewImageSeries multiviewImageSeries, boolean bl) {
        boolean bl2 = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(multiviewImageSeries);
            InsightRequest insightRequest = InsightRequest.newRequest(76, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", multiviewImageSeries.getGroupID());
            insightRequest.addLongParam("OBJECT_ID", multiviewImageSeries.getObjectID());
            insightRequest.addLongParam("MEDIA_ID", multiviewImageSeries.getImageID());
            insightRequest.addBooleanParam("HAS_MVI", bl);
            insightRequest.addCollectionKeyParam(multiviewImageSeries);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl2 = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in setMultiviewImage().", 2);
        }
        return bl2;
    }

    public boolean removeMultiviewImage(int n, long l, long l2, CollectionKey collectionKey) {
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(61, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", n);
            insightRequest.addLongParam("OBJECT_ID", l);
            insightRequest.addLongParam("MEDIA_ID", l2);
            insightRequest.addCollectionKeyParam(collectionConnection.tci);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in deleteMultiviewImage().", 2);
        }
        return bl;
    }

    public boolean groupHasMultiviewImages(Vector vector) {
        boolean bl = false;
        try {
            for (int i = 0; i < vector.size(); ++i) {
                GroupInformation groupInformation = (GroupInformation)vector.get(i);
                CollectionConnection collectionConnection = this.getCollectionConnection(groupInformation.getTci());
                InsightRequest insightRequest = InsightRequest.newRequest(63, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", groupInformation.getGroupID());
                insightRequest.addIntegerParam("PROFILE_ID", groupInformation.getTci().getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", groupInformation.getTci().getUserCollection());
                insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) <= 0 || !collectionConnection.ois.readBoolean()) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in groupHasMultiviewImages(): " + exception, 2);
        }
        return bl;
    }

    public boolean groupHasMultipageDocuments(Vector vector) {
        boolean bl = false;
        try {
            for (int i = 0; i < vector.size(); ++i) {
                GroupInformation groupInformation = (GroupInformation)vector.get(i);
                CollectionConnection collectionConnection = this.getCollectionConnection(groupInformation.getTci());
                InsightRequest insightRequest = InsightRequest.newRequest(86, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", groupInformation.getGroupID());
                insightRequest.addIntegerParam("PROFILE_ID", groupInformation.getTci().getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", groupInformation.getTci().getUserCollection());
                insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) <= 0 || !collectionConnection.ois.readBoolean()) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in groupHasMultipageDocuments(): " + exception, 2);
        }
        return bl;
    }

    public boolean groupContainsAudio(Vector vector) {
        return this.groupContainsMediaType(2, vector);
    }

    public boolean groupContainsVideo(Vector vector) {
        return this.groupContainsMediaType(3, vector);
    }

    public boolean groupContainsQtvr(Vector vector) {
        return this.groupContainsMediaType(4, vector);
    }

    public boolean groupContainsMisc(Vector vector) {
        return this.groupContainsMediaType(5, vector);
    }

    public boolean groupContainsMediaType(int n, Vector vector) {
        boolean bl = false;
        try {
            for (int i = 0; i < vector.size(); ++i) {
                GroupInformation groupInformation = (GroupInformation)vector.get(i);
                CollectionConnection collectionConnection = this.getCollectionConnection(groupInformation.getTci());
                InsightRequest insightRequest = InsightRequest.newRequest(81, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("MEDIA_TYPE", n);
                insightRequest.addIntegerParam("GROUP_ID", groupInformation.getGroupID());
                insightRequest.addIntegerParam("PROFILE_ID", groupInformation.getTci().getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", groupInformation.getTci().getUserCollection());
                insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) <= 0 || !collectionConnection.ois.readBoolean()) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in groupContainsMediaType(): " + exception, 2);
        }
        return bl;
    }

    public Vector getLinks(CollectionKey collectionKey, long l, Vector vector) {
        Vector<LinkData> vector2 = new Vector<LinkData>();
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(64, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(collectionKey);
            insightRequest.addObjectParam("USER_GROUP_SHELLS", vector);
            insightRequest.addLongParam("MEDIA_ID", l);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            Vector vector3 = new Vector();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                vector3 = (Vector)collectionConnection.ois.readObject();
            }
            for (int i = 0; i < vector3.size(); ++i) {
                LinkData linkData = (LinkData)vector3.get(i);
                if (linkData instanceof ImageLinkData) {
                    if (!this.isConnectionGood(new CollectionKeyWrapper(((ImageLinkData)linkData).getLinkedImageInstitutionID(), ((ImageLinkData)linkData).getLinkedImageCollectionID(), ((ImageLinkData)linkData).getLinkedImageVCID()))) continue;
                    vector2.add(linkData);
                    continue;
                }
                vector2.add(linkData);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getLinks(): " + exception, 2);
        }
        return vector2;
    }

    public boolean saveLink(LinkData linkData) {
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(linkData);
            InsightRequest insightRequest = InsightRequest.newRequest(65, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("LINK_DATA", linkData);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in saveLink(): " + exception, 2);
        }
        return bl;
    }

    public boolean removeLink(LinkData linkData) {
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(linkData);
            InsightRequest insightRequest = InsightRequest.newRequest(66, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(linkData);
            insightRequest.addStringParam("LINK_GROUP_NAME", linkData.getGroupName());
            insightRequest.addStringParam("LINK_GROUP_CODE_KEY", linkData.getGroupCodeKey());
            insightRequest.addLongParam("LINK_MEDIA_ID", linkData.getImageID());
            insightRequest.addObjectParam("LINK_REGION", linkData.getRegion());
            insightRequest.addIntegerParam("LINK_SAVE_LOCATION", linkData.getSaveLocation());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in removeLink(): " + exception, 2);
        }
        return bl;
    }

    public boolean hasLinkCode(CollectionKey collectionKey, String string) {
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(88, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(collectionKey);
            insightRequest.addStringParam("LINK_CODE", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in hasLinkCode():\n" + InsightUtilities.convertStackTraceToString(exception), 2);
        }
        return bl;
    }

    public boolean publishLinks(CollectionKey collectionKey, Vector vector, String string) {
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(89, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("LINKS", vector);
            insightRequest.addStringParam("LINK_CODE", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in publishLinks():\n" + InsightUtilities.convertStackTraceToString(exception), 2);
            bl = false;
        }
        return bl;
    }

    public boolean unpublishLinks(CollectionKey collectionKey, Vector vector, String string) {
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(90, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("LINKS", vector);
            insightRequest.addStringParam("LINK_CODE", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in unpublishLinks():\n" + InsightUtilities.convertStackTraceToString(exception), 2);
            bl = false;
        }
        return bl;
    }

    public List getVirtualCollectionGroupList(CollectionKey collectionKey) {
        InsightSmartClient.debugOut("in getVirtualCollectionGroupList.");
        List list = new ArrayList();
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(12, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("VCID", collectionKey.getVCID());
            insightRequest.addBooleanParam("VC_GROUPS_ONLY", true);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                list = (List)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getVirtualCollectionGroupList().", 2);
        }
        return list;
    }

    public String[] getGroupList(CollectionKey collectionKey, MutableObject mutableObject) {
        InsightSmartClient.debugOut("Get group list.");
        String[] stringArray = new String[]{};
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(12, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("VCID", collectionKey.getVCID());
            insightRequest.addBooleanParam("VC_GROUPS_ONLY", false);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                int n = collectionConnection.ois.readInt();
                stringArray = new String[n];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)collectionConnection.ois.readObject();
                    InsightSmartClient.debugOut("Received: " + stringArray[i]);
                }
                if (InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(4, 0, 1), 7)) {
                    Map map = (Map)collectionConnection.ois.readObject();
                    if (mutableObject != null) {
                        mutableObject.setValue(map);
                    }
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getGroupList().", 2);
        }
        return stringArray;
    }

    public List getCollectionNames() {
        InsightSmartClient.debugOut("in getCollectionNames");
        List list = null;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            if (collectionConnection == null) {
                InsightSmartClient.debugOut("No collection connection.");
                return null;
            }
            InsightRequest insightRequest = InsightRequest.newRequest(13, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            if (this.waitForInput(collectionConnection) > 0) {
                list = (List)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getCollectionNames(key):\n" + InsightUtilities.getStackTrace(exception));
            list = null;
        }
        return list;
    }

    public String[] getCollectionList() {
        return null;
    }

    public String[] getCollectionList(CollectionKey collectionKey) {
        return null;
    }

    public ObjectDimension getObjectDimension(long l, CollectionKey collectionKey) {
        ObjectDimension objectDimension = new ObjectDimension();
        ObjectDimension objectDimension2 = new ObjectDimension();
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightSmartClient.debugOut("Getting object dimension for image " + l);
            InsightRequest insightRequest = InsightRequest.newRequest(67, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("MEDIA_ID", l);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                objectDimension2 = (ObjectDimension)collectionConnection.ois.readObject();
                if (objectDimension2 != null) {
                    objectDimension = objectDimension2;
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getObjectDimension(): " + exception, 2);
        }
        return objectDimension;
    }

    public Vector getFullInformation(long l, CollectionKey collectionKey) {
        return this.getFullInformation(l, collectionKey, null);
    }

    public Vector getFullInformation(long l, CollectionKey collectionKey, String string) {
        Vector vector = new Vector(0);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightSmartClient.debugOut("Getting full information for image " + l);
            InsightRequest insightRequest = InsightRequest.newRequest(3, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("OBJECT_ID", l);
            insightRequest.addBooleanParam("USING_STANDARD_NAME", string != null);
            insightRequest.addStringParam("STANDARD_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                vector = (Vector)collectionConnection.ois.readObject();
                Field field = new Field();
                field.fieldDisplayName = "Collection";
                field.fieldName = "Collection";
                field.stringType = 2;
                InsightSmartClient.debugOut("Collection Name: " + collectionConnection.tci.collectionName);
                FieldValue fieldValue = new FieldValue(field, collectionConnection.tci.collectionName);
                vector.insertElementAt(fieldValue, 0);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getFullInformation(): " + exception, 2);
        }
        return vector;
    }

    public ObjectDataRecord getFullObjectData(long l, CollectionKey collectionKey) {
        return this.getFullObjectData(l, collectionKey, null);
    }

    public ObjectDataRecord getFullObjectData(long l, CollectionKey collectionKey, String string) {
        Vector vector = new Vector(0);
        ObjectDataRecord objectDataRecord = null;
        FieldValue fieldValue = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightSmartClient.debugOut("Getting full object data for object:" + l + ", standardName: " + string);
            InsightRequest insightRequest = InsightRequest.newRequest(115, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("OBJECT_ID", l);
            insightRequest.addBooleanParam("USING_STANDARD_NAME", string != null);
            insightRequest.addStringParam("STANDARD_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                objectDataRecord = (ObjectDataRecord)collectionConnection.ois.readObject();
                Field field = new Field();
                field.fieldDisplayName = "Collection";
                field.fieldName = "Collection";
                field.stringType = 2;
                InsightSmartClient.debugOut("Collection Name: " + collectionConnection.tci.collectionName);
                fieldValue = new FieldValue(field, collectionConnection.tci.collectionName);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getFullInformation(): " + exception, 2);
        }
        return objectDataRecord;
    }

    public MediaMetaData getFullMediaData(long l, CollectionKey collectionKey, int n) {
        MediaMetaData mediaMetaData = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightSmartClient.debugOut("Getting full information for image " + l);
            InsightRequest insightRequest = InsightRequest.newRequest(116, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("MEDIA_ID", l);
            insightRequest.addIntegerParam("RESOLUTION", n);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                mediaMetaData = (MediaMetaData)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getFullMediaData(): " + exception, 2);
        }
        return mediaMetaData;
    }

    public String getSingleURL(long l, int n, CollectionKey collectionKey, boolean bl) {
        String string = new String("");
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightSmartClient.debugOut("Getting a single URL for " + l + " at resolution " + n + ".");
            InsightRequest insightRequest = InsightRequest.newRequest(4, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
            insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
            insightRequest.addBooleanParam("EXCLUDE_SPS", false);
            insightRequest.addBooleanParam("IS_OBJECT_ID", bl);
            insightRequest.addLongParam("MEDIA_ID", l);
            insightRequest.addIntegerParam("RESOLUTION", n);
            insightRequest.addStringParam("INSTITUTION_ID", collectionConnection.tci.getInstitutionID());
            insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                string = (String)collectionConnection.ois.readObject();
                InsightSmartClient.debugOut("URL: " + string);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getSingleURL().", 2);
        }
        return string;
    }

    public Object[] getURLs(long l, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("in getURLS");
        Object[] objectArray = new Object[]{};
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightSmartClient.debugOut("Getting URLs for " + l + " with profile " + collectionConnection.tci.getProfileID() + ".");
            InsightRequest insightRequest = InsightRequest.newRequest(17, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
            insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
            insightRequest.addBooleanParam("EXCLUDE_SPS", false);
            insightRequest.addLongParam("MEDIA_ID", l);
            insightRequest.addStringParam("INSTITUTION_ID", collectionConnection.tci.getInstitutionID());
            insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                int n = collectionConnection.ois.readInt();
                objectArray = new Object[n];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = collectionConnection.ois.readObject();
                    InsightSmartClient.debugOut("Received: " + objectArray[i]);
                }
            } else {
                InsightSmartClient.debugOut("waitForInput in getURLs aborted.");
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getURLs().", 2);
        }
        return objectArray;
    }

    public Object[] getMediaURL(long l, CollectionKey collectionKey, int n) {
        InsightSmartClient.debugOut("in getMediaURL");
        Object[] objectArray = new Object[3];
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightSmartClient.debugOut("Getting Source URL for " + l + " with profile " + collectionConnection.tci.getProfileID() + ".");
            InsightRequest insightRequest = InsightRequest.newRequest(189, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
            insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
            insightRequest.addBooleanParam("EXCLUDE_SPS", false);
            insightRequest.addLongParam("MEDIA_ID", l);
            insightRequest.addIntegerParam("RESOLUTION", n);
            insightRequest.addStringParam("INSTITUTION_ID", collectionConnection.tci.getInstitutionID());
            insightRequest.addStringParam("VCID", collectionConnection.tci.getVCID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                objectArray[0] = collectionConnection.ois.readObject();
                objectArray[1] = collectionConnection.ois.readObject();
                objectArray[2] = collectionConnection.ois.readObject();
                InsightSmartClient.debugOut("getMediaURL: Source URL: " + objectArray[0]);
                InsightSmartClient.debugOut("getMediaURL: Source File Name: " + objectArray[1]);
                InsightSmartClient.debugOut("getMediaURL: Resolution: " + objectArray[2]);
            } else {
                InsightSmartClient.debugOut("waitForInput in getURLs aborted.");
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getURLs().", 2);
        }
        return objectArray;
    }

    public VirtualCollectionInfo getVirtualCollectionInfo(VirtualCollectionInfo virtualCollectionInfo, CollectionKey collectionKey) {
        return null;
    }

    public Vector getDescriptionData(TrinityCollectionInfo trinityCollectionInfo) {
        Vector vector = null;
        try {
            InsightSmartClient.debugOut("Getting collection description data for [InstID: " + trinityCollectionInfo.getInstitutionID() + ", CollID: " + trinityCollectionInfo.getCollectionID() + ", VCID: " + trinityCollectionInfo.getVCID() + "].");
            CollectionConnection collectionConnection = this.getCollectionConnection(trinityCollectionInfo);
            InsightRequest insightRequest = InsightRequest.newRequest(41, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(trinityCollectionInfo);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                boolean bl = collectionConnection.ois.readBoolean();
                if (bl) {
                    vector = (Vector)collectionConnection.ois.readObject();
                } else {
                    InsightSmartClient.debugOut("Description data not found for collection " + trinityCollectionInfo.getCollectionID(), 2);
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getDescriptionData().", 2);
        }
        return vector;
    }

    public TrinityCollectionInfo getConfigurationInfo(TrinityCollectionInfo trinityCollectionInfo, String string) {
        TrinityCollectionInfo trinityCollectionInfo2 = trinityCollectionInfo;
        VirtualCollectionInfo virtualCollectionInfo = trinityCollectionInfo.getVCIReference();
        try {
            int n;
            Object object;
            InsightSmartClient.debugOut("Getting configuration info for " + trinityCollectionInfo.getCollectionName() + ".");
            CollectionConnection collectionConnection = this.getCollectionConnection(trinityCollectionInfo);
            trinityCollectionInfo.clearVCIReference();
            InsightRequest insightRequest = InsightRequest.newRequest(36, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("COLLECTION_INFO", trinityCollectionInfo);
            insightRequest.addStringParam("STANDARD_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            trinityCollectionInfo.setVirtualCollection(virtualCollectionInfo);
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                object = trinityCollectionInfo2.getContextMap();
                trinityCollectionInfo2 = (TrinityCollectionInfo)collectionConnection.ois.readObject();
                ((TrinityCollectionInfo.ContextMap)object).putAll((Map)trinityCollectionInfo2.getContextMap());
                trinityCollectionInfo2.setContextMap((TrinityCollectionInfo.ContextMap)object);
                collectionConnection.tci = trinityCollectionInfo2;
                if (!trinityCollectionInfo2.isInfoComplete()) {
                    InsightSmartClient.debugOut("Configuration information not retreived properly.");
                }
            }
            InsightSmartClient.debugOut("Getting user privs for profile " + trinityCollectionInfo2.getProfileID() + ", user collection " + trinityCollectionInfo2.getUserCollection());
            object = new int[20];
            for (n = 0; n < ((Object)object).length; ++n) {
                object[n] = false;
            }
            insightRequest = InsightRequest.newRequest(18, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("PROFILE_ID", trinityCollectionInfo2.getProfileID());
            insightRequest.addIntegerParam("USER_COLLECTION", trinityCollectionInfo2.getUserCollection());
            insightRequest.addBooleanParam("EXCLUDE_SPS", false);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(1, WAIT_LIMIT * 5L, collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                object = (int[])collectionConnection.ois.readObject();
            } else {
                InsightSmartClient.debugOut("Did not receive privs from server.", 2);
            }
            if (object != null && ((Object)object).length >= 4) {
                trinityCollectionInfo2.exportMaxResolution = (int)object[0];
                trinityCollectionInfo2.printResolution = (int)object[1];
                trinityCollectionInfo2.objectEditorPriv = object[2] == true;
                boolean bl = trinityCollectionInfo2.vocabEditorPriv = object[3] == true;
            }
            if (object != null && ((Object)object).length >= 8) {
                trinityCollectionInfo2.maxViewableSize = (int)object[4];
                trinityCollectionInfo2.htmlExportPriv = object[5] == true;
                trinityCollectionInfo2.saveDBGroupsPriv = object[6] == true;
                boolean bl = trinityCollectionInfo2.deleteDBGroupsPriv = object[7] == true;
            }
            if (object != null && ((Object)object).length >= 9) {
                boolean bl = trinityCollectionInfo2.mviPriv = object[8] == true;
            }
            if (object != null && ((Object)object).length >= 10) {
                boolean bl = trinityCollectionInfo2.linkPriv = object[9] == true;
            }
            if (object != null && ((Object)object).length >= 11) {
                boolean bl = trinityCollectionInfo2.editMpdPriv = object[10] == true;
            }
            if (object != null && ((Object)object).length >= 12) {
                trinityCollectionInfo2.editPersonalCollections = object[11] == true;
            }
            trinityCollectionInfo2.presentationExportMaxResolution = object != null && ((Object)object).length >= 13 ? (int)object[12] : trinityCollectionInfo2.getDefaultPresentationExportMaxResolution();
            if (trinityCollectionInfo2.isPersonalCollection()) {
                n = trinityCollectionInfo2.getPcPermissions();
                boolean bl = PersonalCollection.hasPermissionSetting(n, 3);
                boolean bl2 = PersonalCollection.hasPermissionSetting(n, 5);
                trinityCollectionInfo2.objectEditorPriv = bl && bl2;
                trinityCollectionInfo2.vocabEditorPriv = bl && bl2;
                trinityCollectionInfo2.htmlExportPriv = bl;
                trinityCollectionInfo2.saveDBGroupsPriv = bl;
                trinityCollectionInfo2.deleteDBGroupsPriv = bl2;
                trinityCollectionInfo2.mviPriv = bl;
                trinityCollectionInfo2.linkPriv = bl;
                trinityCollectionInfo2.editMpdPriv = bl && bl2;
            }
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            hashtable.put("approval-level", new Integer(0));
            hashtable.put("mede-user-ID", new Integer(0));
            if (InsightVersion.compareVersions(trinityCollectionInfo2.serverVersion, new InsightVersion(5, 50, 0), 7)) {
                hashtable.put("permissions", new Integer(collectionConnection.ois.readInt()));
            } else {
                hashtable.put("permissions", new Integer(0));
            }
            trinityCollectionInfo2.setMedePrivileges(new MedePrivileges(hashtable));
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getConfigurationInfo():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        trinityCollectionInfo2.setVirtualCollection(virtualCollectionInfo);
        return trinityCollectionInfo2;
    }

    public void updateConfigurationInfo(TrinityCollectionInfo trinityCollectionInfo, String string) {
        try {
            InsightSmartClient.debugOut("Updating configuration info for " + trinityCollectionInfo.getCollectionName() + ".");
            CollectionConnection collectionConnection = this.getCollectionConnection(trinityCollectionInfo);
            InsightRequest insightRequest = InsightRequest.newRequest(75, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(trinityCollectionInfo);
            insightRequest.addStringParam("STANDARD_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                Vector vector = (Vector)collectionConnection.ois.readObject();
                Vector vector2 = (Vector)collectionConnection.ois.readObject();
                Vector vector3 = (Vector)collectionConnection.ois.readObject();
                trinityCollectionInfo.dataFieldMappings = vector;
                trinityCollectionInfo.sortFieldMappings = vector2;
                trinityCollectionInfo.setSearchCriteria(vector3);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in updateConfigurationInfo()" + exception + ".");
        }
    }

    public boolean rebuildFsmAndThumbCache(boolean bl, MutableBoolean mutableBoolean) {
        InsightSmartClient.debugOut("in rebuildFsmAndThumbCache().");
        boolean bl2 = false;
        try {
            CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
            InsightRequest insightRequest = InsightRequest.newRequest(126, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addBooleanParam("WAIT_FOR_SERVER", bl);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            boolean bl3 = false;
            if (bl) {
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    bl2 = collectionConnection.ois.readBoolean();
                    bl3 = collectionConnection.ois.readBoolean();
                }
            } else if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl2 = collectionConnection.ois.readBoolean();
                bl3 = collectionConnection.ois.readBoolean();
            }
            if (mutableBoolean != null) {
                mutableBoolean.setValue(bl3);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in rebuildFsmAndThumbCache():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl2;
    }

    public void setServerFSMAndThumbCache(InsightTransientPackager insightTransientPackager, InsightTransientPackager insightTransientPackager2, boolean bl) {
        InsightSmartClient.debugOut("in setServerFSMAndThumbCache(). DEPRECATED");
    }

    public MultipageDocumentSeries getMultipageDocument(ObjectKey objectKey) {
        InsightSmartClient.debugOut("Getting MPD " + objectKey.toKeyString() + ".");
        MultipageDocumentSeries multipageDocumentSeries = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(objectKey);
            InsightRequest insightRequest = InsightRequest.newRequest(85, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("OBJECT_ID", objectKey.getObjectID());
            insightRequest.addLongParam("MEDIA_ID", objectKey.getImageID());
            insightRequest.addCollectionKeyParam(objectKey);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                multipageDocumentSeries = (MultipageDocumentSeries)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getMultipageDocument(): " + exception, 2);
        }
        return multipageDocumentSeries;
    }

    public boolean saveMultipageDocuments(MultipageDocumentSeries multipageDocumentSeries) {
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(multipageDocumentSeries);
            InsightRequest insightRequest = InsightRequest.newRequest(91, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("MPD_SERIES", multipageDocumentSeries);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                bl = collectionConnection.ois.readBoolean();
                InsightSmartClient.debugOut("saved is " + bl);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in saveMultipageDocument().", 2);
        }
        return bl;
    }

    public MpdSearchResults searchMultipageDocument(String string, String string2) {
        InsightSmartClient.debugOut("In searchMultipageDocument().");
        MpdSearchResults mpdSearchResults = null;
        if (string2 != null && string != null) {
            try {
                InsightSmartClient.debugOut("Transmitting document ID: " + string + " and search value: '" + string2 + "'");
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(92, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("MPD_DOCUMENT_ID", string);
                insightRequest.addStringParam("MPD_DOCUMENT_SEARCH", string2);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    mpdSearchResults = (MpdSearchResults)collectionConnection.ois.readObject();
                    if (mpdSearchResults == null) {
                        InsightSmartClient.debugOut("Unable to search the multipage document.");
                    }
                }
            }
            catch (Exception exception) {
                InsightSmartClient.debugOut("Exception in searchMultipageDocument():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return mpdSearchResults;
    }

    public String getMediaTicket(CollectionKey collectionKey) {
        InsightSmartClient.debugOut("in getMediaTicket().");
        String string = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(123, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
            insightRequest.addIntegerParam("USER_COLLECTION", collectionConnection.tci.getUserCollection());
            insightRequest.addBooleanParam("EXCLUDE_SPS", false);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                string = (String)collectionConnection.ois.readObject();
            }
            collectionConnection.tci.setMediaTicket(string);
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getMediaTicket():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return string;
    }

    public FieldCriterion getFuzzyDateConversion(FieldCriterion fieldCriterion, String string) {
        FieldCriterion fieldCriterion2 = null;
        try {
            InsightSmartClient.debugOut("Converting fuzzy date: " + string + ".");
            CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
            InsightRequest insightRequest = InsightRequest.newRequest(42, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("FUZZY_DATE", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                FuzzyDateJulianRange fuzzyDateJulianRange = (FuzzyDateJulianRange)collectionConnection.ois.readObject();
                if (fuzzyDateJulianRange != null) {
                    if (fieldCriterion instanceof LinkFieldCriterion) {
                        fieldCriterion2 = fieldCriterion;
                        ((LinkFieldCriterion)fieldCriterion2).setFuzzyDateJulianRange(fuzzyDateJulianRange);
                    } else {
                        fieldCriterion2 = new FuzzyDateFieldCriterion(fieldCriterion.booleanOperator, fuzzyDateJulianRange);
                        fieldCriterion2.fieldMapping = fieldCriterion.fieldMapping;
                    }
                } else {
                    InsightSmartClient.debugOut("Unable to convert '" + string + "'.");
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getFuzzyDateConversion():\n" + InsightUtilities.getStackTrace(exception));
        }
        return fieldCriterion2;
    }

    public Vector getTopLevelNodes(String string) {
        Vector vector = null;
        try {
            InsightSmartClient.debugOut("Getting top level nodes.");
            CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
            InsightRequest insightRequest = InsightRequest.newRequest(44, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("HIERARCHY_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                vector = (Vector)collectionConnection.ois.readObject();
                if (vector != null && vector.size() == 0) {
                    vector = null;
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getTopLevelNodes(): " + exception + ".", 2);
        }
        return vector;
    }

    public Vector doTreeChildSearch(HierarchyNodeData hierarchyNodeData) {
        Vector vector = null;
        try {
            InsightSmartClient.debugOut("Getting child nodes for node '" + hierarchyNodeData.getNodeName() + "'.");
            CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
            InsightRequest insightRequest = InsightRequest.newRequest(47, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("NODE_DATA", hierarchyNodeData);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                vector = (Vector)collectionConnection.ois.readObject();
                if (vector != null && vector.size() == 0) {
                    vector = null;
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in doTreeChildSearch(): " + exception + ".");
        }
        return vector;
    }

    public String[] getThesaurusList() {
        String[] stringArray = null;
        try {
            InsightSmartClient.debugOut("Getting thesaurus list.");
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(43, collectionConnection.tci, this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    int n = collectionConnection.ois.readInt();
                    if (n > 0) {
                        stringArray = new String[n];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = (String)collectionConnection.ois.readObject();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getThesaurusList(): " + exception + ".");
        }
        return stringArray;
    }

    public Vector doTermSearch(String string, String string2, int n, int n2) {
        Vector vector = null;
        try {
            InsightSmartClient.debugOut("Searching for term '" + string2 + "' in " + string + ".");
            CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
            InsightRequest insightRequest = InsightRequest.newRequest(45, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("THESAURUS_NAME", string);
            insightRequest.addStringParam("TERM", string2);
            insightRequest.addIntegerParam("START", n);
            insightRequest.addIntegerParam("LENGTH", n2);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                if (InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(3, 50, 0), 7)) {
                    collectionConnection.totalRecords = collectionConnection.ois.readInt();
                }
                if ((vector = (Vector)collectionConnection.ois.readObject()) == null) {
                    vector = new Vector(0);
                }
                if (!InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(3, 50, 0), 7)) {
                    collectionConnection.totalRecords = vector.size();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in doTermSearch():\n" + InsightUtilities.getStackTrace(exception));
        }
        return vector;
    }

    public int getJtipLevelCount(String string) {
        InsightSmartClient.debugOut("in getJtipLevelCount().");
        int n = 0;
        try {
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(51, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("MEDIA_ID", string);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    n = collectionConnection.ois.readInt();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getJtipLevelCount(): " + exception + ".");
        }
        return n;
    }

    public InsightJtipImage getJtipImage(long l, CollectionKey collectionKey, int n) {
        InsightSmartClient.debugOut("in getJtipImage().");
        InsightJtipImage insightJtipImage = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(49, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("MEDIA_ID", l);
            insightRequest.addIntegerParam("RESOLUTION", n);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                insightJtipImage = (InsightJtipImage)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getJtipImage(): " + exception + ".");
        }
        return insightJtipImage;
    }

    public Vector getJtipImages(long l) {
        InsightSmartClient.debugOut("in getJtipImages().");
        Vector vector = null;
        try {
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(50, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addLongParam("MEDIA_ID", l);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    vector = (Vector)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getJtipImages(): " + exception + ".");
        }
        return vector;
    }

    public Vector getJtipImageData(Vector vector, InsightJtipListener insightJtipListener) {
        InsightSmartClient.debugOut("in getJtipImageData().");
        Vector<InsightJtipTile> vector2 = new Vector<InsightJtipTile>();
        try {
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(52, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("TILES", vector);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    int n = collectionConnection.ois.readInt();
                    int n2 = collectionConnection.ois.readInt();
                    InsightSmartClient.debugOut("Attempting to recieve " + n2 + " for " + n + " tiles.");
                    int n3 = 0;
                    if (insightJtipListener != null) {
                        insightJtipListener.setJtipByteCount(n2);
                        insightJtipListener.setJtipTileCount(n);
                        insightJtipListener.setJtipProgress(n3);
                    }
                    int n4 = 4096;
                    for (int i = 0; i < n; ++i) {
                        InsightSmartClient.debugOut("Reading InsightJtipTile " + i);
                        InsightJtipTile insightJtipTile = (InsightJtipTile)collectionConnection.ois.readObject();
                        int n5 = collectionConnection.ois.readInt();
                        int n6 = 0;
                        byte[] byArray = new byte[n4];
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5);
                        InsightSmartClient.debugOut("Expecting to receive " + n5 + " bytes.");
                        while (n6 < n5) {
                            if (this.waitForInput(collectionConnection) <= 0) continue;
                            int n7 = n4;
                            if (n7 > n5 - n6) {
                                n7 = n5 - n6;
                            }
                            int n8 = 0;
                            while (n8 < n7) {
                                int n9 = n7 - n8;
                                int n10 = collectionConnection.theInputStream.read(byArray, n8, n9);
                                InsightSmartClient.debugOut("Read " + n10 + " bytes.");
                                n8 += n10;
                                n6 += n10;
                                n3 += n10;
                                if (insightJtipListener == null) continue;
                                insightJtipListener.setJtipProgress(n3);
                            }
                            byteArrayOutputStream.write(byArray, 0, n7);
                            InsightSmartClient.debugOut("baos.size(): " + byteArrayOutputStream.size());
                        }
                        insightJtipTile.jpegData = byteArrayOutputStream.toByteArray();
                        InsightSmartClient.debugOut("tile.jpegData.length: " + insightJtipTile.jpegData.length);
                        vector2.add(insightJtipTile);
                    }
                    if (insightJtipListener != null) {
                        insightJtipListener.jtipDownloadComplete();
                    }
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getJtipImageData(): " + exception + ".");
        }
        return vector2;
    }

    public InsightSmartClientResults[] getUcbThumbnails(int n, int n2, FieldMapping[] fieldMappingArray, FieldMapping[] fieldMappingArray2, List list, boolean bl, int n3, Vector vector) {
        InsightSmartClientResults[] insightSmartClientResultsArray = new InsightSmartClientResults[]{};
        try {
            InsightSmartClient.debugOut("Getting Ucb thumbnails.");
            if (this.collectionConnections.size() == 1) {
                ResultsProgressListener resultsProgressListener = (ResultsProgressListener)vector.get(0);
                resultsProgressListener.serverContacted(true);
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(53, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addIntegerParam("GROUP_ID", resultsProgressListener.getGroupInfo().getGroupID());
                insightRequest.addIntegerParam("START", n);
                insightRequest.addIntegerParam("LENGTH", n2);
                insightRequest.addObjectParam("CAPTION_FIELDS", InsightUtilities.toVector(fieldMappingArray));
                insightRequest.addObjectParam("SORT_FIELDS", InsightUtilities.toVector(fieldMappingArray2));
                insightRequest.addBooleanParam("IS_KEYWORD_SEARCH", !bl);
                insightRequest.addObjectParam("SEARCH_CRITERIA", list);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(1, WAIT_LIMIT * 5L, collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    collectionConnection.totalRecords = collectionConnection.ois.readInt();
                    int n4 = collectionConnection.ois.readInt();
                    resultsProgressListener.setResultCounts(collectionConnection.totalRecords, n4);
                    insightSmartClientResultsArray = new InsightSmartClientResults[n4];
                    for (int i = 0; i < n4; ++i) {
                        InsightSmartClient.debugOut("Receiving item #" + i, 3);
                        insightSmartClientResultsArray[i] = (InsightSmartClientResults)collectionConnection.ois.readObject();
                        insightSmartClientResultsArray[i].institutionID = collectionConnection.tci.getInstitutionID();
                        insightSmartClientResultsArray[i].collectionID = collectionConnection.tci.getCollectionID();
                        insightSmartClientResultsArray[i].vcID = collectionConnection.tci.getVCID();
                    }
                }
                resultsProgressListener.resultLoadComplete();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getUcbThumbnails().", 2);
        }
        return insightSmartClientResultsArray;
    }

    public HierarchyAncillaryData doAncillarySearch(HierarchyNodeData hierarchyNodeData) {
        HierarchyAncillaryData hierarchyAncillaryData = null;
        try {
            InsightSmartClient.debugOut("Performing ancillary search with node: '" + hierarchyNodeData.getNodeName() + "'.");
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                if (!InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(3, 50, 0), 7)) {
                    return null;
                }
                InsightRequest insightRequest = InsightRequest.newRequest(48, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("NODE_DATA", hierarchyNodeData);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    hierarchyAncillaryData = (HierarchyAncillaryData)collectionConnection.ois.readObject();
                    if (hierarchyAncillaryData != null && hierarchyAncillaryData.getListCount() == 0) {
                        hierarchyAncillaryData = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in doAncillarySearch(): " + exception + ".");
        }
        return hierarchyAncillaryData;
    }

    public Vector doTreePathSearch(HierarchyNodeData hierarchyNodeData) {
        Vector vector = null;
        try {
            InsightSmartClient.debugOut("Performing tree path search.");
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(46, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addObjectParam("NODE_DATA", hierarchyNodeData);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    vector = (Vector)collectionConnection.ois.readObject();
                    if (vector != null && vector.size() == 0) {
                        vector = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in doTreePathSearch(): " + exception + ".");
        }
        return vector;
    }

    public boolean addLocalNodePath(String string, String string2, Field field, String string3) {
        InsightSmartClient.debugOut("in addLocalNodePath().");
        boolean bl = false;
        try {
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(132, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("HIERARCHY_NAME", string);
                insightRequest.addStringParam("LOCAL_VOCABULARY_ROOT_NAME", string2);
                insightRequest.addObjectParam("FIELD", field);
                insightRequest.addStringParam("TERM", string3);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    bl = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in addLocalNodePath(): " + exception + ".");
        }
        return bl;
    }

    public Vector getTermsInHierarchy(String string) {
        InsightSmartClient.debugOut("in getTermsInHierarchy().");
        Vector vector = new Vector(0);
        try {
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(133, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("HIERARCHY_NAME", string);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    vector = (Vector)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getTermsInHierarchy(): " + exception + ".");
        }
        return vector;
    }

    public List getHierarchyNames() {
        InsightSmartClient.debugOut("in getHierarchyNames().");
        List list = null;
        try {
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(164, collectionConnection.tci, this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    list = (List)collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getHierarchyNames(): " + exception + ".");
        }
        return list == null ? new ArrayList() : list;
    }

    public boolean isTermInHierarchy(String string, String string2) {
        InsightSmartClient.debugOut("in isTermInHierarchy().");
        boolean bl = false;
        try {
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(134, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("HIERARCHY_NAME", string);
                insightRequest.addStringParam("TERM", string2);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    bl = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in isTermInHierarchy(): " + exception + ".");
        }
        return bl;
    }

    public void logXMLExport(long l, String string, int n, String string2) {
        try {
            InsightSmartClient.debugOut("Logging XML Export.");
            if (this.collectionConnections.size() == 1) {
                CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
                InsightRequest insightRequest = InsightRequest.newRequest(117, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("COLLECTION_NAME", collectionConnection.tci.getCollectionName());
                insightRequest.addStringParam("USER_NAME", string);
                insightRequest.addCollectionKeyParam(collectionConnection.tci);
                insightRequest.addIntegerParam("PROFILE_ID", collectionConnection.tci.getProfileID());
                insightRequest.addLongParam("EXPORT_MEDIA_ID", l);
                insightRequest.addIntegerParam("EXPORT_RESOLUTION", n);
                insightRequest.addStringParam("EXPORT_IMAGE_URL", string2);
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in logXMLExport():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public boolean isPersonalCollectionNameUnique(String string) {
        boolean bl = false;
        try {
            InsightSmartClient.debugOut("in isPersonalCollectionNameUnique().");
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(145, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("PC_NAME", string);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in isPersonalCollectionNameUnique():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean savePersonalCollection(PersonalCollection personalCollection, MutableObject mutableObject) {
        return false;
    }

    public boolean isLicensedPersonalCollectionServer() {
        boolean bl = false;
        try {
            InsightSmartClient.debugOut("In isLicensedPersonalCollectionServer().");
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(160, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in isLicensedPersonalCollectionServer():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean canCreatePersonalCollections(InsightUser insightUser) {
        boolean bl = false;
        try {
            InsightSmartClient.debugOut("In canCreatePersonalCollections().");
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            if (InsightVersion.compareVersions(this.getServerVersion(), new InsightVersion(5, 0, 0), 7)) {
                InsightRequest insightRequest = InsightRequest.newRequest(159, collectionConnection.tci, this.getLocalAddress());
                insightRequest.addStringParam("SESSION_GROUP_NAME", collectionConnection.tci.getSessionGroupName());
                insightRequest.addStringParam("SESSION_GROUP_CODE_KEY", collectionConnection.tci.getSessionCodeKey());
                insightRequest.addStringParam("INSIGHT_USER", insightUser.getLoginName());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    bl = collectionConnection.ois.readBoolean();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in canCreatePersonalCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public List getPersonalCollections(InsightUser insightUser) {
        List list = null;
        try {
            InsightSmartClient.debugOut("in getPersonalCollections().");
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(138, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("INSIGHT_USER", insightUser);
            insightRequest.addStringParam("SESSION_GROUP_NAME", collectionConnection.tci.getSessionGroupName());
            insightRequest.addStringParam("SESSION_GROUP_CODE_KEY", collectionConnection.tci.getSessionCodeKey());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                list = (List)collectionConnection.ois.readObject();
            }
            for (int i = 0; list != null && i < list.size(); ++i) {
                TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)list.get(i);
                TrinityCollectionInfo.ContextMap contextMap = new TrinityCollectionInfo.ContextMap(trinityCollectionInfo);
                contextMap.putAll((Map)collectionConnection.tci.getContextMap());
                contextMap.putAll((Map)trinityCollectionInfo.getContextMap());
                trinityCollectionInfo.setContextMap(contextMap);
                trinityCollectionInfo.setUserID(collectionConnection.tci.getUserID());
                trinityCollectionInfo.setUserName(collectionConnection.tci.getUserName());
                trinityCollectionInfo.setServerID(collectionConnection.tci.getServerID());
                trinityCollectionInfo.setServerAddress(collectionConnection.tci.getServerAddress());
                trinityCollectionInfo.setServerPort(collectionConnection.tci.getServerPort());
                trinityCollectionInfo.setUserGroupName(collectionConnection.tci.getUserGroupName());
                trinityCollectionInfo.setUserGroupCodeKey(collectionConnection.tci.getUserGroupCodeKey());
                trinityCollectionInfo.setUserGroupProfileID(collectionConnection.tci.getUserGroupProfileID());
                trinityCollectionInfo.setSessionGroupName(collectionConnection.tci.getSessionGroupName());
                trinityCollectionInfo.setSessionCodeKey(collectionConnection.tci.getSessionCodeKey());
                trinityCollectionInfo.setGroupDisplayName(collectionConnection.tci.getGroupDisplayName());
                trinityCollectionInfo.setLocaleUserServer(collectionConnection.tci.getLocaleUserServer());
                trinityCollectionInfo.setLocaleCollectionServer(collectionConnection.tci.getLocaleCollectionServer());
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getPersonalCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public ImportMediaResult importMediaFiles(CollectionBuildingObject collectionBuildingObject, List list, Entity entity, int n) {
        InsightSmartClient.debugOut("in savePersonalCollectionMediaFiles()");
        ImportMediaResult importMediaResult = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionBuildingObject.getTCI());
            InsightRequest insightRequest = InsightRequest.newRequest(139, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("MEDIA_FILE_LIST", list);
            insightRequest.addStringParam("VCID", collectionBuildingObject.getVCID());
            insightRequest.addStringParam("INITIAL_GROUP_OPEN", collectionBuildingObject.getTCI().getInitialGroupOpen());
            insightRequest.addObjectParam("ENTITY", entity);
            insightRequest.addIntegerParam("LPS_ID", n);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                long l;
                InsightSmartClient.debugOut("Receiving data.");
                importMediaResult = InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(5, 10, 13), 7) ? (ImportMediaResult)collectionConnection.ois.readObject() : ((l = collectionConnection.ois.readLong()) == -1L ? new ImportMediaResult(1) : new ImportMediaResult(l));
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in savePersonalCollectionMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
        return importMediaResult;
    }

    public boolean publishMedia(CollectionBuildingObject collectionBuildingObject, String string, List list) {
        InsightSmartClient.debugOut("in publishMedia()");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionBuildingObject.getTCI());
            InsightRequest insightRequest = InsightRequest.newRequest(167, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("GROUP_NAME", string);
            insightRequest.addObjectParam("MEDIA_IDS", list);
            insightRequest.addStringParam("VCID", collectionBuildingObject.getVCID());
            insightRequest.addBooleanParam("WAIT_FOR_SERVER", true);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in publishMedia():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean unpublishMedia(CollectionBuildingObject collectionBuildingObject, String string, List list) {
        InsightSmartClient.debugOut("in unpublishMedia()");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionBuildingObject.getTCI());
            InsightRequest insightRequest = InsightRequest.newRequest(168, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addStringParam("GROUP_NAME", string);
            insightRequest.addObjectParam("MEDIA_IDS", list);
            insightRequest.addStringParam("VCID", collectionBuildingObject.getVCID());
            insightRequest.addBooleanParam("WAIT_FOR_SERVER", true);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in unpublishMedia():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public void sayHello() {
        CollectionConnection collectionConnection = this.getFirstCollectionConnection();
        try {
            collectionConnection.oos.writeObject(InsightRequest.newRequest(1001, collectionConnection.tci, this.getLocalAddress()));
            collectionConnection.oos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean saveObjectDataRecord(ObjectDataRecord objectDataRecord, CollectionKey collectionKey) {
        InsightSmartClient.debugOut("in saveObjectDataRecord().");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(140, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("OBJECT_DATA_RECORD", objectDataRecord);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
                long l = collectionConnection.ois.readLong();
                objectDataRecord.setObjectID(l);
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in saveObjectDataRecord():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean deletePersonalCollectionObject(PersonalCollection personalCollection, long l, long l2) {
        InsightSmartClient.debugOut("in deletePersonalCollectionObject");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(personalCollection);
            InsightRequest insightRequest = InsightRequest.newRequest(141, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addLongParam("OBJECT_ID", l);
            insightRequest.addLongParam("MEDIA_ID", l2);
            insightRequest.addStringParam("VCID", personalCollection.getVCID());
            insightRequest.addStringParam("INITIAL_GROUP_OPEN", personalCollection.getTci().getInitialGroupOpen());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in deletePersonalCollectionObject():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean deleteCollection(TrinityCollectionInfo trinityCollectionInfo) {
        InsightSmartClient.debugOut("in deleteCollection()");
        boolean bl = false;
        boolean bl2 = InsightVersion.compareVersions(this.getServerVersion(), new InsightVersion(5, 10, 15), 7);
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(trinityCollectionInfo);
            InsightRequest insightRequest = InsightRequest.newRequest(144, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(trinityCollectionInfo);
            insightRequest.addObjectParam("COLLECTION_INFO", trinityCollectionInfo);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (bl2) {
                if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    bl = collectionConnection.ois.readBoolean();
                }
            } else if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in deletePersonalCollectionObject():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean updatePcMediaUrls(PersonalCollection personalCollection, String string, String string2) {
        InsightSmartClient.debugOut("in updatePcMediaUrls");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(personalCollection);
            InsightRequest insightRequest = InsightRequest.newRequest(146, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(personalCollection);
            insightRequest.addStringParam("INITIAL_GROUP_OPEN", personalCollection.getTci().getInitialGroupOpen());
            insightRequest.addStringParam("CURRENT_PC_DIRECTORY", string);
            insightRequest.addStringParam("NEW_PC_DIRECTORY", string2);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in updatePcMediaUrls():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public String getMediaSecurityKey(CollectionKey collectionKey) {
        InsightSmartClient.debugOut("in getMediaSecurityKey");
        String string = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(187, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                string = (String)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getMediaSecurityKey():\n" + InsightUtilities.getStackTrace(exception));
        }
        return string;
    }

    public String getMediaSecurityServletBaseUrl(CollectionKey collectionKey) {
        InsightSmartClient.debugOut("in getMediaSecurityServletBaseUrl");
        String string = null;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(142, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                string = (String)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getMediaSecurityServletBaseUrl():\n" + InsightUtilities.getStackTrace(exception));
        }
        return string;
    }

    public boolean authenticateStudioUser(String string) {
        InsightSmartClient.debugOut("In authenticateStudioUser");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(161, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in authenticateStudioUser():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public int getCollectionServerPrivs() {
        InsightSmartClient.debugOut("In getCollectionServerPrivs");
        int n = 0;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightVersion insightVersion = collectionConnection.tci.getServerVersion();
            if (insightVersion == null) {
                collectionConnection.tci.setServerVersion(this.getServerVersion());
            }
            if (InsightVersion.compareVersions(collectionConnection.tci.getServerVersion(), new InsightVersion(5, 10, 15), 7)) {
                InsightRequest insightRequest = InsightRequest.newRequest(180, collectionConnection.tci, this.getLocalAddress());
                collectionConnection.oos.writeObject(insightRequest);
                collectionConnection.oos.flush();
                InsightSmartClient.debugOut("Waiting for data.");
                if (this.waitForInput(collectionConnection) > 0) {
                    InsightSmartClient.debugOut("Receiving data.");
                    n = collectionConnection.ois.readInt();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getCollectionServerPrivs():\n" + InsightUtilities.getStackTrace(exception));
        }
        return n;
    }

    public boolean saveThemeFile(DefaultTheme defaultTheme) {
        InsightSmartClient.debugOut("In saveThemeFile");
        boolean bl = false;
        try {
            String string = DefaultTheme.createThemeImagesZip(defaultTheme);
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(162, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(collectionConnection.tci);
            insightRequest.addObjectParam("COLLECTION_THEME", defaultTheme);
            insightRequest.addObjectParam("COLLECTION_THEME_ZIP", CoreUtilities.importFileBytes(string));
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in saveThemeFile():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public byte[] getThemeFileIfNecessary(ImageIcon imageIcon) {
        InsightSmartClient.debugOut("In getThemeFile");
        byte[] byArray = null;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(163, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addCollectionKeyParam(collectionConnection.tci);
            insightRequest.addLongParam("COLLECTION_THEME_CRC", imageIcon == null ? 0L : DefaultTheme.calculateThemeCRC(imageIcon));
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                boolean bl = collectionConnection.ois.readBoolean();
                if (bl) {
                    byArray = (byte[])collectionConnection.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getThemeFile():\n" + InsightUtilities.getStackTrace(exception));
        }
        return byArray;
    }

    public boolean deleteMediaBatch(int n) {
        InsightSmartClient.debugOut("in deleteMediaBatch()");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(173, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("MEDIA_BATCH_ID", n);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in deleteMediaBatch():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public List getMediaBatchElements(IMediaBatch iMediaBatch) {
        InsightSmartClient.debugOut("in getMediaBatchElements()");
        List list = null;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(172, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("MEDIA_BATCH_ID", iMediaBatch.getBatchID());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                list = (List)collectionConnection.ois.readObject();
            }
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((IMediaBatchElement)iterator.next()).setMediaBatch(iMediaBatch);
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getMediaBatchElements():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public List getMediaBatches() {
        InsightSmartClient.debugOut("in getMediaBatches()");
        List list = null;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(165, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                list = (List)collectionConnection.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getMediaBatches():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public boolean deleteMediaRecords(Set set) {
        InsightSmartClient.debugOut("In deleteMediaRecords.");
        boolean bl = false;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(179, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("MEDIA_IDS", set);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitWhileKeepAlive(1, collectionConnection) > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in deleteMediaRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean saveMediaBatch(IMediaBatch iMediaBatch, boolean bl) {
        Object object;
        InsightSmartClient.debugOut("in saveMediaBatch()");
        boolean bl2 = false;
        List list = iMediaBatch.getBatchElements();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl3 = false;
        boolean bl4 = iMediaBatch.isModifiedSinceLastCommit() && iMediaBatch.hasBeenSaved();
        try {
            object = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(166, ((CollectionConnection)object).tci, this.getLocalAddress());
            insightRequest.addObjectParam("MEDIA_BATCH", iMediaBatch);
            insightRequest.addBooleanParam("WAIT_FOR_SERVER", true);
            if (bl) {
                iMediaBatch.setBatchElements(new ArrayList());
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        IMediaBatchElement iMediaBatchElement = (IMediaBatchElement)list.get(i);
                        if (!iMediaBatchElement.isModifiedSinceLastCommit()) continue;
                        iMediaBatch.addBatchElement(iMediaBatchElement);
                        arrayList.add(new Integer(i));
                    }
                }
            } else {
                iMediaBatch.setBatchElements(null);
            }
            ((CollectionConnection)object).oos.writeObject(insightRequest);
            ((CollectionConnection)object).oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitWhileKeepAlive(1, (CollectionConnection)object) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                IMediaBatch iMediaBatch2 = (IMediaBatch)((CollectionConnection)object).ois.readObject();
                if (iMediaBatch2 != null) {
                    bl2 = true;
                    iMediaBatch.setHasBeenSaved(true);
                    iMediaBatch.setBatchID(iMediaBatch2.getBatchID());
                    iMediaBatch.setLpsDir(iMediaBatch2.getLpsDir());
                    iMediaBatch.setLpsId(iMediaBatch2.getLpsId());
                    if (bl4) {
                        iMediaBatch.setModifiedSinceLastCommit(iMediaBatch2.isModifiedSinceLastCommit());
                    }
                    if (bl && list != null) {
                        for (int i = 0; i < iMediaBatch2.getBatchElements().size(); ++i) {
                            IMediaBatchElement iMediaBatchElement = (IMediaBatchElement)iMediaBatch2.getBatchElements().get(i);
                            if (iMediaBatchElement == null) {
                                bl3 = true;
                                list.set((Integer)arrayList.get(i), null);
                                continue;
                            }
                            IMediaBatchElement iMediaBatchElement2 = (IMediaBatchElement)list.get((Integer)arrayList.get(i));
                            iMediaBatchElement2.copy(iMediaBatchElement);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in saveMediaBatch():\n" + InsightUtilities.getStackTrace(exception));
        }
        iMediaBatch.setBatchElements(list);
        if (bl2 && bl) {
            if (bl3) {
                object = new ArrayList();
                object.add(null);
                iMediaBatch.getBatchElements().removeAll((Collection<?>)object);
            }
            iMediaBatch.updateHashes();
        }
        return bl2;
    }

    public int saveCollectionUserGroupKey(CollectionUserGroupKey collectionUserGroupKey) {
        InsightSmartClient.debugOut("in saveCollectionUserGroupKey()");
        int n = 5;
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(169, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addObjectParam("COLLECTION_USER_GROUP_KEY", collectionUserGroupKey);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                CollectionUserGroupKey collectionUserGroupKey2 = (CollectionUserGroupKey)collectionConnection.ois.readObject();
                if (collectionUserGroupKey2 != null) {
                    collectionUserGroupKey.setGroupID(collectionUserGroupKey2.getGroupID());
                    n = 0;
                } else {
                    n = collectionConnection.ois.readInt();
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in saveCollectionUserGroupKey():\n" + InsightUtilities.getStackTrace(exception));
        }
        return n;
    }

    public List getCollectionProfileKeyList(int n) {
        InsightSmartClient.debugOut("in getCollectionProfileKeyList()");
        List list = new ArrayList();
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(170, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("USER_COLLECTION", n);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                List list2 = (List)collectionConnection.ois.readObject();
                if (list2 != null) {
                    list = list2;
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getCollectionProfileKeyList():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public List getCollectionUserGroupKeyList(int n) {
        InsightSmartClient.debugOut("in getCollectionUserGroupKeyList()");
        List list = new ArrayList();
        try {
            CollectionConnection collectionConnection = this.getFirstCollectionConnection();
            InsightRequest insightRequest = InsightRequest.newRequest(171, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("USER_COLLECTION", n);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                List list2 = (List)collectionConnection.ois.readObject();
                if (list2 != null) {
                    list = list2;
                }
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in getCollectionUserGroupKeyList():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public boolean reorderGroupImages(CollectionKey collectionKey, int n, boolean bl, Vector vector) {
        InsightSmartClient.debugOut("in reorderGroupImages()");
        boolean bl2 = false;
        try {
            CollectionConnection collectionConnection = this.getCollectionConnection(collectionKey);
            InsightRequest insightRequest = InsightRequest.newRequest(174, collectionConnection.tci, this.getLocalAddress());
            insightRequest.addIntegerParam("GROUP_ID", n);
            insightRequest.addBooleanParam("ABSOLUTE_ORDERING", bl);
            insightRequest.addObjectParam("IMAGES_IN_GROUP", vector);
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
            InsightSmartClient.debugOut("Waiting for data.");
            if (this.waitForInput(collectionConnection) > 0) {
                InsightSmartClient.debugOut("Receiving data.");
                bl2 = collectionConnection.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in reorderGroupImages():\n" + InsightUtilities.getStackTrace(exception), 3);
        }
        return bl2;
    }

    public void startTermProcessing() {
        InsightSmartClient.debugOut("in startTermProcessing");
        try {
            CollectionConnection collectionConnection = (CollectionConnection)this.collectionConnections.get(0);
            InsightRequest insightRequest = InsightRequest.newRequest(188, collectionConnection.tci, this.getLocalAddress());
            collectionConnection.oos.writeObject(insightRequest);
            collectionConnection.oos.flush();
        }
        catch (Exception exception) {
            InsightSmartClient.debugOut("Exception in startTermProcessing():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected int waitForInput(CollectionKey collectionKey) {
        return this.waitForInput(1, WAIT_LIMIT, collectionKey);
    }

    protected int waitForInput(CollectionConnection collectionConnection) {
        return this.waitForInput(1, WAIT_LIMIT, collectionConnection);
    }

    protected int waitForInput(int n, CollectionKey collectionKey) {
        return this.waitForInput(n, WAIT_LIMIT, collectionKey);
    }

    protected int waitForInput(int n, CollectionConnection collectionConnection) {
        return this.waitForInput(n, WAIT_LIMIT, collectionConnection);
    }

    protected int waitForInput(int n, long l, CollectionKey collectionKey) {
        return this.waitForInput(n, l, this.getCollectionConnection(collectionKey));
    }

    protected int waitForInput(int n, long l, CollectionConnection collectionConnection) {
        int n2;
        block5: {
            n2 = 0;
            try {
                if (collectionConnection == null || collectionConnection.theInputStream == null) break block5;
                int n3 = 0;
                while (collectionConnection.theInputStream.available() < n) {
                    n3 += 200;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((long)n3 < l) continue;
                }
                n2 = collectionConnection.theInputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n2;
    }

    protected int waitWhileKeepAlive(int n, long l, CollectionConnection collectionConnection) {
        int n2 = 0;
        try {
            while (collectionConnection != null && collectionConnection.theInputStream != null) {
                int n3 = 0;
                while (collectionConnection.theInputStream.available() < n) {
                    n3 += 200;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((long)n3 < l) continue;
                }
                if ((n2 = collectionConnection.theInputStream.available()) > 0) {
                    KeepAliveMessage keepAliveMessage = new KeepAliveMessage();
                    try {
                        Object object = collectionConnection.ois.readObject();
                        if (object instanceof KeepAliveMessage) {
                            keepAliveMessage = (KeepAliveMessage)object;
                        } else {
                            InsightSmartClient.debugOut("Expecting KeepAliveMessage found " + object.getClass() + ".");
                        }
                    }
                    catch (Exception exception) {
                        InsightSmartClient.debugOut("Exception in waitWhileKeepAlive: " + exception);
                    }
                    if (keepAliveMessage.getStatus() == 1) {
                        return n2;
                    }
                    if (keepAliveMessage.getStatus() != -1) continue;
                    return 0;
                }
                return 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n2;
    }

    protected int waitWhileKeepAlive(int n, CollectionConnection collectionConnection) {
        return this.waitWhileKeepAlive(n, WAIT_LIMIT, collectionConnection);
    }

    public int getCollectionCount() {
        return this.collections != null ? this.collections.size() : 0;
    }
}

