/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightRequestKeys;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.TrinityCollectionInfo;
import java.io.Serializable;
import java.util.Hashtable;

public class InsightRequest
extends Hashtable
implements Serializable,
InsightRequestKeys {
    static final long serialVersionUID = 6826402086801621983L;

    public static void debugOut(String string) {
        InsightRequest.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("InsightRequest: " + string, n);
    }

    public static InsightRequest newRequest(int n, TrinityCollectionInfo trinityCollectionInfo, String string) {
        return InsightRequest.newRequest(n, trinityCollectionInfo != null ? trinityCollectionInfo.getSessionGroupName() : "", trinityCollectionInfo != null ? trinityCollectionInfo.getSessionCodeKey() : "", string, trinityCollectionInfo);
    }

    private static InsightRequest newRequest(int n, String string, String string2, String string3, TrinityCollectionInfo trinityCollectionInfo) {
        InsightRequest insightRequest = new InsightRequest();
        String string4 = trinityCollectionInfo.getUserName();
        String string5 = new Integer(trinityCollectionInfo.getUserID()).toString();
        insightRequest.addRequestParam(n);
        insightRequest.addVersion(new InsightVersion());
        Integer n2 = trinityCollectionInfo.getUniqueCollectionID();
        if (n2 != null) {
            insightRequest.addIntegerParam("UNIQUE_COLLECTION_ID", n2);
        }
        insightRequest.addStringParam("SESSION_GROUP_NAME", string);
        insightRequest.addStringParam("SESSION_GROUP_CODE_KEY", string2);
        insightRequest.addStringParam("CLIENT_LOCAL_IP", string3);
        insightRequest.addStringParam("USER_NAME", string4);
        insightRequest.addStringParam("USER_ID", string5);
        return insightRequest;
    }

    private InsightRequest() {
    }

    public void addIntegerParam(Object object, int n) {
        if (object != null) {
            this.addObjectParam(object, new Integer(n));
        }
    }

    public void addLongParam(Object object, long l) {
        if (object != null) {
            this.addObjectParam(object, new Long(l));
        }
    }

    public void addBooleanParam(Object object, boolean bl) {
        if (object != null) {
            this.addObjectParam(object, new Boolean(bl));
        }
    }

    public void addStringParam(Object object, String string) {
        if (object != null) {
            this.addObjectParam(object, string);
        }
    }

    public void addObjectParam(Object object, Object object2) {
        if (object != null && object2 != null) {
            this.put(object, object2);
        }
    }

    public void addRequestParam(int n) {
        this.addIntegerParam("REQUEST_CMD_ID", n);
    }

    public void addVersion(InsightVersion insightVersion) {
        this.addObjectParam("INSIGHT_VERSION", insightVersion);
    }

    public void addCollectionKeyParam(CollectionKey collectionKey) {
        if (collectionKey != null) {
            this.addObjectParam("COLLECTION_KEY", new CollectionKeyWrapper(collectionKey.getInstitutionID(), collectionKey.getCollectionID(), collectionKey.getVCID()));
        }
    }

    public void addCollectionKeyParam(String string, String string2, String string3) {
        if (string != null && string2 != null && string3 != null) {
            this.addObjectParam("COLLECTION_KEY", new CollectionKeyWrapper(string, string2, string3));
        }
    }

    public int getIntegerParam(Object object) {
        return this.getIntegerParam(object, 0);
    }

    public int getIntegerParam(Object object, int n) {
        Object v;
        if (object != null && (v = this.get(object)) instanceof Integer) {
            return (Integer)v;
        }
        return n;
    }

    public long getLongParam(Object object) {
        return this.getLongParam(object, 0L);
    }

    public long getLongParam(Object object, long l) {
        Object v;
        if (object != null && (v = this.get(object)) instanceof Long) {
            return (Long)v;
        }
        return l;
    }

    public boolean getBooleanParam(Object object) {
        return this.getBooleanParam(object, false);
    }

    public boolean getBooleanParam(Object object, boolean bl) {
        Object v;
        if (object != null && (v = this.get(object)) instanceof Boolean) {
            return (Boolean)v;
        }
        return bl;
    }

    public String getStringParam(Object object) {
        return this.getStringParam(object, null);
    }

    public String getStringParam(Object object, String string) {
        Object v;
        if (object != null && (v = this.get(object)) instanceof String) {
            return (String)v;
        }
        return string;
    }

    public Object getObjectParam(Object object) {
        if (object != null) {
            return this.get(object);
        }
        return null;
    }

    public int getRequestCmd() {
        return this.getIntegerParam("REQUEST_CMD_ID", 0);
    }

    public InsightVersion getVersion() {
        Object object = this.getObjectParam("INSIGHT_VERSION");
        if (object instanceof InsightVersion) {
            return (InsightVersion)object;
        }
        return null;
    }

    public CollectionKey getCollectionKeyParam() {
        Object object = this.getObjectParam("COLLECTION_KEY");
        if (object instanceof CollectionKey) {
            return (CollectionKey)object;
        }
        return null;
    }
}

