/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;

public class EventLog {
    public static final long MAXIMUM_LOGFILE_LENGTH = 2000000L;
    public static final String DEFAULT_LOGFILE_EXTENSION = ".txt";
    public static final String CSV_SEPARATOR = ",";
    public static final String AUTHENTICATED_STATUS = "Authenticated";
    public static final String AUTHENTICATING = "Authenticating";
    public static final String FAILURE_STATUS = "Invalid Login";
    public static final String AUTH_FAILURE_STATUS = "Not Authenticated";
    public static final String BOGUS_STATUS = "Mimic Session";
    public static final String OUTDATED_CLIENT = "Outdated client";
    public static final String COLLECTIONS = "Retrieving collections";
    protected String eventLogFilename;
    protected int eventNumber = 0;
    protected boolean limitLength = false;

    public EventLog(String string) {
        this(string, true);
    }

    public EventLog(String string, boolean bl) {
        this.eventLogFilename = string;
        this.limitLength = bl;
    }

    public synchronized void logDated(String string) {
        this.log(Calendar.getInstance().getTime() + ": " + string);
    }

    public synchronized void log(String string) {
        if (this.eventLogFilename != null) {
            ++this.eventNumber;
            try {
                Object object;
                if (this.limitLength && this.eventNumber % 50 == 0 && ((File)(object = new File(this.eventLogFilename))).length() > 2000000L) {
                    ((File)object).delete();
                }
                object = new FileWriter(this.eventLogFilename, true);
                ((Writer)object).write(string + "\r\n");
                ((OutputStreamWriter)object).flush();
                ((OutputStreamWriter)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

