/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class EnhancedProperties
extends Properties {
    protected boolean ignoreCase = false;
    protected List keysInOrder = new Vector();
    protected Hashtable propertyComments;
    protected static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final String specialSaveChars = "=: \t\r\n\f#!";

    public EnhancedProperties() {
        this(false);
    }

    public EnhancedProperties(boolean bl) {
        this.ignoreCase = bl;
    }

    protected EnhancedProperties(Properties properties) {
        super(properties);
    }

    public long getLongProperty(String string) {
        return this.getLongProperty(string, 0L);
    }

    public long getLongProperty(String string, long l) {
        long l2 = l;
        try {
            l2 = Long.parseLong(this.getProperty(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l2;
    }

    public int getIntegerProperty(String string) {
        return this.getIntegerProperty(string, 0);
    }

    public int getIntegerProperty(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(this.getProperty(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public char getCharProperty(String string) {
        return this.getCharProperty(string, ' ');
    }

    public char getCharProperty(String string, char c) {
        char c2 = c;
        try {
            c2 = string.charAt(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c2;
    }

    public double getDoubleProperty(String string) {
        return this.getDoubleProperty(string, 0.0);
    }

    public double getDoubleProperty(String string, double d) {
        double d2 = d;
        try {
            d2 = Double.parseDouble(this.getProperty(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d2;
    }

    public float getFloatProperty(String string) {
        return this.getFloatProperty(string, 0.0f);
    }

    public float getFloatProperty(String string, float f) {
        float f2 = f;
        try {
            f2 = Float.parseFloat(this.getProperty(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f2;
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = this.getProperty(string);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("Yes") || string2.equalsIgnoreCase("1")) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("No") || string2.equalsIgnoreCase("0")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public Object setProperty(String string, String string2, String string3) {
        if (this.ignoreCase && string instanceof String) {
            string = string.toLowerCase();
        }
        if (string != null && string.length() > 0 && string3 != null && string3.length() > 0) {
            if (this.propertyComments == null) {
                this.propertyComments = new Hashtable();
            }
            this.propertyComments.put(string, string3);
        }
        return this.setProperty(string, string2);
    }

    public Object put(Object object, Object object2) {
        if (this.ignoreCase && object instanceof String) {
            object = ((String)object).toLowerCase();
        }
        if (object2 instanceof String) {
            object2 = ((String)object2).trim();
        }
        Object object3 = super.put(object, object2);
        if (object != null && !this.keysInOrder.contains(object)) {
            this.keysInOrder.add(object);
        }
        return object3;
    }

    public Object get(Object object) {
        if (this.ignoreCase && object instanceof String) {
            object = ((String)object).toLowerCase();
        }
        return super.get(object);
    }

    public Iterator keysInOrder() {
        return this.keysInOrder.iterator();
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            EnhancedProperties.writeln(bufferedWriter, "# " + string);
        }
        EnhancedProperties.writeln(bufferedWriter, "# " + DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        Iterator iterator = this.keysInOrder.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)this.get(string2);
            bufferedWriter.newLine();
            List list = this.getCommentLines(this.getComment(string2));
            string2 = this.saveConvert(string2, true);
            string3 = this.saveConvert(string3, false);
            for (int i = 0; list != null && i < list.size(); ++i) {
                EnhancedProperties.writeln(bufferedWriter, "# " + list.get(i));
            }
            EnhancedProperties.writeln(bufferedWriter, string2 + " = " + string3);
        }
        bufferedWriter.flush();
    }

    protected String getComment(String string) {
        return this.propertyComments != null ? (String)this.propertyComments.get(string) : null;
    }

    protected List getCommentLines(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f");
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (stringBuffer.length() > 0 && stringBuffer.length() + string2.length() > 80) {
                    vector.add((vector.size() > 0 ? "  " : "") + stringBuffer.toString().trim());
                    stringBuffer = new StringBuffer();
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string2);
            }
            if (stringBuffer.length() > 0) {
                vector.add((vector.size() > 0 ? "  " : "") + stringBuffer.toString().trim());
            }
        }
        return vector;
    }

    protected static void writeln(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    protected String saveConvert(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(EnhancedProperties.toHex(c >> 12 & 0xF));
                        stringBuffer.append(EnhancedProperties.toHex(c >> 8 & 0xF));
                        stringBuffer.append(EnhancedProperties.toHex(c >> 4 & 0xF));
                        stringBuffer.append(EnhancedProperties.toHex(c & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected static char toHex(int n) {
        return hexDigit[n & 0xF];
    }
}

