/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import com.luna.insight.core.iface.CoreConsts;
import com.luna.insight.core.iface.Theme;
import com.luna.insight.core.insightwizard.gui.util.ColorPicker;
import com.luna.insight.core.theme.ThemeImageCreator;
import com.luna.insight.core.util.CoreUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.ImageIcon;

public class DefaultTheme
implements Serializable,
Theme,
CoreConsts {
    public static final String CMM_THEME_SUFFIX = ".thm";
    public static final int PREVIEW_WIDTH = 803;
    public static final int PREVIEW_HEIGHT = 590;
    public static final transient String THEME_DIR = "Theme-Templates";
    public static final transient Hashtable themeTable = new Hashtable();
    public static boolean resampleDuringResize = true;
    static final long serialVersionUID = 4982336553720503637L;
    protected String name;
    protected String description;
    protected String bgSource;
    protected Color bgBlendColor = ColorPicker.getDEFAULT_COLOR();
    protected Color bgFillColor = null;
    protected long crcValue = 0L;
    protected transient ImageIcon preview;
    protected transient String collectionName;
    protected transient boolean custom;

    public static void setResampleDuringResize(boolean bl) {
        resampleDuringResize = bl;
    }

    public static long calculateThemeCRC(ImageIcon imageIcon) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    public static String[] getAvailableThemes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(THEME_DIR);
        if (!file.exists()) {
            file.mkdirs();
            return CoreConsts.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                return file2.getName().endsWith(DefaultTheme.CMM_THEME_SUFFIX);
            }
        });
        DefaultTheme.checkThemeCache(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].substring(0, stringArray[i].length() - CMM_THEME_SUFFIX.length());
            arrayList.add(string);
        }
        return arrayList.toArray(stringArray);
    }

    protected static void checkThemeCache(final String[] stringArray) {
        Thread thread = new Thread("Theme Loader"){

            public void run() {
                try {
                    2.sleep(100L);
                    for (int i = 0; i < stringArray.length; ++i) {
                        Theme theme = DefaultTheme.getTheme(stringArray[i]);
                    }
                }
                catch (InterruptedException interruptedException) {
                    CoreUtilities.logException("themeloader", interruptedException);
                }
            }
        };
        thread.setPriority(5);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Theme getTheme(String string) {
        Theme theme;
        if (!themeTable.containsKey(string) && (theme = DefaultTheme.loadTheme(string)) != null) {
            Hashtable hashtable = themeTable;
            synchronized (hashtable) {
                themeTable.put(string, theme);
            }
        }
        return (Theme)themeTable.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String createThemeImagesZip(Theme theme) {
        String string;
        block17: {
            string = null;
            String string2 = THEME_DIR;
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            File file = new File(DefaultTheme.getThemeImagesDir(theme, false));
            File[] fileArray = file.listFiles();
            FileOutputStream fileOutputStream = null;
            FileInputStream fileInputStream = null;
            String string3 = string2 + URLEncoder.encode(theme.getName(), "UTF-8") + ".zip";
            fileOutputStream = new FileOutputStream(string3);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            byte[] byArray = new byte[1024];
            for (int i = 0; i < fileArray.length; ++i) {
                int n;
                fileInputStream = new FileInputStream(fileArray[i]);
                zipOutputStream.putNextEntry(new ZipEntry(fileArray[i].getName()));
                while ((n = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                fileInputStream.close();
            }
            zipOutputStream.close();
            string = string3;
            Object var13_13 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block17;
            }
            catch (Exception exception) {}
            break block17;
            {
                catch (Exception exception) {
                    CoreUtilities.logException(exception);
                    Object var13_14 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block17;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string;
    }

    public static String getThemeImagesDir(Theme theme, boolean bl) {
        String string = THEME_DIR;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        try {
            string = string + URLEncoder.encode(theme.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        boolean bl2 = true;
        File file = new File(string);
        if (bl) {
            if (file.exists() && !file.isDirectory()) {
                bl2 = file.delete();
            } else if (!file.exists()) {
                bl2 = file.mkdirs();
            }
        }
        return bl2 ? string : null;
    }

    protected static void generateThemePreview(Theme theme) {
        String string = THEME_DIR;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        ThemeImageCreator themeImageCreator = new ThemeImageCreator(resampleDuringResize);
        themeImageCreator.setDestinationDir(string);
        themeImageCreator.setBgImage(theme.getBGImageSource());
        themeImageCreator.create(false);
        ((DefaultTheme)theme).setBackgroundImage(((DefaultTheme)theme).getPreviewDiskImage());
    }

    protected static void generateThemeImages(Theme theme) {
        String string = DefaultTheme.getThemeImagesDir(theme, true);
        ThemeImageCreator themeImageCreator = new ThemeImageCreator(resampleDuringResize);
        themeImageCreator.setDestinationDir(string);
        themeImageCreator.setBgImage(theme.getBGImageSource());
        themeImageCreator.create();
        ((DefaultTheme)theme).setFillColor(themeImageCreator.getBlendColor());
        ((DefaultTheme)theme).setBackgroundImage(theme.getBackgroundImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean saveTheme(String string, Theme theme) {
        DefaultTheme.checkThemeDir();
        if (theme != null) {
            DefaultTheme.generateThemeImages(theme);
            if (string == null) {
                string = theme.getName();
            }
            if (!string.endsWith(CMM_THEME_SUFFIX)) {
                string = string + CMM_THEME_SUFFIX;
            }
            File file = new File(THEME_DIR);
            File file2 = new File(file, string);
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(theme);
            objectOutputStream.close();
            fileOutputStream.close();
            DefaultTheme.getTheme(theme.getName());
            boolean bl = file2.exists();
            Object var8_8 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
            catch (Exception exception) {
                try {
                    CoreUtilities.logInfo("ctm: " + exception);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception3) {}
            }
        }
        return false;
    }

    public static Theme loadTheme(String string) {
        File file;
        File file2;
        Theme theme = null;
        if (!DefaultTheme.checkThemeDir() || string == null) {
            return null;
        }
        if (!string.endsWith(CMM_THEME_SUFFIX)) {
            string = string + CMM_THEME_SUFFIX;
        }
        if ((file2 = new File(file = new File(THEME_DIR), string)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                theme = (Theme)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
                ((DefaultTheme)theme).setBackgroundImage(theme.getBackgroundImage());
            }
            catch (Exception exception) {
                CoreUtilities.logException("Exception in load(): ", exception);
            }
        } else {
            CoreUtilities.logInfo("File is missing: " + string);
        }
        return theme;
    }

    private static boolean checkThemeDir() {
        File file = new File(THEME_DIR);
        if (!file.exists()) {
            file.mkdirs();
            return false;
        }
        return true;
    }

    public DefaultTheme(String string, String string2) {
        this.name = string;
        this.description = string2;
        this.custom = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getBGImageSource() {
        return this.bgSource;
    }

    public ImageIcon getPreviewDiskImage() {
        ImageIcon imageIcon = new ImageIcon(this.getPreviewImageFileName().replace(File.separatorChar, '/'));
        imageIcon.getImage().flush();
        return imageIcon;
    }

    public ImageIcon getBackgroundImage() {
        if (this.preview == null) {
            ImageIcon imageIcon = new ImageIcon(this.getBackgroundImageFileName().replace(File.separatorChar, '/'));
            imageIcon.getImage().flush();
            this.setPreviewImage(imageIcon);
        }
        return this.preview;
    }

    public String getBackgroundImageFileName() {
        return DefaultTheme.getThemeImagesDir(this, false) + File.separator + "insightbackground.jpg";
    }

    public String getPreviewImageFileName() {
        String string = THEME_DIR;
        if (!THEME_DIR.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + "insightbackground.jpg";
        return string;
    }

    public void setBackgroundImage(ImageIcon imageIcon) {
        this.setCRC(imageIcon);
        this.setPreviewImage(imageIcon);
    }

    public void setCRC(ImageIcon imageIcon) {
        this.crcValue = DefaultTheme.calculateThemeCRC(imageIcon);
    }

    public void setPreviewImage(ImageIcon imageIcon) {
        this.preview = new ImageIcon(imageIcon.getImage().getScaledInstance(803, 590, 2));
        while (this.preview.getImageLoadStatus() != 8 && this.preview.getImageLoadStatus() != 4) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ImageIcon getPreviewImage() {
        return this.preview != null ? this.preview : null;
    }

    public void setBackgroundImage(String string) {
        this.bgSource = string;
        DefaultTheme.generateThemePreview(this);
    }

    public Dimension getBackgroundDimension() {
        ImageIcon imageIcon = this.getBackgroundImage();
        return imageIcon != null ? new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()) : new Dimension(0, 0);
    }

    public boolean isCustom() {
        return this.isCustom();
    }

    public Color getBlendColor() {
        return this.bgBlendColor;
    }

    public void setBlendColor(Color color) {
        this.bgBlendColor = color;
        DefaultTheme.generateThemePreview(this);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String string) {
        this.collectionName = string;
    }

    public long getCRCValue() {
        return this.crcValue;
    }

    public void setCRCValue(long l) {
        this.crcValue = l;
    }

    public void setFillColor(Color color) {
        this.bgFillColor = color;
    }

    public Color getFillColor() {
        return this.bgFillColor;
    }
}

