/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.theme;

import com.luna.insight.core.util.CoreUtilities;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.ij.jaiio.JAIReader;

public class ThemeImageUtilities {
    public static ImageProcessor crop(ImagePlus imagePlus, int n, int n2, int n3, int n4) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.setRoi(n, n2, n3, n4);
        return imageProcessor.crop();
    }

    public static ImageProcessor crop(ImagePlus imagePlus, int n, int n2, int n3, int n4, Color color) {
        ImageProcessor imageProcessor = ThemeImageUtilities.crop(imagePlus, n, n2, n3, n4);
        imageProcessor.setColor(color);
        ColorProcessor colorProcessor = new ColorProcessor(n3, n4);
        colorProcessor.setColor(color);
        colorProcessor.setRoi(0, 0, n3, n4);
        colorProcessor.fill();
        colorProcessor.crop();
        colorProcessor.insert(imageProcessor, 0, 0);
        ImagePlus imagePlus2 = new ImagePlus("a - " + n3 + " - " + n4, (ImageProcessor)colorProcessor);
        return colorProcessor;
    }

    public static ImagePlus open(String string) {
        return new ImagePlus(string);
    }

    public static ImagePlus openImageJ(String string) throws IOException {
        Opener opener = new Opener();
        ImagePlus imagePlus = opener.openImage(string);
        if (imagePlus == null) {
            CoreUtilities.logInfo("Attempting to use JAI to open the file, ImagePlus Failed");
            try {
                File file = new File(string);
                ImagePlus[] imagePlusArray = JAIReader.read((File)file);
                imagePlus = imagePlusArray[0];
                if (imagePlus.getOriginalFileInfo() == null) {
                    FileInfo fileInfo = imagePlus.getFileInfo();
                    fileInfo.directory = file.getParent();
                    fileInfo.fileName = file.getName();
                    imagePlus.setFileInfo(fileInfo);
                }
            }
            catch (Exception exception) {
                throw new IOException("Could not open the image as ImagePlus or in JAI");
            }
        }
        if (imagePlus == null) {
            throw new IOException("Could not open the image as ImagePlus");
        }
        return imagePlus;
    }

    public static ImagePlus openImageResized(String string, boolean bl) {
        ImagePlus imagePlus = null;
        Object var3_3 = null;
        int n = -1;
        int n2 = -1;
        try {
            imagePlus = ThemeImageUtilities.openImageJ(string);
            if (imagePlus == null) {
                CoreUtilities.logError("Unable to load source image: " + string);
                return null;
            }
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            n = imageProcessor.getWidth();
            n2 = imageProcessor.getHeight();
            imageProcessor = null;
        }
        catch (Exception exception) {
            CoreUtilities.logError("Caught exception while loading source image: " + exception);
            if (imagePlus != null) {
                imagePlus.flush();
                imagePlus = null;
            }
            return null;
        }
        float f = 803.0f / (float)n;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (bl) {
            CoreUtilities.logInfo("Smoothing is enabled, but will not be applied");
        } else {
            CoreUtilities.logInfo("Smoothing is disabled");
        }
        imageProcessor.setInterpolate(true);
        imageProcessor = imageProcessor.resize(Math.round((float)imageProcessor.getWidth() * f), Math.round((float)imageProcessor.getHeight() * f));
        if (imageProcessor.getHeight() < 590) {
            imageProcessor.setInterpolate(true);
            imageProcessor = imageProcessor.resize(imageProcessor.getWidth(), 590);
        }
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        CoreUtilities.logInfo("***openImageResized(): destwidth=" + n3 + " destHeight=" + n4);
        imagePlus.setProcessor(null, imageProcessor);
        return imagePlus;
    }

    public static void writeImage(ImageProcessor imageProcessor, String string) throws IOException {
        int n = 15;
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        float f = 1.0f - (float)n / 100.0f;
        ThemeImageUtilities.writeImage(imageProcessor, string, f);
    }

    public static void writeImage(ImageProcessor imageProcessor, String string, float f) throws IOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            BufferedImage bufferedImage = new BufferedImage(imageProcessor.getWidth(), imageProcessor.getHeight(), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(imageProcessor.createImage(), 0, 0, null);
            graphics2D.dispose();
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw fileNotFoundException;
        }
        catch (ImageFormatException imageFormatException) {
            imageFormatException.printStackTrace();
            throw imageFormatException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }
}

