/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.theme;

import ij.ImagePlus;
import java.awt.Color;

public class ThemeImageLayer
implements Comparable {
    ImagePlus mOrigImage;
    float mAlpha = 0.95f;
    float mContrast;
    Color mColor1;
    Color mColor2;
    String mId;
    int mXoffset;
    int mYoffset;
    int mOrder;
    boolean mUseCustomColors;
    boolean mIsTranslating;
    int mOverlayMode;
    float mContourPlotMinVal;
    float mContourPlotMaxVal;
    public static final int COLOR_BURN = 1;
    public static final int CONTOUR = 2;
    public static final int SRC_OVER = 3;
    public static final int SRC = 4;
    public static final int SRC_SPECIAL = 4;

    public ThemeImageLayer(ImagePlus imagePlus) {
        this.mOrigImage = imagePlus;
        this.mId = imagePlus.getTitle();
        this.mColor2 = new Color(1.0f, 1.0f, 1.0f);
        this.mColor1 = new Color(0.0f, 0.0f, 0.0f);
        this.mUseCustomColors = false;
        this.mOverlayMode = 1;
        this.mContourPlotMinVal = (float)imagePlus.getProcessor().getMin();
        this.mContourPlotMaxVal = (float)imagePlus.getProcessor().getMax();
    }

    public String getName() {
        return this.mId;
    }

    public int getOverlayMode() {
        return this.mOverlayMode;
    }

    public void setOverlayMode(int n) {
        this.mOverlayMode = n;
    }

    public boolean getIsTranslating() {
        return this.mIsTranslating;
    }

    public void setIsTranslating(boolean bl) {
        this.mIsTranslating = bl;
    }

    public float getContourPlotMinVal() {
        return this.mContourPlotMinVal;
    }

    public void setContourPlotMinVal(float f) {
        this.mContourPlotMinVal = f > this.mContourPlotMaxVal ? this.mContourPlotMaxVal : f;
    }

    public float getContourPlotMaxVal() {
        return this.mContourPlotMaxVal;
    }

    public void setContourPlotMaxVal(float f) {
        this.mContourPlotMaxVal = f < this.mContourPlotMinVal ? this.mContourPlotMinVal : f;
    }

    public int getOrder() {
        return this.mOrder;
    }

    public ThemeImageLayer setOrder(int n) {
        this.mOrder = n;
        return this;
    }

    public void setAlpha(float f) {
        this.mAlpha = f;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setContrast(float f) {
        this.mContrast = f;
    }

    public float getContrast() {
        return this.mContrast;
    }

    public boolean getUseCustomColors() {
        return this.mUseCustomColors;
    }

    public void setUseCustomColors(boolean bl) {
        this.mUseCustomColors = bl;
    }

    public Color getColor1() {
        return this.mColor1;
    }

    public Color getColor2() {
        return this.mColor2;
    }

    public void setColor1(Color color) {
        this.mColor1 = color != null ? color : Color.white;
    }

    public void setColor2(Color color) {
        if (color != null) {
            this.mColor2 = color;
        } else {
            this.mColor1 = Color.black;
        }
    }

    public void setImagePlus(ImagePlus imagePlus) {
        this.mOrigImage = imagePlus;
    }

    public ImagePlus getImagePlus() {
        return this.mOrigImage;
    }

    public int getHeight() {
        return this.mOrigImage.getHeight();
    }

    public int getWidth() {
        return this.mOrigImage.getWidth();
    }

    public int getXOffset() {
        return this.mXoffset;
    }

    public int getYOffset() {
        return this.mYoffset;
    }

    public void setXOffset(int n) {
        this.mXoffset = n;
    }

    public void setYOffset(int n) {
        this.mYoffset = n;
    }

    public ThemeImageLayer incrementOrder() {
        ++this.mOrder;
        return this;
    }

    public ThemeImageLayer decrementOrder() {
        --this.mOrder;
        return this;
    }

    public int compareTo(Object object) {
        int n = ((ThemeImageLayer)object).getOrder();
        if (this.mOrder < n) {
            return 1;
        }
        if (this.mOrder > n) {
            return -1;
        }
        return 0;
    }
}

